/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.image.compression.bintable;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import nom.tam.fits.FitsException;
import nom.tam.image.compression.bintable.BinaryTableTile;
import nom.tam.image.compression.bintable.BinaryTableTileDescription;
import nom.tam.image.compression.hdu.CompressedTableData;
import nom.tam.util.ArrayDataInput;
import nom.tam.util.BufferedDataInputStream;
import nom.tam.util.ColumnTable;

public class BinaryTableTileDecompressor
extends BinaryTableTile {
    private final ByteBuffer compressedBytes;
    private ArrayDataInput is;

    public BinaryTableTileDecompressor(CompressedTableData binData, ColumnTable<?> columnTable, BinaryTableTileDescription description) throws FitsException {
        super(columnTable, description);
        this.compressedBytes = ByteBuffer.wrap((byte[])binData.getElement(this.rowStart, this.column));
    }

    @Override
    public void run() {
        if (this.is == null) {
            ByteBuffer unCompressedBytes = ByteBuffer.wrap(new byte[this.getUncompressedSizeInBytes()]);
            this.getCompressorControl().decompress(this.compressedBytes, (Buffer)this.type.asTypedBuffer(unCompressedBytes), null);
            this.is = new BufferedDataInputStream(new ByteArrayInputStream(unCompressedBytes.array()));
        }
        try {
            this.data.read(this.is, this.rowStart, this.rowEnd, this.column);
        }
        catch (IOException e) {
            throw new IllegalStateException("could not read compressed data", e);
        }
    }
}

