/*
 * Decompiled with CFR 0.152.
 */
package aigis.model;

import aigis.model.LatLon;
import aigis.model.loader.PropLoader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3d;

public class CameraInfo
implements Cloneable {
    public final Point3d position = new Point3d();
    public final Vector3d direction = new Vector3d();
    public final Vector3d up = new Vector3d();
    public final Point3f light = new Point3f();
    public double fov;
    public double roll;
    private final Vector3d vec3 = new Vector3d();
    private final Matrix4d mtx4 = new Matrix4d();
    private final Vector3d side = new Vector3d();

    public CameraInfo() {
        this.reset();
    }

    public CameraInfo clone() {
        CameraInfo cameraInfo = null;
        cameraInfo = new CameraInfo();
        cameraInfo.position.set(this.position);
        cameraInfo.direction.set(this.direction);
        cameraInfo.up.set(this.up);
        cameraInfo.light.set(this.light);
        cameraInfo.fov = this.fov;
        cameraInfo.roll = this.roll;
        return cameraInfo;
    }

    public Matrix4d lookat() {
        return this.lookat(new Matrix4d());
    }

    public Matrix4d lookatWithoutYaw() {
        CameraInfo cameraInfo = this.clone();
        cameraInfo.direction.set(this.position);
        cameraInfo.direction.negate();
        cameraInfo.direction.normalize();
        this.side.cross(cameraInfo.direction, this.up);
        cameraInfo.up.cross(this.side, cameraInfo.direction);
        return cameraInfo.lookat();
    }

    public Matrix4d lookat(Matrix4d matrix4d) {
        this.side.cross(this.direction, this.up);
        this.side.normalize();
        matrix4d.setIdentity();
        matrix4d.m00 = this.side.x;
        matrix4d.m01 = this.side.y;
        matrix4d.m02 = this.side.z;
        matrix4d.m10 = this.up.x;
        matrix4d.m11 = this.up.y;
        matrix4d.m12 = this.up.z;
        matrix4d.m20 = -this.direction.x;
        matrix4d.m21 = -this.direction.y;
        matrix4d.m22 = -this.direction.z;
        this.mtx4.setIdentity();
        this.mtx4.m03 = -this.position.x;
        this.mtx4.m13 = -this.position.y;
        this.mtx4.m23 = -this.position.z;
        matrix4d.mul(this.mtx4);
        return matrix4d;
    }

    public float getDistance() {
        return (float)this.position.distance(new Point3d());
    }

    public double[] matrixToArray(Matrix4d matrix4d) {
        return new double[]{matrix4d.m00, matrix4d.m10, matrix4d.m20, matrix4d.m30, matrix4d.m01, matrix4d.m11, matrix4d.m21, matrix4d.m31, matrix4d.m02, matrix4d.m12, matrix4d.m22, matrix4d.m32, matrix4d.m03, matrix4d.m13, matrix4d.m23, matrix4d.m33};
    }

    public double[] lookatArray() {
        return this.matrixToArray(this.lookat());
    }

    public void move(float f, float f2) {
        if (f == 0.0f && f2 == 0.0f) {
            return;
        }
        this.vec3.set(f2, -f, 0.0);
        Matrix4d matrix4d = this.lookat();
        matrix4d.invert();
        matrix4d.transform(this.vec3);
        this.vec3.normalize();
        float f3 = (float)Math.sqrt(f * f + f2 * f2) / 10.0f;
        matrix4d.setIdentity();
        matrix4d.setRotation(new AxisAngle4d(this.vec3.x, this.vec3.y, this.vec3.z, f3));
        matrix4d.transform(this.direction);
        matrix4d.transform(this.up);
    }

    public void rotate(float f, float f2, float f3, boolean bl, boolean bl2) {
        Matrix4d matrix4d;
        if (f == 0.0f && f2 == 0.0f && f3 == 0.0f) {
            return;
        }
        this.vec3.set(f, f2, f3);
        if (bl) {
            matrix4d = this.mtx4;
        } else {
            matrix4d = this.lookat();
            matrix4d.invert();
            matrix4d.transform(this.vec3);
        }
        this.vec3.normalize();
        float f4 = (float)Math.sqrt(f * f + f2 * f2 + f3 * f3) / 100.0f;
        matrix4d.setIdentity();
        matrix4d.setRotation(new AxisAngle4d(this.vec3.x, this.vec3.y, this.vec3.z, f4));
        matrix4d.transform(this.position);
        matrix4d.transform(this.direction);
        matrix4d.transform(this.up);
        if (bl2) {
            matrix4d.transform(this.light);
        }
        this.calcRoll();
    }

    public void rotateLight(float f, float f2, float f3) {
        if (f == 0.0f && f2 == 0.0f && f3 == 0.0f) {
            return;
        }
        this.vec3.set(f, f2, f3);
        Matrix4d matrix4d = this.lookat();
        matrix4d.invert();
        matrix4d.transform(this.vec3);
        this.vec3.normalize();
        float f4 = (float)Math.sqrt(f * f + f2 * f2 + f3 * f3) / 100.0f;
        matrix4d.setIdentity();
        matrix4d.setRotation(new AxisAngle4d(this.vec3.x, this.vec3.y, this.vec3.z, f4));
        matrix4d.transform(this.light);
    }

    private LatLon getLatLng(double d, double d2, double d3) {
        double d4 = Math.atan2(d3, Math.sqrt(d * d + d2 * d2));
        double d5 = Math.atan2(d2, d);
        if (d5 < 0.0) {
            d5 += Math.PI * 2;
        }
        return new LatLon(Math.toDegrees(d4), Math.toDegrees(d5));
    }

    public LatLon getLatLng() {
        return this.getLatLng(this.position.x, this.position.y, this.position.z);
    }

    public LatLon getLightLatLng() {
        return this.getLatLng(this.light.x, this.light.y, this.light.z);
    }

    public void moveLatLng(float f, float f2, float f3) {
        this.roll = f3;
        Matrix4d matrix4d = this.lookatWithoutYaw();
        Matrix4d matrix4d2 = this.lookat();
        matrix4d2.invert();
        matrix4d.mul(matrix4d2);
        double d = this.position.distance(new Point3d());
        this.position.set(0.0, 0.0, d);
        this.direction.set(0.0, 0.0, -1.0);
        this.up.set(0.0, 1.0, 0.0);
        Matrix4d matrix4d3 = this.mtx4;
        matrix4d3.setIdentity();
        matrix4d3.rotZ(Math.toRadians(f2 + 90.0f));
        Matrix4d matrix4d4 = new Matrix4d();
        matrix4d4.setIdentity();
        matrix4d4.rotX(Math.toRadians(-f + 90.0f));
        matrix4d3.mul(matrix4d4);
        matrix4d4.setIdentity();
        matrix4d4.setRotation(new AxisAngle4d(this.direction.x, this.direction.y, this.direction.z, -Math.toRadians(f3)));
        matrix4d3.mul(matrix4d4);
        matrix4d3.transform(this.position);
        matrix4d3.mul(matrix4d);
        matrix4d3.transform(this.direction);
        matrix4d3.transform(this.up);
    }

    public void moveLightLatLng(float f, float f2) {
        float f3 = this.light.distance(new Point3f());
        this.light.set(0.0f, 0.0f, f3);
        Matrix4d matrix4d = this.mtx4;
        matrix4d.rotZ(Math.toRadians(f2 + 90.0f));
        Matrix4d matrix4d2 = new Matrix4d();
        matrix4d2.rotX(Math.toRadians(-f + 90.0f));
        matrix4d.mul(matrix4d2);
        matrix4d.transform(this.light);
    }

    public Vector3d[] getFrustum() {
        Matrix4d matrix4d = this.lookat();
        matrix4d.invert();
        Vector3d[] vector3dArray = new Vector3d[4];
        double d = this.fov * Math.sqrt(2.0) / 2.0;
        for (int i = 0; i < 2; ++i) {
            double d2 = i == 0 ? -0.5 : 0.5;
            for (int j = 0; j < 2; ++j) {
                double d3 = j == 0 ? -0.5 : 0.5;
                this.vec3.set(d3, d2, 0.0);
                matrix4d.transform(this.vec3);
                this.vec3.normalize();
                this.mtx4.setIdentity();
                this.mtx4.setRotation(new AxisAngle4d(this.vec3.x, this.vec3.y, this.vec3.z, d));
                this.vec3.set(this.direction);
                this.mtx4.transform(this.vec3);
                this.vec3.normalize();
                vector3dArray[j + i * 2] = new Vector3d(this.vec3);
            }
        }
        return vector3dArray;
    }

    public void setDefaultSize(double d) {
        double d2 = Math.toRadians(7.5) / 2.0;
        double d3 = d / 2.0 * 1.4 / Math.tan(d2);
        this.position.set(0.0, 0.0, d3);
    }

    public void reset() {
        this.position.set(0.0, 0.0, 10.0);
        this.direction.set(0.0, 0.0, -1.0);
        this.up.set(0.0, 1.0, 0.0);
        this.light.set(0.0f, 0.0f, 5000.0f);
        this.fov = Math.toRadians(7.5);
        this.roll = 270.0;
    }

    private void calcRoll() {
        this.vec3.set(0.0, 0.0, 1.0);
        Matrix4d matrix4d = this.lookatWithoutYaw();
        matrix4d.transform(this.vec3);
        if (this.vec3.x == 0.0 && this.vec3.y == 0.0) {
            this.vec3.set(0.0, 1.0, 0.0);
            matrix4d.transform(this.vec3);
            this.roll = Math.PI * 2;
        } else {
            this.roll = 1.5707963267948966;
        }
        this.roll -= Math.atan2(this.vec3.y, this.vec3.x);
        this.roll = Math.toDegrees(this.roll);
        if (this.roll < 0.0) {
            this.roll += 360.0;
        }
    }

    public static CameraInfo loadFromInfo(String string) throws UnsupportedEncodingException, FileNotFoundException, IOException {
        PropLoader propLoader = new PropLoader();
        propLoader.load(new InputStreamReader((InputStream)new FileInputStream(string), "UTF-8"));
        CameraInfo cameraInfo = new CameraInfo();
        cameraInfo.position.set(CameraInfo.convertStringToFloat(propLoader.getProperty("SPACECRAFT_POSITION")));
        cameraInfo.direction.normalize();
        cameraInfo.direction.set(CameraInfo.convertStringToFloat(propLoader.getProperty("BORESIGHT_DIRECTION")));
        cameraInfo.up.set(CameraInfo.convertStringToFloat(propLoader.getProperty("UP_DIRECTION")));
        cameraInfo.up.normalize();
        double[] dArray = CameraInfo.convertStringToFloat(propLoader.getProperty("FRUSTUM1"));
        double[] dArray2 = CameraInfo.convertStringToFloat(propLoader.getProperty("FRUSTUM2"));
        Vector3d vector3d = new Vector3d(dArray);
        Vector3d vector3d2 = new Vector3d(dArray2);
        cameraInfo.fov = vector3d.angle(vector3d2);
        cameraInfo.calcRoll();
        return cameraInfo;
    }

    private static double[] convertStringToFloat(String string) {
        String string2 = string.replace("(", "");
        string2 = string2.replace(")", "");
        String[] stringArray = string2.split(",", 0);
        double[] dArray = new double[]{Double.parseDouble(stringArray[0]), Double.parseDouble(stringArray[1]), Double.parseDouble(stringArray[2])};
        return dArray;
    }

    public double getFov() {
        return Math.toDegrees(this.fov);
    }

    public void setFov(float f) {
        this.fov = Math.toRadians(f);
    }
}

