/*
 * Decompiled with CFR 0.152.
 */
package aigis.ui;

import aigis.Logger;
import aigis.Scene;
import aigis.gl.Renderer;
import aigis.gl.Textures;
import aigis.model.CameraInfo;
import aigis.model.LatLon;
import aigis.model.Models;
import com.jogamp.common.nio.Buffers;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.awt.GLJPanel;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.nio.FloatBuffer;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.JOptionPane;

public class GLSplitWindow {
    public boolean isSync = true;
    private GL2 gl;
    private Renderer[] renderers = new Renderer[4];
    public Textures textures;
    private GLJPanel glPanel = null;
    private int division = 1;
    private Dimension divideSize;
    private int currentScreen = 0;
    private EventListener eventListener;
    private Point prevMousePos = new Point();
    private float[] viewScales = new float[]{1.0f, 1.0f};
    private boolean withoutFrame = false;
    private Character fixedAxis = null;
    private Scene scene;

    public GLSplitWindow(final GLJPanel gLJPanel, final Scene scene) {
        this.glPanel = gLJPanel;
        this.scene = scene;
        gLJPanel.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                int n = GLSplitWindow.this.getScreenIndex(mouseWheelEvent.getPoint());
                if (GLSplitWindow.this.isSync) {
                    for (int i = 0; i < GLSplitWindow.this.division; ++i) {
                        GLSplitWindow.this.renderers[i].scale(-mouseWheelEvent.getWheelRotation());
                    }
                } else {
                    GLSplitWindow.this.renderers[n].scale(-mouseWheelEvent.getWheelRotation());
                }
                if (GLSplitWindow.this.eventListener != null) {
                    GLSplitWindow.this.eventListener.cameraMoved(GLSplitWindow.this.renderers[n].getCameraInfo());
                }
                GLSplitWindow.this.setScreenIndex(n);
                gLJPanel.repaint();
            }
        });
        gLJPanel.setFocusable(true);
        gLJPanel.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 16) {
                    ((GLSplitWindow)GLSplitWindow.this).renderers[((GLSplitWindow)GLSplitWindow.this).currentScreen].setting.displayLightDirection = true;
                }
                if (keyEvent.getKeyCode() >= 88 && keyEvent.getKeyCode() <= 90) {
                    GLSplitWindow.this.fixedAxis = Character.valueOf(keyEvent.getKeyChar());
                }
                gLJPanel.repaint();
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                for (int i = 0; i < GLSplitWindow.this.division; ++i) {
                    ((GLSplitWindow)GLSplitWindow.this).renderers[i].setting.displayLightDirection = false;
                }
                GLSplitWindow.this.fixedAxis = null;
                gLJPanel.repaint();
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }
        });
        gLJPanel.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                int n = mouseEvent.getX();
                int n2 = mouseEvent.getY();
                int n3 = GLSplitWindow.this.getScreenIndex(mouseEvent.getPoint());
                if (GLSplitWindow.this.renderers[n3] == null) {
                    return;
                }
                GLSplitWindow.this.setScreenIndex(n3);
                if (mouseEvent.isAltDown()) {
                    float f = n2 - ((GLSplitWindow)GLSplitWindow.this).prevMousePos.y;
                    if (GLSplitWindow.this.isSync) {
                        for (int i = 0; i < GLSplitWindow.this.division; ++i) {
                            GLSplitWindow.this.renderers[i].scale(f);
                        }
                    } else {
                        GLSplitWindow.this.renderers[n3].scale(f);
                    }
                    if (GLSplitWindow.this.eventListener != null) {
                        GLSplitWindow.this.eventListener.cameraMoved(GLSplitWindow.this.renderers[n3].getCameraInfo());
                    }
                } else if (mouseEvent.isControlDown()) {
                    float f = (float)(n - ((GLSplitWindow)GLSplitWindow.this).prevMousePos.x) / 10.0f;
                    float f2 = (float)(((GLSplitWindow)GLSplitWindow.this).prevMousePos.y - n2) / 10.0f;
                    if (GLSplitWindow.this.isSync) {
                        for (int i = 0; i < GLSplitWindow.this.division; ++i) {
                            GLSplitWindow.this.renderers[i].move(-f, -f2);
                        }
                    } else {
                        GLSplitWindow.this.renderers[n3].move(-f, -f2);
                    }
                } else if (mouseEvent.isShiftDown()) {
                    int n4;
                    float f = n - ((GLSplitWindow)GLSplitWindow.this).prevMousePos.x;
                    float f3 = n2 - ((GLSplitWindow)GLSplitWindow.this).prevMousePos.y;
                    if (GLSplitWindow.this.isSync) {
                        for (n4 = 0; n4 < GLSplitWindow.this.division; ++n4) {
                            GLSplitWindow.this.renderers[n4].rotateLight(f3, f);
                        }
                    } else {
                        GLSplitWindow.this.renderers[n3].rotateLight(f3, f);
                    }
                    for (n4 = 0; n4 < GLSplitWindow.this.division; ++n4) {
                        ((GLSplitWindow)GLSplitWindow.this).renderers[n4].setting.displayLightDirection = GLSplitWindow.this.currentScreen == n4;
                    }
                    if (GLSplitWindow.this.eventListener != null) {
                        GLSplitWindow.this.eventListener.lightMoved(GLSplitWindow.this.renderers[n3].getLightLatLon());
                    }
                } else {
                    float f = ((GLSplitWindow)GLSplitWindow.this).prevMousePos.x - n;
                    float f4 = ((GLSplitWindow)GLSplitWindow.this).prevMousePos.y - n2;
                    float f5 = 0.0f;
                    if (GLSplitWindow.this.fixedAxis != null) {
                        switch (GLSplitWindow.this.fixedAxis.charValue()) {
                            case 'X': 
                            case 'x': {
                                f = 0.0f;
                                break;
                            }
                            case 'Y': 
                            case 'y': {
                                f4 = 0.0f;
                                break;
                            }
                            case 'Z': 
                            case 'z': {
                                f5 = f4 + f;
                                f4 = 0.0f;
                                f = 0.0f;
                            }
                        }
                    }
                    if (GLSplitWindow.this.isSync) {
                        for (int i = 0; i < GLSplitWindow.this.division; ++i) {
                            GLSplitWindow.this.renderers[i].rotateObject(f4, f, f5, GLSplitWindow.this.fixedAxis != null);
                        }
                    } else {
                        GLSplitWindow.this.renderers[n3].rotateObject(f4, f, f5, GLSplitWindow.this.fixedAxis != null);
                    }
                    if (GLSplitWindow.this.eventListener != null) {
                        GLSplitWindow.this.eventListener.cameraMoved(GLSplitWindow.this.renderers[n3].getCameraInfo());
                        if (((GLSplitWindow)GLSplitWindow.this).renderers[n3].setting.fixedLightPos) {
                            GLSplitWindow.this.eventListener.lightMoved(GLSplitWindow.this.renderers[n3].getLightLatLon());
                        }
                    }
                }
                ((GLSplitWindow)GLSplitWindow.this).prevMousePos.x = n;
                ((GLSplitWindow)GLSplitWindow.this).prevMousePos.y = n2;
                gLJPanel.repaint();
            }

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
            }
        });
        gLJPanel.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int n = GLSplitWindow.this.getScreenIndex(mouseEvent.getPoint());
                if (n == GLSplitWindow.this.currentScreen) {
                    Point2D.Double double_ = new Point2D.Double(mouseEvent.getX(), gLJPanel.getHeight() - mouseEvent.getY());
                    int n2 = GLSplitWindow.this.renderers[n].getPointPolygonID(double_, GLSplitWindow.this.viewScales);
                    LatLon latLon = GLSplitWindow.this.renderers[n].selectPolygon(n2, mouseEvent.isControlDown());
                    if (GLSplitWindow.this.eventListener != null) {
                        GLSplitWindow.this.eventListener.polygonSelected(n2, latLon);
                    }
                }
                GLSplitWindow.this.setScreenIndex(n);
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                ((GLSplitWindow)GLSplitWindow.this).prevMousePos.x = mouseEvent.getX();
                ((GLSplitWindow)GLSplitWindow.this).prevMousePos.y = mouseEvent.getY();
                int n = GLSplitWindow.this.getScreenIndex(mouseEvent.getPoint());
                if (scene.isChangeModel()) {
                    if (GLSplitWindow.this.isSync) {
                        for (int i = 0; i < GLSplitWindow.this.division; ++i) {
                            if (!GLSplitWindow.this.renderers[i].getCurrentModel().equals("ModelHigh")) continue;
                            GLSplitWindow.this.renderers[i].changeModelTemporary("ModelLow");
                        }
                    } else if (GLSplitWindow.this.renderers[n].getCurrentModel().equals("ModelHigh")) {
                        GLSplitWindow.this.renderers[n].changeModelTemporary("ModelLow");
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                for (int i = 0; i < GLSplitWindow.this.division; ++i) {
                    if (!scene.isChangeModel()) continue;
                    GLSplitWindow.this.renderers[i].changeModelTemporary(null);
                }
                gLJPanel.repaint();
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                gLJPanel.requestFocus();
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                for (int i = 0; i < GLSplitWindow.this.division; ++i) {
                    ((GLSplitWindow)GLSplitWindow.this).renderers[i].setting.displayLightDirection = false;
                }
            }
        });
        gLJPanel.addGLEventListener(new GLEventListener(){

            @Override
            public void init(GLAutoDrawable gLAutoDrawable) {
                Logger.Debug("*gl init");
                GLSplitWindow.this.initgl(gLAutoDrawable);
            }

            @Override
            public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
                Logger.Debug("*gl reshape: x=" + n + ", y=" + n2 + ", w=" + n3 + ", h=" + n4);
                gLJPanel.getCurrentSurfaceScale(GLSplitWindow.this.viewScales);
                Logger.Debug("*viewScales: x=" + GLSplitWindow.this.viewScales[0] + ", y=" + GLSplitWindow.this.viewScales[1]);
                GLSplitWindow.this.divide(GLSplitWindow.this.division);
            }

            @Override
            public void display(GLAutoDrawable gLAutoDrawable) {
                GLSplitWindow.this.gl.glClear(16640);
                GLSplitWindow.this.gl.glEnable(3553);
                GLSplitWindow.this.gl.glActiveTexture(33984);
                GLSplitWindow.this.gl.glBindTexture(3553, 0);
                try {
                    scene.compile(GLSplitWindow.this.gl);
                    Models models = scene.getRegisteredModels();
                    try {
                        GLSplitWindow.this.textures.initTexture(GLSplitWindow.this.gl, models);
                    }
                    catch (RuntimeException runtimeException) {
                        Logger.Error(runtimeException);
                        String string = runtimeException.getMessage();
                        JOptionPane.showMessageDialog(null, string != null ? string : runtimeException.getClass(), "Error", 2);
                    }
                    GLSplitWindow.this.gl.glMatrixMode(5888);
                    for (int i = 0; i < GLSplitWindow.this.division; ++i) {
                        GLSplitWindow.this.setViewPort(i);
                        GLSplitWindow.this.renderers[i].render(GLSplitWindow.this.gl, GLSplitWindow.this.textures, i);
                    }
                    GLSplitWindow.this.drawFrame();
                }
                catch (Exception exception) {
                    Logger.Error(exception);
                    String string = exception.getMessage();
                    JOptionPane.showMessageDialog(null, string != null ? string : exception.getClass(), "Error", 0);
                    System.exit(1);
                    return;
                }
            }

            @Override
            public void dispose(GLAutoDrawable gLAutoDrawable) {
                Logger.Debug("*gl dispose");
            }
        });
    }

    public void setEventListener(EventListener eventListener) {
        this.eventListener = eventListener;
    }

    public void divide(int n) {
        this.division = n;
        int n2 = this.currentScreen;
        if (this.currentScreen + 1 > n) {
            n2 = 0;
        }
        Dimension dimension = this.glPanel.getSize();
        this.divideSize = n == 1 ? new Dimension(dimension) : (n == 2 ? new Dimension(dimension.width, dimension.height / 2) : new Dimension(dimension.width / 2, dimension.height / 2));
        for (int i = 0; i < n; ++i) {
            if (this.renderers[i] == null) {
                this.renderers[i] = new Renderer(this.scene);
            }
            if (this.eventListener == null || n2 != i) continue;
            this.eventListener.lightMoved(this.renderers[n2].getLightLatLon());
            this.eventListener.cameraMoved(this.renderers[n2].getCameraInfo());
        }
        this.currentScreen = n2;
        if (this.eventListener != null) {
            this.eventListener.screenChanged(n2);
        }
        this.sync();
        this.glPanel.repaint();
    }

    public void sync() {
        for (int i = 0; i < this.division; ++i) {
            if (this.currentScreen == i) continue;
            this.renderers[i].syncCamera(this.renderers[this.currentScreen]);
        }
        this.glPanel.repaint();
    }

    public void moveCamera(float f, float f2, float f3) {
        if (this.isSync) {
            for (int i = 0; i < this.division; ++i) {
                this.renderers[i].moveCamera(f, f2, f3);
            }
        } else {
            this.renderers[this.currentScreen].moveCamera(f, f2, f3);
        }
    }

    public void moveLight(float f, float f2) {
        if (this.isSync) {
            for (int i = 0; i < this.division; ++i) {
                this.renderers[i].moveLight(f, f2);
            }
        } else {
            this.renderers[this.currentScreen].moveLight(f, f2);
        }
    }

    public void setCameraDistance(float f) {
        if (this.isSync) {
            for (int i = 0; i < this.division; ++i) {
                this.renderers[i].setCameraDistance(f);
            }
        } else {
            this.renderers[this.currentScreen].setCameraDistance(f);
        }
    }

    public void setFov(float f) {
        if (this.isSync) {
            for (int i = 0; i < this.division; ++i) {
                this.renderers[i].setFov(f);
            }
        } else {
            this.renderers[this.currentScreen].setFov(f);
        }
    }

    public Renderer getActiveRenderer() {
        return this.renderers[this.currentScreen];
    }

    public void resetRenderer(boolean bl, double d) {
        for (int i = 0; i < this.division; ++i) {
            this.renderers[i].resetSetting(bl);
            if (!bl) continue;
            this.renderers[i].getCameraInfo().setDefaultSize(d);
        }
        if (this.eventListener != null) {
            this.eventListener.screenChanged(this.currentScreen);
            this.eventListener.lightMoved(this.renderers[0].getLightLatLon());
            this.eventListener.cameraMoved(this.renderers[0].getCameraInfo());
        }
        this.glPanel.repaint();
    }

    public void resetColorbar() {
        for (int i = 0; i < this.division; ++i) {
            if (this.renderers[i] == null) continue;
            this.renderers[i].changeColorbar(0);
        }
        this.glPanel.repaint();
    }

    private void initgl(GLAutoDrawable gLAutoDrawable) {
        Logger.Debug("Initializing JOGL...");
        this.gl = gLAutoDrawable.getGL().getGL2();
        Logger.Debug("GL:" + this.gl.glGetString(7938));
        boolean bl = this.gl.isExtensionAvailable("GL_ARB_vertex_buffer_object");
        Logger.Debug("VBO:" + bl);
        Package package_ = Package.getPackage("com.jogamp.opengl");
        if (package_ == null) {
            package_ = Package.getPackage("javax.media.opengl");
        }
        if (package_ != null) {
            Logger.Debug("JOGL version: " + package_.getImplementationVersion());
        }
        FloatBuffer floatBuffer = Buffers.newDirectFloatBuffer(2);
        this.gl.glGetFloatv(2850, floatBuffer);
        Logger.Debug("LINE_WIDTH: " + floatBuffer.get(0) + "~" + floatBuffer.get(1));
        this.textures = new Textures(this.gl);
        if (!bl) {
            JOptionPane.showMessageDialog(null, "VBO not supported. \n", "Error", 0);
            System.exit(1);
            return;
        }
    }

    private int getScreenIndex(Point point) {
        int n = 0;
        if (this.division == 2) {
            n = point.y > this.divideSize.height ? 1 : 0;
            return n;
        }
        n = point.x < this.divideSize.width ? (point.y > this.divideSize.height ? 2 : 0) : (point.y > this.divideSize.height ? 3 : 1);
        return n;
    }

    private void setScreenIndex(int n) {
        if (this.currentScreen == n) {
            return;
        }
        this.currentScreen = n;
        if (this.eventListener != null) {
            this.eventListener.lightMoved(this.renderers[this.currentScreen].getLightLatLon());
            this.eventListener.cameraMoved(this.renderers[this.currentScreen].getCameraInfo());
            this.eventListener.screenChanged(n);
        }
    }

    private void setViewPort(int n) {
        int n2 = n % 2;
        int n3 = n / 2;
        if (this.division == 4) {
            n3 = 1 - n3;
        }
        int n4 = this.divideSize.width * (int)this.viewScales[0];
        int n5 = this.divideSize.height * (int)this.viewScales[1];
        if (this.division == 2) {
            this.gl.glViewport(0, n5 * (1 - n), n4, n5);
        } else {
            this.gl.glViewport(n4 * n2, n5 * n3, n4, n5);
        }
    }

    private void drawFrame() {
        if (this.withoutFrame) {
            return;
        }
        if (this.division == 1) {
            return;
        }
        this.setViewPort(this.currentScreen);
        this.gl.glDisable(2929);
        this.gl.glDisable(2896);
        this.gl.glMatrixMode(5889);
        this.gl.glLoadIdentity();
        this.gl.glMatrixMode(5888);
        this.gl.glLoadIdentity();
        this.gl.glLineWidth(6.0f * this.viewScales[0]);
        this.gl.glColor3f(0.0f, 0.0f, 1.0f);
        this.gl.glBegin(2);
        float f = 0.995f;
        this.gl.glVertex2d(-f, -f);
        this.gl.glVertex2d(f, -f);
        this.gl.glVertex2d(f, f);
        this.gl.glVertex2d(-f, f);
        this.gl.glEnd();
    }

    public void screenshot(File file) throws Exception {
        int n = (int)this.viewScales[0];
        int n2 = (int)this.viewScales[1];
        int n3 = this.glPanel.getWidth() * n;
        int n4 = this.glPanel.getHeight() * n2;
        BufferedImage bufferedImage = new BufferedImage(n3, n4, 5);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        this.withoutFrame = true;
        graphics2D.scale(n, n2);
        this.glPanel.paint(graphics2D);
        this.withoutFrame = false;
        this.saveImage(file, bufferedImage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveImage(File file, BufferedImage bufferedImage) throws Exception {
        Iterator<ImageWriter> iterator = ImageIO.getImageWritersByFormatName("png");
        while (iterator.hasNext()) {
            ImageWriter imageWriter = iterator.next();
            ImageWriteParam imageWriteParam = imageWriter.getDefaultWriteParam();
            ImageTypeSpecifier imageTypeSpecifier = ImageTypeSpecifier.createFromBufferedImageType(1);
            IIOMetadata iIOMetadata = imageWriter.getDefaultImageMetadata(imageTypeSpecifier, imageWriteParam);
            if (iIOMetadata.isReadOnly() || !iIOMetadata.isStandardMetadataFormatSupported()) continue;
            this.setDPI(iIOMetadata);
            try (ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(new FileOutputStream(file));){
                imageWriter.setOutput(imageOutputStream);
                imageWriter.write(iIOMetadata, new IIOImage(bufferedImage, null, iIOMetadata), imageWriteParam);
                break;
            }
        }
    }

    private void setDPI(IIOMetadata iIOMetadata) throws IIOInvalidTreeException {
        int n = (int)this.viewScales[0];
        int n2 = (int)this.viewScales[1];
        double d = 2.8346457481384277;
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("HorizontalPixelSize");
        iIOMetadataNode.setAttribute("value", Double.toString(d * (double)n2));
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("VerticalPixelSize");
        iIOMetadataNode2.setAttribute("value", Double.toString(d * (double)n));
        IIOMetadataNode iIOMetadataNode3 = new IIOMetadataNode("Dimension");
        iIOMetadataNode3.appendChild(iIOMetadataNode);
        iIOMetadataNode3.appendChild(iIOMetadataNode2);
        IIOMetadataNode iIOMetadataNode4 = new IIOMetadataNode("javax_imageio_1.0");
        iIOMetadataNode4.appendChild(iIOMetadataNode3);
        iIOMetadata.mergeTree("javax_imageio_1.0", iIOMetadataNode4);
    }

    public static interface EventListener {
        public void cameraMoved(CameraInfo var1);

        public void lightMoved(LatLon var1);

        public void polygonSelected(int var1, LatLon var2);

        public void screenChanged(int var1);
    }
}

