/*
 * Decompiled with CFR 0.152.
 */
package aigis.model;

import aigis.model.Grids;
import aigis.model.Model;
import aigis.model.SpectrumMap;
import aigis.model.SpectrumMaps;
import com.jogamp.opengl.GL2;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.TreeMap;

public class Models
implements Cloneable {
    private TreeMap<String, Model> models = new TreeMap();
    private boolean compiled = false;

    public Models clone() throws CloneNotSupportedException {
        Models models = (Models)super.clone();
        models.models = (TreeMap)this.models.clone();
        return models;
    }

    public void addModel(String string, Model model) {
        this.models.put(string, model);
        this.compiled = false;
    }

    public void removeModel(String string) {
        this.models.remove(string);
    }

    public boolean rewriteColor(String string, ByteBuffer byteBuffer) {
        boolean bl = this.models.get(string).rewriteColor(byteBuffer);
        byteBuffer.limit(byteBuffer.position());
        byteBuffer.position(0);
        return bl;
    }

    public void changeSpectrumMap(String string, String string2, int n) {
        if (this.models.get(string) == null) {
            return;
        }
        this.models.get(string).changeSpectrumMap(string2, n);
    }

    public void addSpectrumMap(String string, String string2, SpectrumMap spectrumMap) throws IOException {
        this.models.get(string).addSpectrumMap(string2, spectrumMap);
    }

    public void clearSpectrumMap(String string) {
        this.models.get(string).getAvailableSpectrumMaps().clear();
    }

    public void emphasizePolygon(String string, Integer n) {
        this.models.get(string).emphasizePolygon(n);
    }

    public void compile(GL2 gL2) {
        for (Map.Entry<String, Model> entry : this.models.entrySet()) {
            entry.getValue().compile(gL2);
            this.compiled = true;
        }
    }

    public int getID(String string, Point2D.Double double_, double[] dArray, double[] dArray2, int[] nArray) {
        if (this.models.get(string) == null) {
            return -1;
        }
        return this.models.get(string).getID(double_, dArray, dArray2, nArray);
    }

    public int getSize() {
        return this.models.size();
    }

    public Model getModel(String string) {
        return this.models.get(string);
    }

    public int getNVertex(String string) {
        return this.models.get(string).getNVertex();
    }

    public int getNFace(String string) {
        return this.models.get(string).getNFace();
    }

    public Grids getGrids(String string) {
        return this.models.get(string).getGrids();
    }

    public float getSpectrumData(String string, String string2, int n) {
        return this.models.get(string).getSpectrumData(string2, n);
    }

    public SpectrumMaps getAvailableSpectrumMaps(String string) {
        if (this.models.get(string) == null) {
            return null;
        }
        return this.models.get(string).getAvailableSpectrumMaps();
    }

    public SpectrumMap getSpectrumMap(String string, String string2) {
        if (this.models.get(string) == null) {
            return null;
        }
        return this.models.get(string).getSpectrum(string2);
    }

    public int getVboId(String string, int n) {
        return this.models.get(string).getVboId(n);
    }

    public float[] getSurfaceSpecular(String string) {
        return this.models.get(string).getSpecular();
    }

    public float[] getSurfaceDiffuse(String string) {
        return this.models.get(string).getDiffuse();
    }

    public float[] getSurfaceAmbient(String string) {
        return this.models.get(string).getAmbient();
    }

    public float getSurfaceShiness(String string) {
        return this.models.get(string).getShiness();
    }

    public boolean isCompiled() {
        return this.compiled;
    }
}

