/*
 * Decompiled with CFR 0.152.
 */
package aigis.gl;

import aigis.Scene;
import aigis.gl.Renderer;
import aigis.model.SpectrumMap;
import aigis.model.loader.FastReader;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.util.awt.TextRenderer;
import java.awt.Font;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.ArrayList;

public class ColorBar {
    private ArrayList<Model> models = new ArrayList();
    private Font font = new Font("Monospaced", 0, 20);
    private TextRenderer tr = new TextRenderer(this.font, true, true);

    public ColorBar() {
        this.init();
    }

    public void init() {
        this.models.clear();
        Model model = new Model();
        model.title = "Rainbow";
        model.table = new float[][]{{0.0f, 0.0f, 1.0f}, {0.0f, 1.0f, 1.0f}, {0.0f, 1.0f, 0.0f}, {1.0f, 1.0f, 0.0f}, {1.0f, 0.0f, 0.0f}};
        this.models.add(model);
        model = new Model();
        model.title = "Grayscale";
        model.table = new float[][]{{0.0f, 0.0f, 0.0f}, {1.0f, 1.0f, 1.0f}};
        this.models.add(model);
    }

    public void load(String string, String string2) throws IOException {
        float f;
        FastReader fastReader = new FastReader(string2);
        ArrayList<float[]> arrayList = new ArrayList<float[]>();
        while ((f = fastReader.nextFloat()) != Float.NEGATIVE_INFINITY) {
            float[] fArray = new float[]{f, fastReader.nextFloat(), fastReader.nextFloat()};
            arrayList.add(fArray);
        }
        Model model = new Model();
        model.title = string;
        model.table = (float[][])arrayList.toArray((T[])new float[arrayList.size()][3]);
        this.models.add(model);
    }

    public String[] getTitles() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Model model : this.models) {
            arrayList.add(model.title);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private void drawString(String string, int n, int n2, int n3, boolean bl) {
        float f = (float)n2 / (float)n3;
        int n4 = n2 - 720;
        int n5 = n3 - 640 + 50;
        float f2 = (float)n3 / 850.0f + 0.25f;
        if (bl) {
            this.tr.draw3D(string, 360.0f + (float)n4 * 0.5f - (float)string.length() * 6.0f * f2, 90.0f + (float)n5 * 0.15f, 0.0f, f2);
            return;
        }
        if ((double)f > 0.9) {
            this.tr.draw3D(string, (float)(100 + 130 * n) + (float)n4 * 0.5f + (float)n5 * (0.2f * (float)(n - 2)) - (float)string.length() * 6.0f * f2, 30.0f + (float)n5 * 0.05f, 0.0f, f2);
        } else {
            this.tr.draw3D(string, (float)(200 + 88 * n) + (float)n4 * 0.5f + (float)n5 * (0.15f * (float)(n - 2)) - (float)string.length() * 6.0f * f2, 30.0f + (float)n5 * 0.05f, 0.0f, f2 * 0.7f);
        }
    }

    public void draw(GL2 gL2, int n, int n2, Scene scene, Renderer renderer) {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6 = renderer.getCurrentModel();
        String string7 = renderer.getCurrentSpectrum();
        SpectrumMap spectrumMap = scene.getRegisteredModels().getSpectrumMap(string6, string7);
        if (spectrumMap == null) {
            return;
        }
        String string8 = spectrumMap.getName();
        String string9 = spectrumMap.getUnitRepresentation();
        if (string8 == null || string9 == null) {
            return;
        }
        gL2.glDisable(2896);
        gL2.glDisable(16384);
        gL2.glDisable(3168);
        gL2.glDisable(3169);
        gL2.glDisable(3170);
        gL2.glDisable(3171);
        double d = spectrumMap.maxColor;
        double d2 = spectrumMap.minColor;
        double d3 = (d - d2) / 4.0;
        BigDecimal bigDecimal = new BigDecimal(d);
        BigDecimal bigDecimal2 = new BigDecimal(d2);
        BigDecimal bigDecimal3 = new BigDecimal(d2 + d3);
        BigDecimal bigDecimal4 = new BigDecimal(d2 + d3 * 2.0);
        BigDecimal bigDecimal5 = new BigDecimal(d2 + d3 * 3.0);
        if (d < 0.001) {
            DecimalFormat decimalFormat = new DecimalFormat("0.00E0");
            string5 = decimalFormat.format(bigDecimal);
            string4 = decimalFormat.format(bigDecimal2);
            string3 = decimalFormat.format(bigDecimal3);
            string2 = decimalFormat.format(bigDecimal4);
            string = decimalFormat.format(bigDecimal5);
        } else {
            string5 = bigDecimal.setScale(3, RoundingMode.DOWN).toString();
            string4 = bigDecimal2.setScale(3, RoundingMode.DOWN).toString();
            string3 = bigDecimal3.setScale(3, RoundingMode.DOWN).toString();
            string2 = bigDecimal4.setScale(3, RoundingMode.DOWN).toString();
            string = bigDecimal5.setScale(3, RoundingMode.DOWN).toString();
        }
        float f = n;
        float f2 = n2;
        float f3 = f / f2;
        float f4 = f2 / 850.0f + 0.25f;
        this.tr.beginRendering(n, n2);
        this.tr.setColor(1.0f, 1.0f, 0.0f, 1.0f);
        this.drawString(string4, 0, n, n2, false);
        this.drawString(string3, 1, n, n2, false);
        this.drawString(string2, 2, n, n2, false);
        this.drawString(string, 3, n, n2, false);
        this.drawString(string5, 4, n, n2, false);
        this.tr.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        this.drawString(string8, 2, n, n2, true);
        this.tr.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        if (!string9.equals("-")) {
            this.tr.draw3D("(" + string9 + ")", (float)n - (float)string9.length() * 8.0f * f4 - 42.0f * f4, 10.0f * f4, 0.0f, f4 * 0.8f);
        }
        this.tr.endRendering();
        gL2.glLoadIdentity();
        gL2.glDisable(2929);
        gL2.glTranslated(0.0, -0.55, -10.0);
        gL2.glBegin(8);
        Model model = this.models.get(renderer.setting.colorbarIndex);
        float[][] fArray = model.table;
        float f5 = -0.6f;
        float f6 = 1.2f / (float)(fArray.length - 1);
        if ((double)f3 < 0.9) {
            f5 = -0.4f;
            f6 = 0.8f / (float)(fArray.length - 1);
        }
        for (int i = 0; i < fArray.length; ++i) {
            float[] fArray2 = fArray[i];
            gL2.glColor3f(fArray2[0], fArray2[1], fArray2[2]);
            gL2.glVertex2d(f5 + f6 * (float)i, 0.06);
            gL2.glVertex2d(f5 + f6 * (float)i, 0.0);
        }
        gL2.glEnd();
        gL2.glEnable(2929);
    }

    public float[] convertSpectrum(int n, SpectrumMap spectrumMap, float f) {
        Model model = this.models.get(n);
        float[][] fArray = model.table;
        float[] fArray2 = new float[]{0.8f, 0.8f, 0.8f};
        if (f != Float.NEGATIVE_INFINITY) {
            if (spectrumMap.maxColor <= (double)f) {
                fArray2 = fArray[fArray.length - 1];
            } else if (spectrumMap.minColor >= (double)f) {
                fArray2 = fArray[0];
            } else {
                double d = spectrumMap.maxColor - spectrumMap.minColor;
                double d2 = (float)(((double)f - spectrumMap.minColor) / d);
                int n2 = (int)Math.floor(d2 /= (double)(1.0f / (float)(fArray.length - 1)));
                float[] fArray3 = fArray[n2];
                float[] fArray4 = fArray[n2 + 1];
                float f2 = (float)(d2 % 1.0);
                fArray2[0] = fArray3[0] + (fArray4[0] - fArray3[0]) * f2;
                fArray2[1] = fArray3[1] + (fArray4[1] - fArray3[1]) * f2;
                fArray2[2] = fArray3[2] + (fArray4[2] - fArray3[2]) * f2;
            }
        }
        return new float[]{fArray2[0], fArray2[1], fArray2[2], 1.0f};
    }

    private class Model {
        public String title;
        public float[][] table;

        private Model() {
        }
    }
}

