/*
 * Decompiled with CFR 0.152.
 */
package aigis.ui;

import aigis.App;
import aigis.Logger;
import aigis.model.ChartData;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.chart.event.OverlayChangeListener;
import org.jfree.chart.panel.AbstractOverlay;
import org.jfree.chart.panel.Overlay;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.Second;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.time.TimeSeriesDataItem;
import org.jfree.data.xy.XYDataItem;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.text.TextUtilities;
import org.jfree.ui.TextAnchor;

public class MainChartPanel
extends JPanel
implements ChartMouseListener,
ActionListener {
    private static final long serialVersionUID = 1420405664687350894L;
    private ChartData data;
    private ChartPanel chartPanel;
    private InfoOverlay infoOverlay;
    private boolean isTime = false;
    private String[] xColumns;
    private String[] yRows;
    private List<Integer> polygonList = new ArrayList<Integer>();
    private List<String[]> xColumnsList = new ArrayList<String[]>();
    private List<String[]> yRowsList = new ArrayList<String[]>();
    private JButton jbuttonChart = new JButton("save chart");

    public void setChartInfo(String string, String string2, String string3) {
        this.chartPanel.getChart().setTitle(string);
        XYPlot xYPlot = (XYPlot)this.chartPanel.getChart().getPlot();
        xYPlot.getDomainAxis().setLabel(string2);
        xYPlot.getRangeAxis().setLabel(string3);
    }

    public void clearData() {
        XYPlot xYPlot = this.chartPanel.getChart().getXYPlot();
        xYPlot.setDataset(null);
        xYPlot.setDomainCrosshairValue(0.0);
        this.infoOverlay.setValues(null, null);
        this.polygonList.clear();
        this.xColumnsList.clear();
        this.yRowsList.clear();
    }

    public void setData(ChartData chartData) {
        if (this.data != null && this.data.mapName.equals(chartData.mapName)) {
            return;
        }
        this.initChart(chartData.isTimeFormat);
        this.data = chartData;
    }

    public void addPolygonID(Integer n) {
        this.polygonList.add(n + 1);
        if (this.data == null) {
            return;
        }
        if (this.data.data.length < n) {
            return;
        }
        XYPlot xYPlot = this.chartPanel.getChart().getXYPlot();
        if (this.data.isTimeFormat) {
            TimeSeriesCollection timeSeriesCollection = (TimeSeriesCollection)xYPlot.getDataset();
            if (timeSeriesCollection == null) {
                timeSeriesCollection = new TimeSeriesCollection();
            }
            TimeSeries timeSeries = new TimeSeries((Comparable)((Object)""), Second.class);
            this.xColumns = new String[this.data.timeRange[n].length];
            this.yRows = new String[this.data.timeRange[n].length];
            for (int i = 0; i < this.data.timeRange[n].length; ++i) {
                Date date = new Date(this.data.timeRange[n][i] * 1000L);
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                int n2 = calendar.get(2) + 1;
                int n3 = calendar.get(1);
                int n4 = calendar.get(5);
                int n5 = calendar.get(11);
                int n6 = calendar.get(12);
                int n7 = calendar.get(13);
                timeSeries.addOrUpdate((RegularTimePeriod)new Second(n7, n6, n5, n4, n2, n3), (double)this.data.data[n][i]);
                this.xColumns[i] = String.valueOf(this.data.data[n][i]);
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss");
                this.yRows[i] = String.valueOf(simpleDateFormat.format(calendar.getTime()) + ":00");
            }
            timeSeries.setDescription("" + (n + 1));
            timeSeriesCollection.addSeries(timeSeries);
            this.chartPanel.getChart().getXYPlot().setDataset((XYDataset)timeSeriesCollection);
        } else {
            XYSeriesCollection xYSeriesCollection = (XYSeriesCollection)xYPlot.getDataset();
            if (xYSeriesCollection == null) {
                xYSeriesCollection = new XYSeriesCollection();
            }
            if (xYSeriesCollection.getSeriesIndex((Comparable)((Object)n.toString())) >= 0) {
                return;
            }
            XYSeries xYSeries = new XYSeries((Comparable)((Object)n.toString()));
            this.xColumns = new String[this.data.range[n].length];
            this.yRows = new String[this.data.range[n].length];
            for (int i = 0; i < this.data.range[n].length; ++i) {
                xYSeries.add((double)this.data.range[n][i], (double)this.data.data[n][i]);
                this.xColumns[i] = String.valueOf(this.data.data[n][i]);
                this.yRows[i] = String.valueOf(this.data.range[n][i]);
            }
            xYSeries.setDescription("" + (n + 1));
            xYSeriesCollection.addSeries(xYSeries);
            this.chartPanel.getChart().getXYPlot().setDataset((XYDataset)xYSeriesCollection);
        }
        this.xColumnsList.add(this.xColumns);
        this.yRowsList.add(this.yRows);
        this.infoOverlay.setValues(null, null);
    }

    public void saveChart() {
        try {
            File file;
            String string = "";
            String string2 = App.getProp("saveGraphDataPath");
            string = string2 == null ? System.getProperty("user.home") : (!(file = new File(string2)).exists() || string2.equals("") ? System.getProperty("user.home") : string2);
            string = string + File.separator + "graphdata.txt";
            file = new File(string);
            FileWriter fileWriter = new FileWriter(file, true);
            for (int i = 0; i < this.polygonList.size(); ++i) {
                int n;
                fileWriter.write(String.valueOf(this.polygonList.get(i)));
                for (n = 0; n < this.yRowsList.get(i).length; ++n) {
                    fileWriter.write(" " + this.yRowsList.get(i)[n]);
                }
                fileWriter.write("\n");
                fileWriter.write(String.valueOf(this.polygonList.get(i)));
                for (n = 0; n < this.xColumnsList.get(i).length; ++n) {
                    fileWriter.write(" " + this.xColumnsList.get(i)[n]);
                }
                fileWriter.write("\n");
            }
            fileWriter.close();
            JOptionPane.showMessageDialog(this, "The chart data was saved successfully.\n'" + string + "'", "Done", 1);
        }
        catch (Exception exception) {
            Logger.Error(exception);
            JOptionPane.showMessageDialog(this, "Failed to save the chart data. \n[" + exception.getMessage() + "]", "Error", 0);
        }
    }

    public void chartMouseClicked(ChartMouseEvent chartMouseEvent) {
    }

    public void chartMouseMoved(ChartMouseEvent chartMouseEvent) {
        Rectangle2D rectangle2D = this.chartPanel.getScreenDataArea();
        JFreeChart jFreeChart = chartMouseEvent.getChart();
        XYPlot xYPlot = jFreeChart.getXYPlot();
        ValueAxis valueAxis = xYPlot.getDomainAxis();
        EntityCollection entityCollection = this.chartPanel.getChartRenderingInfo().getEntityCollection();
        Iterator iterator = entityCollection.iterator();
        int n = Integer.MAX_VALUE;
        int n2 = chartMouseEvent.getTrigger().getX();
        XYItemEntity xYItemEntity = null;
        while (iterator.hasNext()) {
            int n3;
            ChartEntity chartEntity = (ChartEntity)iterator.next();
            if (!(chartEntity instanceof XYItemEntity) || (n3 = Math.abs(n2 - (int)chartEntity.getArea().getBounds().getMaxX())) >= n) continue;
            n = n3;
            xYItemEntity = (XYItemEntity)chartEntity;
        }
        if (xYItemEntity == null) {
            return;
        }
        double d = valueAxis.java2DToValue(xYItemEntity.getArea().getBounds().getCenterX(), rectangle2D, xYPlot.getDomainAxisEdge());
        xYPlot.setDomainCrosshairValue(d);
        int n4 = xYItemEntity.getItem();
        String string = null;
        InfoValue[] infoValueArray = null;
        if (this.isTime) {
            TimeSeriesCollection timeSeriesCollection = (TimeSeriesCollection)xYPlot.getDataset();
            infoValueArray = new InfoValue[timeSeriesCollection.getSeriesCount()];
            for (int i = 0; i < timeSeriesCollection.getSeriesCount(); ++i) {
                Paint paint = xYPlot.getRenderer().getSeriesPaint(i);
                TimeSeries timeSeries = timeSeriesCollection.getSeries(i);
                TimeSeriesDataItem timeSeriesDataItem = timeSeries.getDataItem(n4);
                InfoValue infoValue = new InfoValue();
                infoValue.color = (Color)paint;
                infoValue.title = timeSeries.getDescription();
                infoValue.value = timeSeriesDataItem.getValue().toString();
                infoValueArray[i] = infoValue;
                if (i != xYItemEntity.getSeriesIndex()) continue;
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss");
                string = String.valueOf(simpleDateFormat.format(timeSeriesDataItem.getPeriod().getMiddleMillisecond()) + ":00");
            }
        } else {
            XYSeriesCollection xYSeriesCollection = (XYSeriesCollection)xYPlot.getDataset();
            infoValueArray = new InfoValue[xYSeriesCollection.getSeriesCount()];
            for (int i = 0; i < xYSeriesCollection.getSeriesCount(); ++i) {
                Paint paint = xYPlot.getRenderer().getSeriesPaint(i);
                XYSeries xYSeries = xYSeriesCollection.getSeries(i);
                XYDataItem xYDataItem = xYSeries.getDataItem(n4);
                InfoValue infoValue = new InfoValue();
                infoValue.color = (Color)paint;
                infoValue.title = xYSeries.getDescription();
                infoValue.value = xYDataItem.getY().toString();
                infoValueArray[i] = infoValue;
                if (i != xYItemEntity.getSeriesIndex()) continue;
                string = xYDataItem.getX().toString();
            }
        }
        this.infoOverlay.setLocation(xYItemEntity.getArea().getBounds().getCenterX(), chartMouseEvent.getTrigger().getY());
        this.infoOverlay.setValues(string, infoValueArray);
    }

    public void initChart(boolean bl) {
        this.isTime = bl;
        JFreeChart jFreeChart = bl ? ChartFactory.createTimeSeriesChart(null, null, null, null) : ChartFactory.createXYLineChart(null, null, null, null);
        jFreeChart.removeLegend();
        if (this.chartPanel != null) {
            this.remove((Component)this.chartPanel);
        }
        this.chartPanel = new ChartPanel(jFreeChart);
        this.chartPanel.addChartMouseListener((ChartMouseListener)this);
        this.chartPanel.setMaximumDrawWidth(2048);
        this.chartPanel.setMaximumDrawHeight(2048);
        XYPlot xYPlot = (XYPlot)jFreeChart.getPlot();
        xYPlot.setBackgroundPaint((Paint)Color.WHITE);
        xYPlot.setDomainGridlinePaint((Paint)Color.LIGHT_GRAY);
        xYPlot.setRangeGridlinePaint((Paint)Color.LIGHT_GRAY);
        XYLineAndShapeRenderer xYLineAndShapeRenderer = new XYLineAndShapeRenderer();
        xYLineAndShapeRenderer.setBaseShapesVisible(true);
        xYPlot.setRenderer(0, (XYItemRenderer)xYLineAndShapeRenderer);
        xYPlot.setDomainCrosshairVisible(true);
        xYPlot.setRangeCrosshairLockedOnData(true);
        this.setLayout(new BorderLayout());
        this.add((Component)this.chartPanel, "Center");
        this.infoOverlay = new InfoOverlay();
        this.chartPanel.addOverlay((Overlay)this.infoOverlay);
        this.chartPanel.setLayout((LayoutManager)new FlowLayout(2));
        this.chartPanel.add((Component)this.jbuttonChart);
        this.jbuttonChart.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.jbuttonChart) {
            this.saveChart();
        }
    }

    class InfoOverlay
    extends AbstractOverlay
    implements Overlay {
        private double basePosX;
        private double basePosY;
        private String title;
        private InfoValue[] values;

        InfoOverlay() {
        }

        public void setLocation(double d, double d2) {
            this.basePosX = d;
            this.basePosY = d2;
        }

        public void setValues(String string, InfoValue[] infoValueArray) {
            this.title = string;
            this.values = infoValueArray;
        }

        public String gettitle() {
            return this.title;
        }

        public void addChangeListener(OverlayChangeListener overlayChangeListener) {
        }

        public void paintOverlay(Graphics2D graphics2D, ChartPanel chartPanel) {
            if (this.title == null) {
                return;
            }
            Shape shape = graphics2D.getClip();
            Rectangle2D rectangle2D = chartPanel.getScreenDataArea();
            graphics2D.clip(rectangle2D);
            graphics2D.setStroke(new BasicStroke(1.0f));
            int n = 180;
            int n2 = 20;
            int n3 = (int)this.basePosX + 10;
            int n4 = (int)this.basePosY + 30;
            if ((double)(n3 + n + 10) > rectangle2D.getMaxX()) {
                n3 = (int)rectangle2D.getMaxX() - n - 10;
            }
            if ((double)(n4 + n2 * (this.values.length + 1) + 10) > rectangle2D.getMaxY()) {
                n4 = (int)rectangle2D.getMaxY() - n2 * (this.values.length + 1) - 10;
            }
            Rectangle rectangle = new Rectangle(n3, n4, n, n2);
            graphics2D.setClip(n3, n4, n + 1, n2 + 1);
            graphics2D.setPaint(Color.LIGHT_GRAY);
            graphics2D.fill(rectangle);
            graphics2D.draw(rectangle);
            graphics2D.setPaint(Color.WHITE);
            TextUtilities.drawAlignedString((String)this.title, (Graphics2D)graphics2D, (float)(n3 + 6), (float)(n4 + 3), (TextAnchor)TextAnchor.TOP_LEFT);
            for (int i = 0; i < this.values.length; ++i) {
                InfoValue infoValue = this.values[i];
                int n5 = n3;
                int n6 = n4 + n2 * (i + 1);
                Rectangle rectangle2 = new Rectangle(n5, n6, n / 2, n2);
                graphics2D.setClip(n5, n6, n / 2 + 1, n2 + 1);
                graphics2D.setPaint(Color.WHITE);
                graphics2D.fill(rectangle2);
                graphics2D.setPaint(Color.LIGHT_GRAY);
                graphics2D.draw(rectangle2);
                graphics2D.setPaint(infoValue.color);
                Rectangle rectangle3 = new Rectangle(n5 + 6, n6 + 6, n2 / 2, n2 / 2);
                graphics2D.fill(rectangle3);
                graphics2D.setPaint(Color.GRAY);
                TextUtilities.drawAlignedString((String)infoValue.title, (Graphics2D)graphics2D, (float)(n5 + 20), (float)(n6 + 3), (TextAnchor)TextAnchor.TOP_LEFT);
                rectangle2 = new Rectangle(n5 += n / 2, n6, n / 2, n2);
                graphics2D.setClip(n5, n6, n / 2 + 1, n2 + 1);
                graphics2D.setPaint(Color.WHITE);
                graphics2D.fill(rectangle2);
                graphics2D.setPaint(Color.LIGHT_GRAY);
                graphics2D.draw(rectangle2);
                graphics2D.setPaint(Color.GRAY);
                TextUtilities.drawAlignedString((String)infoValue.value, (Graphics2D)graphics2D, (float)(n5 + 6), (float)(n6 + 3), (TextAnchor)TextAnchor.TOP_LEFT);
            }
            graphics2D.setClip(shape);
        }

        public void removeChangeListener(OverlayChangeListener overlayChangeListener) {
        }
    }

    class InfoValue {
        public Color color;
        public String title;
        public String value;

        InfoValue() {
        }
    }
}

