/*
 * Decompiled with CFR 0.152.
 */
package aigis.ui;

import aigis.Logger;
import aigis.gl.Textures;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class TexPrevDialog
extends JDialog {
    private JLabel lblImageName;
    private JLabel lblImagePrev;
    private JTextArea textArea;

    public static void main(String[] stringArray) {
        try {
            TexPrevDialog texPrevDialog = new TexPrevDialog(null);
            texPrevDialog.setDefaultCloseOperation(2);
            texPrevDialog.setVisible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public TexPrevDialog(Frame frame) {
        super(frame);
        this.setTitle("Preview");
        this.setSize(800, 500);
        this.setLocationRelativeTo(frame);
        this.getContentPane().setLayout(new BorderLayout());
        JComponent jComponent = new JPanel();
        jComponent.setLayout(new FlowLayout(2));
        this.getContentPane().add((Component)jComponent, "South");
        JButton jButton = new JButton("OK");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TexPrevDialog.this.setVisible(false);
            }
        });
        jButton.setActionCommand("OK");
        jComponent.add(jButton);
        this.getRootPane().setDefaultButton(jButton);
        jComponent = new JPanel();
        jComponent.setPreferredSize(new Dimension(300, 10));
        this.getContentPane().add((Component)jComponent, "West");
        jComponent.setLayout(new BorderLayout(0, 0));
        this.lblImageName = new JLabel("");
        this.lblImageName.setHorizontalAlignment(0);
        jComponent.add((Component)this.lblImageName, "North");
        this.lblImagePrev = new JLabel("");
        this.lblImagePrev.setHorizontalTextPosition(0);
        this.lblImagePrev.setHorizontalAlignment(0);
        this.lblImagePrev.setAlignmentX(0.5f);
        jComponent.add((Component)this.lblImagePrev, "Center");
        jComponent = new JScrollPane();
        this.getContentPane().add((Component)jComponent, "Center");
        this.textArea = new JTextArea();
        this.textArea.setEditable(false);
        ((JScrollPane)jComponent).setViewportView(this.textArea);
    }

    public void setTextureSetting(Textures.Setting setting) {
        int n;
        this.lblImageName.setText(setting.imageFile.getName());
        ImageIcon imageIcon = null;
        imageIcon = setting.img == null ? new ImageIcon(setting.imageFile.getAbsolutePath()) : new ImageIcon(setting.img);
        float f = (float)imageIcon.getIconHeight() / (float)imageIcon.getIconWidth();
        if (f > 1.0f) {
            n = (int)(1.0f / f * 400.0f);
            if (n == 0) {
                n = 1;
            }
            imageIcon = new ImageIcon(imageIcon.getImage().getScaledInstance(n, 400, 1));
        } else {
            n = (int)(f * 300.0f);
            if (n == 0) {
                n = 1;
            }
            imageIcon = new ImageIcon(imageIcon.getImage().getScaledInstance(300, n, 1));
        }
        this.lblImagePrev.setIcon(imageIcon);
        if (setting.infoFile == null) {
            this.textArea.setText("None");
            return;
        }
        try {
            StringBuffer stringBuffer = new StringBuffer();
            List<String> list = Files.readAllLines(setting.infoFile.toPath(), StandardCharsets.UTF_8);
            for (String string : list) {
                stringBuffer.append(string);
                stringBuffer.append("\n");
            }
            this.textArea.setText(stringBuffer.toString());
        }
        catch (IOException iOException) {
            Logger.Error(iOException);
            this.textArea.setText(iOException.getLocalizedMessage());
        }
    }

    protected JLabel getLblImageName() {
        return this.lblImageName;
    }

    protected JLabel getLblImagePrev() {
        return this.lblImagePrev;
    }

    protected JTextArea getTextArea() {
        return this.textArea;
    }
}

