/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.jfr.settings;

import com.oracle.jrockit.jfr.EventInfo;
import java.util.Map;
import oracle.jrockit.jfr.events.EventDescriptor;
import oracle.jrockit.jfr.settings.StringParse;

@Deprecated
public final class EventSetting {
    static final String THRESHOLD = "threshold";
    static final String PERIOD = "period";
    static final String STACKTRACE = "stackTrace";
    static final String ENABLED = "enabled";
    private final int id;
    private final boolean enabled;
    private final boolean stacktrace;
    private final long thresholdNanos;
    private final long periodMillis;

    public EventSetting(int n, Map<String, String> map) {
        this.id = n;
        this.enabled = this.getEnabled(map);
        this.stacktrace = this.getStackTrace(map);
        this.thresholdNanos = this.getThreshold(map);
        this.periodMillis = this.getPeriod(map);
    }

    private boolean getEnabled(Map<String, String> map) {
        String string = this.getIgnoreCase(map, ENABLED);
        return string != null ? StringParse.enable(string) : false;
    }

    private long getThreshold(Map<String, String> map) {
        String string = this.getIgnoreCase(map, THRESHOLD);
        return string != null ? StringParse.threshold(string) : -1L;
    }

    private boolean getStackTrace(Map<String, String> map) {
        String string = this.getIgnoreCase(map, STACKTRACE);
        return string != null ? StringParse.stackTrace(string) : false;
    }

    private long getPeriod(Map<String, String> map) {
        String string = this.getIgnoreCase(map, PERIOD);
        return string != null ? StringParse.period(string) / 1000000L : -1L;
    }

    private String getIgnoreCase(Map<String, String> map, String string) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (!entry.getKey().equalsIgnoreCase(string)) continue;
            return entry.getValue();
        }
        return null;
    }

    public EventSetting(int n, boolean bl, boolean bl2, long l, long l2) {
        this.id = n;
        this.enabled = bl;
        this.stacktrace = bl2;
        this.thresholdNanos = l;
        this.periodMillis = l2;
    }

    public EventSetting(int n) {
        this(n, false, false, -1L, -1L);
    }

    public EventSetting() {
        this(0);
    }

    public EventSetting(EventDescriptor eventDescriptor, boolean bl, boolean bl2, long l, long l2) {
        this(eventDescriptor.getId(), bl, eventDescriptor.hasStackTrace() ? bl2 : false, l, eventDescriptor.isRequestable() ? l2 : 0L);
    }

    public EventSetting(EventDescriptor eventDescriptor, EventSetting eventSetting) {
        this(eventDescriptor, eventSetting.isEnabled(), eventSetting.isStacktraceEnabled(), eventSetting.getThreshold(), eventSetting.getPeriod());
    }

    public EventSetting(EventInfo eventInfo, boolean bl, boolean bl2, long l, long l2) {
        this(eventInfo.getId(), bl, eventInfo.hasStackTrace() ? bl2 : false, l, eventInfo.isRequestable() ? l2 : 0L);
    }

    public EventSetting(EventInfo eventInfo, EventSetting eventSetting) {
        this(eventInfo, eventSetting.isEnabled(), eventSetting.isStacktraceEnabled(), eventSetting.getThreshold(), eventSetting.getPeriod());
    }

    public EventSetting(EventSetting eventSetting, EventSetting eventSetting2) {
        assert (eventSetting.id == eventSetting2.id || eventSetting2.id == 0);
        this.id = eventSetting.id;
        this.enabled = eventSetting.enabled || eventSetting2.enabled;
        this.stacktrace = eventSetting.stacktrace || eventSetting2.stacktrace;
        long l = Math.min(eventSetting.thresholdNanos, eventSetting2.thresholdNanos);
        if (l == -1L) {
            l = Math.max(eventSetting.thresholdNanos, eventSetting2.thresholdNanos);
        }
        this.thresholdNanos = l;
        long l2 = Math.min(eventSetting.periodMillis, eventSetting2.periodMillis);
        if (l2 == -1L || l2 == 0L) {
            l2 = Math.max(eventSetting.periodMillis, eventSetting2.periodMillis);
        }
        this.periodMillis = l2;
    }

    public EventSetting(EventInfo eventInfo) {
        this(eventInfo.getId());
    }

    public int getId() {
        return this.id;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isStacktraceEnabled() {
        return this.stacktrace;
    }

    public long getThreshold() {
        return this.thresholdNanos;
    }

    public long getPeriod() {
        return this.periodMillis;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{ id=").append(this.id);
        if (this.enabled) {
            stringBuilder.append(", enabled");
        }
        if (this.stacktrace) {
            stringBuilder.append(", stacktrace");
        }
        if (this.thresholdNanos != 0L) {
            stringBuilder.append(", threshold=").append(this.thresholdNanos).append("ns");
        }
        if (this.periodMillis != 0L) {
            stringBuilder.append(", period=").append(this.periodMillis).append("ms");
        }
        stringBuilder.append(" }");
        return stringBuilder.toString();
    }

    public int hashCode() {
        int n = 17;
        n = 31 * n + this.id;
        n = 31 * n + (this.enabled ? 1 : 0);
        n = 31 * n + (int)(this.thresholdNanos ^ this.thresholdNanos >>> 32);
        n = 31 * n + (int)(this.periodMillis ^ this.periodMillis >>> 32);
        return n;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof EventSetting) {
            EventSetting eventSetting = (EventSetting)object;
            return eventSetting.id == this.id && eventSetting.enabled == this.enabled && eventSetting.thresholdNanos == this.thresholdNanos && eventSetting.stacktrace == this.stacktrace && eventSetting.periodMillis == this.periodMillis;
        }
        return false;
    }
}

