/*
 * Decompiled with CFR 0.152.
 */
package aigis;

import aigis.App;
import aigis.Logger;
import aigis.gl.ColorBar;
import aigis.model.ChartData;
import aigis.model.General3D;
import aigis.model.Model;
import aigis.model.Models;
import aigis.model.SettingModel;
import aigis.model.SpectrumMap;
import aigis.model.loader.ChartLoader;
import aigis.model.loader.GeneralLoader;
import aigis.ui.LoadingDialog;
import com.jogamp.opengl.GL2;
import java.awt.geom.Point2D;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;

public class Scene {
    public ColorBar colorbar = new ColorBar();
    private SettingModel settings = new SettingModel();
    private Models registeredModels = new Models();
    private HashMap<String, ChartData> chartData = new HashMap();
    private double modelSize = 0.0;
    private boolean isDirty = false;
    public ArrayList<General3D> generals = new ArrayList();

    public void load(File file, LoadingDialog loadingDialog, boolean bl) throws Exception {
        try {
            loadingDialog.updateInfo("configfile");
            this.settings.loadData(file);
            this.settings.dump();
            this.registeredModels = new Models();
            loadingDialog.updateInfo(this.settings.getShapePath());
            Model model = new Model(file.getAbsolutePath(), this.settings.getShapePath(), this.settings.getGridwPath(), this.settings.getGridrPath());
            this.registeredModels.addModel("ModelLow", model);
            if (this.settings.getShapeHighPath() != null) {
                loadingDialog.updateInfo(this.settings.getShapeHighPath());
                this.registeredModels.addModel("ModelHigh", new Model(file.getAbsolutePath(), this.settings.getShapeHighPath(), this.settings.getGridwPath(), this.settings.getGridrPath()));
            }
            this.modelSize = model.getSize();
            this.loadGeneral3D();
            this.loadMapData(loadingDialog, bl);
        }
        catch (Exception exception) {
            this.registeredModels = new Models();
            this.generals.clear();
            this.settings.clear();
            this.chartData.clear();
            throw exception;
        }
        this.registeredModels.addSpectrumMap("ModelLow", "#None", new SpectrumMap(this.registeredModels.getNFace("ModelLow"), "#None", this.colorbar));
        this.registeredModels.changeSpectrumMap("ModelLow", "#None", 0);
        this.isDirty = true;
    }

    public void loadGeneral3D() throws Exception {
        String string = this.settings.getGridPath();
        if (string != null) {
            File file = new File(this.settings.getBaseDir().getAbsolutePath() + File.separator + string);
            String[] stringArray = file.list();
            ArrayList<General3D> arrayList = new ArrayList<General3D>();
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                if (string2.trim().startsWith(".")) continue;
                General3D general3D = this.findGeneral(string2);
                if (general3D == null) {
                    general3D = new General3D();
                }
                GeneralLoader.load(file.getAbsolutePath(), string2, general3D);
                arrayList.add(general3D);
            }
            this.generals = arrayList;
        } else {
            this.generals.clear();
        }
    }

    public void loadGeneral3D(String string) throws Exception {
        String string2 = this.settings.getGridPath();
        if (string2 == null) {
            return;
        }
        File file = new File(this.settings.getBaseDir().getAbsolutePath() + File.separator + string2);
        General3D general3D = this.findGeneral(string);
        if (general3D == null) {
            general3D = new General3D();
            this.generals.add(general3D);
        }
        GeneralLoader.load(file.getAbsolutePath(), string, general3D);
    }

    private General3D findGeneral(String string) {
        for (General3D general3D : this.generals) {
            if (!general3D.name.equals(string)) continue;
            return general3D;
        }
        return null;
    }

    public void loadLookUpTable() throws Exception {
        String string = App.getProp("LookUpTablePath");
        if (string == null) {
            return;
        }
        File file = new File(string);
        File[] fileArray = file.listFiles();
        this.colorbar.init();
        if (fileArray == null) {
            return;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].getName().startsWith(".")) continue;
            Logger.Debug("lookup:" + fileArray[i].getName());
            this.colorbar.load(fileArray[i].getName(), fileArray[i].getAbsolutePath());
        }
    }

    public void loadMapData(LoadingDialog loadingDialog, boolean bl) throws Exception {
        Object object;
        Object object2;
        Object object3;
        String string;
        String[] stringArray = new String[]{"ModelLow", "ModelHigh"};
        String[] stringArray2 = new String[]{"MapData", "MapDataHigh"};
        String[] stringArray3 = new String[]{this.settings.getMapData(), this.settings.getMapHighData()};
        String string2 = this.settings.getMapDir();
        String string3 = this.settings.getMapHighDir();
        if (string2 != null) {
            stringArray2[0] = string2;
        }
        if (string3 != null) {
            stringArray2[1] = string3;
        }
        int n = this.registeredModels.getSize();
        ArrayList<String> arrayList = new ArrayList<String>();
        String string4 = this.settings.getBaseDir().getAbsolutePath() + File.separator;
        for (int i = 0; i < n; ++i) {
            int n2;
            string = stringArray[i];
            loadingDialog.updateInfo(stringArray2[i]);
            this.registeredModels.clearSpectrumMap(string);
            this.registeredModels.addSpectrumMap(string, "#None", new SpectrumMap(this.registeredModels.getNFace(string), "#None", this.colorbar));
            object3 = new File(string4 + stringArray2[i]);
            File[] fileArray = ((File)object3).listFiles();
            object2 = stringArray3[i];
            if (object2 != null) {
                object = ((String)object2).split(",", 0);
                n2 = fileArray.length;
                fileArray = new File[fileArray.length + ((String[])object).length];
                System.arraycopy(((File)object3).listFiles(), 0, fileArray, 0, n2);
                for (int j = 0; j < ((Object)object).length; ++j) {
                    fileArray[n2 + j] = new File(string4 + (String)object[j]);
                }
            }
            if (fileArray == null) {
                fileArray = new File[]{};
            }
            Arrays.sort(fileArray, new Comparator<File>(){

                @Override
                public int compare(File file, File file2) {
                    return file.getName().compareToIgnoreCase(file2.getName());
                }
            });
            object = new ArrayList();
            for (n2 = 0; n2 < fileArray.length; ++n2) {
                if (fileArray[n2].getName().startsWith(".")) continue;
                SpectrumMap spectrumMap = new SpectrumMap(fileArray[n2].getPath(), this.colorbar);
                String string5 = spectrumMap.getName() + "-" + string;
                if (arrayList.contains(string5)) {
                    throw new Exception("The map name \"" + spectrumMap.getName() + "\" is duplicated in \"" + fileArray[n2].getName() + "\".");
                }
                Logger.Debug("spec:" + string5);
                arrayList.add(string5);
                object.add(spectrumMap);
            }
            if (bl) {
                Collections.sort(object, new Comparator<SpectrumMap>(){

                    @Override
                    public int compare(SpectrumMap spectrumMap, SpectrumMap spectrumMap2) {
                        return spectrumMap.getName().compareToIgnoreCase(spectrumMap2.getName());
                    }
                });
            }
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                SpectrumMap spectrumMap = (SpectrumMap)iterator.next();
                this.registeredModels.addSpectrumMap(string, spectrumMap.getName(), spectrumMap);
            }
        }
        this.chartData.clear();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        string = this.settings.getChartData();
        if (string != null) {
            object3 = string.split(",", 0);
            for (int i = 0; i < ((String[])object3).length; ++i) {
                loadingDialog.updateInfo(object3[i]);
                object2 = this.registeredModels.getModel("ModelHigh") == null ? ChartLoader.load(string4 + object3[i], this.registeredModels.getModel((String)"ModelLow").nVertex, -1, loadingDialog) : ChartLoader.load(string4 + object3[i], this.registeredModels.getModel((String)"ModelLow").nVertex, this.registeredModels.getModel((String)"ModelHigh").nVertex, loadingDialog);
                object = ((ChartData)object2).mapName + "-" + ((ChartData)object2).mapType;
                if (!arrayList.contains(object)) {
                    throw new Exception("The map name \"" + ((ChartData)object2).mapName + "\" is not defined in '" + ((ChartData)object2).mapType + "' type of map data. \n[" + (String)object3[i] + "].");
                }
                if (arrayList2.contains(object)) {
                    throw new Exception("The map name \"" + ((ChartData)object2).mapName + "\" is duplicated in \"" + (String)object3[i] + "\".");
                }
                arrayList2.add(object);
                Logger.Debug("chart:" + (String)object);
                this.chartData.put((String)object, (ChartData)object2);
            }
        }
    }

    public ChartData getChartData(String string, String string2) {
        return this.chartData.get(string2 + "-" + string);
    }

    public Integer getPointPolygonID(String string, Point2D.Double double_, float[] fArray, double[] dArray, double[] dArray2, int[] nArray) {
        if (fArray[0] > 1.0f) {
            nArray[0] = (int)((float)nArray[0] / fArray[0]);
            nArray[2] = (int)((float)nArray[2] / fArray[0]);
        }
        if (fArray[1] > 1.0f) {
            nArray[1] = (int)((float)nArray[1] / fArray[1]);
            nArray[3] = (int)((float)nArray[3] / fArray[1]);
        }
        return this.registeredModels.getID(string, double_, dArray, dArray2, nArray);
    }

    public void compile(GL2 gL2) throws Exception {
        if (!this.isDirty) {
            return;
        }
        try {
            this.registeredModels.compile(gL2);
            this.isDirty = false;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            Logger.Error(outOfMemoryError);
            throw new Exception("OutOfMemoryError");
        }
    }

    public Models getRegisteredModels() {
        return this.registeredModels;
    }

    public boolean isChangeModel() {
        return this.settings.isChangeModel();
    }

    public boolean hasHighModel() {
        return this.settings.getShapeHighPath() != null;
    }

    public String getTitle() {
        return this.settings.getBodyName();
    }

    public String getHighModelName() {
        if (this.hasHighModel()) {
            return new File(this.settings.getShapeHighPath()).getName();
        }
        return null;
    }

    public String getModelName() {
        return new File(this.settings.getShapePath()).getName();
    }

    public String getImageMapPath() {
        return this.settings.getImageMapPath();
    }

    public double getModelSize() {
        return this.modelSize;
    }
}

