/*
 * Decompiled with CFR 0.152.
 */
package aigis.model.loader;

import aigis.model.LatLon;
import aigis.model.Model;
import aigis.model.loader.FastReader;
import java.io.IOException;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;

public class ModelLoader {
    public static void load(String string, Model model) throws IOException {
        int n;
        int n2;
        FastReader fastReader = new FastReader(string);
        model.nVertex = n2 = fastReader.nextInt();
        model.vertices = new float[n2][3];
        double d = 0.0;
        for (n = 0; n < n2; ++n) {
            fastReader.nextInt();
            for (int i = 0; i < 3; ++i) {
                model.vertices[n][i] = fastReader.nextFloat();
            }
            float f = model.vertices[n][0];
            float f2 = model.vertices[n][1];
            double d2 = f * f + f2 * f2;
            if (!(d < d2)) continue;
            d = d2;
        }
        model.setSize(Math.sqrt(d) * 2.0);
        model.nFace = n = fastReader.nextInt();
        model.faces = new int[n][3];
        for (int i = 0; i < n; ++i) {
            fastReader.nextInt();
            model.faces[i][0] = fastReader.nextInt();
            model.faces[i][1] = fastReader.nextInt();
            model.faces[i][2] = fastReader.nextInt();
        }
        fastReader.close();
        ModelLoader.makeNormalUV(model, n);
    }

    public static void makeNormalUV(Model model, int n) {
        float[][] fArray = new float[n][6];
        model.nNormal = n;
        model.normals = new float[n][3];
        model.normalIndex = new int[3 * n];
        model.point = new float[n][3];
        model.info = new LatLon[n];
        for (int i = 0; i < n; ++i) {
            Point3f point3f = new Point3f(model.vertices[model.faces[i][0] - 1][0], model.vertices[model.faces[i][0] - 1][1], model.vertices[model.faces[i][0] - 1][2]);
            Point3f point3f2 = new Point3f(model.vertices[model.faces[i][1] - 1][0], model.vertices[model.faces[i][1] - 1][1], model.vertices[model.faces[i][1] - 1][2]);
            Point3f point3f3 = new Point3f(model.vertices[model.faces[i][2] - 1][0], model.vertices[model.faces[i][2] - 1][1], model.vertices[model.faces[i][2] - 1][2]);
            model.point[i][0] = (point3f.x + point3f2.x + point3f3.x) / 3.0f;
            model.point[i][1] = (point3f.y + point3f2.y + point3f3.y) / 3.0f;
            model.point[i][2] = (point3f.z + point3f2.z + point3f3.z) / 3.0f;
            model.info[i] = new LatLon(model.point[i][0], model.point[i][1], model.point[i][2]);
            Vector3f vector3f = new Vector3f(point3f2.x - point3f.x, point3f2.y - point3f.y, point3f2.z - point3f.z);
            Vector3f vector3f2 = new Vector3f(point3f3.x - point3f.x, point3f3.y - point3f.y, point3f3.z - point3f.z);
            Vector3f vector3f3 = new Vector3f();
            vector3f3.cross(vector3f, vector3f2);
            vector3f3.normalize();
            model.normals[i][0] = vector3f3.x;
            model.normals[i][1] = vector3f3.y;
            model.normals[i][2] = vector3f3.z;
            model.normalIndex[i * 3 + 0] = i;
            model.normalIndex[i * 3 + 1] = i;
            model.normalIndex[i * 3 + 2] = i;
            LatLon latLon = new LatLon(point3f.x, point3f.y, point3f.z);
            fArray[i][0] = (float)latLon.longitude / 360.0f;
            fArray[i][1] = (float)(latLon.latitude + 90.0) / 180.0f;
            latLon = new LatLon(point3f2.x, point3f2.y, point3f2.z);
            fArray[i][2] = (float)latLon.longitude / 360.0f;
            fArray[i][3] = (float)(latLon.latitude + 90.0) / 180.0f;
            latLon = new LatLon(point3f3.x, point3f3.y, point3f3.z);
            fArray[i][4] = (float)latLon.longitude / 360.0f;
            fArray[i][5] = (float)(latLon.latitude + 90.0) / 180.0f;
            int[] nArray = new int[]{0, 2, 4, 0, 2};
            for (int j = 0; j < 3; ++j) {
                if (!((double)fArray[i][nArray[j]] > 0.9)) continue;
                for (int k = 0; k < 2; ++k) {
                    if (!((double)fArray[i][nArray[j + k + 1]] < 0.1)) continue;
                    fArray[i][nArray[j + k + 1]] = 1.0f + fArray[i][nArray[j + k + 1]];
                }
            }
        }
        model.uv = fArray;
    }
}

