/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class ByteBufferInputStream
extends InputStream {
    private static final int BYTE_MASK = 255;
    private final ByteBuffer buf;

    public ByteBufferInputStream(ByteBuffer buffer) {
        this.buf = buffer;
    }

    @Override
    public int read() throws IOException {
        if (!this.buf.hasRemaining()) {
            return -1;
        }
        return this.buf.get() & 0xFF;
    }

    @Override
    public int read(byte[] bytes, int off, int len) throws IOException {
        if (!this.buf.hasRemaining()) {
            return -1;
        }
        int readLen = Math.min(len, this.buf.remaining());
        this.buf.get(bytes, off, readLen);
        return readLen;
    }
}

