/*
 * Decompiled with CFR 0.152.
 */
package jogamp.newt;

import com.jogamp.common.ExceptionUtils;
import com.jogamp.common.util.ArrayHashSet;
import com.jogamp.common.util.Bitfield;
import com.jogamp.common.util.PropertyAccess;
import com.jogamp.common.util.ReflectionUtil;
import com.jogamp.common.util.locks.LockFactory;
import com.jogamp.common.util.locks.RecursiveLock;
import com.jogamp.nativewindow.AbstractGraphicsConfiguration;
import com.jogamp.nativewindow.AbstractGraphicsDevice;
import com.jogamp.nativewindow.CapabilitiesChooser;
import com.jogamp.nativewindow.CapabilitiesImmutable;
import com.jogamp.nativewindow.NativeSurface;
import com.jogamp.nativewindow.NativeWindow;
import com.jogamp.nativewindow.NativeWindowException;
import com.jogamp.nativewindow.NativeWindowFactory;
import com.jogamp.nativewindow.OffscreenLayerSurface;
import com.jogamp.nativewindow.SurfaceUpdatedListener;
import com.jogamp.nativewindow.WindowClosingProtocol;
import com.jogamp.nativewindow.util.Insets;
import com.jogamp.nativewindow.util.InsetsImmutable;
import com.jogamp.nativewindow.util.Point;
import com.jogamp.nativewindow.util.Rectangle;
import com.jogamp.nativewindow.util.RectangleImmutable;
import com.jogamp.newt.Display;
import com.jogamp.newt.MonitorDevice;
import com.jogamp.newt.MonitorMode;
import com.jogamp.newt.NewtFactory;
import com.jogamp.newt.Screen;
import com.jogamp.newt.Window;
import com.jogamp.newt.event.DoubleTapScrollGesture;
import com.jogamp.newt.event.GestureHandler;
import com.jogamp.newt.event.InputEvent;
import com.jogamp.newt.event.KeyEvent;
import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.event.MonitorEvent;
import com.jogamp.newt.event.MonitorModeListener;
import com.jogamp.newt.event.MouseEvent;
import com.jogamp.newt.event.MouseListener;
import com.jogamp.newt.event.NEWTEvent;
import com.jogamp.newt.event.NEWTEventConsumer;
import com.jogamp.newt.event.WindowEvent;
import com.jogamp.newt.event.WindowListener;
import com.jogamp.newt.event.WindowUpdateEvent;
import com.jogamp.opengl.math.FloatUtil;
import java.io.PrintStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import jogamp.common.os.PlatformPropsImpl;
import jogamp.nativewindow.SurfaceScaleUtils;
import jogamp.nativewindow.SurfaceUpdatedHelper;
import jogamp.newt.Debug;
import jogamp.newt.DisplayImpl;
import jogamp.newt.OffscreenWindow;
import jogamp.newt.PointerIconImpl;
import jogamp.newt.ScreenImpl;

public abstract class WindowImpl
implements Window,
NEWTEventConsumer {
    public static final boolean DEBUG_TEST_REPARENT_INCOMPATIBLE;
    private static final boolean DEBUG_FREEZE_AT_VISIBILITY_FAILURE;
    protected static final ArrayList<WeakReference<WindowImpl>> windowList;
    static final long QUEUED_EVENT_TO = 1200L;
    private static final String COMMA = ", ";
    private static final MouseEvent.PointerType[] constMousePointerTypes;
    private volatile long windowHandle = 0L;
    protected final float[] minPixelScale = new float[]{1.0f, 1.0f};
    protected final float[] maxPixelScale = new float[]{1.0f, 1.0f};
    protected final float[] hasPixelScale = new float[]{1.0f, 1.0f};
    protected final float[] reqPixelScale = new float[]{0.0f, 0.0f};
    private volatile int[] pixelPos = new int[]{64, 64};
    private volatile int[] pixelSize = new int[]{128, 128};
    private volatile int[] windowPos = new int[]{64, 64};
    private volatile int[] windowSize = new int[]{128, 128};
    private volatile Insets insets = new Insets();
    private boolean blockInsetsChange = false;
    private final RecursiveLock windowLock = LockFactory.createRecursiveLock();
    private int surfaceLockCount = 0;
    private ScreenImpl screen;
    private boolean screenReferenceAdded = false;
    private NativeWindow parentWindow = null;
    private long parentWindowHandle = 0L;
    private AbstractGraphicsConfiguration config = null;
    protected CapabilitiesImmutable capsRequested = null;
    protected CapabilitiesChooser capabilitiesChooser = null;
    private List<MonitorDevice> fullscreenMonitors = null;
    private int nfs_width;
    private int nfs_height;
    private int nfs_x;
    private int nfs_y;
    private NativeWindow nfs_parent = null;
    private String title = "Newt Window";
    private PointerIconImpl pointerIcon = null;
    private LifecycleHook lifecycleHook = null;
    protected static final int QUIRK_BIT_VISIBILITY = 0;
    protected static final Bitfield quirks;
    protected static final int STATE_BIT_COUNT_ALL_PUBLIC = 15;
    protected static final int STATE_MASK_ALL_PUBLIC = Short.MAX_VALUE;
    protected static final int STATE_BIT_FULLSCREEN_SPAN = 15;
    protected static final int STATE_BIT_COUNT_ALL_RECONFIG = 16;
    protected static final int STATE_MASK_ALL_RECONFIG = 65535;
    protected static final int STATE_MASK_ALL_PUBLIC_SUPPORTED = 32765;
    static final int PSTATE_BIT_FOCUS_CHANGE_BROKEN = 30;
    static final int PSTATE_BIT_FULLSCREEN_MAINMONITOR = 31;
    static final int STATE_MASK_FULLSCREEN_SPAN = 32768;
    static final int PSTATE_MASK_FOCUS_CHANGE_BROKEN = 0x40000000;
    static final int PSTATE_MASK_FULLSCREEN_MAINMONITOR = Integer.MIN_VALUE;
    private static final int STATE_MASK_FULLSCREEN_NFS = 1824;
    protected static final int STATE_MASK_CREATENATIVE = 18431;
    protected static final int CHANGE_MASK_VISIBILITY = Integer.MIN_VALUE;
    protected static final int CHANGE_MASK_VISIBILITY_FAST = 0x40000000;
    protected static final int CHANGE_MASK_PARENTING = 0x20000000;
    protected static final int CHANGE_MASK_DECORATION = 0x10000000;
    protected static final int CHANGE_MASK_ALWAYSONTOP = 0x8000000;
    protected static final int CHANGE_MASK_ALWAYSONBOTTOM = 0x4000000;
    protected static final int CHANGE_MASK_STICKY = 0x2000000;
    protected static final int CHANGE_MASK_RESIZABLE = 0x1000000;
    protected static final int CHANGE_MASK_MAXIMIZED_VERT = 0x800000;
    protected static final int CHANGE_MASK_MAXIMIZED_HORZ = 0x400000;
    protected static final int CHANGE_MASK_FULLSCREEN = 0x200000;
    private final Bitfield stateMask = Bitfield.Factory.synchronize((Bitfield)Bitfield.Factory.create((int)32));
    private final Bitfield stateMaskNFS = Bitfield.Factory.synchronize((Bitfield)Bitfield.Factory.create((int)32));
    protected int supportedReconfigStateMask = 0;
    protected static final int minimumReconfigStateMask = 9;
    protected static final int mutableSizePosReconfigStateMask = 18697;
    private Runnable windowDestroyNotifyAction = null;
    private Window.FocusRunnable focusAction = null;
    private KeyListener keyboardFocusHandler = null;
    private final SurfaceUpdatedHelper surfaceUpdatedHelper = new SurfaceUpdatedHelper();
    private final Object childWindowsLock = new Object();
    private final ArrayList<NativeWindow> childWindows = new ArrayList();
    private ArrayList<MouseListener> mouseListeners = new ArrayList();
    private final PointerState0 pState0 = new PointerState0();
    private final PointerState1 pState1 = new PointerState1();
    private final ArrayHashSet<Short> pName2pID = new ArrayHashSet(false, 16, 0.75f);
    private boolean defaultGestureHandlerEnabled = true;
    private DoubleTapScrollGesture gesture2PtrTouchScroll = null;
    private ArrayList<GestureHandler> pointerGestureHandler = new ArrayList();
    private ArrayList<GestureHandler.GestureListener> gestureListeners = new ArrayList();
    private ArrayList<KeyListener> keyListeners = new ArrayList();
    private ArrayList<WindowListener> windowListeners = new ArrayList();
    private boolean repaintQueued = false;
    private final Object closingListenerLock = new Object();
    private WindowClosingProtocol.WindowClosingMode defaultCloseOperation = WindowClosingProtocol.WindowClosingMode.DISPOSE_ON_CLOSE;
    private final Runnable destroyAction = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            boolean bl = false;
            if (null != WindowImpl.this.lifecycleHook) {
                bl = WindowImpl.this.lifecycleHook.pauseRenderingAction();
            }
            if (null != WindowImpl.this.lifecycleHook) {
                WindowImpl.this.lifecycleHook.destroyActionPreLock();
            }
            RuntimeException runtimeException = null;
            RecursiveLock recursiveLock = WindowImpl.this.windowLock;
            recursiveLock.lock();
            try {
                if (Window.DEBUG_IMPLEMENTATION) {
                    System.err.println("Window DestroyAction() hasScreen " + (null != WindowImpl.this.screen) + ", isNativeValid " + WindowImpl.this.isNativeValid() + " - " + WindowImpl.getThreadName());
                }
                WindowImpl.this.sendWindowEvent(102);
                Object object = WindowImpl.this.childWindowsLock;
                synchronized (object) {
                    if (WindowImpl.this.childWindows.size() > 0) {
                        ArrayList arrayList = (ArrayList)WindowImpl.this.childWindows.clone();
                        while (arrayList.size() > 0) {
                            NativeWindow nativeWindow = (NativeWindow)arrayList.remove(0);
                            if (nativeWindow instanceof WindowImpl) {
                                ((WindowImpl)nativeWindow).windowDestroyNotify(true);
                                continue;
                            }
                            nativeWindow.destroy();
                        }
                    }
                }
                if (null != WindowImpl.this.lifecycleHook) {
                    try {
                        WindowImpl.this.lifecycleHook.destroyActionInLock();
                    }
                    catch (RuntimeException runtimeException2) {
                        runtimeException = runtimeException2;
                    }
                }
                if (WindowImpl.this.isNativeValid()) {
                    WindowImpl.this.screen.removeMonitorModeListener(WindowImpl.this.monitorModeListenerImpl);
                    WindowImpl.this.closeNativeImpl();
                    object = WindowImpl.this.config.getScreen().getDevice();
                    if (object != WindowImpl.this.screen.getDisplay().getGraphicsDevice()) {
                        object.close();
                    }
                    WindowImpl.this.setGraphicsConfiguration(null);
                }
                WindowImpl.this.removeScreenReference();
                object = WindowImpl.this.screen.getDisplay();
                if (null != object) {
                    ((Display)object).validateEDTStopped();
                }
                WindowImpl.this.sendWindowEvent(106);
                if (Window.DEBUG_IMPLEMENTATION) {
                    System.err.println("Window.destroy() END " + WindowImpl.getThreadName());
                    if (null != runtimeException) {
                        System.err.println("Window.destroy() caught: " + runtimeException.getMessage());
                        runtimeException.printStackTrace();
                    }
                }
                if (null != runtimeException) {
                    throw runtimeException;
                }
            }
            finally {
                WindowImpl.this.setWindowHandle(0L);
                WindowImpl.this.resetStateMask();
                WindowImpl.this.fullscreenMonitors = null;
                WindowImpl.this.parentWindowHandle = 0L;
                WindowImpl.this.hasPixelScale[0] = 1.0f;
                WindowImpl.this.hasPixelScale[1] = 1.0f;
                WindowImpl.this.minPixelScale[0] = 1.0f;
                WindowImpl.this.minPixelScale[1] = 1.0f;
                WindowImpl.this.maxPixelScale[0] = 1.0f;
                WindowImpl.this.maxPixelScale[1] = 1.0f;
                recursiveLock.unlock();
            }
            if (bl) {
                WindowImpl.this.lifecycleHook.resumeRenderingAction();
            }
        }
    };
    private final Runnable reparentActionRecreate = new Runnable(){

        @Override
        public final void run() {
            RecursiveLock recursiveLock = WindowImpl.this.windowLock;
            recursiveLock.lock();
            try {
                if (Window.DEBUG_IMPLEMENTATION) {
                    System.err.println("Window.reparent: ReparentActionRecreate (" + WindowImpl.getThreadName() + ") state " + WindowImpl.this.getStateMaskString() + ", windowHandle " + WindowImpl.toHexString(WindowImpl.this.windowHandle) + ", parentWindowHandle " + WindowImpl.toHexString(WindowImpl.this.parentWindowHandle) + ", parentWindow " + Display.hashCodeNullSafe(WindowImpl.this.parentWindow));
                }
                WindowImpl.this.setVisibleActionImpl(true);
                WindowImpl.this.requestFocusInt(0L == WindowImpl.this.parentWindowHandle);
            }
            finally {
                recursiveLock.unlock();
            }
        }
    };
    private final int[] normPosSize = new int[]{0, 0, 0, 0};
    private final boolean[] normPosSizeStored = new boolean[]{false, false};
    private final Object scaleLock = new Object();
    private final Runnable requestFocusAction = new Runnable(){

        @Override
        public final void run() {
            if (Window.DEBUG_IMPLEMENTATION) {
                System.err.println("Window.RequestFocusAction: force 0 - (" + WindowImpl.getThreadName() + "): state " + WindowImpl.this.getStateMaskString() + " -> focus true - windowHandle " + WindowImpl.toHexString(WindowImpl.this.windowHandle) + " parentWindowHandle " + WindowImpl.toHexString(WindowImpl.this.parentWindowHandle));
            }
            WindowImpl.this.requestFocusImpl(false);
        }
    };
    private final Runnable requestFocusActionForced = new Runnable(){

        @Override
        public final void run() {
            if (Window.DEBUG_IMPLEMENTATION) {
                System.err.println("Window.RequestFocusAction: force 1 - (" + WindowImpl.getThreadName() + "): state " + WindowImpl.this.getStateMaskString() + " -> focus true - windowHandle " + WindowImpl.toHexString(WindowImpl.this.windowHandle) + " parentWindowHandle " + WindowImpl.toHexString(WindowImpl.this.parentWindowHandle));
            }
            WindowImpl.this.requestFocusImpl(true);
        }
    };
    private final FullScreenAction fullScreenAction = new FullScreenAction();
    private final MonitorModeListenerImpl monitorModeListenerImpl = new MonitorModeListenerImpl();
    private static final int keyTrackingRange = 255;
    private final Bitfield keyPressedState = Bitfield.Factory.create((int)256);
    protected boolean keyboardVisible = false;

    public static final void shutdownAll() {
        int n = windowList.size();
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("Window.shutdownAll " + n + " instances, on thread " + WindowImpl.getThreadName());
        }
        for (int i = 0; i < n && windowList.size() > 0; ++i) {
            WindowImpl windowImpl = (WindowImpl)windowList.remove(0).get();
            if (DEBUG_IMPLEMENTATION) {
                long l = null != windowImpl ? windowImpl.getWindowHandle() : 0L;
                System.err.println("Window.shutdownAll[" + (i + 1) + "/" + n + "]: " + WindowImpl.toHexString(l) + ", GCed " + (null == windowImpl));
            }
            if (null == windowImpl) continue;
            windowImpl.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addWindow2List(WindowImpl windowImpl) {
        ArrayList<WeakReference<WindowImpl>> arrayList = windowList;
        synchronized (arrayList) {
            int n = 0;
            int n2 = 0;
            while (n < windowList.size()) {
                if (null == windowList.get(n).get()) {
                    ++n2;
                    windowList.remove(n);
                    continue;
                }
                ++n;
            }
            windowList.add(new WeakReference<WindowImpl>(windowImpl));
            if (DEBUG_IMPLEMENTATION) {
                System.err.println("Window.addWindow2List: GCed " + n2 + ", size " + windowList.size());
            }
        }
    }

    final void resetStateMask() {
        this.stateMask.clearField(false);
        this.stateMask.put32(0, 32, 2 | (null != this.parentWindow ? 4 : 0) | (this.isReconfigureMaskSupported(256) ? 256 : 0) | (this.isReconfigureMaskSupported(16384) ? 16384 : 0) | 0x1000 | Integer.MIN_VALUE);
        this.stateMaskNFS.clearField(false);
        this.normPosSizeStored[0] = false;
        this.normPosSizeStored[1] = false;
    }

    @Override
    public final int getStatePublicBitCount() {
        return 15;
    }

    @Override
    public final int getStatePublicBitmask() {
        return Short.MAX_VALUE;
    }

    @Override
    public final int getStateMask() {
        return this.stateMask.get32(0, 15);
    }

    @Override
    public final String getStateMaskString() {
        return WindowImpl.appendStateBits(new StringBuilder(), this.stateMask.get32(0, 15), false).toString();
    }

    @Override
    public final int getSupportedStateMask() {
        return this.supportedReconfigStateMask & 0x7FFD;
    }

    @Override
    public final String getSupportedStateMaskString() {
        return WindowImpl.appendStateBits(new StringBuilder(), this.getSupportedStateMask(), true).toString();
    }

    protected static StringBuilder appendStateBits(StringBuilder stringBuilder, int n, boolean bl) {
        stringBuilder.append("[");
        if (bl) {
            if (0 != (Integer.MIN_VALUE & n)) {
                stringBuilder.append("*");
            }
            if (0 != (0x40000000 & n)) {
                stringBuilder.append("*");
            }
        }
        stringBuilder.append(0 != (1 & n) ? "visible" : "invisible");
        if (0 != (2 & n)) {
            stringBuilder.append(COMMA);
            stringBuilder.append("autopos");
        }
        if (bl) {
            stringBuilder.append(COMMA);
            if (0 != (0x20000000 & n)) {
                stringBuilder.append("*");
            }
            stringBuilder.append(0 != (4 & n) ? "child" : "toplevel");
        } else if (0 != (4 & n)) {
            stringBuilder.append(COMMA);
            stringBuilder.append("child");
        }
        if (0 != (8 & n)) {
            stringBuilder.append(COMMA);
            stringBuilder.append("focused");
        }
        if (bl) {
            stringBuilder.append(COMMA);
            if (0 != (0x10000000 & n)) {
                stringBuilder.append("*");
            }
            stringBuilder.append(0 != (0x10 & n) ? "undecor" : "decor");
        } else if (0 != (0x10 & n)) {
            stringBuilder.append(COMMA);
            stringBuilder.append("undecor");
        }
        if (bl) {
            stringBuilder.append(COMMA);
            if (0 != (0x8000000 & n)) {
                stringBuilder.append("*");
            }
            if (0 == (0x20 & n)) {
                stringBuilder.append("!");
            }
            stringBuilder.append("aontop");
        } else if (0 != (0x20 & n)) {
            stringBuilder.append(COMMA);
            stringBuilder.append("aontop");
        }
        if (bl) {
            stringBuilder.append(COMMA);
            if (0 != (0x4000000 & n)) {
                stringBuilder.append("*");
            }
            stringBuilder.append(0 != (0x40 & n) ? "aonbottom" : "!aonbottom");
        } else if (0 != (0x40 & n)) {
            stringBuilder.append(COMMA);
            stringBuilder.append("aonbottom");
        }
        if (bl) {
            stringBuilder.append(COMMA);
            if (0 != (0x2000000 & n)) {
                stringBuilder.append("*");
            }
            stringBuilder.append(0 != (0x80 & n) ? "sticky" : "unsticky");
        } else if (0 != (0x80 & n)) {
            stringBuilder.append(COMMA);
            stringBuilder.append("sticky");
        }
        if (bl) {
            stringBuilder.append(COMMA);
            stringBuilder.append(0 != (0x4000 & n) ? "repositionable" : "fixed-position");
        } else if (0 != (0x4000 & n)) {
            stringBuilder.append(COMMA);
            stringBuilder.append("repositionable");
        }
        if (bl) {
            stringBuilder.append(COMMA);
            if (0 != (0x1000000 & n)) {
                stringBuilder.append("*");
            }
            stringBuilder.append(0 != (0x100 & n) ? "resizable" : "fixed-size");
        } else if (0 != (0x100 & n)) {
            stringBuilder.append(COMMA);
            stringBuilder.append("resizable");
        }
        if (bl) {
            stringBuilder.append(COMMA);
            stringBuilder.append("max[");
            if (0 != (0x400000 & n)) {
                stringBuilder.append("*");
            }
            if (0 == (0x400 & n)) {
                stringBuilder.append("!");
            }
            stringBuilder.append("h");
            stringBuilder.append(COMMA);
            if (0 != (0x800000 & n)) {
                stringBuilder.append("*");
            }
            if (0 == (0x200 & n)) {
                stringBuilder.append("!");
            }
            stringBuilder.append("v");
            stringBuilder.append("]");
        } else if (0 != (0x600 & n)) {
            stringBuilder.append(COMMA);
            stringBuilder.append("max[");
            if (0 != (0x400 & n)) {
                stringBuilder.append("h");
            }
            if (0 != (0x200 & n)) {
                stringBuilder.append("v");
            }
            stringBuilder.append("]");
        }
        if (bl) {
            stringBuilder.append(COMMA);
            if (0 != (0x200000 & n)) {
                stringBuilder.append("*");
            }
            stringBuilder.append("fullscreen[");
            stringBuilder.append(0 != (0x800 & n));
            stringBuilder.append(0 != (0x8000 & n) ? ", span" : "");
            stringBuilder.append("]");
        } else if (0 != (0x800 & n)) {
            stringBuilder.append(COMMA);
            stringBuilder.append("fullscreen");
        }
        if (bl) {
            stringBuilder.append(COMMA);
            stringBuilder.append("pointer[");
            if (0 == (0x1000 & n)) {
                stringBuilder.append("invisible");
            } else {
                stringBuilder.append("visible");
            }
            stringBuilder.append(COMMA);
            if (0 != (0x2000 & n)) {
                stringBuilder.append("confined");
            } else {
                stringBuilder.append("free");
            }
            stringBuilder.append("]");
        } else if (0 == (0x1000 & n) || 0 != (0x2000 & n)) {
            stringBuilder.append(COMMA);
            stringBuilder.append("pointer[");
            if (0 == (0x1000 & n)) {
                stringBuilder.append("invisible");
            }
            if (0 != (0x2000 & n)) {
                stringBuilder.append(COMMA);
                stringBuilder.append("confined");
            }
            stringBuilder.append("]");
        }
        stringBuilder.append("]");
        return stringBuilder;
    }

    private static Class<?> getWindowClass(String string) throws ClassNotFoundException {
        return NewtFactory.getCustomClass(string, "WindowDriver");
    }

    public static WindowImpl create(NativeWindow nativeWindow, long l, Screen screen, CapabilitiesImmutable capabilitiesImmutable) {
        try {
            Class clazz = capabilitiesImmutable.isOnscreen() ? WindowImpl.getWindowClass(screen.getDisplay().getType()) : OffscreenWindow.class;
            WindowImpl windowImpl = (WindowImpl)clazz.newInstance();
            windowImpl.parentWindow = nativeWindow;
            windowImpl.parentWindowHandle = l;
            windowImpl.screen = (ScreenImpl)screen;
            windowImpl.capsRequested = (CapabilitiesImmutable)capabilitiesImmutable.cloneMutable();
            windowImpl.instantiationFinished();
            WindowImpl.addWindow2List(windowImpl);
            return windowImpl;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new NativeWindowException(throwable);
        }
    }

    public static WindowImpl create(Object[] objectArray, Screen screen, CapabilitiesImmutable capabilitiesImmutable) {
        try {
            Class<?> clazz = WindowImpl.getWindowClass(screen.getDisplay().getType());
            Class[] classArray = WindowImpl.getCustomConstructorArgumentTypes(clazz);
            if (null == classArray) {
                throw new NativeWindowException("WindowClass " + clazz + " doesn't support custom arguments in constructor");
            }
            int n = WindowImpl.verifyConstructorArgumentTypes(classArray, objectArray);
            if (n < objectArray.length) {
                throw new NativeWindowException("WindowClass " + clazz + " constructor mismatch at argument #" + n + "; Constructor: " + WindowImpl.getTypeStrList(classArray) + ", arguments: " + WindowImpl.getArgsStrList(objectArray));
            }
            WindowImpl windowImpl = (WindowImpl)ReflectionUtil.createInstance(clazz, (Class[])classArray, (Object[])objectArray);
            windowImpl.screen = (ScreenImpl)screen;
            windowImpl.capsRequested = (CapabilitiesImmutable)capabilitiesImmutable.cloneMutable();
            windowImpl.instantiationFinished();
            WindowImpl.addWindow2List(windowImpl);
            return windowImpl;
        }
        catch (Throwable throwable) {
            throw new NativeWindowException(throwable);
        }
    }

    private final void shutdown() {
        if (null != this.lifecycleHook) {
            this.lifecycleHook.shutdownRenderingAction();
        }
        this.setWindowHandle(0L);
        this.resetStateMask();
        this.fullscreenMonitors = null;
        this.parentWindowHandle = 0L;
    }

    protected final void setGraphicsConfiguration(AbstractGraphicsConfiguration abstractGraphicsConfiguration) {
        this.config = abstractGraphicsConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createNative() {
        boolean bl;
        long l;
        if (DEBUG_IMPLEMENTATION) {
            l = System.nanoTime();
            System.err.println("Window.createNative() START (" + WindowImpl.getThreadName() + COMMA + this + ")");
        } else {
            l = 0L;
        }
        if (null != this.parentWindow && 1 >= this.parentWindow.lockSurface()) {
            throw new NativeWindowException("Parent surface lock: not ready: " + this.parentWindow);
        }
        boolean bl2 = bl = null != this.parentWindow || 0L != this.parentWindowHandle;
        if (bl && (this.stateMask.get(1) || 0 > this.getX() || 0 > this.getY())) {
            this.defineWindowPosition(0, 0);
        }
        boolean bl3 = false;
        try {
            if (this.validateParentWindowHandle()) {
                if (!this.screenReferenceAdded) {
                    this.screen.addReference();
                    this.screenReferenceAdded = true;
                }
                if (this.canCreateNativeImpl()) {
                    boolean bl4;
                    int n;
                    int n2;
                    boolean[] blArray = new boolean[]{false};
                    if (this.stateMask.get(1)) {
                        n2 = 0;
                        n = 0;
                        bl4 = false;
                    } else {
                        n2 = this.getX();
                        n = this.getY();
                        bl4 = true;
                    }
                    long l2 = System.currentTimeMillis();
                    this.createNativeImpl(blArray);
                    bl4 = bl4 && !blArray[0];
                    this.supportedReconfigStateMask = this.getSupportedReconfigMaskImpl() & 0xFFFF;
                    if (DEBUG_IMPLEMENTATION) {
                        boolean bl5 = 9 == (9 & this.supportedReconfigStateMask);
                        System.err.println("Supported Reconfig.1 (minimum-ok " + bl5 + "): " + WindowImpl.appendStateBits(new StringBuilder(), this.supportedReconfigStateMask, true).toString());
                    }
                    this.screen.addMonitorModeListener(this.monitorModeListenerImpl);
                    this.setTitleImpl(this.title);
                    this.setPointerIconIntern(this.pointerIcon);
                    if (!this.stateMask.get(12)) {
                        if (this.isReconfigureMaskSupported(4096)) {
                            this.setPointerVisibleIntern(this.stateMask.get(12));
                        } else {
                            this.stateMask.set(12);
                        }
                    }
                    if (this.stateMask.get(13)) {
                        if (this.isReconfigureMaskSupported(8192)) {
                            this.confinePointerImpl(true);
                        } else {
                            this.stateMask.clear(13);
                        }
                    }
                    this.setKeyboardVisible(this.keyboardVisible);
                    long l3 = this.waitForVisible(true, false);
                    if (0L <= l3) {
                        if (this.stateMask.get(11) && !this.isReconfigureMaskSupported(2048)) {
                            this.stateMask.clear(11);
                        }
                        if (this.stateMask.get(11)) {
                            FullScreenAction fullScreenAction = this.fullScreenAction;
                            synchronized (fullScreenAction) {
                                this.stateMask.clear(11);
                                this.fullScreenAction.init(true);
                                this.fullScreenAction.run();
                            }
                        } else if (!bl) {
                            this.waitForPosition(bl4, n2, n, 1000L);
                        }
                        if (DEBUG_IMPLEMENTATION) {
                            System.err.println("Window.createNative(): position[modified " + blArray[0] + ", use " + bl4 + "], elapsed " + (System.currentTimeMillis() - l2) + " ms");
                        }
                        bl3 = true;
                    }
                }
            }
        }
        finally {
            if (null != this.parentWindow) {
                this.parentWindow.unlockSurface();
            }
        }
        if (bl3) {
            this.requestFocusInt(this.isFullscreen());
            ((DisplayImpl)this.screen.getDisplay()).dispatchMessagesNative();
        }
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("Window.createNative() END (" + WindowImpl.getThreadName() + COMMA + this + ") total " + (double)(System.nanoTime() - l) / 1000000.0 + "ms");
        }
        return this.isNativeValid();
    }

    private void removeScreenReference() {
        if (this.screenReferenceAdded) {
            this.screenReferenceAdded = false;
            this.screen.removeReference();
        }
    }

    private boolean validateParentWindowHandle() {
        if (null != this.parentWindow) {
            this.parentWindowHandle = WindowImpl.getNativeWindowHandle(this.parentWindow);
            return 0L != this.parentWindowHandle;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getNativeWindowHandle(NativeWindow nativeWindow) {
        long l = 0L;
        if (null != nativeWindow) {
            boolean bl = false;
            if (1 < nativeWindow.lockSurface()) {
                bl = true;
                try {
                    l = nativeWindow.getWindowHandle();
                    if (0L == l) {
                        throw new NativeWindowException("Parent native window handle is NULL, after succesful locking: " + nativeWindow);
                    }
                }
                catch (NativeWindowException nativeWindowException) {
                    if (DEBUG_IMPLEMENTATION) {
                        System.err.println("Window.getNativeWindowHandle: not successful yet: " + nativeWindowException);
                    }
                }
                finally {
                    nativeWindow.unlockSurface();
                }
            }
            if (DEBUG_IMPLEMENTATION) {
                System.err.println("Window.getNativeWindowHandle: locked " + bl + COMMA + nativeWindow);
            }
        }
        return l;
    }

    protected int lockSurfaceImpl() {
        return 3;
    }

    protected void unlockSurfaceImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final WindowClosingProtocol.WindowClosingMode getDefaultCloseOperation() {
        Object object = this.closingListenerLock;
        synchronized (object) {
            return this.defaultCloseOperation;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final WindowClosingProtocol.WindowClosingMode setDefaultCloseOperation(WindowClosingProtocol.WindowClosingMode windowClosingMode) {
        Object object = this.closingListenerLock;
        synchronized (object) {
            WindowClosingProtocol.WindowClosingMode windowClosingMode2 = this.defaultCloseOperation;
            this.defaultCloseOperation = windowClosingMode;
            return windowClosingMode2;
        }
    }

    private final void instantiationFinished() {
        this.supportedReconfigStateMask = this.getSupportedReconfigMaskImpl() & 0xFFFF;
        if (DEBUG_IMPLEMENTATION) {
            boolean bl = 9 == (9 & this.supportedReconfigStateMask);
            System.err.println("Supported Reconfig.0 (minimum-ok " + bl + "): " + WindowImpl.appendStateBits(new StringBuilder(), this.supportedReconfigStateMask, true).toString());
        }
        this.resetStateMask();
        this.instantiationFinishedImpl();
    }

    protected void instantiationFinishedImpl() {
    }

    protected boolean canCreateNativeImpl() {
        return true;
    }

    protected abstract void createNativeImpl(boolean[] var1);

    protected abstract void closeNativeImpl();

    protected abstract void requestFocusImpl(boolean var1);

    protected abstract int getSupportedReconfigMaskImpl();

    protected abstract boolean reconfigureWindowImpl(int var1, int var2, int var3, int var4, int var5);

    protected final boolean isReconfigureMaskSupported(int n) {
        return n == (n & this.supportedReconfigStateMask);
    }

    protected int getReconfigureMask(int n, boolean bl) {
        int n2 = this.stateMask.get32(0, 16);
        return n | n2 & 0xFFFFFFEA | (bl ? 1 : 0) | (WindowImpl.isUndecorated(n2) ? 16 : 0) | (0L != this.getParentWindowHandle() ? 4 : 0);
    }

    protected static String getReconfigStateMaskString(int n) {
        return WindowImpl.appendStateBits(new StringBuilder(), n, true).toString();
    }

    protected void setTitleImpl(String string) {
    }

    protected abstract Point getLocationOnScreenImpl(int var1, int var2);

    protected boolean setPointerVisibleImpl(boolean bl) {
        return false;
    }

    protected boolean confinePointerImpl(boolean bl) {
        return false;
    }

    protected void warpPointerImpl(int n, int n2) {
    }

    protected void setPointerIconImpl(PointerIconImpl pointerIconImpl) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int lockSurface() throws NativeWindowException, RuntimeException {
        int n;
        block9: {
            RecursiveLock recursiveLock = this.windowLock;
            recursiveLock.lock();
            ++this.surfaceLockCount;
            int n2 = n = 1 == this.surfaceLockCount ? 1 : 3;
            if (1 == n) {
                try {
                    if (!this.isNativeValid()) break block9;
                    AbstractGraphicsDevice abstractGraphicsDevice = this.getGraphicsConfiguration().getScreen().getDevice();
                    abstractGraphicsDevice.lock();
                    try {
                        n = this.lockSurfaceImpl();
                    }
                    finally {
                        if (1 >= n) {
                            abstractGraphicsDevice.unlock();
                        }
                    }
                }
                finally {
                    if (1 >= n) {
                        --this.surfaceLockCount;
                        recursiveLock.unlock();
                    }
                }
            }
        }
        return n;
    }

    @Override
    public final void unlockSurface() {
        RecursiveLock recursiveLock = this.windowLock;
        recursiveLock.validateLocked();
        if (1 == this.surfaceLockCount) {
            AbstractGraphicsDevice abstractGraphicsDevice = this.getGraphicsConfiguration().getScreen().getDevice();
            try {
                this.unlockSurfaceImpl();
            }
            finally {
                abstractGraphicsDevice.unlock();
            }
        }
        --this.surfaceLockCount;
        recursiveLock.unlock();
    }

    @Override
    public final boolean isSurfaceLockedByOtherThread() {
        return this.windowLock.isLockedByOtherThread();
    }

    @Override
    public final Thread getSurfaceLockOwner() {
        return this.windowLock.getOwner();
    }

    @Override
    public final RecursiveLock getLock() {
        return this.windowLock;
    }

    @Override
    public long getSurfaceHandle() {
        return this.windowHandle;
    }

    @Override
    public boolean surfaceSwap() {
        return false;
    }

    @Override
    public final void addSurfaceUpdatedListener(SurfaceUpdatedListener surfaceUpdatedListener) {
        this.surfaceUpdatedHelper.addSurfaceUpdatedListener(surfaceUpdatedListener);
    }

    @Override
    public final void addSurfaceUpdatedListener(int n, SurfaceUpdatedListener surfaceUpdatedListener) throws IndexOutOfBoundsException {
        this.surfaceUpdatedHelper.addSurfaceUpdatedListener(n, surfaceUpdatedListener);
    }

    @Override
    public final void removeSurfaceUpdatedListener(SurfaceUpdatedListener surfaceUpdatedListener) {
        this.surfaceUpdatedHelper.removeSurfaceUpdatedListener(surfaceUpdatedListener);
    }

    @Override
    public final void surfaceUpdated(Object object, NativeSurface nativeSurface, long l) {
        this.surfaceUpdatedHelper.surfaceUpdated(object, nativeSurface, l);
    }

    @Override
    public final AbstractGraphicsConfiguration getGraphicsConfiguration() {
        return this.config.getNativeGraphicsConfiguration();
    }

    @Override
    public final long getDisplayHandle() {
        return this.config.getNativeGraphicsConfiguration().getScreen().getDevice().getHandle();
    }

    @Override
    public final int getScreenIndex() {
        return this.screen.getIndex();
    }

    @Override
    public final NativeSurface getNativeSurface() {
        return this;
    }

    @Override
    public final NativeWindow getParent() {
        return this.parentWindow;
    }

    @Override
    public final long getWindowHandle() {
        return this.windowHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Point getLocationOnScreen(Point point) {
        if (this.isNativeValid()) {
            Point point2;
            RecursiveLock recursiveLock = this.windowLock;
            recursiveLock.lock();
            try {
                point2 = this.getLocationOnScreenImpl(0, 0);
            }
            finally {
                recursiveLock.unlock();
            }
            if (null != point2) {
                if (null != point) {
                    point.translate(point2.getX(), point2.getY());
                    return point;
                }
                return point2;
            }
        }
        if (null != point) {
            point.translate(this.getX(), this.getY());
        } else {
            point = new Point(this.getX(), this.getY());
        }
        if (null != this.parentWindow) {
            this.parentWindow.getLocationOnScreen(point);
        }
        return point;
    }

    @Override
    public final boolean isNativeValid() {
        return 0L != this.windowHandle;
    }

    @Override
    public final Screen getScreen() {
        return this.screen;
    }

    protected void setScreen(ScreenImpl screenImpl) {
        this.removeScreenReference();
        this.screen = screenImpl;
    }

    @Override
    public final MonitorDevice getMainMonitor() {
        return this.screen.getMainMonitor(this.getBounds());
    }

    protected final void setVisibleImpl(boolean bl, boolean bl2, int n, int n2, int n3, int n4) {
        int n5 = bl2 ? this.getReconfigureMask(-1073741824, bl) : this.getReconfigureMask(Integer.MIN_VALUE, bl);
        this.reconfigureWindowImpl(n, n2, n3, n4, n5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void setVisibleActionImpl(boolean bl) {
        boolean bl2 = false;
        int n = -1;
        RecursiveLock recursiveLock = this.windowLock;
        recursiveLock.lock();
        try {
            NativeWindow nativeWindow;
            int n2;
            if (!bl && null != this.childWindows && this.childWindows.size() > 0) {
                Object object = this.childWindowsLock;
                synchronized (object) {
                    for (n2 = 0; n2 < this.childWindows.size(); ++n2) {
                        nativeWindow = this.childWindows.get(n2);
                        if (!(nativeWindow instanceof WindowImpl)) continue;
                        ((WindowImpl)nativeWindow).setVisible(false);
                    }
                }
            }
            if (!this.isNativeValid() && bl) {
                if (0 < this.getWidth() * this.getHeight()) {
                    bl2 = this.createNative();
                    n = bl2 ? 1 : -1;
                }
                this.stateMask.set(0);
            } else if (this.stateMask.get(0) != bl) {
                if (this.isNativeValid()) {
                    boolean bl3 = quirks.get(0);
                    this.setVisibleImpl(bl, bl3 || this.isChildWindow(), this.getX(), this.getY(), this.getWidth(), this.getHeight());
                    if (0L > this.waitForVisible(bl, false)) {
                        if (!bl3) {
                            quirks.set(0);
                            if (DEBUG_IMPLEMENTATION) {
                                System.err.println("Setting VISIBILITY QUIRK, due to setVisible(" + bl + ") failure");
                            }
                            this.setVisibleImpl(bl, true, this.getX(), this.getY(), this.getWidth(), this.getHeight());
                            if (0L <= this.waitForVisible(bl, false)) {
                                n = bl ? 1 : 0;
                            }
                        }
                    } else {
                        n = bl ? 1 : 0;
                    }
                } else {
                    this.stateMask.set(0);
                }
            }
            if (null != this.lifecycleHook) {
                this.lifecycleHook.setVisibleActionPost(bl, bl2);
            }
            if (this.isNativeValid() && bl && null != this.childWindows && this.childWindows.size() > 0) {
                Object object = this.childWindowsLock;
                synchronized (object) {
                    for (n2 = 0; n2 < this.childWindows.size(); ++n2) {
                        nativeWindow = this.childWindows.get(n2);
                        if (!(nativeWindow instanceof WindowImpl)) continue;
                        ((WindowImpl)nativeWindow).setVisible(true);
                    }
                }
            }
            if (DEBUG_IMPLEMENTATION) {
                System.err.println("Window setVisible: END (" + WindowImpl.getThreadName() + ") state " + this.getStateMaskString() + ", nativeWindowCreated: " + bl2 + ", madeVisible: " + n + ", geom " + this.getX() + "/" + this.getY() + " " + this.getWidth() + "x" + this.getHeight() + ", windowHandle " + WindowImpl.toHexString(this.windowHandle));
            }
        }
        finally {
            if (null != this.lifecycleHook) {
                this.lifecycleHook.resetCounter();
            }
            recursiveLock.unlock();
        }
        if (bl2 || 1 == n) {
            this.sendWindowEvent(100);
        }
    }

    @Override
    public final void setVisible(boolean bl, boolean bl2) {
        if (!this.isReconfigureMaskSupported(1) && this.isNativeValid()) {
            return;
        }
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("Window setVisible: START (" + WindowImpl.getThreadName() + ") " + this.getX() + "/" + this.getY() + " " + this.getWidth() + "x" + this.getHeight() + ", windowHandle " + WindowImpl.toHexString(this.windowHandle) + ", state " + this.getStateMaskString() + " -> visible " + bl2 + ", parentWindowHandle " + WindowImpl.toHexString(this.parentWindowHandle) + ", parentWindow " + (null != this.parentWindow));
        }
        this.runOnEDTIfAvail(bl, new VisibleAction(bl2));
    }

    @Override
    public final void setVisible(boolean bl) {
        this.setVisible(true, bl);
    }

    protected void setPosSizeImpl(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        this.runOnEDTIfAvail(true, new SetSizeAction(n, n2, true, n3, n4, bl, bl2));
    }

    protected void setSizeImpl(int n, int n2, boolean bl, boolean bl2) {
        this.runOnEDTIfAvail(true, new SetSizeAction(0, 0, false, n, n2, bl, bl2));
    }

    @Override
    public final void setSize(int n, int n2) {
        this.setSizeImpl(n, n2, true, false);
    }

    @Override
    public final void setSurfaceSize(int n, int n2) {
        this.setSize(SurfaceScaleUtils.scaleInv(n, this.getPixelScaleX()), SurfaceScaleUtils.scaleInv(n2, this.getPixelScaleY()));
    }

    @Override
    public final void setTopLevelSize(int n, int n2) {
        InsetsImmutable insetsImmutable = this.getInsets();
        this.setSize(n - insetsImmutable.getTotalWidth(), n2 - insetsImmutable.getTotalHeight());
    }

    @Override
    public void destroy() {
        this.stateMask.clear(0);
        this.runOnEDTIfAvail(true, this.destroyAction);
    }

    protected void destroy(boolean bl) {
        if (null != this.lifecycleHook) {
            this.lifecycleHook.preserveGLStateAtDestroy(bl);
        }
        this.destroy();
    }

    protected static boolean isOffscreenInstance(NativeWindow nativeWindow, NativeWindow nativeWindow2) {
        AbstractGraphicsConfiguration abstractGraphicsConfiguration;
        boolean bl = false;
        AbstractGraphicsConfiguration abstractGraphicsConfiguration2 = nativeWindow.getGraphicsConfiguration();
        if (null != abstractGraphicsConfiguration2) {
            boolean bl2 = bl = !abstractGraphicsConfiguration2.getChosenCapabilities().isOnscreen();
        }
        if (!bl && null != nativeWindow2 && null != (abstractGraphicsConfiguration = nativeWindow2.getGraphicsConfiguration())) {
            bl = !abstractGraphicsConfiguration.getChosenCapabilities().isOnscreen();
        }
        return bl;
    }

    @Override
    public final Window.ReparentOperation reparentWindow(NativeWindow nativeWindow, int n, int n2, int n3) {
        if (!this.isReconfigureMaskSupported(4) && this.isNativeValid()) {
            return Window.ReparentOperation.ACTION_INVALID;
        }
        ReparentAction reparentAction = new ReparentAction(nativeWindow, n, n2, n3);
        this.runOnEDTIfAvail(true, reparentAction);
        return reparentAction.getOp();
    }

    @Override
    public final boolean isChildWindow() {
        return this.stateMask.get(2);
    }

    @Override
    public final CapabilitiesChooser setCapabilitiesChooser(CapabilitiesChooser capabilitiesChooser) {
        CapabilitiesChooser capabilitiesChooser2 = this.capabilitiesChooser;
        this.capabilitiesChooser = capabilitiesChooser;
        return capabilitiesChooser2;
    }

    @Override
    public final CapabilitiesImmutable getChosenCapabilities() {
        return this.getGraphicsConfiguration().getChosenCapabilities();
    }

    @Override
    public final CapabilitiesImmutable getRequestedCapabilities() {
        return this.capsRequested;
    }

    @Override
    public final void setUndecorated(boolean bl) {
        if (this.isNativeValid()) {
            if (!this.isReconfigureMaskSupported(16)) {
                return;
            }
            if (this.isFullscreen()) {
                this.stateMaskNFS.put(16, bl);
                return;
            }
        }
        this.runOnEDTIfAvail(true, new DecorationAction(bl));
    }

    @Override
    public final boolean isUndecorated() {
        return WindowImpl.isUndecorated(this.getStateMask());
    }

    private static final boolean isUndecorated(int n) {
        return 0 != (n & 0x814);
    }

    @Override
    public final void setAlwaysOnTop(boolean bl) {
        if (this.isChildWindow()) {
            return;
        }
        if (this.isNativeValid()) {
            if (!this.isReconfigureMaskSupported(32)) {
                return;
            }
            if (this.isFullscreen()) {
                if (bl && this.isAlwaysOnBottom()) {
                    this.setAlwaysOnBottom(false);
                }
                this.stateMaskNFS.put(5, bl);
                return;
            }
        }
        if (bl && this.isAlwaysOnBottom()) {
            this.setAlwaysOnBottom(false);
        }
        this.runOnEDTIfAvail(true, new AlwaysOnTopAction(bl));
    }

    @Override
    public final boolean isAlwaysOnTop() {
        return this.stateMask.get(5);
    }

    @Override
    public final void setAlwaysOnBottom(boolean bl) {
        if (this.isChildWindow()) {
            return;
        }
        if (!this.isReconfigureMaskSupported(64) && this.isNativeValid()) {
            return;
        }
        if (bl && this.isAlwaysOnTop()) {
            this.setAlwaysOnTop(false);
        }
        this.runOnEDTIfAvail(true, new AlwaysOnBottomAction(bl));
    }

    @Override
    public final boolean isAlwaysOnBottom() {
        return this.stateMask.get(6);
    }

    @Override
    public final void setResizable(boolean bl) {
        if (this.isChildWindow()) {
            return;
        }
        if (this.isNativeValid()) {
            if (!this.isReconfigureMaskSupported(256)) {
                return;
            }
            if (this.isFullscreen()) {
                this.stateMaskNFS.put(8, bl);
                return;
            }
        }
        this.runOnEDTIfAvail(true, new ResizableAction(bl));
    }

    @Override
    public final boolean isResizable() {
        return this.stateMask.get(8);
    }

    @Override
    public final void setSticky(boolean bl) {
        if (this.isChildWindow()) {
            return;
        }
        if (!this.isReconfigureMaskSupported(128) && this.isNativeValid()) {
            return;
        }
        this.runOnEDTIfAvail(true, new StickyAction(bl));
    }

    @Override
    public final boolean isSticky() {
        return this.stateMask.get(7);
    }

    @Override
    public final void setMaximized(boolean bl, boolean bl2) {
        if (this.isNativeValid()) {
            if (bl && !this.isReconfigureMaskSupported(1024)) {
                bl = false;
            }
            if (bl2 && !this.isReconfigureMaskSupported(512)) {
                bl2 = false;
            }
        }
        if (this.isChildWindow()) {
            return;
        }
        if (this.isFullscreen()) {
            this.stateMaskNFS.put(10, bl);
            this.stateMaskNFS.put(9, bl2);
        } else {
            this.runOnEDTIfAvail(true, new MaximizeAction(bl, bl2));
        }
    }

    @Override
    public final boolean isMaximizedVert() {
        return this.stateMask.get(9);
    }

    @Override
    public final boolean isMaximizedHorz() {
        return this.stateMask.get(10);
    }

    protected final void maximizedChanged(boolean bl, boolean bl2) {
        if (!this.isFullscreen()) {
            boolean bl3;
            String string = DEBUG_IMPLEMENTATION ? this.getStateMaskString() : null;
            boolean bl4 = this.stateMask.put(10, bl) != bl;
            boolean bl5 = bl3 = this.stateMask.put(9, bl2) != bl2;
            if (DEBUG_IMPLEMENTATION && (bl4 || bl3)) {
                System.err.println("Window.maximizedChanged.accepted: " + string + " -> " + this.getStateMaskString());
            }
        } else if (DEBUG_IMPLEMENTATION) {
            boolean bl6;
            String string = DEBUG_IMPLEMENTATION ? this.getStateMaskString() : null;
            boolean bl7 = this.stateMask.get(10) != bl;
            boolean bl8 = bl6 = this.stateMask.get(9) != bl2;
            if (bl7 || bl6) {
                System.err.println("Window.maximizedChanged.ignored: " + string + " -> max[" + (bl ? "" : "!") + "h, " + (bl2 ? "" : "!") + "v]");
            }
        }
    }

    protected void reconfigMaximizedManual(int n, int[] nArray, InsetsImmutable insetsImmutable) {
        MonitorMode monitorMode = this.getMainMonitor().getCurrentMode();
        int n2 = SurfaceScaleUtils.scaleInv(monitorMode.getRotatedWidth(), this.getPixelScaleX());
        int n3 = SurfaceScaleUtils.scaleInv(monitorMode.getRotatedHeight(), this.getPixelScaleY());
        if (0 != (0x400000 & n)) {
            if (0 != (0x400 & n)) {
                this.normPosSizeStored[0] = true;
                this.normPosSize[0] = nArray[0];
                this.normPosSize[2] = nArray[2];
                nArray[0] = insetsImmutable.getLeftWidth();
                nArray[2] = n2 - insetsImmutable.getTotalWidth();
            } else {
                this.normPosSizeStored[0] = false;
                nArray[0] = this.normPosSize[0];
                nArray[2] = this.normPosSize[2];
            }
        }
        if (0 != (0x800000 & n)) {
            if (0 != (0x200 & n)) {
                this.normPosSizeStored[1] = true;
                this.normPosSize[1] = nArray[1];
                this.normPosSize[3] = nArray[3];
                nArray[1] = insetsImmutable.getTopHeight();
                nArray[3] = n3 - insetsImmutable.getTotalHeight();
            } else {
                this.normPosSizeStored[1] = false;
                nArray[1] = this.normPosSize[1];
                nArray[3] = this.normPosSize[3];
            }
        }
    }

    protected void resetMaximizedManual(int[] nArray) {
        if (this.normPosSizeStored[0]) {
            this.normPosSizeStored[0] = false;
            nArray[0] = this.normPosSize[0];
            nArray[2] = this.normPosSize[2];
        }
        if (this.normPosSizeStored[1]) {
            this.normPosSizeStored[1] = false;
            nArray[1] = this.normPosSize[1];
            nArray[3] = this.normPosSize[3];
        }
    }

    @Override
    public final String getTitle() {
        return this.title;
    }

    @Override
    public final void setTitle(String string) {
        if (string == null) {
            string = "";
        }
        this.title = string;
        if (0L != this.getWindowHandle()) {
            this.setTitleImpl(string);
        }
    }

    @Override
    public final boolean isPointerVisible() {
        return this.stateMask.get(12);
    }

    @Override
    public final void setPointerVisible(boolean bl) {
        if (!this.isReconfigureMaskSupported(4096) && this.isNativeValid()) {
            return;
        }
        if (this.stateMask.get(12) != bl) {
            boolean bl2;
            boolean bl3 = bl2 = 0L == this.getWindowHandle();
            if (!bl2) {
                bl2 = this.setPointerVisibleIntern(bl);
            }
            if (bl2) {
                this.stateMask.put(12, bl);
            }
        }
    }

    private boolean setPointerVisibleIntern(boolean bl) {
        boolean bl2 = this.setOffscreenPointerVisible(bl, this.pointerIcon);
        return this.setPointerVisibleImpl(bl) || bl2;
    }

    private boolean setOffscreenPointerVisible(boolean bl, PointerIconImpl pointerIconImpl) {
        if (bl) {
            return this.setOffscreenPointerIcon(pointerIconImpl);
        }
        NativeWindow nativeWindow = this.getParent();
        if (nativeWindow instanceof OffscreenLayerSurface) {
            OffscreenLayerSurface offscreenLayerSurface = (OffscreenLayerSurface)((Object)nativeWindow);
            try {
                return offscreenLayerSurface.hideCursor();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return false;
    }

    @Override
    public final Display.PointerIcon getPointerIcon() {
        return this.pointerIcon;
    }

    @Override
    public final void setPointerIcon(Display.PointerIcon pointerIcon) {
        final PointerIconImpl pointerIconImpl = (PointerIconImpl)pointerIcon;
        if (this.pointerIcon != pointerIconImpl) {
            if (this.isNativeValid()) {
                this.runOnEDTIfAvail(true, new Runnable(){

                    @Override
                    public void run() {
                        WindowImpl.this.setPointerIconIntern(pointerIconImpl);
                    }
                });
            }
            this.pointerIcon = pointerIconImpl;
        }
    }

    private void setPointerIconIntern(PointerIconImpl pointerIconImpl) {
        this.setOffscreenPointerIcon(pointerIconImpl);
        this.setPointerIconImpl(pointerIconImpl);
    }

    private boolean setOffscreenPointerIcon(PointerIconImpl pointerIconImpl) {
        NativeWindow nativeWindow = this.getParent();
        if (nativeWindow instanceof OffscreenLayerSurface) {
            OffscreenLayerSurface offscreenLayerSurface = (OffscreenLayerSurface)((Object)nativeWindow);
            try {
                if (null != pointerIconImpl) {
                    return offscreenLayerSurface.setCursor(pointerIconImpl, pointerIconImpl.getHotspot());
                }
                return offscreenLayerSurface.setCursor(null, null);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return false;
    }

    @Override
    public final boolean isPointerConfined() {
        return this.stateMask.get(13);
    }

    @Override
    public final void confinePointer(boolean bl) {
        if (!this.isReconfigureMaskSupported(8192) && this.isNativeValid()) {
            return;
        }
        if (this.stateMask.get(13) != bl) {
            boolean bl2;
            boolean bl3 = bl2 = 0L == this.getWindowHandle();
            if (!bl2) {
                if (bl) {
                    this.requestFocus();
                    this.warpPointer(this.getSurfaceWidth() / 2, this.getSurfaceHeight() / 2);
                }
                bl2 = this.confinePointerImpl(bl);
                if (bl) {
                    try {
                        Thread.sleep(3L * this.screen.getDisplay().getEDTUtil().getPollPeriod());
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            if (bl2) {
                this.stateMask.put(13, bl);
            }
        }
    }

    @Override
    public final void warpPointer(int n, int n2) {
        if (0L != this.getWindowHandle()) {
            this.warpPointerImpl(n, n2);
        }
    }

    @Override
    public final InsetsImmutable getInsets() {
        if (this.isUndecorated()) {
            return Insets.getZero();
        }
        return this.insets;
    }

    @Override
    public final int getX() {
        return this.windowPos[0];
    }

    @Override
    public final int getY() {
        return this.windowPos[1];
    }

    @Override
    public final int getWidth() {
        return this.windowSize[0];
    }

    @Override
    public final int getHeight() {
        return this.windowSize[1];
    }

    @Override
    public final Rectangle getBounds() {
        return new Rectangle(this.windowPos[0], this.windowPos[1], this.windowSize[0], this.windowSize[1]);
    }

    @Override
    public final int getSurfaceWidth() {
        return this.pixelSize[0];
    }

    @Override
    public final int getSurfaceHeight() {
        return this.pixelSize[1];
    }

    @Override
    public final Rectangle getSurfaceBounds() {
        return new Rectangle(this.pixelPos[0], this.pixelPos[1], this.pixelSize[0], this.pixelSize[1]);
    }

    @Override
    public final int[] convertToWindowUnits(int[] nArray) {
        return SurfaceScaleUtils.scaleInv(nArray, nArray, this.hasPixelScale);
    }

    @Override
    public final int[] convertToPixelUnits(int[] nArray) {
        return SurfaceScaleUtils.scale(nArray, nArray, this.hasPixelScale);
    }

    protected final Point convertToWindowUnits(Point point) {
        return point.scaleInv(this.getPixelScaleX(), this.getPixelScaleY());
    }

    protected final Point convertToPixelUnits(Point point) {
        return point.scale(this.getPixelScaleX(), this.getPixelScaleY());
    }

    protected final float getPixelScaleX() {
        return this.hasPixelScale[0];
    }

    protected final float getPixelScaleY() {
        return this.hasPixelScale[1];
    }

    @Override
    public boolean setSurfaceScale(float[] fArray) {
        System.arraycopy(fArray, 0, this.reqPixelScale, 0, 2);
        return false;
    }

    @Override
    public final float[] getRequestedSurfaceScale(float[] fArray) {
        System.arraycopy(this.reqPixelScale, 0, fArray, 0, 2);
        return fArray;
    }

    @Override
    public final float[] getCurrentSurfaceScale(float[] fArray) {
        System.arraycopy(this.hasPixelScale, 0, fArray, 0, 2);
        return fArray;
    }

    @Override
    public final float[] getMinimumSurfaceScale(float[] fArray) {
        System.arraycopy(this.minPixelScale, 0, fArray, 0, 2);
        return fArray;
    }

    @Override
    public final float[] getMaximumSurfaceScale(float[] fArray) {
        System.arraycopy(this.maxPixelScale, 0, fArray, 0, 2);
        return fArray;
    }

    @Override
    public final float[] getPixelsPerMM(float[] fArray) {
        this.getMainMonitor().getPixelsPerMM(fArray);
        fArray[0] = fArray[0] * (this.hasPixelScale[0] / this.maxPixelScale[0]);
        fArray[1] = fArray[1] * (this.hasPixelScale[1] / this.maxPixelScale[1]);
        return fArray;
    }

    protected final boolean autoPosition() {
        return this.stateMask.get(1);
    }

    protected final int[] getWindowPosI() {
        return this.windowPos;
    }

    protected final int[] getPixelPosI() {
        return this.pixelPos;
    }

    protected final int[] getWindowSizeI() {
        return this.windowSize;
    }

    protected final int[] getPixelSizeI() {
        return this.pixelSize;
    }

    protected final void defineWindowPosition(int n, int n2) {
        int[] nArray = new int[]{n, n2};
        int[] nArray2 = SurfaceScaleUtils.scale(new int[2], nArray, this.hasPixelScale);
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("defineWinPosition: win[" + this.windowPos[0] + "/" + this.windowPos[1] + " -> " + nArray[0] + "/" + nArray[1] + "], pixel[" + this.pixelSize[0] + "x" + this.pixelSize[1] + " -> " + nArray2[0] + "x" + nArray2[1] + "]");
        }
        this.stateMask.clear(1);
        this.windowPos = nArray;
        this.pixelPos = nArray2;
    }

    protected final void definePixelPosition(int n, int n2) {
        int[] nArray = new int[]{n, n2};
        int[] nArray2 = SurfaceScaleUtils.scaleInv(new int[2], nArray, this.hasPixelScale);
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("definePixelPosition: win[" + this.windowPos[0] + "/" + this.windowPos[1] + " -> " + nArray2[0] + "/" + nArray2[1] + "], pixel[" + this.pixelPos[0] + "x" + this.pixelPos[1] + " -> " + nArray[0] + "x" + nArray[1] + "]");
        }
        this.stateMask.clear(1);
        this.windowPos = nArray2;
        this.pixelPos = nArray;
    }

    protected final void defineWindowSize(int n, int n2) {
        int[] nArray = new int[]{n, n2};
        int[] nArray2 = SurfaceScaleUtils.scale(new int[2], nArray, this.hasPixelScale);
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("defineWinSize: win[" + this.windowSize[0] + "x" + this.windowSize[1] + " -> " + nArray[0] + "x" + nArray[1] + "], pixel[" + this.pixelSize[0] + "x" + this.pixelSize[1] + " -> " + nArray2[0] + "x" + nArray2[1] + "]");
        }
        this.windowSize = nArray;
        this.pixelSize = nArray2;
    }

    protected final void definePixelSize(int n, int n2) {
        int[] nArray = new int[]{n, n2};
        int[] nArray2 = SurfaceScaleUtils.scaleInv(new int[2], nArray, this.hasPixelScale);
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("definePixelSize: win[" + this.windowSize[0] + "x" + this.windowSize[1] + " -> " + nArray2[0] + "x" + nArray2[1] + "], pixel[" + this.pixelSize[0] + "x" + this.pixelSize[1] + " -> " + nArray[0] + "x" + nArray[1] + "]");
        }
        this.windowSize = nArray2;
        this.pixelSize = nArray;
    }

    protected void updatePixelPosSize(boolean bl, boolean bl2) {
        boolean bl3;
        int[] nArray = SurfaceScaleUtils.scale(new int[2], this.windowPos, this.hasPixelScale);
        int[] nArray2 = SurfaceScaleUtils.scale(new int[2], this.windowSize, this.hasPixelScale);
        boolean bl4 = this.pixelPos[0] != nArray[0] || this.pixelPos[1] != nArray[1];
        boolean bl5 = bl3 = this.pixelSize[0] != nArray2[0] || this.pixelSize[1] != nArray2[1];
        if (bl4 || bl3) {
            if (DEBUG_IMPLEMENTATION) {
                System.err.println("updatePixelPosSize: (" + WindowImpl.getThreadName() + "): (event: " + bl + ", defer: " + bl2 + "), state " + this.getStateMaskString() + " - windowHandle " + WindowImpl.toHexString(this.windowHandle) + " parentWindowHandle " + WindowImpl.toHexString(this.parentWindowHandle));
                System.err.println("updatePixelPos: win[" + this.windowPos[0] + "/" + this.windowPos[1] + "], pixel[" + this.pixelSize[0] + "x" + this.pixelSize[1] + " -> " + nArray[0] + "x" + nArray[1] + "]");
                System.err.println("updatePixelSize: win[" + this.windowSize[0] + "x" + this.windowSize[1] + "], pixel[" + this.pixelSize[0] + "x" + this.pixelSize[1] + " -> " + nArray2[0] + "x" + nArray2[1] + "]");
            }
            if (bl4) {
                this.pixelPos = nArray;
            }
            if (bl3) {
                this.pixelSize = nArray2;
                if (bl && this.isNativeValid()) {
                    if (!bl2) {
                        this.sendWindowEvent(100);
                    } else {
                        this.enqueueWindowEvent(false, 100);
                    }
                }
            }
        }
    }

    protected void updateWindowPosSize(boolean bl, boolean bl2) {
        boolean bl3;
        int[] nArray = SurfaceScaleUtils.scaleInv(new int[2], this.pixelPos, this.hasPixelScale);
        int[] nArray2 = SurfaceScaleUtils.scaleInv(new int[2], this.pixelSize, this.hasPixelScale);
        boolean bl4 = this.windowPos[0] != nArray[0] || this.windowPos[1] != nArray[1];
        boolean bl5 = bl3 = this.windowSize[0] != nArray2[0] || this.windowSize[1] != nArray2[1];
        if (bl4 || bl3) {
            if (DEBUG_IMPLEMENTATION) {
                System.err.println("updateWindowPosSize: (" + WindowImpl.getThreadName() + "): (event: " + bl + ", defer: " + bl2 + "), state " + this.getStateMaskString() + " - windowHandle " + WindowImpl.toHexString(this.windowHandle) + " parentWindowHandle " + WindowImpl.toHexString(this.parentWindowHandle));
                System.err.println("updateWindowPos: win[" + this.windowPos[0] + "/" + this.windowPos[1] + " -> " + nArray[0] + "/" + nArray[1] + "], pixel[" + this.pixelSize[0] + "x" + this.pixelSize[1] + "]");
                System.err.println("updateWindowSize: win[" + this.windowSize[0] + "x" + this.windowSize[1] + " -> " + nArray2[0] + "x" + nArray2[1] + "], pixel[" + this.pixelSize[0] + "x" + this.pixelSize[1] + "]");
            }
            if (bl4) {
                this.windowPos = nArray;
            }
            if (bl3) {
                this.windowSize = nArray2;
                if (bl && this.isNativeValid()) {
                    if (!bl2) {
                        this.sendWindowEvent(100);
                    } else {
                        this.enqueueWindowEvent(false, 100);
                    }
                }
            }
        }
    }

    private static int sign(int n) {
        if (0 == n) {
            return 0;
        }
        if (0 < n) {
            return 1;
        }
        return -1;
    }

    private boolean applySoftPixelScaleImpl(int[] nArray, boolean bl, boolean bl2, float[] fArray) {
        boolean bl3 = false;
        float[] fArray2 = new float[2];
        float[] fArray3 = new float[2];
        if (FloatUtil.isZero(fArray[0], 1.1920929E-7f) || FloatUtil.isZero(fArray[1], 1.1920929E-7f)) {
            fArray2[0] = 1.0f;
            fArray2[1] = 1.0f;
        } else {
            System.arraycopy(fArray, 0, fArray2, 0, 2);
        }
        System.arraycopy(fArray2, 0, fArray3, 0, 2);
        if (SurfaceScaleUtils.setNewPixelScale(this.hasPixelScale, this.hasPixelScale, fArray2, this.minPixelScale, fArray3, DEBUG_IMPLEMENTATION ? this.getClass().getName() : null)) {
            int n;
            int n2;
            int[] nArray2 = this.getWindowSizeI();
            int[] nArray3 = this.getPixelPosI();
            int[] nArray4 = this.getWindowPosI();
            int[] nArray5 = SurfaceScaleUtils.scaleInv(new int[2], nArray3, this.hasPixelScale);
            int[] nArray6 = this.getPixelSizeI();
            int[] nArray7 = SurfaceScaleUtils.scale(new int[2], nArray2, this.hasPixelScale);
            if (DEBUG_IMPLEMENTATION) {
                System.err.println("Window.SoftPixelScale.1: " + WindowImpl.getThreadName());
                System.err.println("Window.SoftPixelScale.1: windowSize: " + nArray2[0] + "x" + nArray2[1] + " const");
                System.err.println("Window.SoftPixelScale.1: pixelPos: " + nArray3[0] + "/" + nArray3[1] + " const");
                System.err.println("Window.SoftPixelScale.1: oldWindowPos: " + nArray4[0] + "/" + nArray4[1]);
                System.err.println("Window.SoftPixelScale.1: newWindowPos: " + nArray5[0] + "/" + nArray5[1]);
                System.err.println("Window.SoftPixelScale.1: oldPixelSize: " + nArray6[0] + "x" + nArray6[1]);
                System.err.println("Window.SoftPixelScale.1: newPixelSize: " + nArray7[0] + "x" + nArray7[1]);
                if (null != nArray) {
                    System.err.println("Window.SoftPixelScale.1: move_diff: " + nArray[0] + "/" + nArray[1] + " [pixels]");
                } else {
                    System.err.println("Window.SoftPixelScale.1: move_diff: null");
                }
            }
            if (null != nArray) {
                int[] nArray8 = new int[]{WindowImpl.sign(nArray[0]), WindowImpl.sign(nArray[1])};
                int[] nArray9 = new int[]{(int)((float)Math.abs(nArray7[0] - nArray6[0]) * 0.5f + 0.5f), (int)((float)Math.abs(nArray7[1] - nArray6[1]) * 0.5f + 0.5f)};
                SurfaceScaleUtils.scaleInv(nArray9, nArray9, this.hasPixelScale);
                SurfaceScaleUtils.scaleInv(nArray, nArray, this.hasPixelScale);
                n2 = nArray5[0] + nArray8[0] * nArray9[0] + nArray[0];
                n = nArray5[1] + nArray8[1] * nArray9[1] + nArray[1];
            } else {
                n2 = nArray5[0];
                n = nArray5[1];
            }
            if (DEBUG_IMPLEMENTATION) {
                System.err.println("Window.SoftPixelScale.2: Position: " + nArray4[0] + "/" + nArray4[1] + " -> " + n2 + "/" + n);
            }
            this.setPosSizeImpl(n2, n, nArray2[0], nArray2[1], false, true);
            bl3 = true;
        }
        return bl3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean applySoftPixelScale(int[] nArray, boolean bl, boolean bl2, float[] fArray) {
        boolean bl3 = false;
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("Window.SoftPixelScale.0a: req " + this.reqPixelScale[0] + ", has " + this.hasPixelScale[0] + ", new " + fArray[0] + " - " + WindowImpl.getThreadName());
        }
        Object object = this.scaleLock;
        synchronized (object) {
            try {
                bl3 = this.applySoftPixelScaleImpl(nArray, bl, bl2, fArray);
            }
            finally {
                if (DEBUG_IMPLEMENTATION) {
                    System.err.println("Window.SoftPixelScale.X: res " + bl3 + ", has " + this.hasPixelScale[0] + " - " + WindowImpl.getThreadName());
                }
            }
        }
        return bl3;
    }

    @Override
    public final boolean isVisible() {
        return this.stateMask.get(0);
    }

    @Override
    public final boolean isFullscreen() {
        return this.stateMask.get(11);
    }

    @Override
    public final Window getDelegatedWindow() {
        return this;
    }

    public boolean hasDeviceChanged() {
        return false;
    }

    public final LifecycleHook getLifecycleHook() {
        return this.lifecycleHook;
    }

    public final LifecycleHook setLifecycleHook(LifecycleHook lifecycleHook) {
        LifecycleHook lifecycleHook2 = this.lifecycleHook;
        this.lifecycleHook = lifecycleHook;
        return lifecycleHook2;
    }

    public NativeSurface getWrappedSurface() {
        return null;
    }

    @Override
    public final void setWindowDestroyNotifyAction(Runnable runnable) {
        this.windowDestroyNotifyAction = runnable;
    }

    protected final long getParentWindowHandle() {
        return this.isFullscreen() ? 0L : this.parentWindowHandle;
    }

    @Override
    public final StringBuilder toSimpleString(StringBuilder stringBuilder) {
        stringBuilder.append(this.getClass().getSimpleName()).append("[").append("State ").append(this.getStateMaskString()).append("; ").append("Window").append("[").append(this.getX()).append("/").append(this.getY()).append(" ").append(this.getWidth()).append("x").append(this.getHeight()).append(" wu").append(COMMA).append(this.getSurfaceWidth()).append("x").append(this.getSurfaceHeight()).append(" pixel").append("]").append(" handle ").append(WindowImpl.toHexString(this.getWindowHandle())).append(COMMA).append("surfaceHandle ").append(WindowImpl.toHexString(this.getSurfaceHandle())).append(COMMA).append("children ").append(this.childWindows.size()).append("; ").append("ParentWindow ").append(this.parentWindow).append(" (handle ").append(WindowImpl.toHexString(this.parentWindowHandle)).append(")").append("]");
        return stringBuilder;
    }

    @Override
    public final String toSimpleString() {
        return this.toSimpleString(new StringBuilder()).toString();
    }

    @Override
    public final StringBuilder toString(StringBuilder stringBuilder) {
        int n;
        stringBuilder.append(this.getClass().getName()).append("[").append("State ").append(this.getStateMaskString()).append(COMMA).append("supported ").append(this.getSupportedStateMaskString()).append("; ").append("Window").append("[").append(this.getX()).append("/").append(this.getY()).append(" ").append(this.getWidth()).append("x").append(this.getHeight()).append(" wu").append(COMMA).append(this.getSurfaceWidth()).append("x").append(this.getSurfaceHeight()).append(" pixel").append("]").append(" handle ").append(WindowImpl.toHexString(this.getWindowHandle())).append(COMMA).append("surfaceHandle ").append(WindowImpl.toHexString(this.getSurfaceHandle())).append(COMMA).append("children ").append(this.childWindows.size()).append("; ").append("ParentWindow ").append(this.parentWindow).append(" (handle ").append(WindowImpl.toHexString(this.parentWindowHandle)).append(")").append(COMMA).append(PlatformPropsImpl.NEWLINE).append("  ").append(this.screen).append(COMMA).append(PlatformPropsImpl.NEWLINE).append("  Config ").append(this.config).append(COMMA).append(PlatformPropsImpl.NEWLINE).append("  WrappedSurface ").append(this.getWrappedSurface()).append(COMMA).append(PlatformPropsImpl.NEWLINE);
        stringBuilder.append("  SurfaceUpdatedListeners num ").append(this.surfaceUpdatedHelper.size()).append(" [");
        for (n = 0; n < this.surfaceUpdatedHelper.size(); ++n) {
            stringBuilder.append(this.surfaceUpdatedHelper.get(n) + COMMA);
        }
        stringBuilder.append("]").append(COMMA).append(PlatformPropsImpl.NEWLINE).append("  WindowListeners num ").append(this.windowListeners.size()).append(" [");
        for (n = 0; n < this.windowListeners.size(); ++n) {
            stringBuilder.append(this.windowListeners.get(n) + COMMA);
        }
        stringBuilder.append("]").append(COMMA).append(PlatformPropsImpl.NEWLINE).append("  MouseListeners num ").append(this.mouseListeners.size()).append(" [");
        for (n = 0; n < this.mouseListeners.size(); ++n) {
            stringBuilder.append(this.mouseListeners.get(n) + COMMA);
        }
        stringBuilder.append("]").append(COMMA).append(PlatformPropsImpl.NEWLINE).append("  PointerGestures default ").append(this.defaultGestureHandlerEnabled).append(COMMA).append("custom ").append(this.pointerGestureHandler.size()).append(" [");
        for (n = 0; n < this.pointerGestureHandler.size(); ++n) {
            stringBuilder.append(this.pointerGestureHandler.get(n) + COMMA);
        }
        stringBuilder.append("]").append(COMMA).append(PlatformPropsImpl.NEWLINE).append("  KeyListeners num ").append(this.keyListeners.size()).append(" [");
        for (n = 0; n < this.keyListeners.size(); ++n) {
            stringBuilder.append(this.keyListeners.get(n) + COMMA);
        }
        stringBuilder.append("]").append(COMMA).append(PlatformPropsImpl.NEWLINE).append("  windowLock ").append(this.windowLock).append(COMMA).append("surfaceLockCount ").append(this.surfaceLockCount).append("]");
        return stringBuilder;
    }

    @Override
    public final String toString() {
        return this.toString(new StringBuilder()).toString();
    }

    protected final void setWindowHandle(long l) {
        this.windowHandle = l;
    }

    @Override
    public final void runOnEDTIfAvail(boolean bl, Runnable runnable) {
        if (this.windowLock.isOwner(Thread.currentThread())) {
            runnable.run();
        } else {
            ((DisplayImpl)this.screen.getDisplay()).runOnEDTIfAvail(bl, runnable);
        }
    }

    @Override
    public final boolean hasFocus() {
        return this.stateMask.get(3);
    }

    @Override
    public final void requestFocus() {
        this.requestFocus(true);
    }

    @Override
    public final void requestFocus(boolean bl) {
        this.requestFocus(bl, false, this.stateMask.get(30));
    }

    private void requestFocus(boolean bl, boolean bl2, boolean bl3) {
        if (!(!this.isNativeValid() || !bl3 && this.hasFocus() || !bl2 && this.focusAction())) {
            this.runOnEDTIfAvail(bl, bl3 ? this.requestFocusActionForced : this.requestFocusAction);
        }
    }

    private void requestFocusInt(boolean bl) {
        if (bl || !this.focusAction()) {
            if (!this.isReconfigureMaskSupported(8)) {
                return;
            }
            if (DEBUG_IMPLEMENTATION) {
                System.err.println("Window.RequestFocusInt: forcing - (" + WindowImpl.getThreadName() + "): skipFocusAction " + bl + ", state " + this.getStateMaskString() + " -> focus true - windowHandle " + WindowImpl.toHexString(this.windowHandle) + " parentWindowHandle " + WindowImpl.toHexString(this.parentWindowHandle));
            }
            this.requestFocusImpl(true);
        }
    }

    @Override
    public final void setFocusAction(Window.FocusRunnable focusRunnable) {
        this.focusAction = focusRunnable;
    }

    private boolean focusAction() {
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("Window.focusAction() START - " + WindowImpl.getThreadName() + ", focusAction: " + this.focusAction + " - windowHandle " + WindowImpl.toHexString(this.getWindowHandle()));
        }
        boolean bl = null != this.focusAction ? this.focusAction.run() : false;
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("Window.focusAction() END - " + WindowImpl.getThreadName() + ", focusAction: " + this.focusAction + " - windowHandle " + WindowImpl.toHexString(this.getWindowHandle()) + ", res: " + bl);
        }
        return bl;
    }

    protected final void setBrokenFocusChange(boolean bl) {
        this.stateMask.put(30, bl);
    }

    @Override
    public final void setKeyboardFocusHandler(KeyListener keyListener) {
        this.keyboardFocusHandler = keyListener;
    }

    protected void setPositionImpl(int n, int n2, boolean bl, boolean bl2) {
        this.stateMask.clear(1);
        this.runOnEDTIfAvail(true, new SetPositionAction(n, n2, bl, bl2));
    }

    @Override
    public void setPosition(int n, int n2) {
        this.setPositionImpl(n, n2, true, false);
    }

    @Override
    public final void setTopLevelPosition(int n, int n2) {
        InsetsImmutable insetsImmutable = this.getInsets();
        this.setPosition(n + insetsImmutable.getLeftWidth(), n2 + insetsImmutable.getTopHeight());
    }

    @Override
    public boolean setFullscreen(boolean bl) {
        return this.setFullscreenImpl(bl, true, null);
    }

    @Override
    public boolean setFullscreen(List<MonitorDevice> list) {
        return this.setFullscreenImpl(true, false, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setFullscreenImpl(boolean bl, boolean bl2, List<MonitorDevice> list) {
        FullScreenAction fullScreenAction = this.fullScreenAction;
        synchronized (fullScreenAction) {
            this.fullscreenMonitors = list;
            this.stateMask.put(31, bl2);
            if (this.fullScreenAction.init(bl)) {
                if (this.fullScreenAction.fsOn() && WindowImpl.isOffscreenInstance(this, this.parentWindow)) {
                    if (null != this.parentWindow) {
                        this.nfs_parent = this.parentWindow;
                        this.reparentWindow(null, -1, -1, 3);
                    } else {
                        throw new InternalError("Offscreen instance w/o parent unhandled");
                    }
                }
                this.runOnEDTIfAvail(true, this.fullScreenAction);
                if (!this.fullScreenAction.fsOn() && null != this.nfs_parent) {
                    this.reparentWindow(this.nfs_parent, -1, -1, 3);
                    this.nfs_parent = null;
                }
            }
            return this.stateMask.get(11);
        }
    }

    protected void monitorModeChanged(MonitorEvent monitorEvent, boolean bl) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean removeChild(NativeWindow nativeWindow) {
        Object object = this.childWindowsLock;
        synchronized (object) {
            return this.childWindows.remove(nativeWindow);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean addChild(NativeWindow nativeWindow) {
        if (nativeWindow == null) {
            return false;
        }
        Object object = this.childWindowsLock;
        synchronized (object) {
            return this.childWindows.add(nativeWindow);
        }
    }

    private void doEvent(boolean bl, boolean bl2, NEWTEvent nEWTEvent) {
        boolean bl3 = false;
        if (!bl) {
            bl2 = bl3 = this.consumeEvent(nEWTEvent);
        }
        if (!bl3) {
            this.enqueueEvent(bl2, nEWTEvent);
        }
    }

    @Override
    public final void enqueueEvent(boolean bl, NEWTEvent nEWTEvent) {
        if (this.isNativeValid()) {
            ((DisplayImpl)this.screen.getDisplay()).enqueueEvent(bl, nEWTEvent);
        }
    }

    @Override
    public final boolean consumeEvent(NEWTEvent nEWTEvent) {
        switch (nEWTEvent.getEventType()) {
            case 105: {
                if (this.windowLock.isLockedByOtherThread()) {
                    if (!this.repaintQueued) {
                        boolean bl;
                        this.repaintQueued = true;
                        boolean bl2 = bl = 1200L <= System.currentTimeMillis() - nEWTEvent.getWhen();
                        if (DEBUG_IMPLEMENTATION) {
                            System.err.println("Window.consumeEvent: REPAINT [me " + Thread.currentThread().getName() + ", owner " + this.windowLock.getOwner() + "] - queued " + nEWTEvent + ", discard-to " + bl);
                        }
                        return bl;
                    }
                    return true;
                }
                this.repaintQueued = false;
                break;
            }
            case 100: {
                boolean bl;
                if (!this.windowLock.isLockedByOtherThread()) break;
                boolean bl3 = bl = 1200L <= System.currentTimeMillis() - nEWTEvent.getWhen();
                if (DEBUG_IMPLEMENTATION) {
                    System.err.println("Window.consumeEvent: RESIZED [me " + Thread.currentThread().getName() + ", owner " + this.windowLock.getOwner() + "] - queued " + nEWTEvent + ", discard-to " + bl);
                }
                return bl;
            }
        }
        if (nEWTEvent instanceof WindowEvent) {
            this.consumeWindowEvent((WindowEvent)nEWTEvent);
        } else if (nEWTEvent instanceof KeyEvent) {
            this.consumeKeyEvent((KeyEvent)nEWTEvent);
        } else if (nEWTEvent instanceof MouseEvent) {
            this.consumePointerEvent((MouseEvent)nEWTEvent);
        } else {
            throw new NativeWindowException("Unexpected NEWTEvent type " + nEWTEvent);
        }
        return true;
    }

    public final void sendMouseEvent(short s, int n, int n2, int n3, short s2, float f) {
        this.doMouseEvent(false, false, s, n, n2, n3, s2, MouseEvent.getRotationXYZ(f, n), 1.0f);
    }

    public final void enqueueMouseEvent(boolean bl, short s, int n, int n2, int n3, short s2, float f) {
        this.doMouseEvent(true, bl, s, n, n2, n3, s2, MouseEvent.getRotationXYZ(f, n), 1.0f);
    }

    protected final void doMouseEvent(boolean bl, boolean bl2, short s, int n, int n2, int n3, short s2, float f) {
        this.doMouseEvent(bl, bl2, s, n, n2, n3, s2, MouseEvent.getRotationXYZ(f, n), 1.0f);
    }

    protected void doMouseEvent(boolean bl, boolean bl2, short s, int n, int n2, int n3, short s2, float[] fArray, float f) {
        if (0 > s2 || s2 > 16) {
            throw new NativeWindowException("Invalid mouse button number" + s2);
        }
        this.doPointerEvent(bl, bl2, constMousePointerTypes, s, n, 0, new short[]{0}, s2, new int[]{n2}, new int[]{n3}, new float[]{0.0f}, 1.0f, fArray, f);
    }

    public final void doPointerEvent(boolean bl, boolean bl2, MouseEvent.PointerType[] pointerTypeArray, short s, int n, int n2, boolean bl3, short[] sArray, int[] nArray, int[] nArray2, float[] fArray, float f, float[] fArray2, float f2) {
        int n3;
        short[] sArray2;
        int n4 = sArray.length;
        short[] sArray3 = sArray2 = bl3 ? sArray : new short[n4];
        if (!bl3) {
            for (n3 = 0; n3 < n4; ++n3) {
                int n5;
                short s2;
                int n6 = this.pName2pID.size();
                Short s3 = (Short)this.pName2pID.getOrAdd((Object)sArray[n3]);
                sArray2[n3] = s2 = (short)this.pName2pID.indexOf((Object)s3);
                if (DEBUG_MOUSE_EVENT && n6 != (n5 = this.pName2pID.size())) {
                    System.err.println("PointerName2ID[sz " + n5 + "]: Map " + s3 + " == " + s2);
                }
                if (204 != s) continue;
                this.pName2pID.remove((Object)s3);
                if (!DEBUG_MOUSE_EVENT) continue;
                System.err.println("PointerName2ID[sz " + this.pName2pID.size() + "]: Unmap " + s3 + " == " + s2);
            }
        }
        n3 = 0 < n4 ? (int)(sArray2[n2] + 1) : 0;
        this.doPointerEvent(bl, bl2, pointerTypeArray, s, n, n2, sArray2, (short)n3, nArray, nArray2, fArray, f, fArray2, f2);
    }

    public final void doPointerEvent(boolean bl, boolean bl2, MouseEvent.PointerType[] pointerTypeArray, short s, int n, int n2, short[] sArray, short s2, int[] nArray, int[] nArray2, float[] fArray, float f, float[] fArray2, float f2) {
        MouseEvent mouseEvent;
        long l = System.currentTimeMillis();
        int n3 = pointerTypeArray.length;
        if (0 > n2 || n2 >= n3) {
            throw new IllegalArgumentException("actionIdx " + n2 + " out of bounds [0.." + (n3 - 1) + "]");
        }
        if (0 < n2) {
            MouseEvent.PointerType pointerType = pointerTypeArray[n2];
            pointerTypeArray[n2] = pointerTypeArray[0];
            pointerTypeArray[0] = pointerType;
            int n4 = sArray[n2];
            sArray[n2] = sArray[0];
            sArray[0] = n4;
            n4 = nArray[n2];
            nArray[n2] = nArray[0];
            nArray[0] = n4;
            n4 = nArray2[n2];
            nArray2[n2] = nArray2[0];
            nArray2[0] = n4;
            float f3 = fArray[n2];
            fArray[n2] = fArray[0];
            fArray[0] = f3;
        }
        short s3 = 0 <= s2 && s2 <= 16 ? s2 : (short)1;
        int n5 = nArray[0];
        int n6 = nArray2[0];
        boolean bl3 = n5 >= 0 && n6 >= 0 && n5 < this.getSurfaceWidth() && n6 < this.getSurfaceHeight();
        Point point = this.pState1.getMovePosition(sArray[0]);
        switch (s) {
            case 202: {
                if (this.pState1.dragging) {
                    if (DEBUG_MOUSE_EVENT) {
                        System.err.println("doPointerEvent: drop " + MouseEvent.getEventTypeString(s) + " due to dragging: " + this.pState1);
                    }
                    return;
                }
                if (null != point) {
                    if (n5 == -1 && n6 == -1) {
                        n5 = point.getX();
                        n6 = point.getY();
                    }
                    point.set(0, 0);
                }
            }
            case 201: {
                if (s == 201) {
                    this.pState1.insideSurface = true;
                    this.pState1.exitSent = false;
                } else {
                    this.pState1.insideSurface = false;
                    this.pState1.exitSent = true;
                }
                this.pState1.clearButton();
                if (pointerTypeArray[0] != MouseEvent.PointerType.Mouse) {
                    if (DEBUG_MOUSE_EVENT) {
                        System.err.println("doPointerEvent: drop " + MouseEvent.getEventTypeString(s) + " due to !Mouse but " + pointerTypeArray[0] + ": " + this.pState1);
                    }
                    return;
                }
                n5 = Math.min(Math.max(n5, 0), this.getSurfaceWidth() - 1);
                n6 = Math.min(Math.max(n6, 0), this.getSurfaceHeight() - 1);
                break;
            }
            case 205: 
            case 206: {
                if (null != point) {
                    if (point.getX() == n5 && point.getY() == n6) {
                        if (DEBUG_MOUSE_EVENT) {
                            System.err.println("doPointerEvent: drop " + MouseEvent.getEventTypeString(s) + " w/ same position: " + point + COMMA + this.pState1);
                        }
                        return;
                    }
                    point.set(n5, n6);
                }
            }
            default: {
                if (this.pState1.insideSurface == bl3) break;
                this.pState1.insideSurface = bl3;
                if (bl3) {
                    this.pState1.exitSent = false;
                }
                this.pState1.clearButton();
            }
        }
        if (!this.pState1.dragging && !bl3 && 202 != s) {
            if (DEBUG_MOUSE_EVENT) {
                System.err.println("doPointerEvent: drop: " + MouseEvent.getEventTypeString(s) + ", mod " + n + ", pos " + n5 + "/" + n6 + ", button " + s3 + ", lastMousePosition: " + point + ", insideWindow " + bl3 + COMMA + this.pState1);
            }
            return;
        }
        if (DEBUG_MOUSE_EVENT) {
            System.err.println("doPointerEvent: enqueue " + bl + ", wait " + bl2 + COMMA + MouseEvent.getEventTypeString(s) + ", mod " + n + ", pos " + n5 + "/" + n6 + ", button " + s3 + ", lastMousePosition: " + point + COMMA + this.pState1);
        }
        int n7 = InputEvent.getButtonMask(s3);
        n |= n7;
        n |= this.pState1.buttonPressedMask;
        if (this.isPointerConfined()) {
            n |= 0x40000000;
        }
        if (!this.isPointerVisible()) {
            n |= Integer.MIN_VALUE;
        }
        nArray[0] = n5;
        nArray2[0] = n6;
        switch (s) {
            case 200: {
                return;
            }
            case 203: {
                if (0.0f >= fArray[0]) {
                    fArray[0] = f;
                }
                this.pState1.buttonPressedMask |= n7;
                if (1 == n3) {
                    this.pState1.lastButtonClickCount = l - this.pState1.lastButtonPressTime < (long)MouseEvent.getClickTimeout() ? (short)(this.pState1.lastButtonClickCount + 1) : (short)1;
                    this.pState1.lastButtonPressTime = l;
                    this.pState1.buttonPressed = s3;
                    mouseEvent = new MouseEvent(s, this, l, n, pointerTypeArray, sArray, nArray, nArray2, fArray, f, s3, this.pState1.lastButtonClickCount, fArray2, f2);
                    break;
                }
                mouseEvent = new MouseEvent(s, this, l, n, pointerTypeArray, sArray, nArray, nArray2, fArray, f, s3, 1, fArray2, f2);
                break;
            }
            case 204: {
                this.pState1.buttonPressedMask &= ~n7;
                if (1 == n3) {
                    mouseEvent = new MouseEvent(s, this, l, n, pointerTypeArray, sArray, nArray, nArray2, fArray, f, s3, this.pState1.lastButtonClickCount, fArray2, f2);
                    if (l - this.pState1.lastButtonPressTime >= (long)MouseEvent.getClickTimeout()) {
                        this.pState1.lastButtonClickCount = 0;
                        this.pState1.lastButtonPressTime = 0L;
                    }
                    this.pState1.buttonPressed = 0;
                    this.pState1.dragging = false;
                } else {
                    mouseEvent = new MouseEvent(s, this, l, n, pointerTypeArray, sArray, nArray, nArray2, fArray, f, s3, 1, fArray2, f2);
                    if (0 == this.pState1.buttonPressedMask) {
                        this.pState1.clearButton();
                    }
                }
                if (null == point) break;
                point.set(0, 0);
                break;
            }
            case 205: {
                if (0 != this.pState1.buttonPressedMask) {
                    mouseEvent = new MouseEvent(206, this, l, n, pointerTypeArray, sArray, nArray, nArray2, fArray, f, this.pState1.buttonPressed, 1, fArray2, f2);
                    this.pState1.dragging = true;
                    break;
                }
                mouseEvent = new MouseEvent(s, this, l, n, pointerTypeArray, sArray, nArray, nArray2, fArray, f, s3, 0, fArray2, f2);
                break;
            }
            case 206: {
                if (0.0f >= fArray[0]) {
                    fArray[0] = f;
                }
                this.pState1.dragging = true;
            }
            default: {
                mouseEvent = new MouseEvent(s, this, l, n, pointerTypeArray, sArray, nArray, nArray2, fArray, f, s3, 0, fArray2, f2);
            }
        }
        this.doEvent(bl, bl2, mouseEvent);
    }

    private static int step(int n, int n2, int n3) {
        return n3 < n2 ? n : n3;
    }

    protected void consumePointerEvent(MouseEvent mouseEvent) {
        Object object;
        int n;
        int n2;
        boolean bl;
        if (DEBUG_MOUSE_EVENT) {
            System.err.println("consumePointerEvent.in: " + mouseEvent + COMMA + this.pState0 + ", pos " + mouseEvent.getX() + "/" + mouseEvent.getY() + ", win[" + this.getX() + "/" + this.getY() + " " + this.getWidth() + "x" + this.getHeight() + "], pixel[" + this.getSurfaceWidth() + "x" + this.getSurfaceHeight() + "]");
        }
        long l = mouseEvent.getWhen();
        short s = mouseEvent.getEventType();
        boolean bl2 = false;
        MouseEvent mouseEvent2 = null;
        MouseEvent mouseEvent3 = null;
        switch (s) {
            case 202: {
                if (this.pState0.exitSent || this.pState0.dragging) {
                    if (DEBUG_MOUSE_EVENT) {
                        System.err.println("consumePointerEvent: drop " + (this.pState0.exitSent ? "already sent" : "due to dragging") + ": " + mouseEvent + COMMA + this.pState0);
                    }
                    return;
                }
            }
            case 201: {
                this.pState0.clearButton();
                if (s == 201) {
                    bl = true;
                    this.pState0.insideSurface = true;
                    this.pState0.exitSent = false;
                    this.pState0.dragging = false;
                    break;
                }
                bl = false;
                this.pState0.insideSurface = false;
                this.pState0.exitSent = true;
                break;
            }
            case 204: 
            case 205: {
                if (1 >= mouseEvent.getButtonDownCount()) {
                    bl2 = !this.pState0.exitSent;
                    this.pState0.dragging = false;
                }
            }
            default: {
                n2 = mouseEvent.getX();
                n = mouseEvent.getY();
                boolean bl3 = bl = n2 >= 0 && n >= 0 && n2 < this.getSurfaceWidth() && n < this.getSurfaceHeight();
                if (mouseEvent.getPointerType(0) == MouseEvent.PointerType.Mouse) {
                    if (!this.pState0.insideSurface && bl) {
                        mouseEvent2 = new MouseEvent(201, mouseEvent.getSource(), mouseEvent.getWhen(), mouseEvent.getModifiers(), Math.min(Math.max(n2, 0), this.getSurfaceWidth() - 1), Math.min(Math.max(n, 0), this.getSurfaceHeight() - 1), 0, 0, mouseEvent.getRotation(), mouseEvent.getRotationScale());
                        this.pState0.exitSent = false;
                    } else if (!bl && bl2) {
                        mouseEvent3 = new MouseEvent(202, mouseEvent.getSource(), mouseEvent.getWhen(), mouseEvent.getModifiers(), Math.min(Math.max(n2, 0), this.getSurfaceWidth() - 1), Math.min(Math.max(n, 0), this.getSurfaceHeight() - 1), 0, 0, mouseEvent.getRotation(), mouseEvent.getRotationScale());
                        this.pState0.exitSent = true;
                    }
                }
                if (this.pState0.insideSurface != bl || null != mouseEvent2 || null != mouseEvent3) {
                    this.pState0.clearButton();
                }
                this.pState0.insideSurface = bl;
            }
        }
        if (null != mouseEvent2) {
            if (DEBUG_MOUSE_EVENT) {
                System.err.println("consumePointerEvent.send.0: " + mouseEvent2 + COMMA + this.pState0);
            }
            this.dispatchMouseEvent(mouseEvent2);
        } else if (DEBUG_MOUSE_EVENT && !bl) {
            System.err.println("INFO consumePointerEvent.exterior: " + this.pState0 + COMMA + mouseEvent);
        }
        if (this.defaultGestureHandlerEnabled && mouseEvent.getPointerType(0).getPointerClass() == MouseEvent.PointerClass.Onscreen) {
            if (null == this.gesture2PtrTouchScroll) {
                MonitorDevice monitorDevice = this.getMainMonitor();
                if (null != monitorDevice) {
                    object = monitorDevice.getSizeMM();
                    float f = (float)monitorDevice.getCurrentMode().getRotatedWidth() / (float)object.getWidth();
                    float f2 = (float)monitorDevice.getCurrentMode().getRotatedHeight() / (float)object.getHeight();
                    float f3 = Math.min(f2, f);
                    n2 = Math.round(DoubleTapScrollGesture.SCROLL_SLOP_MM * f3);
                    n = Math.round(DoubleTapScrollGesture.DOUBLE_TAP_SLOP_MM * f3);
                    if (DEBUG_MOUSE_EVENT) {
                        System.err.println("consumePointerEvent.gscroll: scrollSlop " + n2 + ", doubleTapSlop " + n + ", pixPerMM " + f3 + COMMA + monitorDevice + COMMA + this.pState0);
                    }
                } else {
                    n2 = DoubleTapScrollGesture.SCROLL_SLOP_PIXEL;
                    n = DoubleTapScrollGesture.DOUBLE_TAP_SLOP_PIXEL;
                }
                this.gesture2PtrTouchScroll = new DoubleTapScrollGesture(WindowImpl.step(DoubleTapScrollGesture.SCROLL_SLOP_PIXEL, DoubleTapScrollGesture.SCROLL_SLOP_PIXEL / 2, n2), WindowImpl.step(DoubleTapScrollGesture.DOUBLE_TAP_SLOP_PIXEL, DoubleTapScrollGesture.DOUBLE_TAP_SLOP_PIXEL / 2, n));
            }
            if (this.gesture2PtrTouchScroll.process(mouseEvent)) {
                mouseEvent = (MouseEvent)this.gesture2PtrTouchScroll.getGestureEvent();
                this.gesture2PtrTouchScroll.clear(false);
                if (DEBUG_MOUSE_EVENT) {
                    System.err.println("consumePointerEvent.gscroll: " + mouseEvent + COMMA + this.pState0);
                }
                this.dispatchMouseEvent(mouseEvent);
                return;
            }
            if (this.gesture2PtrTouchScroll.isWithinGesture()) {
                return;
            }
        }
        if ((n2 = this.pointerGestureHandler.size()) > 0) {
            n = 0;
            for (int i = 0; !mouseEvent.isConsumed() && i < n2; ++i) {
                object = this.pointerGestureHandler.get(i);
                if (object.process(mouseEvent)) {
                    InputEvent inputEvent = object.getGestureEvent();
                    object.clear(false);
                    if (inputEvent instanceof MouseEvent) {
                        this.dispatchMouseEvent((MouseEvent)inputEvent);
                    } else if (inputEvent instanceof GestureHandler.GestureEvent) {
                        GestureHandler.GestureEvent gestureEvent = (GestureHandler.GestureEvent)inputEvent;
                        for (int j = 0; !gestureEvent.isConsumed() && j < this.gestureListeners.size(); ++j) {
                            this.gestureListeners.get(j).gestureDetected(gestureEvent);
                        }
                    }
                    return;
                }
                n |= object.isWithinGesture();
            }
            if (n != 0) {
                return;
            }
        }
        MouseEvent mouseEvent4 = null;
        switch (s) {
            case 203: {
                if (1 != mouseEvent.getPointerCount()) break;
                this.pState0.lastButtonPressTime = l;
                break;
            }
            case 204: {
                if (1 == mouseEvent.getPointerCount() && l - this.pState0.lastButtonPressTime < (long)MouseEvent.getClickTimeout()) {
                    mouseEvent4 = mouseEvent.createVariant((short)200);
                    break;
                }
                this.pState0.lastButtonPressTime = 0L;
                break;
            }
            case 200: {
                if (DEBUG_MOUSE_EVENT) {
                    System.err.println("consumePointerEvent: drop recv'ed (synth here) " + mouseEvent + COMMA + this.pState0);
                }
                mouseEvent = null;
                break;
            }
            case 206: {
                this.pState0.dragging = true;
            }
        }
        if (null != mouseEvent) {
            if (DEBUG_MOUSE_EVENT) {
                System.err.println("consumePointerEvent.send.1: " + mouseEvent + COMMA + this.pState0);
            }
            this.dispatchMouseEvent(mouseEvent);
        }
        if (null != mouseEvent4) {
            if (DEBUG_MOUSE_EVENT) {
                System.err.println("consumePointerEvent.send.2: " + mouseEvent4 + COMMA + this.pState0);
            }
            this.dispatchMouseEvent(mouseEvent4);
        }
        if (null != mouseEvent3) {
            if (DEBUG_MOUSE_EVENT) {
                System.err.println("consumePointerEvent.send.3: " + mouseEvent3 + COMMA + this.pState0);
            }
            this.dispatchMouseEvent(mouseEvent3);
        }
    }

    @Override
    public final void addMouseListener(MouseListener mouseListener) {
        this.addMouseListener(-1, mouseListener);
    }

    @Override
    public final void addMouseListener(int n, MouseListener mouseListener) {
        if (mouseListener == null) {
            return;
        }
        ArrayList arrayList = (ArrayList)this.mouseListeners.clone();
        if (0 > n) {
            n = arrayList.size();
        }
        arrayList.add(n, mouseListener);
        this.mouseListeners = arrayList;
    }

    @Override
    public final void removeMouseListener(MouseListener mouseListener) {
        if (mouseListener == null) {
            return;
        }
        ArrayList arrayList = (ArrayList)this.mouseListeners.clone();
        arrayList.remove(mouseListener);
        this.mouseListeners = arrayList;
    }

    @Override
    public final MouseListener getMouseListener(int n) {
        ArrayList arrayList = (ArrayList)this.mouseListeners.clone();
        if (0 > n) {
            n = arrayList.size() - 1;
        }
        return (MouseListener)arrayList.get(n);
    }

    @Override
    public final MouseListener[] getMouseListeners() {
        return this.mouseListeners.toArray(new MouseListener[this.mouseListeners.size()]);
    }

    @Override
    public final void setDefaultGesturesEnabled(boolean bl) {
        this.defaultGestureHandlerEnabled = bl;
    }

    @Override
    public final boolean areDefaultGesturesEnabled() {
        return this.defaultGestureHandlerEnabled;
    }

    @Override
    public final void addGestureHandler(GestureHandler gestureHandler) {
        this.addGestureHandler(-1, gestureHandler);
    }

    @Override
    public final void addGestureHandler(int n, GestureHandler gestureHandler) {
        if (gestureHandler == null) {
            return;
        }
        ArrayList arrayList = (ArrayList)this.pointerGestureHandler.clone();
        if (0 > n) {
            n = arrayList.size();
        }
        arrayList.add(n, gestureHandler);
        this.pointerGestureHandler = arrayList;
    }

    @Override
    public final void removeGestureHandler(GestureHandler gestureHandler) {
        if (gestureHandler == null) {
            return;
        }
        ArrayList arrayList = (ArrayList)this.pointerGestureHandler.clone();
        arrayList.remove(gestureHandler);
        this.pointerGestureHandler = arrayList;
    }

    @Override
    public final void addGestureListener(GestureHandler.GestureListener gestureListener) {
        this.addGestureListener(-1, gestureListener);
    }

    @Override
    public final void addGestureListener(int n, GestureHandler.GestureListener gestureListener) {
        if (gestureListener == null) {
            return;
        }
        ArrayList arrayList = (ArrayList)this.gestureListeners.clone();
        if (0 > n) {
            n = arrayList.size();
        }
        arrayList.add(n, gestureListener);
        this.gestureListeners = arrayList;
    }

    @Override
    public final void removeGestureListener(GestureHandler.GestureListener gestureListener) {
        if (gestureListener == null) {
            return;
        }
        ArrayList arrayList = (ArrayList)this.gestureListeners.clone();
        arrayList.remove(gestureListener);
        this.gestureListeners = arrayList;
    }

    private final void dispatchMouseEvent(MouseEvent mouseEvent) {
        block10: for (int i = 0; !mouseEvent.isConsumed() && i < this.mouseListeners.size(); ++i) {
            MouseListener mouseListener = this.mouseListeners.get(i);
            switch (mouseEvent.getEventType()) {
                case 200: {
                    mouseListener.mouseClicked(mouseEvent);
                    continue block10;
                }
                case 201: {
                    mouseListener.mouseEntered(mouseEvent);
                    continue block10;
                }
                case 202: {
                    mouseListener.mouseExited(mouseEvent);
                    continue block10;
                }
                case 203: {
                    mouseListener.mousePressed(mouseEvent);
                    continue block10;
                }
                case 204: {
                    mouseListener.mouseReleased(mouseEvent);
                    continue block10;
                }
                case 205: {
                    mouseListener.mouseMoved(mouseEvent);
                    continue block10;
                }
                case 206: {
                    mouseListener.mouseDragged(mouseEvent);
                    continue block10;
                }
                case 207: {
                    mouseListener.mouseWheelMoved(mouseEvent);
                    continue block10;
                }
                default: {
                    throw new NativeWindowException("Unexpected mouse event type " + mouseEvent.getEventType());
                }
            }
        }
    }

    protected final boolean isKeyCodeTracked(short s) {
        return (0xFFFF & s) <= 255;
    }

    protected final boolean setKeyPressed(short s, boolean bl) {
        int n = 0xFFFF & s;
        if (n <= 255) {
            return this.keyPressedState.put(n, bl);
        }
        return false;
    }

    protected final boolean isKeyPressed(short s) {
        int n = 0xFFFF & s;
        if (n <= 255) {
            return this.keyPressedState.get(n);
        }
        return false;
    }

    public void sendKeyEvent(short s, int n, short s2, short s3, char c) {
        this.consumeKeyEvent(KeyEvent.create(s, this, System.currentTimeMillis(), n | this.pState1.buttonPressedMask, s2, s3, c));
    }

    public void enqueueKeyEvent(boolean bl, short s, int n, short s2, short s3, char c) {
        this.enqueueEvent(bl, KeyEvent.create(s, this, System.currentTimeMillis(), n | this.pState1.buttonPressedMask, s2, s3, c));
    }

    @Override
    public final void setKeyboardVisible(boolean bl) {
        if (this.isNativeValid()) {
            boolean bl2 = this.setKeyboardVisibleImpl(bl);
            if (DEBUG_IMPLEMENTATION || DEBUG_KEY_EVENT) {
                System.err.println("setKeyboardVisible(native): visible " + this.keyboardVisible + " -- op[visible:" + bl + ", ok " + bl2 + "] -> " + (bl && bl2));
            }
            this.keyboardVisibilityChanged(bl && bl2);
        } else {
            this.keyboardVisibilityChanged(bl);
        }
    }

    @Override
    public final boolean isKeyboardVisible() {
        return this.keyboardVisible;
    }

    protected boolean setKeyboardVisibleImpl(boolean bl) {
        return false;
    }

    protected void keyboardVisibilityChanged(boolean bl) {
        if (this.keyboardVisible != bl) {
            if (DEBUG_IMPLEMENTATION || DEBUG_KEY_EVENT) {
                System.err.println("keyboardVisibilityChanged: " + this.keyboardVisible + " -> " + bl);
            }
            this.keyboardVisible = bl;
        }
    }

    @Override
    public final void addKeyListener(KeyListener keyListener) {
        this.addKeyListener(-1, keyListener);
    }

    @Override
    public final void addKeyListener(int n, KeyListener keyListener) {
        if (keyListener == null) {
            return;
        }
        ArrayList arrayList = (ArrayList)this.keyListeners.clone();
        if (0 > n) {
            n = arrayList.size();
        }
        arrayList.add(n, keyListener);
        this.keyListeners = arrayList;
    }

    @Override
    public final void removeKeyListener(KeyListener keyListener) {
        if (keyListener == null) {
            return;
        }
        ArrayList arrayList = (ArrayList)this.keyListeners.clone();
        arrayList.remove(keyListener);
        this.keyListeners = arrayList;
    }

    @Override
    public final KeyListener getKeyListener(int n) {
        ArrayList arrayList = (ArrayList)this.keyListeners.clone();
        if (0 > n) {
            n = arrayList.size() - 1;
        }
        return (KeyListener)arrayList.get(n);
    }

    @Override
    public final KeyListener[] getKeyListeners() {
        return this.keyListeners.toArray(new KeyListener[this.keyListeners.size()]);
    }

    private final boolean propagateKeyEvent(KeyEvent keyEvent, KeyListener keyListener) {
        switch (keyEvent.getEventType()) {
            case 300: {
                keyListener.keyPressed(keyEvent);
                break;
            }
            case 301: {
                keyListener.keyReleased(keyEvent);
                break;
            }
            default: {
                throw new NativeWindowException("Unexpected key event type " + keyEvent.getEventType());
            }
        }
        return keyEvent.isConsumed();
    }

    protected void consumeKeyEvent(KeyEvent keyEvent) {
        boolean bl = false;
        if (null != this.keyboardFocusHandler && !keyEvent.isAutoRepeat()) {
            bl = this.propagateKeyEvent(keyEvent, this.keyboardFocusHandler);
            if (DEBUG_KEY_EVENT && bl) {
                System.err.println("consumeKeyEvent(kfh): " + keyEvent + ", consumed: " + bl);
            }
        }
        if (!bl) {
            for (int i = 0; !bl && i < this.keyListeners.size(); ++i) {
                bl = this.propagateKeyEvent(keyEvent, this.keyListeners.get(i));
            }
            if (DEBUG_KEY_EVENT) {
                System.err.println("consumeKeyEvent(usr): " + keyEvent + ", consumed: " + bl);
            }
        }
    }

    @Override
    public final void sendWindowEvent(int n) {
        this.consumeWindowEvent(new WindowEvent((short)n, this, System.currentTimeMillis()));
    }

    public final void enqueueWindowEvent(boolean bl, int n) {
        this.enqueueEvent(bl, new WindowEvent((short)n, this, System.currentTimeMillis()));
    }

    @Override
    public final void addWindowListener(WindowListener windowListener) {
        this.addWindowListener(-1, windowListener);
    }

    @Override
    public final void addWindowListener(int n, WindowListener windowListener) throws IndexOutOfBoundsException {
        if (windowListener == null) {
            return;
        }
        ArrayList arrayList = (ArrayList)this.windowListeners.clone();
        if (0 > n) {
            n = arrayList.size();
        }
        arrayList.add(n, windowListener);
        this.windowListeners = arrayList;
    }

    @Override
    public final void removeWindowListener(WindowListener windowListener) {
        if (windowListener == null) {
            return;
        }
        ArrayList arrayList = (ArrayList)this.windowListeners.clone();
        arrayList.remove(windowListener);
        this.windowListeners = arrayList;
    }

    @Override
    public final WindowListener getWindowListener(int n) {
        ArrayList arrayList = (ArrayList)this.windowListeners.clone();
        if (0 > n) {
            n = arrayList.size() - 1;
        }
        return (WindowListener)arrayList.get(n);
    }

    @Override
    public final WindowListener[] getWindowListeners() {
        return this.windowListeners.toArray(new WindowListener[this.windowListeners.size()]);
    }

    protected void consumeWindowEvent(WindowEvent windowEvent) {
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("consumeWindowEvent: " + windowEvent + ", visible " + this.isVisible() + " " + this.getX() + "/" + this.getY() + ", win[" + this.getX() + "/" + this.getY() + " " + this.getWidth() + "x" + this.getHeight() + "], pixel[" + this.getSurfaceWidth() + "x" + this.getSurfaceHeight() + "]");
        }
        block9: for (int i = 0; !windowEvent.isConsumed() && i < this.windowListeners.size(); ++i) {
            WindowListener windowListener = this.windowListeners.get(i);
            switch (windowEvent.getEventType()) {
                case 100: {
                    windowListener.windowResized(windowEvent);
                    continue block9;
                }
                case 101: {
                    windowListener.windowMoved(windowEvent);
                    continue block9;
                }
                case 102: {
                    windowListener.windowDestroyNotify(windowEvent);
                    continue block9;
                }
                case 106: {
                    windowListener.windowDestroyed(windowEvent);
                    continue block9;
                }
                case 103: {
                    windowListener.windowGainedFocus(windowEvent);
                    continue block9;
                }
                case 104: {
                    windowListener.windowLostFocus(windowEvent);
                    continue block9;
                }
                case 105: {
                    windowListener.windowRepaint((WindowUpdateEvent)windowEvent);
                    continue block9;
                }
                default: {
                    throw new NativeWindowException("Unexpected window event type " + windowEvent.getEventType());
                }
            }
        }
    }

    protected void focusChanged(boolean bl, boolean bl2) {
        if (this.stateMask.get(30) || this.stateMask.get(3) != bl2) {
            int n;
            if (DEBUG_IMPLEMENTATION) {
                System.err.println("Window.focusChanged: (" + WindowImpl.getThreadName() + "): (defer: " + bl + ") state " + this.getStateMaskString() + " -> focus " + bl2 + " - windowHandle " + WindowImpl.toHexString(this.windowHandle) + " parentWindowHandle " + WindowImpl.toHexString(this.parentWindowHandle));
            }
            this.stateMask.put(3, bl2);
            int n2 = n = bl2 ? 103 : 104;
            if (!bl) {
                this.sendWindowEvent(n);
            } else {
                this.enqueueWindowEvent(false, n);
            }
        }
    }

    protected final void visibleChanged(boolean bl) {
        if (this.stateMask.put(0, bl) != bl && DEBUG_IMPLEMENTATION) {
            System.err.println("Window.visibleChanged (" + WindowImpl.getThreadName() + "): visible " + !bl + " -> state " + this.getStateMaskString() + " - windowHandle " + WindowImpl.toHexString(this.windowHandle) + " parentWindowHandle " + WindowImpl.toHexString(this.parentWindowHandle));
        }
    }

    protected boolean sizeChanged(boolean bl, boolean bl2, int n, int n2, boolean bl3) {
        if (bl3 || bl2 && (this.windowSize[0] != n || this.windowSize[1] != n2) || !bl2 && (this.pixelSize[0] != n || this.pixelSize[1] != n2)) {
            if (DEBUG_IMPLEMENTATION) {
                String string = bl2 ? "win[" + this.windowSize[0] + "x" + this.windowSize[1] + " -> " + n + "x" + n2 + "]" : "pixel[" + this.pixelSize[0] + "x" + this.pixelSize[1] + " -> " + n + "x" + n2 + "]";
                System.err.println("Window.sizeChanged: (" + WindowImpl.getThreadName() + "): (defer: " + bl + ") force " + bl3 + COMMA + string + ", state " + this.getStateMaskString() + " - windowHandle " + WindowImpl.toHexString(this.windowHandle) + " parentWindowHandle " + WindowImpl.toHexString(this.parentWindowHandle));
            }
            if (0 > n || 0 > n2) {
                throw new NativeWindowException("Illegal width or height " + n + "x" + n2 + " (must be >= 0)");
            }
            if (bl2) {
                this.defineWindowSize(n, n2);
            } else {
                this.definePixelSize(n, n2);
            }
            if (this.isNativeValid()) {
                if (!bl) {
                    this.sendWindowEvent(100);
                } else {
                    this.enqueueWindowEvent(false, 100);
                }
            }
            return true;
        }
        return false;
    }

    protected boolean positionChanged(boolean bl, boolean bl2, int n, int n2) {
        if (bl2 && (this.windowPos[0] != n || this.windowPos[1] != n2) || !bl2 && (this.pixelPos[0] != n || this.pixelPos[1] != n2)) {
            if (DEBUG_IMPLEMENTATION) {
                String string = bl2 ? "win[" + this.windowPos[0] + "x" + this.windowPos[1] + " -> " + n + "x" + n2 + "]" : "pixel[" + this.pixelPos[0] + "x" + this.pixelPos[1] + " -> " + n + "x" + n2 + "]";
                System.err.println("Window.positionChanged: (" + WindowImpl.getThreadName() + "): (defer: " + bl + ") " + string + " - windowHandle " + WindowImpl.toHexString(this.windowHandle) + " parentWindowHandle " + WindowImpl.toHexString(this.parentWindowHandle));
            }
            if (bl2) {
                this.defineWindowPosition(n, n2);
            } else {
                this.definePixelPosition(n, n2);
            }
            if (!bl) {
                this.sendWindowEvent(101);
            } else {
                this.enqueueWindowEvent(false, 101);
            }
            return true;
        }
        this.stateMask.clear(1);
        return false;
    }

    protected final void insetsChanged(boolean bl, int n, int n2, int n3, int n4) {
        if (n >= 0 && n2 >= 0 && n3 >= 0 && n4 >= 0) {
            boolean bl2;
            int[] nArray;
            int[] nArray2;
            if (bl) {
                nArray2 = new int[]{n, n3};
                nArray = new int[]{n2, n4};
            } else {
                nArray2 = SurfaceScaleUtils.scaleInv(new int[2], n, n3, this.hasPixelScale);
                nArray = SurfaceScaleUtils.scaleInv(new int[2], n2, n4, this.hasPixelScale);
            }
            boolean bl3 = bl2 = nArray2[0] != this.insets.getLeftWidth() || nArray[0] != this.insets.getRightWidth() || nArray2[1] != this.insets.getTopHeight() || nArray[1] != this.insets.getBottomHeight();
            if (this.blockInsetsChange || this.isUndecorated()) {
                if (DEBUG_IMPLEMENTATION && bl2) {
                    System.err.println("Window.insetsChanged: Skip insets change " + this.insets + " -> " + new Insets(nArray2[0], nArray[0], nArray2[1], nArray[1]) + " (blocked " + this.blockInsetsChange + ", undecoration " + this.isUndecorated() + ")");
                }
            } else if (bl2) {
                if (DEBUG_IMPLEMENTATION) {
                    System.err.println("Window.insetsChanged: Changed " + this.insets + " -> " + new Insets(nArray2[0], nArray[0], nArray2[1], nArray[1]));
                }
                this.insets.set(nArray2[0], nArray[0], nArray2[1], nArray[1]);
            }
        }
    }

    protected final void windowRepaint(boolean bl, int n, int n2, int n3, int n4) {
        n3 = 0 >= n3 ? this.getSurfaceWidth() : n3;
        int n5 = n4 = 0 >= n4 ? this.getSurfaceHeight() : n4;
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("Window.windowRepaint " + WindowImpl.getThreadName() + " (defer: " + bl + ") " + n + "/" + n2 + " " + n3 + "x" + n4);
        }
        if (this.isNativeValid()) {
            WindowUpdateEvent windowUpdateEvent = new WindowUpdateEvent(105, this, System.currentTimeMillis(), new Rectangle(n, n2, n3, n4));
            this.doEvent(bl, false, windowUpdateEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean windowDestroyNotify(boolean bl) {
        boolean bl2;
        WindowClosingProtocol.WindowClosingMode windowClosingMode;
        WindowClosingProtocol.WindowClosingMode windowClosingMode2 = this.getDefaultCloseOperation();
        WindowClosingProtocol.WindowClosingMode windowClosingMode3 = windowClosingMode = bl ? WindowClosingProtocol.WindowClosingMode.DISPOSE_ON_CLOSE : windowClosingMode2;
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("Window.windowDestroyNotify(isNativeValid: " + this.isNativeValid() + ", force: " + bl + ", mode " + (Object)((Object)windowClosingMode2) + " -> " + (Object)((Object)windowClosingMode) + ") " + WindowImpl.getThreadName() + ": " + this);
        }
        if (this.isNativeValid()) {
            if (WindowClosingProtocol.WindowClosingMode.DISPOSE_ON_CLOSE == windowClosingMode) {
                if (bl) {
                    this.setDefaultCloseOperation(windowClosingMode);
                }
                try {
                    if (null == this.windowDestroyNotifyAction) {
                        this.destroy();
                    }
                    this.windowDestroyNotifyAction.run();
                }
                finally {
                    if (bl) {
                        this.setDefaultCloseOperation(windowClosingMode2);
                    }
                }
            } else {
                this.sendWindowEvent(102);
            }
            bl2 = !this.isNativeValid();
        } else {
            bl2 = true;
        }
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("Window.windowDestroyNotify(isNativeValid: " + this.isNativeValid() + ", force: " + bl + ", mode " + (Object)((Object)windowClosingMode) + ") END " + WindowImpl.getThreadName() + ": destroyed " + bl2 + COMMA + this);
        }
        return bl2;
    }

    protected final void visibleChangedSendMouseEvent(boolean bl, int n, short s, int n2, int n3, int n4, short s2, float f) {
        if (0 <= n) {
            this.visibleChanged(0 < n);
        }
        if (0 < s) {
            if (bl) {
                this.enqueueMouseEvent(false, s, n2, n3, n4, s2, f);
            } else {
                this.sendMouseEvent(s, n2, n3, n4, s2, f);
            }
        }
    }

    protected final void visibleChangedWindowRepaint(boolean bl, int n, int n2, int n3, int n4, int n5) {
        if (0 <= n) {
            this.visibleChanged(0 < n);
        }
        this.windowRepaint(bl, n2, n3, n4, n5);
    }

    protected final void focusVisibleChanged(boolean bl, int n, int n2) {
        if (0 <= n) {
            this.focusChanged(bl, 0 < n);
        }
        if (0 <= n2) {
            this.visibleChanged(0 < n2);
        }
    }

    protected final void insetsVisibleChanged(boolean bl, int n, int n2, int n3, int n4, int n5) {
        this.insetsChanged(bl, n, n2, n3, n4);
        if (0 <= n5) {
            this.visibleChanged(0 < n5);
        }
    }

    protected final void sizePosInsetsFocusVisibleChanged(boolean bl, boolean bl2, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, boolean bl3) {
        this.sizeChanged(bl, bl2, n3, n4, bl3);
        this.positionChanged(bl, bl2, n, n2);
        this.insetsChanged(bl2, n5, n6, n7, n8);
        if (0 <= n9) {
            this.focusChanged(bl, 0 < n9);
        }
        if (0 <= n10) {
            this.visibleChanged(0 < n10);
        }
    }

    protected final void sizePosMaxInsetsVisibleChanged(boolean bl, boolean bl2, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, boolean bl3) {
        this.sizeChanged(bl, bl2, n3, n4, bl3);
        this.positionChanged(bl, bl2, n, n2);
        if (0 <= n5 && 0 <= n6) {
            this.maximizedChanged(0 < n5, 0 < n6);
        }
        this.insetsChanged(false, n7, n8, n9, n10);
        if (0 <= n11) {
            this.visibleChanged(0 < n11);
        }
    }

    private long waitForVisible(boolean bl, boolean bl2) {
        return this.waitForVisible(bl, bl2, 1000L);
    }

    private long waitForVisible(boolean bl, boolean bl2, long l) {
        long l2;
        DisplayImpl displayImpl = (DisplayImpl)this.screen.getDisplay();
        displayImpl.dispatchMessagesNative();
        boolean bl3 = this.stateMask.get(0);
        for (l2 = l; 0L < l2 && bl3 != bl; l2 -= 10L) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            displayImpl.dispatchMessagesNative();
            bl3 = this.stateMask.get(0);
        }
        if (bl != bl3) {
            String string = "Visibility not reached as requested within " + l + "ms : requested " + bl + ", is " + bl3;
            if (DEBUG_FREEZE_AT_VISIBILITY_FAILURE) {
                System.err.println("XXXX: " + string);
                System.err.println("XXXX: FREEZE");
                try {
                    while (true) {
                        Thread.sleep(100L);
                        displayImpl.dispatchMessagesNative();
                    }
                }
                catch (InterruptedException interruptedException) {
                    ExceptionUtils.dumpThrowable((String)"", (Throwable)interruptedException);
                    Thread.currentThread().interrupt();
                    throw new NativeWindowException(string);
                }
            }
            if (bl2) {
                throw new NativeWindowException(string);
            }
            if (DEBUG_IMPLEMENTATION) {
                System.err.println(string);
                ExceptionUtils.dumpStack((PrintStream)System.err);
            }
            return -1L;
        }
        if (0L < l2) {
            return l2;
        }
        return 0L;
    }

    private boolean waitForSize(int n, int n2, boolean bl, long l) {
        long l2;
        DisplayImpl displayImpl = (DisplayImpl)this.screen.getDisplay();
        displayImpl.dispatchMessagesNative();
        for (l2 = l; 0L < l2 && n != this.getWidth() && n2 != this.getHeight(); l2 -= 10L) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            displayImpl.dispatchMessagesNative();
        }
        if (0L >= l2) {
            String string = "Size/Pos not reached as requested within " + l + "ms : requested " + n + "x" + n2 + ", is " + this.getWidth() + "x" + this.getHeight();
            if (bl) {
                throw new NativeWindowException(string);
            }
            if (DEBUG_IMPLEMENTATION) {
                System.err.println(string);
                ExceptionUtils.dumpStack((PrintStream)System.err);
            }
            return false;
        }
        return true;
    }

    private boolean waitForPosition(boolean bl, int n, int n2, long l) {
        boolean bl2;
        DisplayImpl displayImpl = (DisplayImpl)this.screen.getDisplay();
        InsetsImmutable insetsImmutable = this.getInsets();
        int n3 = Math.max(64, insetsImmutable.getLeftWidth() * 2);
        int n4 = Math.max(64, insetsImmutable.getTopHeight() * 2);
        long l2 = l;
        boolean bl3 = false;
        do {
            if (bl && this.isReconfigureMaskSupported(16384)) {
                bl2 = Math.abs(n - this.getX()) <= n3 && Math.abs(n2 - this.getY()) <= n4;
            } else {
                bl3 = this.stateMask.get(1);
                boolean bl4 = bl2 = !bl3;
            }
            if (bl2) continue;
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            displayImpl.dispatchMessagesNative();
            l2 -= 10L;
        } while (0L < l2 && !bl2);
        if (DEBUG_IMPLEMENTATION && !bl2) {
            if (bl) {
                System.err.println("Custom position " + n + "/" + n2 + " not reached within timeout, has " + this.getX() + "/" + this.getY() + ", remaining " + l2);
            } else {
                System.err.println("Auto position not reached within timeout, has " + this.getX() + "/" + this.getY() + ", autoPosition " + bl3 + ", remaining " + l2);
            }
            ExceptionUtils.dumpStack((PrintStream)System.err);
        }
        return bl2;
    }

    public final void pixelScaleChangeNotify(float[] fArray, float[] fArray2, boolean bl) {
        System.arraycopy(fArray, 0, this.minPixelScale, 0, 2);
        System.arraycopy(fArray2, 0, this.maxPixelScale, 0, 2);
        if (bl) {
            this.setSurfaceScale(this.reqPixelScale);
        }
    }

    @Override
    public final void windowRepaint(int n, int n2, int n3, int n4) {
        this.windowRepaint(false, n, n2, n3, n4);
    }

    protected final void sendMouseEventRequestFocus(short s, int n, int n2, int n3, short s2, float f) {
        this.sendMouseEvent(s, n, n2, n3, s2, f);
        this.requestFocus(false);
    }

    private static Class<?>[] getCustomConstructorArgumentTypes(Class<?> clazz) {
        Class[] classArray = null;
        try {
            Method method = clazz.getDeclaredMethod("getCustomConstructorArgumentTypes", new Class[0]);
            classArray = (Class[])method.invoke(null, (Object[])null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return classArray;
    }

    private static int verifyConstructorArgumentTypes(Class<?>[] classArray, Object[] objectArray) {
        if (classArray.length != objectArray.length) {
            return -1;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (classArray[i].isInstance(objectArray[i])) continue;
            return i;
        }
        return objectArray.length;
    }

    private static String getArgsStrList(Object[] objectArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < objectArray.length; ++i) {
            stringBuilder.append(objectArray[i].getClass());
            if (i >= objectArray.length) continue;
            stringBuilder.append(COMMA);
        }
        return stringBuilder.toString();
    }

    private static String getTypeStrList(Class<?>[] classArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < classArray.length; ++i) {
            stringBuilder.append(classArray[i]);
            if (i >= classArray.length) continue;
            stringBuilder.append(COMMA);
        }
        return stringBuilder.toString();
    }

    public static String getThreadName() {
        return Display.getThreadName();
    }

    public static String toHexString(int n) {
        return Display.toHexString(n);
    }

    public static String toHexString(long l) {
        return Display.toHexString(l);
    }

    static {
        Debug.initSingleton();
        DEBUG_TEST_REPARENT_INCOMPATIBLE = PropertyAccess.isPropertyDefined((String)"newt.test.Window.reparent.incompatible", (boolean)true);
        DEBUG_FREEZE_AT_VISIBILITY_FAILURE = PropertyAccess.isPropertyDefined((String)"newt.debug.Window.visibility.failure.freeze", (boolean)true);
        ScreenImpl.initSingleton();
        windowList = new ArrayList();
        constMousePointerTypes = new MouseEvent.PointerType[]{MouseEvent.PointerType.Mouse};
        quirks = Bitfield.Factory.synchronize((Bitfield)Bitfield.Factory.create((int)32));
    }

    private class MonitorModeListenerImpl
    implements MonitorModeListener {
        boolean animatorPaused = false;
        boolean hidden = false;
        boolean hadFocus = false;
        boolean fullscreenPaused = false;
        List<MonitorDevice> _fullscreenMonitors = null;
        boolean _fullscreenUseMainMonitor = true;

        private MonitorModeListenerImpl() {
        }

        @Override
        public void monitorModeChangeNotify(MonitorEvent monitorEvent) {
            boolean bl;
            this.hadFocus = WindowImpl.this.hasFocus();
            boolean bl2 = WindowImpl.this.stateMask.get(11);
            boolean bl3 = ".macosx" == NativeWindowFactory.getNativeWindowType(true);
            boolean bl4 = bl2 && WindowImpl.this.isReconfigureMaskSupported(32768);
            boolean bl5 = bl = !bl4 && !bl2 && WindowImpl.this.isVisible() && bl3;
            if (Window.DEBUG_IMPLEMENTATION) {
                System.err.println("Window.monitorModeChangeNotify: hadFocus " + this.hadFocus + ", qFSPause " + bl4 + ", qHide " + bl + WindowImpl.COMMA + monitorEvent + " @ " + Thread.currentThread().getName());
            }
            if (null != WindowImpl.this.lifecycleHook) {
                this.animatorPaused = WindowImpl.this.lifecycleHook.pauseRenderingAction();
            }
            if (bl4) {
                if (Window.DEBUG_IMPLEMENTATION) {
                    System.err.println("Window.monitorModeChangeNotify: FS Pause");
                }
                this.fullscreenPaused = true;
                this._fullscreenMonitors = WindowImpl.this.fullscreenMonitors;
                this._fullscreenUseMainMonitor = WindowImpl.this.stateMask.get(31);
                WindowImpl.this.setFullscreenImpl(false, true, null);
            }
            if (bl) {
                this.hidden = true;
                WindowImpl.this.setVisible(false);
            }
        }

        @Override
        public void monitorModeChanged(MonitorEvent monitorEvent, boolean bl) {
            if (!this.animatorPaused && bl && null != WindowImpl.this.lifecycleHook) {
                this.animatorPaused = WindowImpl.this.lifecycleHook.pauseRenderingAction();
            }
            boolean bl2 = WindowImpl.this.stateMask.get(11);
            if (Window.DEBUG_IMPLEMENTATION) {
                System.err.println("Window.monitorModeChanged.0: success: " + bl + ", hadFocus " + this.hadFocus + ", animPaused " + this.animatorPaused + ", hidden " + this.hidden + ", FS " + bl2 + ", FS-paused " + this.fullscreenPaused + " @ " + Thread.currentThread().getName());
                System.err.println("Window.monitorModeChanged.0: " + WindowImpl.this.getScreen());
                System.err.println("Window.monitorModeChanged.0: " + monitorEvent);
            }
            WindowImpl.this.monitorModeChanged(monitorEvent, bl);
            if (bl && !bl2 && !this.fullscreenPaused) {
                RectangleImmutable rectangleImmutable = WindowImpl.this.screen.getViewportInWindowUnits();
                if (rectangleImmutable.getWidth() > 0 && rectangleImmutable.getHeight() > 0) {
                    Rectangle rectangle = new Rectangle(WindowImpl.this.getX(), WindowImpl.this.getY(), WindowImpl.this.getWidth(), WindowImpl.this.getHeight());
                    Rectangle rectangle2 = rectangleImmutable.intersection(rectangle);
                    if (WindowImpl.this.getHeight() > rectangle2.getHeight() || WindowImpl.this.getWidth() > rectangle2.getWidth()) {
                        if (Window.DEBUG_IMPLEMENTATION) {
                            System.err.println("Window.monitorModeChanged.1: Non-FS - Fit window " + rectangle + " into screen viewport " + rectangleImmutable + ", due to minimal intersection " + rectangle2);
                        }
                        WindowImpl.this.defineWindowPosition(rectangleImmutable.getX(), rectangleImmutable.getY());
                        WindowImpl.this.setSizeImpl(rectangleImmutable.getWidth(), rectangleImmutable.getHeight(), true, true);
                    }
                }
            } else if (this.fullscreenPaused) {
                if (Window.DEBUG_IMPLEMENTATION) {
                    System.err.println("Window.monitorModeChanged.2: FS Restore");
                }
                WindowImpl.this.setFullscreenImpl(true, this._fullscreenUseMainMonitor, this._fullscreenMonitors);
                this.fullscreenPaused = false;
                this._fullscreenMonitors = null;
                this._fullscreenUseMainMonitor = true;
            } else if (bl && bl2 && null != WindowImpl.this.fullscreenMonitors) {
                MonitorDevice monitorDevice = monitorEvent.getMonitor();
                if (WindowImpl.this.fullscreenMonitors.contains(monitorDevice)) {
                    Rectangle rectangle = new Rectangle();
                    MonitorDevice.unionOfViewports(null, rectangle, WindowImpl.this.fullscreenMonitors);
                    if (Window.DEBUG_IMPLEMENTATION) {
                        Rectangle rectangle3 = WindowImpl.this.getBounds();
                        System.err.println("Window.monitorModeChanged.3: FS Monitor Match: Fit window " + rectangle3 + " into new viewport union " + rectangle + " [window], provoked by " + monitorDevice);
                    }
                    WindowImpl.this.defineWindowPosition(rectangle.getX(), rectangle.getY());
                    WindowImpl.this.setSizeImpl(rectangle.getWidth(), rectangle.getHeight(), true, true);
                }
            }
            if (this.hidden) {
                WindowImpl.this.setVisible(true);
                this.hidden = false;
            }
            WindowImpl.this.sendWindowEvent(100);
            if (this.animatorPaused) {
                WindowImpl.this.lifecycleHook.resumeRenderingAction();
                this.animatorPaused = false;
            }
            if (this.hadFocus) {
                WindowImpl.this.requestFocus(true);
            }
            if (Window.DEBUG_IMPLEMENTATION) {
                System.err.println("Window.monitorModeChanged.X: @ " + Thread.currentThread().getName() + ", this: " + WindowImpl.this);
            }
        }
    }

    public static interface LifecycleHook {
        public void resetCounter();

        public void setVisibleActionPost(boolean var1, boolean var2);

        public void preserveGLStateAtDestroy(boolean var1);

        public void destroyActionPreLock();

        public void destroyActionInLock();

        public boolean pauseRenderingAction();

        public void resumeRenderingAction();

        public void shutdownRenderingAction();
    }

    private static class PointerState0 {
        boolean insideSurface = false;
        boolean exitSent = false;
        long lastButtonPressTime = 0L;
        boolean dragging = false;

        private PointerState0() {
        }

        void clearButton() {
            this.lastButtonPressTime = 0L;
        }

        public String toString() {
            return "PState0[inside " + this.insideSurface + ", exitSent " + this.exitSent + ", lastPress " + this.lastButtonPressTime + ", dragging " + this.dragging + "]";
        }
    }

    private static class PointerState1
    extends PointerState0 {
        short buttonPressed = 0;
        int buttonPressedMask = 0;
        short lastButtonClickCount = 0;
        final Point[] movePositions = new Point[]{new Point(), new Point(), new Point(), new Point(), new Point(), new Point(), new Point(), new Point()};

        private PointerState1() {
        }

        @Override
        final void clearButton() {
            super.clearButton();
            this.lastButtonClickCount = 0;
            if (!this.dragging || 0 == this.buttonPressedMask) {
                this.buttonPressed = 0;
                this.buttonPressedMask = 0;
                this.dragging = false;
            }
        }

        final Point getMovePosition(int n) {
            if (0 <= n && n < this.movePositions.length) {
                return this.movePositions[n];
            }
            return null;
        }

        @Override
        public final String toString() {
            return "PState1[inside " + this.insideSurface + ", exitSent " + this.exitSent + ", lastPress " + this.lastButtonPressTime + ", pressed [button " + this.buttonPressed + ", mask " + this.buttonPressedMask + ", dragging " + this.dragging + ", clickCount " + this.lastButtonClickCount + "]";
        }
    }

    private class FullScreenAction
    implements Runnable {
        boolean _fullscreen;

        private FullScreenAction() {
        }

        private boolean init(boolean bl) {
            if (WindowImpl.this.isNativeValid()) {
                if (!WindowImpl.this.isReconfigureMaskSupported(2048)) {
                    return false;
                }
                this._fullscreen = bl;
                return WindowImpl.this.isFullscreen() != bl;
            }
            WindowImpl.this.stateMask.put(11, bl);
            return false;
        }

        public boolean fsOn() {
            return this._fullscreen;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public final void run() {
            block40: {
                RecursiveLock recursiveLock = WindowImpl.this.windowLock;
                recursiveLock.lock();
                WindowImpl.this.blockInsetsChange = true;
                try {
                    int n;
                    NativeWindow nativeWindow;
                    void var7_14;
                    int n2;
                    boolean bl;
                    boolean bl2;
                    int n3;
                    int n4;
                    int n6;
                    Rectangle rectangle;
                    Object object;
                    int n7 = WindowImpl.this.getX();
                    int n8 = WindowImpl.this.getY();
                    int n9 = WindowImpl.this.getWidth();
                    int n10 = WindowImpl.this.getHeight();
                    RectangleImmutable rectangleImmutable = WindowImpl.this.screen.getViewportInWindowUnits();
                    if (this._fullscreen) {
                        if (null == WindowImpl.this.fullscreenMonitors) {
                            if (WindowImpl.this.stateMask.get(31)) {
                                WindowImpl.this.fullscreenMonitors = new ArrayList();
                                WindowImpl.this.fullscreenMonitors.add(WindowImpl.this.getMainMonitor());
                            } else {
                                WindowImpl.this.fullscreenMonitors = WindowImpl.this.getScreen().getMonitorDevices();
                            }
                        }
                        object = new Rectangle();
                        MonitorDevice.unionOfViewports(null, (Rectangle)object, WindowImpl.this.fullscreenMonitors);
                        rectangle = object;
                        if (WindowImpl.this.isReconfigureMaskSupported(32768) && (WindowImpl.this.fullscreenMonitors.size() > 1 || rectangleImmutable.compareTo(rectangle) > 0)) {
                            WindowImpl.this.stateMask.set(15);
                        } else {
                            WindowImpl.this.stateMask.clear(15);
                        }
                        WindowImpl.this.nfs_x = n7;
                        WindowImpl.this.nfs_y = n8;
                        WindowImpl.this.nfs_width = n9;
                        WindowImpl.this.nfs_height = n10;
                        WindowImpl.this.stateMaskNFS.put32(0, 32, WindowImpl.this.stateMask.get32(0, 32) & 0x720);
                        n6 = rectangle.getX();
                        int n5 = rectangle.getY();
                        n4 = rectangle.getWidth();
                        n3 = rectangle.getHeight();
                        WindowImpl.this.stateMask.clear(5);
                        WindowImpl.this.stateMask.set(8);
                        bl2 = WindowImpl.this.stateMaskNFS.get(5);
                        bl = !WindowImpl.this.stateMaskNFS.get(8);
                    } else {
                        WindowImpl.this.stateMask.set(31);
                        WindowImpl.this.fullscreenMonitors = null;
                        WindowImpl.this.stateMask.clear(15);
                        rectangle = null;
                        int n11 = WindowImpl.this.nfs_x;
                        int n5 = WindowImpl.this.nfs_y;
                        n2 = WindowImpl.this.nfs_width;
                        int n12 = WindowImpl.this.nfs_height;
                        bl2 = WindowImpl.this.stateMaskNFS.get(5) != WindowImpl.this.stateMask.get(5);
                        bl = WindowImpl.this.stateMaskNFS.get(8) != WindowImpl.this.stateMask.get(8);
                        WindowImpl.this.stateMask.put32(0, 32, WindowImpl.this.stateMaskNFS.get32(0, 32) | WindowImpl.this.stateMask.get32(0, 32) & 0xFFFFF8DF);
                        if (null != WindowImpl.this.parentWindow) {
                            n6 = 0;
                            boolean bl3 = false;
                            n4 = n2 > WindowImpl.this.parentWindow.getWidth() ? WindowImpl.this.parentWindow.getWidth() : n2;
                            n3 = n12 > WindowImpl.this.parentWindow.getHeight() ? WindowImpl.this.parentWindow.getHeight() : n12;
                        } else {
                            n6 = n11;
                            int n13 = n5;
                            n4 = n2;
                            n3 = n12;
                        }
                    }
                    object = (DisplayImpl)WindowImpl.this.screen.getDisplay();
                    ((DisplayImpl)object).dispatchMessagesNative();
                    boolean bl4 = WindowImpl.this.isVisible();
                    int n14 = n2 = !this._fullscreen && bl4 && ".x11" == NativeWindowFactory.getNativeWindowType(true) ? 1 : 0;
                    if (Window.DEBUG_IMPLEMENTATION) {
                        System.err.println("FullScreen.run.0: Window " + n6 + "/" + (int)var7_14 + " " + n4 + "x" + n3 + ", virtl-screenSize: " + rectangleImmutable + " [wu], monitorsViewport " + rectangle + " [wu], wasVisible " + bl4 + ", tempInvisible " + (n2 != 0) + ", hasParent " + (null != WindowImpl.this.parentWindow) + ", state " + WindowImpl.this.getStateMaskString() + " @ " + Thread.currentThread().getName());
                    }
                    if (n2 != 0) {
                        WindowImpl.this.setVisibleImpl(false, true, n7, n8, n9, n10);
                        WindowImpl.this.waitForVisible(false, false);
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        ((DisplayImpl)object).dispatchMessagesNative();
                    }
                    if (null != WindowImpl.this.parentWindow) {
                        nativeWindow = WindowImpl.this.parentWindow;
                        if (1 >= nativeWindow.lockSurface()) {
                            throw new NativeWindowException("Parent surface lock: not ready: " + WindowImpl.this.parentWindow);
                        }
                    } else {
                        nativeWindow = null;
                    }
                    try {
                        int n15 = 0;
                        if (bl2) {
                            n15 = 0x8000000;
                        }
                        if (bl) {
                            n15 |= 0x1000000;
                        }
                        n = n15;
                        if (this._fullscreen && 0 != n) {
                            WindowImpl.this.reconfigureWindowImpl(n7, n8, n9, n10, WindowImpl.this.getReconfigureMask(n, WindowImpl.this.isVisible()));
                        }
                        WindowImpl.this.stateMask.put(11, this._fullscreen);
                        WindowImpl.this.reconfigureWindowImpl(n6, (int)var7_14, n4, n3, WindowImpl.this.getReconfigureMask((null != nativeWindow ? 0x20000000 : 0) | 0x200000 | 0x10000000, WindowImpl.this.isVisible()));
                    }
                    finally {
                        if (null != nativeWindow) {
                            nativeWindow.unlockSurface();
                        }
                    }
                    ((DisplayImpl)object).dispatchMessagesNative();
                    if (bl4) {
                        boolean bl5;
                        if (".x11" == NativeWindowFactory.getNativeWindowType(true)) {
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            ((DisplayImpl)object).dispatchMessagesNative();
                        }
                        WindowImpl.this.setVisibleImpl(true, true, n6, (int)var7_14, n4, n3);
                        boolean bl6 = bl5 = 0L <= WindowImpl.this.waitForVisible(true, false);
                        if (bl5) {
                            bl5 = WindowImpl.this.waitForSize(n4, n3, false, 1000L);
                        }
                        if (bl5 && !this._fullscreen && null == WindowImpl.this.parentWindow) {
                            WindowImpl.this.waitForPosition(true, n6, (int)var7_14, 1000L);
                        }
                        if (bl5) {
                            if (!this._fullscreen && 0 != n) {
                                WindowImpl.this.reconfigureWindowImpl(n6, (int)var7_14, n4, n3, WindowImpl.this.getReconfigureMask(n, WindowImpl.this.isVisible()));
                            }
                            if (WindowImpl.this.isAlwaysOnBottom()) {
                                WindowImpl.this.reconfigureWindowImpl(n6, (int)var7_14, n4, n3, WindowImpl.this.getReconfigureMask(0x4000000, WindowImpl.this.isVisible()));
                            }
                            if (WindowImpl.this.isSticky()) {
                                WindowImpl.this.reconfigureWindowImpl(n6, (int)var7_14, n4, n3, WindowImpl.this.getReconfigureMask(0x2000000, WindowImpl.this.isVisible()));
                            }
                        }
                        if (bl5) {
                            WindowImpl.this.requestFocusInt(this._fullscreen);
                            ((DisplayImpl)object).dispatchMessagesNative();
                        }
                        if (Window.DEBUG_IMPLEMENTATION) {
                            System.err.println("FullScreen.run.X1: wasVisible, ok " + bl5 + ", Window " + WindowImpl.this);
                        }
                        break block40;
                    }
                    if (Window.DEBUG_IMPLEMENTATION) {
                        System.err.println("FullScreen.run.X2: !wasVisible, Window " + WindowImpl.this);
                    }
                }
                finally {
                    WindowImpl.this.blockInsetsChange = false;
                    recursiveLock.unlock();
                }
            }
            WindowImpl.this.sendWindowEvent(100);
        }
    }

    private class VisibleAction
    implements Runnable {
        boolean visible;

        private VisibleAction(boolean bl) {
            this.visible = bl;
        }

        @Override
        public final void run() {
            WindowImpl.this.setVisibleActionImpl(this.visible);
        }
    }

    private class SetSizeAction
    implements Runnable {
        int x;
        int y;
        boolean set_pos;
        int width;
        int height;
        boolean waitForSz;
        boolean force;

        private SetSizeAction(int n, int n2, boolean bl, int n3, int n4, boolean bl2, boolean bl3) {
            this.x = n;
            this.y = n2;
            this.set_pos = bl;
            this.width = n3;
            this.height = n4;
            this.waitForSz = bl2;
            this.force = bl3;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public final void run() {
            RecursiveLock recursiveLock = WindowImpl.this.windowLock;
            recursiveLock.lock();
            try {
                int n;
                boolean bl;
                if (!this.force) {
                    if (!WindowImpl.this.isReconfigureMaskSupported(256)) {
                        if (WindowImpl.this.isNativeValid()) return;
                    }
                    if (WindowImpl.this.isFullscreen()) return;
                    if (WindowImpl.this.getWidth() == this.width) {
                        if (WindowImpl.this.getHeight() == this.height) return;
                    }
                }
                if (Window.DEBUG_IMPLEMENTATION) {
                    System.err.println("Window setSize: START force " + this.force + WindowImpl.COMMA + WindowImpl.this.getWidth() + "x" + WindowImpl.this.getHeight() + " -> " + this.width + "x" + this.height + ", windowHandle " + WindowImpl.toHexString(WindowImpl.this.windowHandle) + ", state " + WindowImpl.this.getStateMaskString());
                }
                if ((bl = WindowImpl.this.isVisible()) && WindowImpl.this.isNativeValid() && (0 >= this.width || 0 >= this.height)) {
                    n = 1;
                    if (this.set_pos) {
                        WindowImpl.this.defineWindowPosition(this.x, this.y);
                    }
                    WindowImpl.this.defineWindowSize(0, 0);
                } else if (bl && !WindowImpl.this.isNativeValid() && 0 < this.width && 0 < this.height) {
                    n = 2;
                    if (this.set_pos) {
                        WindowImpl.this.defineWindowPosition(this.x, this.y);
                    }
                    WindowImpl.this.defineWindowSize(this.width, this.height);
                } else if (bl && WindowImpl.this.isNativeValid()) {
                    n = 0;
                    if (this.set_pos) {
                        WindowImpl.this.reconfigureWindowImpl(this.x, this.y, this.width, this.height, WindowImpl.this.getReconfigureMask(0, bl));
                    } else {
                        WindowImpl.this.reconfigureWindowImpl(WindowImpl.this.getX(), WindowImpl.this.getY(), this.width, this.height, WindowImpl.this.getReconfigureMask(0, bl));
                    }
                    if (this.waitForSz) {
                        WindowImpl.this.waitForSize(this.width, this.height, false, 1000L);
                    }
                } else {
                    n = 0;
                    if (this.set_pos) {
                        WindowImpl.this.defineWindowPosition(this.x, this.y);
                    }
                    WindowImpl.this.defineWindowSize(this.width, this.height);
                }
                if (Window.DEBUG_IMPLEMENTATION) {
                    System.err.println("Window setSize: END " + WindowImpl.this.getWidth() + "x" + WindowImpl.this.getHeight() + ", visibleAction " + n);
                }
                switch (n) {
                    case 1: {
                        WindowImpl.this.setVisibleActionImpl(false);
                        return;
                    }
                    case 2: {
                        WindowImpl.this.setVisibleActionImpl(true);
                        return;
                    }
                }
                return;
            }
            finally {
                recursiveLock.unlock();
            }
        }
    }

    private class ReparentAction
    implements Runnable {
        final NativeWindow newParentWindow;
        final int topLevelX;
        final int topLevelY;
        final int hints;
        Window.ReparentOperation operation;

        private ReparentAction(NativeWindow nativeWindow, int n, int n2, int n3) {
            this.newParentWindow = nativeWindow;
            this.topLevelX = n;
            this.topLevelY = n2;
            if (DEBUG_TEST_REPARENT_INCOMPATIBLE) {
                n3 |= 1;
            }
            this.hints = n3;
            this.operation = Window.ReparentOperation.ACTION_INVALID;
        }

        private Window.ReparentOperation getOp() {
            return this.operation;
        }

        @Override
        public final void run() {
            if (WindowImpl.this.isFullscreen()) {
                if (Window.DEBUG_IMPLEMENTATION) {
                    System.err.println("Window.reparent: NOP (in fullscreen, " + WindowImpl.getThreadName() + ") valid " + WindowImpl.this.isNativeValid() + ", windowHandle " + WindowImpl.toHexString(WindowImpl.this.windowHandle) + " parentWindowHandle " + WindowImpl.toHexString(WindowImpl.this.parentWindowHandle) + ", state " + WindowImpl.this.getStateMaskString());
                }
                return;
            }
            boolean bl = false;
            if (null != WindowImpl.this.lifecycleHook) {
                bl = WindowImpl.this.lifecycleHook.pauseRenderingAction();
            }
            this.reparent();
            if (bl) {
                WindowImpl.this.lifecycleHook.resumeRenderingAction();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void reparent() {
            boolean bl;
            int n = WindowImpl.this.getX();
            int n2 = WindowImpl.this.getY();
            int n3 = WindowImpl.this.getWidth();
            int n4 = WindowImpl.this.getHeight();
            int n5 = n3;
            int n6 = n4;
            RecursiveLock recursiveLock = WindowImpl.this.windowLock;
            recursiveLock.lock();
            try {
                Object object;
                int n7;
                int n8;
                boolean bl2;
                boolean bl3 = bl2 = 0 != (1 & this.hints);
                if (WindowImpl.this.isNativeValid()) {
                    bl2 |= WindowImpl.isOffscreenInstance(WindowImpl.this, this.newParentWindow);
                }
                boolean bl4 = bl2;
                bl = WindowImpl.this.isVisible();
                boolean bl5 = bl || 0 != (2 & this.hints);
                Window window = null;
                if (this.newParentWindow instanceof Window) {
                    window = (Window)this.newParentWindow;
                }
                long l = 0L;
                if (Window.DEBUG_IMPLEMENTATION) {
                    System.err.println("Window.reparent: START (" + WindowImpl.getThreadName() + ") valid " + WindowImpl.this.isNativeValid() + ", windowHandle " + WindowImpl.toHexString(WindowImpl.this.windowHandle) + " parentWindowHandle " + WindowImpl.toHexString(WindowImpl.this.parentWindowHandle) + ", state " + WindowImpl.this.getStateMaskString() + " -> visible " + bl5 + ", forceDestroyCreate " + bl4 + ", DEBUG_TEST_REPARENT_INCOMPATIBLE " + DEBUG_TEST_REPARENT_INCOMPATIBLE + ", HINT_FORCE_RECREATION " + (0 != (1 & this.hints)) + ", HINT_BECOMES_VISIBLE " + (0 != (2 & this.hints)) + ", old parentWindow: " + Display.hashCodeNullSafe(WindowImpl.this.parentWindow) + ", new parentWindow: " + Display.hashCodeNullSafe(this.newParentWindow));
                }
                if (null != this.newParentWindow) {
                    n8 = 0;
                    n7 = 0;
                    if (n5 > this.newParentWindow.getWidth()) {
                        n5 = this.newParentWindow.getWidth();
                    }
                    if (n6 > this.newParentWindow.getHeight()) {
                        n6 = this.newParentWindow.getHeight();
                    }
                    if (0L == (l = WindowImpl.getNativeWindowHandle(this.newParentWindow))) {
                        if (null == window) {
                            throw new NativeWindowException("Reparenting with non NEWT Window type only available after it's realized: " + this.newParentWindow);
                        }
                        WindowImpl.this.destroy(bl5);
                        WindowImpl.this.setScreen((ScreenImpl)window.getScreen());
                        this.operation = Window.ReparentOperation.ACTION_NATIVE_CREATION_PENDING;
                    } else if (this.newParentWindow != WindowImpl.this.getParent()) {
                        if (!WindowImpl.this.isNativeValid()) {
                            if (null != window) {
                                WindowImpl.this.setScreen((ScreenImpl)window.getScreen());
                            } else {
                                object = NewtFactory.createCompatibleScreen(this.newParentWindow, WindowImpl.this.screen);
                                if (WindowImpl.this.screen != object) {
                                    WindowImpl.this.setScreen((ScreenImpl)object);
                                }
                            }
                            this.operation = 0 < n5 && 0 < n6 ? Window.ReparentOperation.ACTION_NATIVE_CREATION : Window.ReparentOperation.ACTION_NATIVE_CREATION_PENDING;
                        } else if (bl4 || !NewtFactory.isScreenCompatible(this.newParentWindow, WindowImpl.this.screen)) {
                            WindowImpl.this.destroy(bl5);
                            if (null != window) {
                                WindowImpl.this.setScreen((ScreenImpl)window.getScreen());
                            } else {
                                WindowImpl.this.setScreen((ScreenImpl)NewtFactory.createCompatibleScreen(this.newParentWindow, WindowImpl.this.screen));
                            }
                            this.operation = Window.ReparentOperation.ACTION_NATIVE_CREATION;
                        } else {
                            this.operation = Window.ReparentOperation.ACTION_NATIVE_REPARENTING;
                        }
                    } else {
                        this.operation = Window.ReparentOperation.ACTION_NOP;
                    }
                } else {
                    if (0 <= this.topLevelX && 0 <= this.topLevelY) {
                        n8 = this.topLevelX;
                        n7 = this.topLevelY;
                    } else if (null != WindowImpl.this.parentWindow) {
                        object = WindowImpl.this.getLocationOnScreen(null);
                        n8 = ((Point)object).getX();
                        n7 = ((Point)object).getY();
                    } else {
                        n8 = n;
                        n7 = n2;
                    }
                    if (0L == WindowImpl.this.parentWindowHandle) {
                        this.operation = Window.ReparentOperation.ACTION_NOP;
                    } else if (!WindowImpl.this.isNativeValid() || bl4) {
                        WindowImpl.this.destroy(bl5);
                        this.operation = 0 < n5 && 0 < n6 ? Window.ReparentOperation.ACTION_NATIVE_CREATION : Window.ReparentOperation.ACTION_NATIVE_CREATION_PENDING;
                    } else {
                        this.operation = Window.ReparentOperation.ACTION_NATIVE_REPARENTING;
                    }
                }
                WindowImpl.this.parentWindowHandle = l;
                if (Window.ReparentOperation.ACTION_INVALID == this.operation) {
                    throw new NativeWindowException("Internal Error: reparentAction not set");
                }
                if (Window.DEBUG_IMPLEMENTATION) {
                    System.err.println("Window.reparent: ACTION (" + WindowImpl.getThreadName() + ") windowHandle " + WindowImpl.toHexString(WindowImpl.this.windowHandle) + " new parentWindowHandle " + WindowImpl.toHexString(l) + ", reparentAction " + (Object)((Object)this.operation) + ", pos/size " + n8 + "/" + n7 + " " + n5 + "x" + n6 + ", visible " + bl);
                }
                if (Window.ReparentOperation.ACTION_NOP == this.operation) {
                    return;
                }
                if (null == this.newParentWindow) {
                    WindowImpl.this.setOffscreenPointerIcon(null);
                    WindowImpl.this.setOffscreenPointerVisible(true, null);
                }
                if (null != WindowImpl.this.parentWindow && WindowImpl.this.parentWindow instanceof Window) {
                    ((Window)WindowImpl.this.parentWindow).removeChild(WindowImpl.this);
                }
                WindowImpl.this.parentWindow = this.newParentWindow;
                WindowImpl.this.stateMask.put(2, null != WindowImpl.this.parentWindow);
                if (WindowImpl.this.parentWindow instanceof Window) {
                    ((Window)WindowImpl.this.parentWindow).addChild(WindowImpl.this);
                }
                if (Window.ReparentOperation.ACTION_NATIVE_REPARENTING == this.operation) {
                    NativeWindow nativeWindow;
                    object = (DisplayImpl)WindowImpl.this.screen.getDisplay();
                    ((DisplayImpl)object).dispatchMessagesNative();
                    if (null != WindowImpl.this.parentWindow && bl && ".x11" == NativeWindowFactory.getNativeWindowType(true)) {
                        WindowImpl.this.setVisibleImpl(false, true, n, n2, n3, n4);
                        WindowImpl.this.waitForVisible(false, false);
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        ((DisplayImpl)object).dispatchMessagesNative();
                    }
                    if (null != WindowImpl.this.parentWindow) {
                        nativeWindow = WindowImpl.this.parentWindow;
                        if (1 >= nativeWindow.lockSurface()) {
                            throw new NativeWindowException("Parent surface lock: not ready: " + nativeWindow);
                        }
                        WindowImpl.this.parentWindowHandle = nativeWindow.getWindowHandle();
                    } else {
                        nativeWindow = null;
                    }
                    boolean bl6 = false;
                    try {
                        bl6 = WindowImpl.this.reconfigureWindowImpl(n8, n7, n5, n6, WindowImpl.this.getReconfigureMask(0x30000000, WindowImpl.this.isVisible()));
                    }
                    finally {
                        if (null != nativeWindow) {
                            nativeWindow.unlockSurface();
                        }
                    }
                    WindowImpl.this.defineWindowPosition(n8, n7);
                    if (bl6) {
                        ((DisplayImpl)object).dispatchMessagesNative();
                        if (bl) {
                            WindowImpl.this.setVisibleImpl(true, true, n8, n7, n5, n6);
                            boolean bl7 = bl6 = 0L <= WindowImpl.this.waitForVisible(true, false);
                            if (bl6) {
                                if (WindowImpl.this.isAlwaysOnTop() && 0L == WindowImpl.this.parentWindowHandle && ".x11" == NativeWindowFactory.getNativeWindowType(true)) {
                                    WindowImpl.this.reconfigureWindowImpl(n8, n7, n5, n6, WindowImpl.this.getReconfigureMask(0x8000000, WindowImpl.this.isVisible()));
                                }
                                bl6 = WindowImpl.this.waitForSize(n5, n6, false, 1000L);
                            }
                            if (bl6) {
                                if (0L == WindowImpl.this.parentWindowHandle) {
                                    WindowImpl.this.waitForPosition(true, n8, n7, 1000L);
                                }
                                WindowImpl.this.requestFocusInt(0L == WindowImpl.this.parentWindowHandle);
                                ((DisplayImpl)object).dispatchMessagesNative();
                            }
                        }
                    }
                    if (!bl6 || !bl) {
                        WindowImpl.this.defineWindowPosition(n8, n7);
                        WindowImpl.this.defineWindowSize(n5, n6);
                    }
                    if (!bl6) {
                        if (Window.DEBUG_IMPLEMENTATION) {
                            System.err.println("Window.reparent: native reparenting failed (" + WindowImpl.getThreadName() + ") windowHandle " + WindowImpl.toHexString(WindowImpl.this.windowHandle) + " parentWindowHandle " + WindowImpl.toHexString(WindowImpl.this.parentWindowHandle) + " -> " + WindowImpl.toHexString(l) + " - Trying recreation");
                        }
                        WindowImpl.this.destroy(bl5);
                        this.operation = Window.ReparentOperation.ACTION_NATIVE_CREATION;
                    } else if (null != WindowImpl.this.parentWindow) {
                        WindowImpl.this.setOffscreenPointerIcon(WindowImpl.this.pointerIcon);
                        WindowImpl.this.setOffscreenPointerVisible(WindowImpl.this.stateMask.get(12), WindowImpl.this.pointerIcon);
                    }
                } else {
                    WindowImpl.this.defineWindowPosition(n8, n7);
                    WindowImpl.this.defineWindowSize(n5, n6);
                }
                if (Window.DEBUG_IMPLEMENTATION) {
                    System.err.println("Window.reparent: END-1 (" + WindowImpl.getThreadName() + ") state " + WindowImpl.this.getStateMaskString() + ", windowHandle " + WindowImpl.toHexString(WindowImpl.this.windowHandle) + ", parentWindowHandle " + WindowImpl.toHexString(WindowImpl.this.parentWindowHandle) + ", parentWindow " + Display.hashCodeNullSafe(WindowImpl.this.parentWindow) + " " + WindowImpl.this.getX() + "/" + WindowImpl.this.getY() + " " + WindowImpl.this.getWidth() + "x" + WindowImpl.this.getHeight());
                }
            }
            finally {
                if (null != WindowImpl.this.lifecycleHook) {
                    WindowImpl.this.lifecycleHook.resetCounter();
                }
                recursiveLock.unlock();
            }
            if (bl) {
                switch (this.operation) {
                    case ACTION_NATIVE_REPARENTING: {
                        WindowImpl.this.sendWindowEvent(100);
                        break;
                    }
                    case ACTION_NATIVE_CREATION: {
                        WindowImpl.this.runOnEDTIfAvail(true, WindowImpl.this.reparentActionRecreate);
                        break;
                    }
                }
            }
            if (Window.DEBUG_IMPLEMENTATION) {
                System.err.println("Window.reparent: END-X (" + WindowImpl.getThreadName() + ") state " + WindowImpl.this.getStateMaskString() + ", windowHandle " + WindowImpl.toHexString(WindowImpl.this.windowHandle) + ", parentWindowHandle " + WindowImpl.toHexString(WindowImpl.this.parentWindowHandle) + ", parentWindow " + Display.hashCodeNullSafe(WindowImpl.this.parentWindow) + " " + WindowImpl.this.getX() + "/" + WindowImpl.this.getY() + " " + WindowImpl.this.getWidth() + "x" + WindowImpl.this.getHeight());
            }
        }
    }

    private class DecorationAction
    implements Runnable {
        boolean undecorated;

        private DecorationAction(boolean bl) {
            this.undecorated = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            RecursiveLock recursiveLock = WindowImpl.this.windowLock;
            recursiveLock.lock();
            try {
                if (WindowImpl.this.stateMask.put(4, this.undecorated) != this.undecorated && WindowImpl.this.isNativeValid() && !WindowImpl.this.isFullscreen()) {
                    int n = WindowImpl.this.getX();
                    int n2 = WindowImpl.this.getY();
                    int n3 = WindowImpl.this.getWidth();
                    int n4 = WindowImpl.this.getHeight();
                    DisplayImpl displayImpl = (DisplayImpl)WindowImpl.this.screen.getDisplay();
                    displayImpl.dispatchMessagesNative();
                    WindowImpl.this.reconfigureWindowImpl(n, n2, n3, n4, WindowImpl.this.getReconfigureMask(0x10000000, WindowImpl.this.isVisible()));
                    displayImpl.dispatchMessagesNative();
                }
            }
            finally {
                recursiveLock.unlock();
            }
            WindowImpl.this.sendWindowEvent(100);
        }
    }

    private class AlwaysOnTopAction
    implements Runnable {
        boolean alwaysOnTop;

        private AlwaysOnTopAction(boolean bl) {
            this.alwaysOnTop = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            RecursiveLock recursiveLock = WindowImpl.this.windowLock;
            recursiveLock.lock();
            try {
                if (WindowImpl.this.stateMask.put(5, this.alwaysOnTop) != this.alwaysOnTop && WindowImpl.this.isNativeValid() && !WindowImpl.this.isFullscreen()) {
                    int n = WindowImpl.this.getX();
                    int n2 = WindowImpl.this.getY();
                    int n3 = WindowImpl.this.getWidth();
                    int n4 = WindowImpl.this.getHeight();
                    DisplayImpl displayImpl = (DisplayImpl)WindowImpl.this.screen.getDisplay();
                    displayImpl.dispatchMessagesNative();
                    WindowImpl.this.reconfigureWindowImpl(n, n2, n3, n4, WindowImpl.this.getReconfigureMask(0x8000000, WindowImpl.this.isVisible()));
                    displayImpl.dispatchMessagesNative();
                }
            }
            finally {
                recursiveLock.unlock();
            }
            WindowImpl.this.sendWindowEvent(100);
        }
    }

    private class AlwaysOnBottomAction
    implements Runnable {
        boolean alwaysOnBottom;

        private AlwaysOnBottomAction(boolean bl) {
            this.alwaysOnBottom = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            RecursiveLock recursiveLock = WindowImpl.this.windowLock;
            recursiveLock.lock();
            try {
                if (WindowImpl.this.stateMask.put(6, this.alwaysOnBottom) != this.alwaysOnBottom && WindowImpl.this.isNativeValid()) {
                    int n = WindowImpl.this.getX();
                    int n2 = WindowImpl.this.getY();
                    int n3 = WindowImpl.this.getWidth();
                    int n4 = WindowImpl.this.getHeight();
                    DisplayImpl displayImpl = (DisplayImpl)WindowImpl.this.screen.getDisplay();
                    displayImpl.dispatchMessagesNative();
                    WindowImpl.this.reconfigureWindowImpl(n, n2, n3, n4, WindowImpl.this.getReconfigureMask(0x4000000, WindowImpl.this.isVisible()));
                    displayImpl.dispatchMessagesNative();
                }
            }
            finally {
                recursiveLock.unlock();
            }
            WindowImpl.this.sendWindowEvent(100);
        }
    }

    private class ResizableAction
    implements Runnable {
        boolean resizable;

        private ResizableAction(boolean bl) {
            this.resizable = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            RecursiveLock recursiveLock = WindowImpl.this.windowLock;
            recursiveLock.lock();
            try {
                if (WindowImpl.this.stateMask.put(8, this.resizable) != this.resizable && WindowImpl.this.isNativeValid()) {
                    int n = WindowImpl.this.getX();
                    int n2 = WindowImpl.this.getY();
                    int n3 = WindowImpl.this.getWidth();
                    int n4 = WindowImpl.this.getHeight();
                    DisplayImpl displayImpl = (DisplayImpl)WindowImpl.this.screen.getDisplay();
                    displayImpl.dispatchMessagesNative();
                    WindowImpl.this.reconfigureWindowImpl(n, n2, n3, n4, WindowImpl.this.getReconfigureMask(0x1000000, WindowImpl.this.isVisible()));
                    displayImpl.dispatchMessagesNative();
                }
            }
            finally {
                recursiveLock.unlock();
            }
            WindowImpl.this.sendWindowEvent(100);
        }
    }

    private class StickyAction
    implements Runnable {
        boolean sticky;

        private StickyAction(boolean bl) {
            this.sticky = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            RecursiveLock recursiveLock = WindowImpl.this.windowLock;
            recursiveLock.lock();
            try {
                if (WindowImpl.this.stateMask.put(7, this.sticky) != this.sticky && WindowImpl.this.isNativeValid()) {
                    int n = WindowImpl.this.getX();
                    int n2 = WindowImpl.this.getY();
                    int n3 = WindowImpl.this.getWidth();
                    int n4 = WindowImpl.this.getHeight();
                    DisplayImpl displayImpl = (DisplayImpl)WindowImpl.this.screen.getDisplay();
                    displayImpl.dispatchMessagesNative();
                    WindowImpl.this.reconfigureWindowImpl(n, n2, n3, n4, WindowImpl.this.getReconfigureMask(0x2000000, WindowImpl.this.isVisible()));
                    displayImpl.dispatchMessagesNative();
                }
            }
            finally {
                recursiveLock.unlock();
            }
            WindowImpl.this.sendWindowEvent(100);
        }
    }

    private class MaximizeAction
    implements Runnable {
        boolean horz;
        boolean vert;

        private MaximizeAction(boolean bl, boolean bl2) {
            this.horz = bl;
            this.vert = bl2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            RecursiveLock recursiveLock = WindowImpl.this.windowLock;
            recursiveLock.lock();
            try {
                int n = 0;
                if (WindowImpl.this.stateMask.put(9, this.vert) != this.vert) {
                    n |= 0x800000;
                }
                if (WindowImpl.this.stateMask.put(10, this.horz) != this.horz) {
                    n |= 0x400000;
                }
                if (0 != n && WindowImpl.this.isNativeValid()) {
                    boolean bl = WindowImpl.this.hasFocus();
                    int n2 = WindowImpl.this.getX();
                    int n3 = WindowImpl.this.getY();
                    int n4 = WindowImpl.this.getWidth();
                    int n5 = WindowImpl.this.getHeight();
                    DisplayImpl displayImpl = (DisplayImpl)WindowImpl.this.screen.getDisplay();
                    displayImpl.dispatchMessagesNative();
                    WindowImpl.this.reconfigureWindowImpl(n2, n3, n4, n5, WindowImpl.this.getReconfigureMask(n, WindowImpl.this.isVisible()));
                    displayImpl.dispatchMessagesNative();
                    if (bl) {
                        WindowImpl.this.requestFocusInt(0L == WindowImpl.this.parentWindowHandle);
                    }
                }
            }
            finally {
                recursiveLock.unlock();
            }
            WindowImpl.this.sendWindowEvent(100);
        }
    }

    private class SetPositionAction
    implements Runnable {
        int x;
        int y;
        boolean waitForPos;
        boolean force;

        private SetPositionAction(int n, int n2, boolean bl, boolean bl2) {
            this.x = n;
            this.y = n2;
            this.waitForPos = bl;
            this.force = bl2;
        }

        @Override
        public final void run() {
            RecursiveLock recursiveLock = WindowImpl.this.windowLock;
            recursiveLock.lock();
            try {
                if (Window.DEBUG_IMPLEMENTATION) {
                    System.err.println("Window setPosition: " + WindowImpl.this.getX() + "/" + WindowImpl.this.getY() + " -> " + this.x + "/" + this.y + ", fs " + WindowImpl.this.stateMask.get(11) + ", windowHandle " + WindowImpl.toHexString(WindowImpl.this.windowHandle));
                }
                if (!(!WindowImpl.this.isReconfigureMaskSupported(16384) && WindowImpl.this.isNativeValid() || WindowImpl.this.isFullscreen() || !this.force && WindowImpl.this.getX() == this.x && WindowImpl.this.getY() == this.y)) {
                    if (WindowImpl.this.isNativeValid()) {
                        WindowImpl.this.reconfigureWindowImpl(this.x, this.y, WindowImpl.this.getWidth(), WindowImpl.this.getHeight(), WindowImpl.this.getReconfigureMask(0, WindowImpl.this.isVisible()));
                        if (null == WindowImpl.this.parentWindow && this.waitForPos) {
                            WindowImpl.this.waitForPosition(true, this.x, this.y, 1000L);
                        }
                    } else {
                        WindowImpl.this.defineWindowPosition(this.x, this.y);
                    }
                }
            }
            finally {
                recursiveLock.unlock();
            }
        }
    }
}

