/*
 * Decompiled with CFR 0.152.
 */
package aigis.gl;

import aigis.Logger;
import aigis.model.CameraInfo;
import aigis.model.Model;
import aigis.model.Models;
import aigis.model.loader.FastReader;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.glu.GLU;
import com.jogamp.opengl.util.awt.ImageUtil;
import com.jogamp.opengl.util.texture.Texture;
import com.jogamp.opengl.util.texture.TextureIO;
import com.jogamp.opengl.util.texture.awt.AWTTextureIO;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;
import java.io.File;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import nom.tam.fits.BasicHDU;
import nom.tam.fits.Fits;
import nom.tam.fits.ImageHDU;

public class Textures {
    private static GLU glu = new GLU();
    private static final int TEXSIZE = 1024;
    private static final int DEPTH_SIZE = 512;
    private ArrayList<Setting> texs = new ArrayList();
    private LinkedList<Integer> uvs = new LinkedList();
    private int maxTex = 0;

    public Textures(GL2 gL2) {
        int[] nArray = new int[1];
        gL2.glGetIntegerv(34018, nArray, 0);
        this.maxTex = nArray[0];
        Logger.Debug("MaxTextureUnits: " + this.maxTex);
        gL2.glGetIntegerv(3379, nArray, 0);
        Logger.Debug("MaxTextureSize: " + nArray[0]);
        Logger.Debug("isNPOTTextureAvailable: " + (gL2.isNPOTTextureAvailable() ? "true" : "false"));
        TextureIO.setTexRectEnabled((boolean)false);
        Logger.Debug("isTexRectEnabled: " + (TextureIO.isTexRectEnabled() ? "true" : "false"));
        boolean bl = gL2.isExtensionAvailable("GL_ARB_texture_non_power_of_two");
        Logger.Debug("GL_ARB_texture_non_power_of_two: " + (bl ? "true" : "false"));
        if (!bl) {
            JOptionPane.showMessageDialog(null, "'GL_ARB_texture_non_power_of_two' is not available. \n", "Error", 0);
            System.exit(1);
            return;
        }
        for (int i = 1; i < this.maxTex; ++i) {
            this.uvs.offer(i);
        }
    }

    public ArrayList<Setting> getTexsInfo() {
        return this.texs;
    }

    public boolean canAddTexture() {
        return this.texs.size() < this.maxTex - 1;
    }

    public void addTexture(File file, File file2, int n, int n2) throws Exception {
        Setting setting = new Setting();
        setting.imageFile = file;
        setting.infoFile = file2;
        setting.rotate = n;
        setting.flip = n2;
        if (file2 != null) {
            String string = file2.getPath();
            if (string.toLowerCase().endsWith(".sum")) {
                String string2;
                CameraInfo cameraInfo = new CameraInfo();
                FastReader fastReader = new FastReader(string);
                int[] nArray = null;
                float f = 0.0f;
                while ((string2 = fastReader.nextString()) != null) {
                    float f2;
                    if ((string2 = string2.toUpperCase()).contains(":") && string2.contains(".")) {
                        int n3 = fastReader.nextInt();
                        int n4 = fastReader.nextInt();
                        nArray = new int[]{n3, n4};
                    }
                    if (string2.equals("THRSH")) {
                        f = fastReader.nextFloat();
                    }
                    if (string2.equals("CTR")) {
                        float f3 = fastReader.nextFloat() * -1.0f;
                        float f4 = fastReader.nextFloat() * -1.0f;
                        f2 = fastReader.nextFloat() * -1.0f;
                        cameraInfo.position.set((double)f3, (double)f4, (double)f2);
                    }
                    if (string2.equals("SCOBJ")) {
                        float f5 = fastReader.nextFloat();
                        float f6 = fastReader.nextFloat();
                        f2 = fastReader.nextFloat();
                        cameraInfo.up.set((double)f5, (double)f6, (double)f2);
                    }
                    if (string2.equals("CY")) {
                        float f7 = fastReader.nextFloat();
                        float f8 = fastReader.nextFloat();
                        f2 = fastReader.nextFloat();
                        cameraInfo.direction.set((double)f7, (double)f8, (double)f2);
                    }
                    if (!string2.equals("SZ")) continue;
                    if (nArray == null || f == 0.0f) {
                        fastReader.close();
                        throw new RuntimeException("data format is incorrect");
                    }
                    fastReader.nextFloat();
                    fastReader.nextFloat();
                    fastReader.nextFloat();
                    fastReader.nextFloat();
                    float f9 = fastReader.nextFloat();
                    cameraInfo.fov = 2.0 * Math.atan(1.0f / f9 * (float)nArray[1] / (2.0f * f));
                    setting.info = cameraInfo;
                    break;
                }
                fastReader.close();
            } else {
                setting.info = CameraInfo.loadFromInfo(string);
            }
        }
        this.texs.add(setting);
    }

    public void removeTexture(int n) {
        Setting setting = this.texs.get(n);
        setting.removeFlg = true;
        if (setting.uvIndex != null && !this.uvs.contains(setting.uvIndex)) {
            this.uvs.offerFirst(setting.uvIndex);
        }
    }

    public void clearTextures() {
        for (int i = 0; i < this.texs.size(); ++i) {
            this.removeTexture(i);
        }
    }

    public void activate(int n, int n2, boolean bl) {
        Setting setting = this.texs.get(n);
        setting.active[n2] = bl;
        if (bl && setting.tex == null) {
            setting.needReloadTex = true;
        }
    }

    public void upOrder(int n) {
        Collections.swap(this.texs, n, n - 1);
    }

    public void bind(GL2 gL2, Model model, int n) {
        for (int i = 0; i < this.texs.size(); ++i) {
            Setting setting = this.texs.get(i);
            if (setting.tex == null) continue;
            int n2 = i + 1;
            gL2.glActiveTexture(33984 + n2);
            if (!setting.active[n]) {
                setting.tex.disable((GL)gL2);
                gL2.glActiveTexture(33984);
                continue;
            }
            setting.tex.bind((GL)gL2);
            setting.tex.enable((GL)gL2);
            gL2.glTexEnvi(8960, 8704, 8449);
            gL2.glClientActiveTexture(33984 + n2);
            gL2.glEnableClientState(32888);
            if (setting.infoFile == null) {
                gL2.glBindBuffer(34962, model.getVboId(3));
            } else {
                gL2.glBindBuffer(34962, model.getVboId(3 + setting.uvIndex));
            }
            gL2.glTexCoordPointer(2, 5126, 0, 0L);
        }
    }

    public void unbind(GL2 gL2) {
        for (int i = 0; i < this.texs.size(); ++i) {
            Setting setting = this.texs.get(i);
            if (setting.tex == null) continue;
            gL2.glActiveTexture(33984 + i + 1);
            setting.tex.disable((GL)gL2);
        }
        gL2.glActiveTexture(33984);
        gL2.glClientActiveTexture(33984);
    }

    public void initTexture(GL2 gL2, Models models) throws Exception {
        Iterator<Setting> iterator = this.texs.iterator();
        while (iterator.hasNext()) {
            Setting setting = iterator.next();
            if (setting.removeFlg) {
                if (setting.tex != null) {
                    setting.tex.destroy((GL)gL2);
                    setting.tex = null;
                }
                iterator.remove();
                continue;
            }
            if (!setting.active[0] && !setting.active[1] && !setting.active[2] && !setting.active[3]) continue;
            this.initTexture(gL2, models, setting);
        }
    }

    private void initTexture(GL2 gL2, Models models, Setting setting) throws Exception {
        if (!setting.needReloadTex) {
            return;
        }
        int n = gL2.glGetError();
        if (n != 0) {
            throw new Exception("gl error: " + n);
        }
        try {
            String string = setting.imageFile.getName().toLowerCase();
            boolean bl = string.endsWith(".fit") || string.endsWith(".fits");
            BufferedImage bufferedImage = bl ? this.loadFits(setting.imageFile) : ImageIO.read(setting.imageFile);
            if (setting.rotate > 0) {
                bufferedImage = this.rotateImage(setting.rotate, bufferedImage);
            }
            if (setting.flip > 0) {
                bufferedImage = this.flipImage(setting.flip, bufferedImage);
            }
            setting.img = bufferedImage;
            if (setting.infoFile == null) {
                ColorModel colorModel = bufferedImage.getColorModel();
                boolean bl2 = colorModel.isAlphaPremultiplied();
                WritableRaster writableRaster = bufferedImage.copyData(null);
                BufferedImage bufferedImage2 = new BufferedImage(colorModel, writableRaster, bl2, null);
                setting.img = bufferedImage2;
                ImageUtil.flipImageVertically((BufferedImage)bufferedImage);
                setting.tex = AWTTextureIO.newTexture((GLProfile)gL2.getGLProfile(), (BufferedImage)bufferedImage, (boolean)true);
                setting.tex.setTexParameteri((GL)gL2, 10242, 10497);
                setting.tex.setTexParameteri((GL)gL2, 10243, 10497);
            } else {
                int n2 = bufferedImage.getHeight();
                int n3 = bufferedImage.getWidth();
                int n4 = 1022;
                int n5 = (int)((double)n3 / (double)n2 * (double)n4);
                Image image = bufferedImage.getScaledInstance(n5, n4, 4);
                BufferedImage bufferedImage3 = new BufferedImage(1024, 1024, 2);
                Graphics2D graphics2D = bufferedImage3.createGraphics();
                int n6 = n4 / 2 - n5 / 2;
                graphics2D.drawImage(image, 1 + n6, 1, null);
                graphics2D.dispose();
                bufferedImage3.flush();
                ImageUtil.flipImageVertically((BufferedImage)bufferedImage3);
                gL2.glActiveTexture(33984 + this.texs.size());
                setting.tex = AWTTextureIO.newTexture((GLProfile)gL2.getGLProfile(), (BufferedImage)bufferedImage3, (boolean)true);
                setting.uvIndex = this.uvs.poll();
                for (Model model : models.getAllModels()) {
                    this.makeUV(gL2, model, setting);
                }
            }
            gL2.glEnable(3553);
            setting.tex.setTexParameteri((GL)gL2, 10241, 9729);
            setting.tex.setTexParameteri((GL)gL2, 10240, 9729);
        }
        catch (Exception exception) {
            setting.tex = null;
            setting.needReloadTex = false;
            if (setting.uvIndex != null && !this.uvs.contains(setting.uvIndex)) {
                this.uvs.offerFirst(setting.uvIndex);
            }
            this.texs.remove(setting);
            throw exception;
        }
        gL2.glActiveTexture(33984);
        setting.needReloadTex = false;
        n = gL2.glGetError();
        if (n != 0) {
            throw new Exception("gl error: " + n);
        }
    }

    private BufferedImage rotateImage(int n, BufferedImage bufferedImage) {
        double d = Math.toRadians(n);
        double d2 = Math.abs(Math.sin(d));
        double d3 = Math.abs(Math.cos(d));
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        int n4 = (int)Math.floor((double)n2 * d3 + (double)n3 * d2);
        int n5 = (int)Math.floor((double)n3 * d3 + (double)n2 * d2);
        BufferedImage bufferedImage2 = new BufferedImage(n4, n5, 2);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate((n4 - n2) / 2, (n5 - n3) / 2);
        int n6 = n2 / 2;
        int n7 = n3 / 2;
        affineTransform.rotate(d, n6, n7);
        graphics2D.setTransform(affineTransform);
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        graphics2D.dispose();
        return bufferedImage2;
    }

    private BufferedImage flipImage(int n, BufferedImage bufferedImage) {
        double d;
        double d2;
        int n2 = 1;
        if (n == 1) {
            d2 = 0.0;
            d = -bufferedImage.getHeight(null);
        } else {
            n2 = -1;
            d2 = -bufferedImage.getWidth(null);
            d = 0.0;
        }
        AffineTransform affineTransform = AffineTransform.getScaleInstance(n2, -n2);
        affineTransform.translate(d2, d);
        AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, 2);
        return affineTransformOp.filter(bufferedImage, null);
    }

    private BufferedImage loadFits(File file) throws Exception {
        Fits fits = new Fits(file);
        fits.read();
        for (int i = 0; i < fits.getNumberOfHDUs(); ++i) {
            Object object;
            int[] nArray;
            BasicHDU basicHDU = fits.getHDU(i);
            if (!(basicHDU instanceof ImageHDU) || (nArray = basicHDU.getAxes()) == null || nArray.length != 2) continue;
            int[] nArray2 = null;
            Object object2 = basicHDU.getData().getData();
            if (object2 instanceof byte[][]) {
                int n;
                int n2;
                byte[] byArray;
                int n3;
                nArray2 = new int[nArray[0] * nArray[1]];
                object = (byte[][])object2;
                int n4 = -128;
                int n5 = 127;
                for (n3 = 0; n3 < ((byte[][])object).length; ++n3) {
                    byArray = object[n3];
                    for (n2 = 0; n2 < byArray.length; ++n2) {
                        n = object[n3][n2] & 0xFF;
                        if (n > n4) {
                            n4 = n;
                        }
                        if (n >= n5) continue;
                        n5 = n;
                    }
                }
                for (n3 = 0; n3 < ((byte[][])object).length; ++n3) {
                    byArray = object[n3];
                    for (n2 = 0; n2 < byArray.length; ++n2) {
                        n = n3 * byArray.length + n2;
                        nArray2[n] = (int)((double)((object[n3][n2] & 0xFF) - n5) / (double)(n4 - n5) * 255.0);
                    }
                }
            } else if (object2 instanceof short[][]) {
                int n;
                int n6;
                byte[] byArray;
                int n7;
                nArray2 = new int[nArray[0] * nArray[1]];
                object = (short[][])object2;
                int n8 = Short.MIN_VALUE;
                int n9 = Short.MAX_VALUE;
                for (n7 = 0; n7 < ((byte[][])object).length; ++n7) {
                    byArray = object[n7];
                    for (n6 = 0; n6 < byArray.length; ++n6) {
                        n = object[n7][n6];
                        if (n > n8) {
                            n8 = n;
                        }
                        if (n >= n9) continue;
                        n9 = n;
                    }
                }
                for (n7 = 0; n7 < ((byte[][])object).length; ++n7) {
                    byArray = object[n7];
                    for (n6 = 0; n6 < byArray.length; ++n6) {
                        n = n7 * byArray.length + n6;
                        nArray2[n] = (int)(((double)object[n7][n6] - (double)n9) / ((double)n8 - (double)n9) * 255.0);
                    }
                }
            } else if (object2 instanceof float[][]) {
                int n;
                byte[] byArray;
                int n10;
                nArray2 = new int[nArray[0] * nArray[1]];
                object = (float[][])object2;
                float f = Float.MIN_VALUE;
                float f2 = Float.MAX_VALUE;
                for (n10 = 0; n10 < ((byte[][])object).length; ++n10) {
                    byArray = object[n10];
                    for (n = 0; n < byArray.length; ++n) {
                        byte by = object[n10][n];
                        if (by > f) {
                            f = by;
                        }
                        if (!(by < f2)) continue;
                        f2 = by;
                    }
                }
                for (n10 = 0; n10 < ((byte[][])object).length; ++n10) {
                    byArray = object[n10];
                    for (n = 0; n < byArray.length; ++n) {
                        int n11 = n10 * byArray.length + n;
                        nArray2[n11] = (int)((object[n10][n] - f2) / (f - f2) * 255.0f);
                    }
                }
            } else if (object2 instanceof double[][]) {
                int n;
                byte[] byArray;
                int n12;
                nArray2 = new int[nArray[0] * nArray[1]];
                object = (double[][])object2;
                Object object3 = Double.MIN_VALUE;
                Object object4 = Double.MAX_VALUE;
                for (n12 = 0; n12 < ((byte[][])object).length; ++n12) {
                    byArray = object[n12];
                    for (n = 0; n < byArray.length; ++n) {
                        Object object5 = object[n12][n];
                        if (object5 > object3) {
                            object3 = object5;
                        }
                        if (!(object5 < object4)) continue;
                        object4 = object5;
                    }
                }
                for (n12 = 0; n12 < ((byte[][])object).length; ++n12) {
                    byArray = object[n12];
                    for (n = 0; n < byArray.length; ++n) {
                        int n13 = n12 * byArray.length + n;
                        nArray2[n13] = (int)((object[n12][n] - object4) / (object3 + object4) * 255.0);
                    }
                }
            } else {
                fits.close();
                throw new RuntimeException("not supported data type");
            }
            object = new BufferedImage(nArray[1], nArray[0], 10);
            WritableRaster writableRaster = ((BufferedImage)object).getRaster();
            writableRaster.setPixels(0, 0, nArray[1], nArray[0], nArray2);
            fits.close();
            return object;
        }
        fits.close();
        throw new RuntimeException("not supported image format");
    }

    private void makeUV(GL2 gL2, Model model, Setting setting) {
        if (model == null) {
            return;
        }
        gL2.glDisable(3553);
        gL2.glClear(256);
        int[] nArray = new int[4];
        gL2.glGetIntegerv(2978, nArray, 0);
        gL2.glViewport(0, 0, 512, 512);
        gL2.glMatrixMode(5889);
        gL2.glPushMatrix();
        gL2.glLoadIdentity();
        gL2.glMatrixMode(5888);
        gL2.glPushMatrix();
        gL2.glLoadIdentity();
        gL2.glRotated(-90.0, 0.0, 0.0, 1.0);
        CameraInfo cameraInfo = setting.info;
        glu.gluPerspective(Math.toDegrees(cameraInfo.fov), 1.0, 1.0, 50.0);
        Vector3d vector3d = new Vector3d((Tuple3d)cameraInfo.position);
        Vector3d vector3d2 = new Vector3d();
        vector3d2.add((Tuple3d)vector3d, (Tuple3d)cameraInfo.direction);
        glu.gluLookAt(vector3d.x, vector3d.y, vector3d.z, vector3d2.x, vector3d2.y, vector3d2.z, cameraInfo.up.x, cameraInfo.up.y, cameraInfo.up.z);
        gL2.glColorMask(false, false, false, false);
        gL2.glEnable(2929);
        gL2.glDisable(2896);
        gL2.glCullFace(1029);
        gL2.glDisableClientState(32888);
        double[] dArray = new double[16];
        gL2.glGetDoublev(2982, dArray, 0);
        gL2.glEnableClientState(32884);
        gL2.glBindBuffer(34962, model.getVboId(0));
        gL2.glVertexPointer(3, 5126, 0, 0L);
        int n = 3 * model.getNFace();
        gL2.glDrawArrays(4, 0, n);
        gL2.glFinish();
        gL2.glBindBuffer(34962, model.getVboId(3 + setting.uvIndex));
        ByteBuffer byteBuffer = gL2.glMapBuffer(34962, 35002);
        FloatBuffer floatBuffer = FloatBuffer.allocate(262144);
        gL2.glReadPixels(0, 0, 512, 512, 6402, 5126, (Buffer)floatBuffer);
        gL2.glColorMask(true, true, true, true);
        int[] nArray2 = new int[]{0, 0, 512, 512};
        double[] dArray2 = new double[]{1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0};
        model.makeUV(byteBuffer, vector3d, floatBuffer, dArray, dArray2, nArray2);
        gL2.glUnmapBuffer(34962);
        gL2.glClear(256);
        gL2.glViewport(nArray[0], nArray[1], nArray[2], nArray[3]);
        gL2.glMatrixMode(5889);
        gL2.glPopMatrix();
        gL2.glMatrixMode(5888);
        gL2.glPopMatrix();
        gL2.glColorMask(true, true, true, true);
        gL2.glEnable(2896);
        gL2.glCullFace(1029);
        gL2.glDisableClientState(32884);
        gL2.glEnable(3553);
        gL2.glBindTexture(3553, 0);
    }

    public class Setting {
        public CameraInfo info;
        public Texture tex;
        public File imageFile;
        public File infoFile;
        public boolean needReloadTex = true;
        public boolean[] active = new boolean[]{true, true, true, true};
        public boolean removeFlg = false;
        public Integer uvIndex = null;
        public Image img;
        public int rotate;
        public int flip;
    }
}

