/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.image.compression.tile.mask;

import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import nom.tam.fits.compression.algorithm.api.ICompressorControl;
import nom.tam.image.compression.tile.mask.AbstractNullPixelMask;
import nom.tam.image.tile.operation.buffer.TileBuffer;
import nom.tam.util.type.PrimitiveTypes;

public class NullPixelMaskRestorer
extends AbstractNullPixelMask {
    public NullPixelMaskRestorer(TileBuffer tileBuffer, int tileIndex, long nullValue, ICompressorControl compressorControl) {
        super(tileBuffer, tileIndex, nullValue, compressorControl);
    }

    public void restoreNulls() {
        if (this.getMask() != null) {
            ByteBuffer decompressed = ByteBuffer.allocate(this.getTileBuffer().getPixelSize());
            this.getCompressorControl().decompress(this.getMask(), decompressed, this.getCompressorControl().option());
            this.setMask(decompressed);
            if (this.getTileBuffer().getBaseType().is(PrimitiveTypes.DOUBLE)) {
                this.restoreNullDoubles();
            } else if (this.getTileBuffer().getBaseType().is(PrimitiveTypes.FLOAT)) {
                this.restoreNullFloats();
            } else if (this.getTileBuffer().getBaseType().is(PrimitiveTypes.LONG)) {
                this.restoreNullLongs();
            } else if (this.getTileBuffer().getBaseType().is(PrimitiveTypes.INT)) {
                this.restoreNullInts();
            } else if (this.getTileBuffer().getBaseType().is(PrimitiveTypes.SHORT)) {
                this.restoreNullShorts();
            } else if (this.getTileBuffer().getBaseType().is(PrimitiveTypes.BYTE)) {
                this.restoreNullBytes();
            }
        }
    }

    private void restoreNullBytes() {
        ByteBuffer buffer = (ByteBuffer)this.getTileBuffer().getBuffer();
        ByteBuffer nullMask = this.initializedMask(buffer.remaining());
        byte nullValue = (byte)this.getNullValue();
        for (int index = 0; index < nullMask.capacity(); ++index) {
            if (nullMask.get(index) != 1) continue;
            buffer.put(index, nullValue);
        }
    }

    private void restoreNullDoubles() {
        DoubleBuffer buffer = (DoubleBuffer)this.getTileBuffer().getBuffer();
        ByteBuffer nullMask = this.initializedMask(buffer.remaining());
        for (int index = 0; index < nullMask.capacity(); ++index) {
            if (nullMask.get(index) != 1) continue;
            buffer.put(index, Double.NaN);
        }
    }

    private void restoreNullFloats() {
        FloatBuffer buffer = (FloatBuffer)this.getTileBuffer().getBuffer();
        ByteBuffer nullMask = this.initializedMask(buffer.remaining());
        for (int index = 0; index < nullMask.capacity(); ++index) {
            if (nullMask.get(index) != 1) continue;
            buffer.put(index, Float.NaN);
        }
    }

    private void restoreNullInts() {
        IntBuffer buffer = (IntBuffer)this.getTileBuffer().getBuffer();
        ByteBuffer nullMask = this.initializedMask(buffer.remaining());
        int nullValue = (int)this.getNullValue();
        for (int index = 0; index < nullMask.capacity(); ++index) {
            if (nullMask.get(index) != 1) continue;
            buffer.put(index, nullValue);
        }
    }

    private void restoreNullLongs() {
        LongBuffer buffer = (LongBuffer)this.getTileBuffer().getBuffer();
        ByteBuffer nullMask = this.initializedMask(buffer.remaining());
        long nullValue = this.getNullValue();
        for (int index = 0; index < nullMask.capacity(); ++index) {
            if (nullMask.get(index) != 1) continue;
            buffer.put(index, nullValue);
        }
    }

    private void restoreNullShorts() {
        ShortBuffer buffer = (ShortBuffer)this.getTileBuffer().getBuffer();
        ByteBuffer nullMask = this.initializedMask(buffer.remaining());
        short nullValue = (short)this.getNullValue();
        for (int index = 0; index < nullMask.capacity(); ++index) {
            if (nullMask.get(index) != 1) continue;
            buffer.put(index, nullValue);
        }
    }
}

