/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits.header;

import java.io.Serializable;
import nom.tam.fits.header.IFitsHeader;

public class FitsHeaderImpl
implements IFitsHeader,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String comment;
    private final IFitsHeader.HDU hdu;
    private final String key;
    private final IFitsHeader.SOURCE status;
    private final IFitsHeader.VALUE valueType;

    public FitsHeaderImpl(String headerName, IFitsHeader.SOURCE status, IFitsHeader.HDU hdu, IFitsHeader.VALUE valueType, String comment) {
        this.key = headerName;
        this.status = status;
        this.hdu = hdu;
        this.valueType = valueType;
        this.comment = comment;
    }

    @Override
    public String comment() {
        return this.comment;
    }

    @Override
    public IFitsHeader.HDU hdu() {
        return this.hdu;
    }

    @Override
    public String key() {
        return this.key;
    }

    @Override
    public IFitsHeader n(int ... numbers) {
        StringBuffer headerName = new StringBuffer(this.key);
        for (int number : numbers) {
            int indexOfN = headerName.indexOf("n");
            headerName.replace(indexOfN, indexOfN + 1, Integer.toString(number));
        }
        return new FitsHeaderImpl(headerName.toString(), this.status, this.hdu, this.valueType, this.comment);
    }

    @Override
    public IFitsHeader.SOURCE status() {
        return this.status;
    }

    @Override
    public IFitsHeader.VALUE valueType() {
        return this.valueType;
    }
}

