/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.util.type;

import java.lang.reflect.Array;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import nom.tam.util.type.PrimitiveType;

abstract class PrimitiveTypeBase<B extends Buffer>
implements PrimitiveType<B> {
    public static final int COPY_BLOCK_SIZE = 1024;
    private final int bitPix;
    private final Class<B> bufferClass;
    private final boolean individualSize;
    private final Class<?> primitiveClass;
    private final int size;
    private final char type;
    private final Class<?> wrapperClass;

    protected PrimitiveTypeBase(int size, boolean individualSize, Class<?> primitiveClass, Class<?> wrapperClass, Class<B> bufferClass, char type, int bitPix) {
        this.size = size;
        this.individualSize = individualSize;
        this.primitiveClass = primitiveClass;
        this.wrapperClass = wrapperClass;
        this.bufferClass = bufferClass;
        this.type = type;
        this.bitPix = bitPix;
    }

    @Override
    public void appendBuffer(B buffer, B dataToAppend) {
        throw new UnsupportedOperationException("no primitive type");
    }

    @Override
    public void appendToByteBuffer(ByteBuffer byteBuffer, B dataToAppend) {
        byte[] temp = new byte[Math.min(1024 * this.size, ((Buffer)dataToAppend).remaining() * this.size)];
        B typedBuffer = this.asTypedBuffer(ByteBuffer.wrap(temp));
        Object array = this.newArray(Math.min(1024, ((Buffer)dataToAppend).remaining()));
        while (((Buffer)dataToAppend).hasRemaining()) {
            int part = Math.min(1024, ((Buffer)dataToAppend).remaining());
            this.getArray(dataToAppend, array, part);
            this.putArray(typedBuffer, array, part);
            byteBuffer.put(temp, 0, part * this.size);
        }
    }

    @Override
    public B asTypedBuffer(ByteBuffer buffer) {
        throw new UnsupportedOperationException("no primitive buffer available");
    }

    @Override
    public int bitPix() {
        return this.bitPix;
    }

    @Override
    public Class<B> bufferClass() {
        return this.bufferClass;
    }

    @Override
    public ByteBuffer convertToByteBuffer(Object array) {
        ByteBuffer buffer = ByteBuffer.wrap(new byte[Array.getLength(array) * this.size]);
        this.putArray(this.asTypedBuffer(buffer), array);
        buffer.rewind();
        return buffer;
    }

    @Override
    public final void getArray(B buffer, Object array) {
        this.getArray(buffer, array, Array.getLength(array));
    }

    @Override
    public final void getArray(B buffer, Object array, int length) {
        this.getArray(buffer, array, 0, length);
    }

    @Override
    public void getArray(B buffer, Object array, int offset, int length) {
        throw new UnsupportedOperationException("no primitive type");
    }

    @Override
    public boolean individualSize() {
        return this.individualSize;
    }

    @Override
    public boolean is(PrimitiveType<? extends Buffer> other) {
        return this.bitPix == other.bitPix();
    }

    @Override
    public Object newArray(int length) {
        return null;
    }

    @Override
    public final B newBuffer(int length) {
        return this.wrap(this.newArray(length));
    }

    @Override
    public final B newBuffer(long length) {
        return this.wrap(this.newArray((int)length));
    }

    @Override
    public Class<?> primitiveClass() {
        return this.primitiveClass;
    }

    @Override
    public final void putArray(B buffer, Object array) {
        this.putArray(buffer, array, Array.getLength(array));
    }

    @Override
    public void putArray(B buffer, Object array, int length) {
        throw new UnsupportedOperationException("no primitive type");
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public int size(Object instance) {
        if (instance == null) {
            return 0;
        }
        return this.size;
    }

    @Override
    public B sliceBuffer(B buffer) {
        return null;
    }

    @Override
    public char type() {
        return this.type;
    }

    @Override
    public B wrap(Object array) {
        return null;
    }

    @Override
    public Class<?> wrapperClass() {
        return this.wrapperClass;
    }
}

