/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp.agent;

import com.sun.jmx.defaults.JmxProperties;
import com.sun.jmx.snmp.SnmpDataTypeEnums;
import com.sun.jmx.snmp.SnmpInt;
import com.sun.jmx.snmp.SnmpOid;
import com.sun.jmx.snmp.SnmpStatusException;
import com.sun.jmx.snmp.SnmpValue;
import com.sun.jmx.snmp.SnmpVarBind;
import com.sun.jmx.snmp.agent.AcmChecker;
import com.sun.jmx.snmp.agent.SnmpEntryOid;
import com.sun.jmx.snmp.agent.SnmpMib;
import com.sun.jmx.snmp.agent.SnmpMibNode;
import com.sun.jmx.snmp.agent.SnmpMibSubRequest;
import com.sun.jmx.snmp.agent.SnmpRequestTree;
import com.sun.jmx.snmp.agent.SnmpTableEntryFactory;
import com.sun.jmx.snmp.agent.SnmpTableEntryNotification;
import java.io.Serializable;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public abstract class SnmpMibTable
extends SnmpMibNode
implements NotificationBroadcaster,
Serializable {
    protected int nodeId = 1;
    protected SnmpMib theMib;
    protected boolean creationEnabled = false;
    protected SnmpTableEntryFactory factory = null;
    private int size = 0;
    private static final int Delta = 16;
    private int tablecount = 0;
    private int tablesize = 16;
    private SnmpOid[] tableoids = new SnmpOid[this.tablesize];
    private final Vector<Object> entries = new Vector();
    private final Vector<ObjectName> entrynames = new Vector();
    private Hashtable<NotificationListener, Vector<Object>> handbackTable = new Hashtable();
    private Hashtable<NotificationListener, Vector<NotificationFilter>> filterTable = new Hashtable();
    transient long sequenceNumber = 0L;

    public SnmpMibTable(SnmpMib snmpMib) {
        this.theMib = snmpMib;
        this.setCreationEnabled(false);
    }

    public abstract void createNewEntry(SnmpMibSubRequest var1, SnmpOid var2, int var3) throws SnmpStatusException;

    public abstract boolean isRegistrationRequired();

    public boolean isCreationEnabled() {
        return this.creationEnabled;
    }

    public void setCreationEnabled(boolean bl) {
        this.creationEnabled = bl;
    }

    public boolean hasRowStatus() {
        return false;
    }

    @Override
    public void get(SnmpMibSubRequest snmpMibSubRequest, int n) throws SnmpStatusException {
        SnmpDataTypeEnums snmpDataTypeEnums;
        boolean bl = snmpMibSubRequest.isNewEntry();
        SnmpMibSubRequest snmpMibSubRequest2 = snmpMibSubRequest;
        if (bl) {
            Enumeration<SnmpVarBind> enumeration = snmpMibSubRequest2.getElements();
            while (enumeration.hasMoreElements()) {
                snmpDataTypeEnums = enumeration.nextElement();
                snmpMibSubRequest2.registerGetException((SnmpVarBind)snmpDataTypeEnums, new SnmpStatusException(224));
            }
        }
        snmpDataTypeEnums = snmpMibSubRequest2.getEntryOid();
        this.get(snmpMibSubRequest, (SnmpOid)snmpDataTypeEnums, n + 1);
    }

    @Override
    public void check(SnmpMibSubRequest snmpMibSubRequest, int n) throws SnmpStatusException {
        SnmpOid snmpOid = snmpMibSubRequest.getEntryOid();
        int n2 = this.getRowAction(snmpMibSubRequest, snmpOid, n + 1);
        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpMibTable.class.getName(), "check", "Calling beginRowAction");
        }
        this.beginRowAction(snmpMibSubRequest, snmpOid, n + 1, n2);
        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpMibTable.class.getName(), "check", "Calling check for " + snmpMibSubRequest.getSize() + " varbinds");
        }
        this.check(snmpMibSubRequest, snmpOid, n + 1);
        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpMibTable.class.getName(), "check", "check finished");
        }
    }

    @Override
    public void set(SnmpMibSubRequest snmpMibSubRequest, int n) throws SnmpStatusException {
        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpMibTable.class.getName(), "set", "Entering set");
        }
        SnmpOid snmpOid = snmpMibSubRequest.getEntryOid();
        int n2 = this.getRowAction(snmpMibSubRequest, snmpOid, n + 1);
        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpMibTable.class.getName(), "set", "Calling set for " + snmpMibSubRequest.getSize() + " varbinds");
        }
        this.set(snmpMibSubRequest, snmpOid, n + 1);
        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpMibTable.class.getName(), "set", "Calling endRowAction");
        }
        this.endRowAction(snmpMibSubRequest, snmpOid, n + 1, n2);
        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpMibTable.class.getName(), "set", "RowAction finished");
        }
    }

    public void addEntry(SnmpOid snmpOid, Object object) throws SnmpStatusException {
        this.addEntry(snmpOid, null, object);
    }

    public synchronized void addEntry(SnmpOid snmpOid, ObjectName objectName, Object object) throws SnmpStatusException {
        if (this.isRegistrationRequired() && objectName == null) {
            throw new SnmpStatusException(3);
        }
        if (this.size == 0) {
            this.insertOid(0, snmpOid);
            if (this.entries != null) {
                this.entries.addElement(object);
            }
            if (this.entrynames != null) {
                this.entrynames.addElement(objectName);
            }
            ++this.size;
            if (this.factory != null) {
                try {
                    this.factory.addEntryCb(0, snmpOid, objectName, object, this);
                }
                catch (SnmpStatusException snmpStatusException) {
                    this.removeOid(0);
                    if (this.entries != null) {
                        this.entries.removeElementAt(0);
                    }
                    if (this.entrynames != null) {
                        this.entrynames.removeElementAt(0);
                    }
                    throw snmpStatusException;
                }
            }
            this.sendNotification("jmx.snmp.table.entry.added", new Date().getTime(), object, objectName);
            return;
        }
        int n = 0;
        n = this.getInsertionPoint(snmpOid, true);
        if (n == this.size) {
            this.insertOid(this.tablecount, snmpOid);
            if (this.entries != null) {
                this.entries.addElement(object);
            }
            if (this.entrynames != null) {
                this.entrynames.addElement(objectName);
            }
            ++this.size;
        } else {
            try {
                this.insertOid(n, snmpOid);
                if (this.entries != null) {
                    this.entries.insertElementAt(object, n);
                }
                if (this.entrynames != null) {
                    this.entrynames.insertElementAt(objectName, n);
                }
                ++this.size;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        if (this.factory != null) {
            try {
                this.factory.addEntryCb(n, snmpOid, objectName, object, this);
            }
            catch (SnmpStatusException snmpStatusException) {
                this.removeOid(n);
                if (this.entries != null) {
                    this.entries.removeElementAt(n);
                }
                if (this.entrynames != null) {
                    this.entrynames.removeElementAt(n);
                }
                throw snmpStatusException;
            }
        }
        this.sendNotification("jmx.snmp.table.entry.added", new Date().getTime(), object, objectName);
    }

    public synchronized void removeEntry(SnmpOid snmpOid, Object object) throws SnmpStatusException {
        int n = this.findObject(snmpOid);
        if (n == -1) {
            return;
        }
        this.removeEntry(n, object);
    }

    public void removeEntry(SnmpOid snmpOid) throws SnmpStatusException {
        int n = this.findObject(snmpOid);
        if (n == -1) {
            return;
        }
        this.removeEntry(n, null);
    }

    public synchronized void removeEntry(int n, Object object) throws SnmpStatusException {
        if (n == -1) {
            return;
        }
        if (n >= this.size) {
            return;
        }
        Object object2 = object;
        if (this.entries != null && this.entries.size() > n) {
            object2 = this.entries.elementAt(n);
            this.entries.removeElementAt(n);
        }
        ObjectName objectName = null;
        if (this.entrynames != null && this.entrynames.size() > n) {
            objectName = this.entrynames.elementAt(n);
            this.entrynames.removeElementAt(n);
        }
        SnmpOid snmpOid = this.tableoids[n];
        this.removeOid(n);
        --this.size;
        if (object2 == null) {
            object2 = object;
        }
        if (this.factory != null) {
            this.factory.removeEntryCb(n, snmpOid, objectName, object2, this);
        }
        this.sendNotification("jmx.snmp.table.entry.removed", new Date().getTime(), object2, objectName);
    }

    public synchronized Object getEntry(SnmpOid snmpOid) throws SnmpStatusException {
        int n = this.findObject(snmpOid);
        if (n == -1) {
            throw new SnmpStatusException(224);
        }
        return this.entries.elementAt(n);
    }

    public synchronized ObjectName getEntryName(SnmpOid snmpOid) throws SnmpStatusException {
        int n = this.findObject(snmpOid);
        if (this.entrynames == null) {
            return null;
        }
        if (n == -1 || n >= this.entrynames.size()) {
            throw new SnmpStatusException(224);
        }
        return this.entrynames.elementAt(n);
    }

    public Object[] getBasicEntries() {
        Object[] objectArray = new Object[this.size];
        this.entries.copyInto(objectArray);
        return objectArray;
    }

    public int getSize() {
        return this.size;
    }

    @Override
    public synchronized void addNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) {
        if (notificationListener == null) {
            throw new IllegalArgumentException("Listener can't be null");
        }
        Vector<Object> vector = this.handbackTable.get(notificationListener);
        Vector<NotificationFilter> vector2 = this.filterTable.get(notificationListener);
        if (vector == null) {
            vector = new Vector();
            vector2 = new Vector();
            this.handbackTable.put(notificationListener, vector);
            this.filterTable.put(notificationListener, vector2);
        }
        vector.addElement(object);
        vector2.addElement(notificationFilter);
    }

    @Override
    public synchronized void removeNotificationListener(NotificationListener notificationListener) throws ListenerNotFoundException {
        Vector<Object> vector = this.handbackTable.get(notificationListener);
        if (vector == null) {
            throw new ListenerNotFoundException("listener");
        }
        this.handbackTable.remove(notificationListener);
        this.filterTable.remove(notificationListener);
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        String[] stringArray = new String[]{"jmx.snmp.table.entry.added", "jmx.snmp.table.entry.removed"};
        MBeanNotificationInfo[] mBeanNotificationInfoArray = new MBeanNotificationInfo[]{new MBeanNotificationInfo(stringArray, "com.sun.jmx.snmp.agent.SnmpTableEntryNotification", "Notifications sent by the SnmpMibTable")};
        return mBeanNotificationInfoArray;
    }

    public void registerEntryFactory(SnmpTableEntryFactory snmpTableEntryFactory) {
        this.factory = snmpTableEntryFactory;
    }

    protected boolean isRowStatus(SnmpOid snmpOid, long l, Object object) {
        return false;
    }

    protected int getRowAction(SnmpMibSubRequest snmpMibSubRequest, SnmpOid snmpOid, int n) throws SnmpStatusException {
        boolean bl = snmpMibSubRequest.isNewEntry();
        SnmpVarBind snmpVarBind = snmpMibSubRequest.getRowStatusVarBind();
        if (snmpVarBind == null) {
            if (bl && !this.hasRowStatus()) {
                return 4;
            }
            return 0;
        }
        try {
            return this.mapRowStatus(snmpOid, snmpVarBind, snmpMibSubRequest.getUserData());
        }
        catch (SnmpStatusException snmpStatusException) {
            SnmpMibTable.checkRowStatusFail(snmpMibSubRequest, snmpStatusException.getStatus());
            return 0;
        }
    }

    protected int mapRowStatus(SnmpOid snmpOid, SnmpVarBind snmpVarBind, Object object) throws SnmpStatusException {
        SnmpValue snmpValue = snmpVarBind.value;
        if (snmpValue instanceof SnmpInt) {
            return ((SnmpInt)snmpValue).intValue();
        }
        throw new SnmpStatusException(12);
    }

    protected SnmpValue setRowStatus(SnmpOid snmpOid, int n, Object object) throws SnmpStatusException {
        return null;
    }

    protected boolean isRowReady(SnmpOid snmpOid, Object object) throws SnmpStatusException {
        return true;
    }

    protected void checkRowStatusChange(SnmpMibSubRequest snmpMibSubRequest, SnmpOid snmpOid, int n, int n2) throws SnmpStatusException {
    }

    protected void checkRemoveTableRow(SnmpMibSubRequest snmpMibSubRequest, SnmpOid snmpOid, int n) throws SnmpStatusException {
    }

    protected void removeTableRow(SnmpMibSubRequest snmpMibSubRequest, SnmpOid snmpOid, int n) throws SnmpStatusException {
        this.removeEntry(snmpOid);
    }

    protected synchronized void beginRowAction(SnmpMibSubRequest snmpMibSubRequest, SnmpOid snmpOid, int n, int n2) throws SnmpStatusException {
        boolean bl = snmpMibSubRequest.isNewEntry();
        SnmpOid snmpOid2 = snmpOid;
        int n3 = n2;
        switch (n3) {
            case 0: {
                if (!bl) break;
                if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                    JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpMibTable.class.getName(), "beginRowAction", "Failed to create row[" + snmpOid + "] : RowStatus = unspecified");
                }
                SnmpMibTable.checkRowStatusFail(snmpMibSubRequest, 6);
                break;
            }
            case 4: 
            case 5: {
                if (bl) {
                    if (this.isCreationEnabled()) {
                        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpMibTable.class.getName(), "beginRowAction", "Creating row[" + snmpOid + "] : RowStatus = createAndGo | createAndWait");
                        }
                        this.createNewEntry(snmpMibSubRequest, snmpOid2, n);
                        break;
                    }
                    if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                        JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpMibTable.class.getName(), "beginRowAction", "Can't create row[" + snmpOid + "] : RowStatus = createAndGo | createAndWait but creation is disabled");
                    }
                    SnmpMibTable.checkRowStatusFail(snmpMibSubRequest, 6);
                    break;
                }
                if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                    JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpMibTable.class.getName(), "beginRowAction", "Can't create row[" + snmpOid + "] : RowStatus = createAndGo | createAndWait but row already exists");
                }
                SnmpMibTable.checkRowStatusFail(snmpMibSubRequest, 12);
                break;
            }
            case 6: {
                if (bl) {
                    if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                        JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpMibTable.class.getName(), "beginRowAction", "Warning: can't destroy row[" + snmpOid + "] : RowStatus = destroy but row does not exist");
                    }
                } else if (!this.isCreationEnabled()) {
                    if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                        JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpMibTable.class.getName(), "beginRowAction", "Can't destroy row[" + snmpOid + "] : RowStatus = destroy but creation is disabled");
                    }
                    SnmpMibTable.checkRowStatusFail(snmpMibSubRequest, 6);
                }
                this.checkRemoveTableRow(snmpMibSubRequest, snmpOid, n);
                break;
            }
            case 1: 
            case 2: {
                if (bl) {
                    if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                        JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpMibTable.class.getName(), "beginRowAction", "Can't switch state of row[" + snmpOid + "] : specified RowStatus = active | notInService but row does not exist");
                    }
                    SnmpMibTable.checkRowStatusFail(snmpMibSubRequest, 12);
                }
                this.checkRowStatusChange(snmpMibSubRequest, snmpOid, n, n3);
                break;
            }
            default: {
                if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                    JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpMibTable.class.getName(), "beginRowAction", "Invalid RowStatus value for row[" + snmpOid + "] : specified RowStatus = " + n3);
                }
                SnmpMibTable.checkRowStatusFail(snmpMibSubRequest, 12);
            }
        }
    }

    protected void endRowAction(SnmpMibSubRequest snmpMibSubRequest, SnmpOid snmpOid, int n, int n2) throws SnmpStatusException {
        SnmpVarBind snmpVarBind;
        boolean bl = snmpMibSubRequest.isNewEntry();
        SnmpOid snmpOid2 = snmpOid;
        int n3 = n2;
        Object object = snmpMibSubRequest.getUserData();
        SnmpValue snmpValue = null;
        switch (n3) {
            case 0: {
                break;
            }
            case 4: {
                if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                    JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpMibTable.class.getName(), "endRowAction", "Setting RowStatus to 'active' for row[" + snmpOid + "] : requested RowStatus = createAndGo");
                }
                snmpValue = this.setRowStatus(snmpOid2, 1, object);
                break;
            }
            case 5: {
                if (this.isRowReady(snmpOid2, object)) {
                    if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                        JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpMibTable.class.getName(), "endRowAction", "Setting RowStatus to 'notInService' for row[" + snmpOid + "] : requested RowStatus = createAndWait");
                    }
                    snmpValue = this.setRowStatus(snmpOid2, 2, object);
                    break;
                }
                if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                    JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpMibTable.class.getName(), "endRowAction", "Setting RowStatus to 'notReady' for row[" + snmpOid + "] : requested RowStatus = createAndWait");
                }
                snmpValue = this.setRowStatus(snmpOid2, 3, object);
                break;
            }
            case 6: {
                if (bl) {
                    if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                        JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpMibTable.class.getName(), "endRowAction", "Warning: requested RowStatus = destroy, but row[" + snmpOid + "] does not exist");
                    }
                } else if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                    JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpMibTable.class.getName(), "endRowAction", "Destroying row[" + snmpOid + "] : requested RowStatus = destroy");
                }
                this.removeTableRow(snmpMibSubRequest, snmpOid2, n);
                break;
            }
            case 1: {
                if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                    JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpMibTable.class.getName(), "endRowAction", "Setting RowStatus to 'active' for row[" + snmpOid + "] : requested RowStatus = active");
                }
                snmpValue = this.setRowStatus(snmpOid2, 1, object);
                break;
            }
            case 2: {
                if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                    JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpMibTable.class.getName(), "endRowAction", "Setting RowStatus to 'notInService' for row[" + snmpOid + "] : requested RowStatus = notInService");
                }
                snmpValue = this.setRowStatus(snmpOid2, 2, object);
                break;
            }
            default: {
                if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                    JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpMibTable.class.getName(), "endRowAction", "Invalid RowStatus value for row[" + snmpOid + "] : specified RowStatus = " + n3);
                }
                SnmpMibTable.setRowStatusFail(snmpMibSubRequest, 12);
            }
        }
        if (snmpValue != null && (snmpVarBind = snmpMibSubRequest.getRowStatusVarBind()) != null) {
            snmpVarBind.value = snmpValue;
        }
    }

    protected long getNextVarEntryId(SnmpOid snmpOid, long l, Object object, int n) throws SnmpStatusException {
        long l2 = l;
        while (this.skipEntryVariable(snmpOid, l2 = this.getNextVarEntryId(snmpOid, l2, object), object, n)) {
        }
        return l2;
    }

    protected boolean skipEntryVariable(SnmpOid snmpOid, long l, Object object, int n) {
        return false;
    }

    protected SnmpOid getNextOid(SnmpOid snmpOid, Object object) throws SnmpStatusException {
        if (this.size == 0) {
            throw new SnmpStatusException(224);
        }
        SnmpOid snmpOid2 = this.tableoids[this.tablecount - 1];
        SnmpOid snmpOid3 = snmpOid;
        if (snmpOid2.equals(snmpOid3)) {
            throw new SnmpStatusException(224);
        }
        int n = this.getInsertionPoint(snmpOid3, false);
        if (n > -1 && n < this.size) {
            try {
                snmpOid2 = this.tableoids[n];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new SnmpStatusException(224);
            }
        } else {
            throw new SnmpStatusException(224);
        }
        return snmpOid2;
    }

    protected SnmpOid getNextOid(Object object) throws SnmpStatusException {
        if (this.size == 0) {
            throw new SnmpStatusException(224);
        }
        return this.tableoids[0];
    }

    protected abstract long getNextVarEntryId(SnmpOid var1, long var2, Object var4) throws SnmpStatusException;

    protected abstract void validateVarEntryId(SnmpOid var1, long var2, Object var4) throws SnmpStatusException;

    protected abstract boolean isReadableEntryId(SnmpOid var1, long var2, Object var4) throws SnmpStatusException;

    protected abstract void get(SnmpMibSubRequest var1, SnmpOid var2, int var3) throws SnmpStatusException;

    protected abstract void check(SnmpMibSubRequest var1, SnmpOid var2, int var3) throws SnmpStatusException;

    protected abstract void set(SnmpMibSubRequest var1, SnmpOid var2, int var3) throws SnmpStatusException;

    SnmpOid getNextOid(long[] lArray, int n, Object object) throws SnmpStatusException {
        SnmpEntryOid snmpEntryOid = new SnmpEntryOid(lArray, n);
        return this.getNextOid(snmpEntryOid, object);
    }

    static void checkRowStatusFail(SnmpMibSubRequest snmpMibSubRequest, int n) throws SnmpStatusException {
        SnmpVarBind snmpVarBind = snmpMibSubRequest.getRowStatusVarBind();
        SnmpStatusException snmpStatusException = new SnmpStatusException(n);
        snmpMibSubRequest.registerCheckException(snmpVarBind, snmpStatusException);
    }

    static void setRowStatusFail(SnmpMibSubRequest snmpMibSubRequest, int n) throws SnmpStatusException {
        SnmpVarBind snmpVarBind = snmpMibSubRequest.getRowStatusVarBind();
        SnmpStatusException snmpStatusException = new SnmpStatusException(n);
        snmpMibSubRequest.registerSetException(snmpVarBind, snmpStatusException);
    }

    @Override
    final synchronized void findHandlingNode(SnmpVarBind snmpVarBind, long[] lArray, int n, SnmpRequestTree snmpRequestTree) throws SnmpStatusException {
        int n2 = lArray.length;
        if (snmpRequestTree == null) {
            throw new SnmpStatusException(5);
        }
        if (n >= n2) {
            throw new SnmpStatusException(6);
        }
        if (lArray[n] != (long)this.nodeId) {
            throw new SnmpStatusException(6);
        }
        if (n + 2 >= n2) {
            throw new SnmpStatusException(6);
        }
        SnmpEntryOid snmpEntryOid = new SnmpEntryOid(lArray, n + 2);
        Object object = snmpRequestTree.getUserData();
        boolean bl = this.contains(snmpEntryOid, object);
        if (!bl) {
            if (!snmpRequestTree.isCreationAllowed()) {
                throw new SnmpStatusException(224);
            }
            if (!this.isCreationEnabled()) {
                throw new SnmpStatusException(6);
            }
        }
        long l = lArray[n + 1];
        if (bl) {
            this.validateVarEntryId(snmpEntryOid, l, object);
        }
        if (snmpRequestTree.isSetRequest() && this.isRowStatus(snmpEntryOid, l, object)) {
            snmpRequestTree.add(this, n, snmpEntryOid, snmpVarBind, !bl, snmpVarBind);
        } else {
            snmpRequestTree.add(this, n, snmpEntryOid, snmpVarBind, !bl);
        }
    }

    @Override
    final synchronized long[] findNextHandlingNode(SnmpVarBind snmpVarBind, long[] lArray, int n, int n2, SnmpRequestTree snmpRequestTree, AcmChecker acmChecker) throws SnmpStatusException {
        SnmpOid snmpOid;
        int n3 = lArray.length;
        if (snmpRequestTree == null) {
            throw new SnmpStatusException(225);
        }
        Object object = snmpRequestTree.getUserData();
        int n4 = snmpRequestTree.getRequestPduVersion();
        long l = -1L;
        if (n >= n3) {
            lArray = new long[]{this.nodeId};
            n = 0;
            n3 = 1;
        } else {
            if (lArray[n] > (long)this.nodeId) {
                throw new SnmpStatusException(225);
            }
            if (lArray[n] < (long)this.nodeId) {
                lArray = new long[]{this.nodeId};
                n = 0;
                n3 = 0;
            } else if (n + 1 < n3) {
                l = lArray[n + 1];
            }
        }
        if (n == n3 - 1) {
            snmpOid = this.getNextOid(object);
            l = this.getNextVarEntryId(snmpOid, l, object, n4);
        } else if (n == n3 - 2) {
            snmpOid = this.getNextOid(object);
            if (this.skipEntryVariable(snmpOid, l, object, n4)) {
                l = this.getNextVarEntryId(snmpOid, l, object, n4);
            }
        } else {
            try {
                snmpOid = this.getNextOid(lArray, n + 2, object);
                if (this.skipEntryVariable(snmpOid, l, object, n4)) {
                    throw new SnmpStatusException(225);
                }
            }
            catch (SnmpStatusException snmpStatusException) {
                snmpOid = this.getNextOid(object);
                l = this.getNextVarEntryId(snmpOid, l, object, n4);
            }
        }
        return this.findNextAccessibleOid(snmpOid, snmpVarBind, lArray, n2, snmpRequestTree, acmChecker, object, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long[] findNextAccessibleOid(SnmpOid snmpOid, SnmpVarBind snmpVarBind, long[] lArray, int n, SnmpRequestTree snmpRequestTree, AcmChecker acmChecker, Object object, long l) throws SnmpStatusException {
        int n2 = snmpRequestTree.getRequestPduVersion();
        do {
            if (snmpOid == null || l == -1L) {
                throw new SnmpStatusException(225);
            }
            if (!this.isReadableEntryId(snmpOid, l, object)) {
                throw new SnmpStatusException(225);
            }
            long[] lArray2 = snmpOid.longValue(false);
            int n3 = lArray2.length;
            long[] lArray3 = new long[n + 2 + n3];
            lArray3[0] = -1L;
            System.arraycopy(lArray2, 0, lArray3, n + 2, n3);
            lArray3[n] = this.nodeId;
            lArray3[n + 1] = l;
            acmChecker.add(n, lArray3, n, n3 + 2);
            try {
                acmChecker.checkCurrentOid();
                snmpRequestTree.add(this, n, snmpOid, snmpVarBind, false);
                long[] lArray4 = lArray3;
                acmChecker.remove(n, n3 + 2);
                return lArray4;
            }
            catch (SnmpStatusException snmpStatusException) {
                try {
                    try {
                        snmpOid = this.getNextOid(snmpOid, object);
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        acmChecker.remove(n, n3 + 2);
                    }
                }
                catch (SnmpStatusException snmpStatusException2) {
                    snmpOid = this.getNextOid(object);
                    l = this.getNextVarEntryId(snmpOid, l, object, n2);
                }
            }
        } while (snmpOid != null && l != -1L);
        throw new SnmpStatusException(225);
    }

    final void validateOid(long[] lArray, int n) throws SnmpStatusException {
        int n2 = lArray.length;
        if (n + 2 >= n2) {
            throw new SnmpStatusException(224);
        }
        if (lArray[n] != (long)this.nodeId) {
            throw new SnmpStatusException(225);
        }
    }

    private synchronized void sendNotification(Notification notification) {
        Enumeration<NotificationListener> enumeration = this.handbackTable.keys();
        while (enumeration.hasMoreElements()) {
            NotificationListener notificationListener = enumeration.nextElement();
            Vector<Object> vector = this.handbackTable.get(notificationListener);
            Vector<NotificationFilter> vector2 = this.filterTable.get(notificationListener);
            Enumeration<NotificationFilter> enumeration2 = vector2.elements();
            Enumeration<Object> enumeration3 = vector.elements();
            while (enumeration3.hasMoreElements()) {
                Object object = enumeration3.nextElement();
                NotificationFilter notificationFilter = enumeration2.nextElement();
                if (notificationFilter != null && !notificationFilter.isNotificationEnabled(notification)) continue;
                notificationListener.handleNotification(notification, object);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendNotification(String string, long l, Object object, ObjectName objectName) {
        Serializable serializable = this;
        synchronized (serializable) {
            ++this.sequenceNumber;
        }
        serializable = new SnmpTableEntryNotification(string, this, this.sequenceNumber, l, object, objectName);
        this.sendNotification((Notification)serializable);
    }

    protected boolean contains(SnmpOid snmpOid, Object object) {
        return this.findObject(snmpOid) > -1;
    }

    private int findObject(SnmpOid snmpOid) {
        int n = 0;
        int n2 = this.size - 1;
        int n3 = n + (n2 - n) / 2;
        while (n <= n2) {
            SnmpOid snmpOid2 = this.tableoids[n3];
            int n4 = snmpOid.compareTo(snmpOid2);
            if (n4 == 0) {
                return n3;
            }
            if (snmpOid.equals(snmpOid2)) {
                return n3;
            }
            if (n4 > 0) {
                n = n3 + 1;
            } else {
                n2 = n3 - 1;
            }
            n3 = n + (n2 - n) / 2;
        }
        return -1;
    }

    private int getInsertionPoint(SnmpOid snmpOid, boolean bl) throws SnmpStatusException {
        int n = 0;
        int n2 = this.size - 1;
        int n3 = n + (n2 - n) / 2;
        while (n <= n2) {
            SnmpOid snmpOid2 = this.tableoids[n3];
            int n4 = snmpOid.compareTo(snmpOid2);
            if (n4 == 0) {
                if (bl) {
                    throw new SnmpStatusException(17, n3);
                }
                return n3 + 1;
            }
            if (n4 > 0) {
                n = n3 + 1;
            } else {
                n2 = n3 - 1;
            }
            n3 = n + (n2 - n) / 2;
        }
        return n3;
    }

    private void removeOid(int n) {
        if (n >= this.tablecount) {
            return;
        }
        if (n < 0) {
            return;
        }
        int n2 = --this.tablecount - n;
        this.tableoids[n] = null;
        if (n2 > 0) {
            System.arraycopy(this.tableoids, n + 1, this.tableoids, n, n2);
        }
        this.tableoids[this.tablecount] = null;
    }

    private void insertOid(int n, SnmpOid snmpOid) {
        if (n >= this.tablesize || this.tablecount == this.tablesize) {
            SnmpOid[] snmpOidArray = this.tableoids;
            this.tablesize += 16;
            this.tableoids = new SnmpOid[this.tablesize];
            if (n > this.tablecount) {
                n = this.tablecount;
            }
            if (n < 0) {
                n = 0;
            }
            int n2 = n;
            int n3 = this.tablecount - n;
            if (n2 > 0) {
                System.arraycopy(snmpOidArray, 0, this.tableoids, 0, n2);
            }
            if (n3 > 0) {
                System.arraycopy(snmpOidArray, n2, this.tableoids, n2 + 1, n3);
            }
        } else if (n < this.tablecount) {
            System.arraycopy(this.tableoids, n, this.tableoids, n + 1, this.tablecount - n);
        }
        this.tableoids[n] = snmpOid;
        ++this.tablecount;
    }
}

