/*
 * Decompiled with CFR 0.152.
 */
package java.util.regex;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Spliterators;
import java.util.function.Predicate;
import java.util.regex.ASCII;
import java.util.regex.Matcher;
import java.util.regex.PatternSyntaxException;
import java.util.regex.UnicodeProp;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import sun.text.Normalizer;

public final class Pattern
implements Serializable {
    public static final int UNIX_LINES = 1;
    public static final int CASE_INSENSITIVE = 2;
    public static final int COMMENTS = 4;
    public static final int MULTILINE = 8;
    public static final int LITERAL = 16;
    public static final int DOTALL = 32;
    public static final int UNICODE_CASE = 64;
    public static final int CANON_EQ = 128;
    public static final int UNICODE_CHARACTER_CLASS = 256;
    private static final long serialVersionUID = 5073258162644648461L;
    private String pattern;
    private int flags;
    private volatile transient boolean compiled = false;
    private transient String normalizedPattern;
    transient Node root;
    transient Node matchRoot;
    transient int[] buffer;
    volatile transient Map<String, Integer> namedGroups;
    transient GroupHead[] groupNodes;
    private transient int[] temp;
    transient int capturingGroupCount;
    transient int localCount;
    private transient int cursor;
    private transient int patternLength;
    private transient boolean hasSupplementary;
    static final int MAX_REPS = Integer.MAX_VALUE;
    static final int GREEDY = 0;
    static final int LAZY = 1;
    static final int POSSESSIVE = 2;
    static final int INDEPENDENT = 3;
    static Node lookbehindEnd = new Node(){

        @Override
        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            return n == matcher.lookbehindTo;
        }
    };
    static Node accept = new Node();
    static Node lastAccept = new LastNode();

    public static Pattern compile(String string) {
        return new Pattern(string, 0);
    }

    public static Pattern compile(String string, int n) {
        return new Pattern(string, n);
    }

    public String pattern() {
        return this.pattern;
    }

    public String toString() {
        return this.pattern;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Matcher matcher(CharSequence charSequence) {
        Object object;
        if (!this.compiled) {
            object = this;
            synchronized (object) {
                if (!this.compiled) {
                    this.compile();
                }
            }
        }
        object = new Matcher(this, charSequence);
        return object;
    }

    public int flags() {
        return this.flags;
    }

    public static boolean matches(String string, CharSequence charSequence) {
        Pattern pattern = Pattern.compile(string);
        Matcher matcher = pattern.matcher(charSequence);
        return matcher.matches();
    }

    public String[] split(CharSequence charSequence, int n) {
        int n2;
        int n3 = 0;
        boolean bl = n > 0;
        ArrayList<String> arrayList = new ArrayList<String>();
        Matcher matcher = this.matcher(charSequence);
        while (matcher.find()) {
            String string;
            if (!bl || arrayList.size() < n - 1) {
                if (n3 == 0 && n3 == matcher.start() && matcher.start() == matcher.end()) continue;
                string = charSequence.subSequence(n3, matcher.start()).toString();
                arrayList.add(string);
                n3 = matcher.end();
                continue;
            }
            if (arrayList.size() != n - 1) continue;
            string = charSequence.subSequence(n3, charSequence.length()).toString();
            arrayList.add(string);
            n3 = matcher.end();
        }
        if (n3 == 0) {
            return new String[]{charSequence.toString()};
        }
        if (!bl || arrayList.size() < n) {
            arrayList.add(charSequence.subSequence(n3, charSequence.length()).toString());
        }
        if (n == 0) {
            for (n2 = arrayList.size(); n2 > 0 && ((String)arrayList.get(n2 - 1)).equals(""); --n2) {
            }
        }
        String[] stringArray = new String[n2];
        return arrayList.subList(0, n2).toArray(stringArray);
    }

    public String[] split(CharSequence charSequence) {
        return this.split(charSequence, 0);
    }

    public static String quote(String string) {
        int n = string.indexOf("\\E");
        if (n == -1) {
            return "\\Q" + string + "\\E";
        }
        StringBuilder stringBuilder = new StringBuilder(string.length() * 2);
        stringBuilder.append("\\Q");
        n = 0;
        int n2 = 0;
        while ((n = string.indexOf("\\E", n2)) != -1) {
            stringBuilder.append(string.substring(n2, n));
            n2 = n + 2;
            stringBuilder.append("\\E\\\\E\\Q");
        }
        stringBuilder.append(string.substring(n2, string.length()));
        stringBuilder.append("\\E");
        return stringBuilder.toString();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.capturingGroupCount = 1;
        this.localCount = 0;
        this.compiled = false;
        if (this.pattern.length() == 0) {
            this.root = new Start(lastAccept);
            this.matchRoot = lastAccept;
            this.compiled = true;
        }
    }

    private Pattern(String string, int n) {
        this.pattern = string;
        this.flags = n;
        if ((this.flags & 0x100) != 0) {
            this.flags |= 0x40;
        }
        this.capturingGroupCount = 1;
        this.localCount = 0;
        if (this.pattern.length() > 0) {
            this.compile();
        } else {
            this.root = new Start(lastAccept);
            this.matchRoot = lastAccept;
        }
    }

    private void normalize() {
        int n;
        boolean bl = false;
        int n2 = -1;
        this.normalizedPattern = java.text.Normalizer.normalize(this.pattern, Normalizer.Form.NFD);
        this.patternLength = this.normalizedPattern.length();
        StringBuilder stringBuilder = new StringBuilder(this.patternLength);
        for (int i = 0; i < this.patternLength; i += Character.charCount(n)) {
            n = this.normalizedPattern.codePointAt(i);
            if (Character.getType(n) == 6 && n2 != -1) {
                StringBuilder stringBuilder2 = new StringBuilder();
                stringBuilder2.appendCodePoint(n2);
                stringBuilder2.appendCodePoint(n);
                while (Character.getType(n) == 6 && (i += Character.charCount(n)) < this.patternLength) {
                    n = this.normalizedPattern.codePointAt(i);
                    stringBuilder2.appendCodePoint(n);
                }
                String string = this.produceEquivalentAlternation(stringBuilder2.toString());
                stringBuilder.setLength(stringBuilder.length() - Character.charCount(n2));
                stringBuilder.append("(?:").append(string).append(")");
            } else if (n == 91 && n2 != 92) {
                i = this.normalizeCharClass(stringBuilder, i);
            } else {
                stringBuilder.appendCodePoint(n);
            }
            n2 = n;
        }
        this.normalizedPattern = stringBuilder.toString();
    }

    private int normalizeCharClass(StringBuilder stringBuilder, int n) {
        int n2;
        StringBuilder stringBuilder2 = new StringBuilder();
        StringBuilder stringBuilder3 = null;
        int n3 = -1;
        ++n;
        stringBuilder2.append("[");
        while (true) {
            if ((n2 = this.normalizedPattern.codePointAt(n)) == 93 && n3 != 92) break;
            if (Character.getType(n2) == 6) {
                StringBuilder stringBuilder4 = new StringBuilder();
                stringBuilder4.appendCodePoint(n3);
                while (Character.getType(n2) == 6) {
                    stringBuilder4.appendCodePoint(n2);
                    if ((n += Character.charCount(n2)) >= this.normalizedPattern.length()) break;
                    n2 = this.normalizedPattern.codePointAt(n);
                }
                String string = this.produceEquivalentAlternation(stringBuilder4.toString());
                stringBuilder2.setLength(stringBuilder2.length() - Character.charCount(n3));
                if (stringBuilder3 == null) {
                    stringBuilder3 = new StringBuilder();
                }
                stringBuilder3.append('|');
                stringBuilder3.append(string);
            } else {
                stringBuilder2.appendCodePoint(n2);
                ++n;
            }
            if (n == this.normalizedPattern.length()) {
                throw this.error("Unclosed character class");
            }
            n3 = n2;
        }
        stringBuilder2.append((char)n2);
        String string = stringBuilder3 != null ? "(?:" + stringBuilder2.toString() + stringBuilder3.toString() + ")" : stringBuilder2.toString();
        stringBuilder.append(string);
        return n;
    }

    private String produceEquivalentAlternation(String string) {
        int n = Pattern.countChars(string, 0, 1);
        if (string.length() == n) {
            return string;
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n);
        String[] stringArray = this.producePermutations(string3);
        StringBuilder stringBuilder = new StringBuilder(string);
        for (int i = 0; i < stringArray.length; ++i) {
            String string4 = string2 + stringArray[i];
            if (i > 0) {
                stringBuilder.append("|" + string4);
            }
            if ((string4 = this.composeOneStep(string4)) == null) continue;
            stringBuilder.append("|" + this.produceEquivalentAlternation(string4));
        }
        return stringBuilder.toString();
    }

    private String[] producePermutations(String string) {
        int n;
        int n2;
        if (string.length() == Pattern.countChars(string, 0, 1)) {
            return new String[]{string};
        }
        if (string.length() == Pattern.countChars(string, 0, 2)) {
            int n3 = Character.codePointAt(string, 0);
            int n4 = Character.codePointAt(string, Character.charCount(n3));
            if (this.getClass(n4) == this.getClass(n3)) {
                return new String[]{string};
            }
            String[] stringArray = new String[2];
            stringArray[0] = string;
            StringBuilder stringBuilder = new StringBuilder(2);
            stringBuilder.appendCodePoint(n4);
            stringBuilder.appendCodePoint(n3);
            stringArray[1] = stringBuilder.toString();
            return stringArray;
        }
        int n5 = 1;
        int n6 = Pattern.countCodePoints(string);
        for (int i = 1; i < n6; ++i) {
            n5 *= i + 1;
        }
        String[] stringArray = new String[n5];
        int[] nArray = new int[n6];
        int n7 = 0;
        for (n2 = 0; n2 < n6; ++n2) {
            n = Character.codePointAt(string, n7);
            nArray[n2] = this.getClass(n);
            n7 += Character.charCount(n);
        }
        n2 = 0;
        n = 0;
        int n8 = 0;
        while (n < n6) {
            block10: {
                n7 = Pattern.countChars(string, n8, 1);
                boolean bl = false;
                for (int i = n - 1; i >= 0; --i) {
                    if (nArray[i] != nArray[n]) {
                        continue;
                    }
                    break block10;
                }
                StringBuilder stringBuilder = new StringBuilder(string);
                String string2 = stringBuilder.delete(n8, n8 + n7).toString();
                String[] stringArray2 = this.producePermutations(string2);
                String string3 = string.substring(n8, n8 + n7);
                for (int i = 0; i < stringArray2.length; ++i) {
                    stringArray[n2++] = string3 + stringArray2[i];
                }
            }
            ++n;
            n8 += n7;
        }
        String[] stringArray3 = new String[n2];
        for (n8 = 0; n8 < n2; ++n8) {
            stringArray3[n8] = stringArray[n8];
        }
        return stringArray3;
    }

    private int getClass(int n) {
        return Normalizer.getCombiningClass(n);
    }

    private String composeOneStep(String string) {
        int n = Pattern.countChars(string, 0, 2);
        String string2 = string.substring(0, n);
        String string3 = java.text.Normalizer.normalize(string2, Normalizer.Form.NFC);
        if (string3.equals(string2)) {
            return null;
        }
        String string4 = string.substring(n);
        return string3 + string4;
    }

    private void RemoveQEQuoting() {
        int n = this.patternLength;
        int n2 = 0;
        while (n2 < n - 1) {
            if (this.temp[n2] != 92) {
                ++n2;
                continue;
            }
            if (this.temp[n2 + 1] == 81) break;
            n2 += 2;
        }
        if (n2 >= n - 1) {
            return;
        }
        int n3 = n2;
        int[] nArray = new int[n3 + 3 * (n - (n2 += 2)) + 2];
        System.arraycopy(this.temp, 0, nArray, 0, n3);
        boolean bl = true;
        boolean bl2 = true;
        while (n2 < n) {
            int n4;
            if (!ASCII.isAscii(n4 = this.temp[n2++]) || ASCII.isAlpha(n4)) {
                nArray[n3++] = n4;
            } else if (ASCII.isDigit(n4)) {
                if (bl2) {
                    nArray[n3++] = 92;
                    nArray[n3++] = 120;
                    nArray[n3++] = 51;
                }
                nArray[n3++] = n4;
            } else if (n4 != 92) {
                if (bl) {
                    nArray[n3++] = 92;
                }
                nArray[n3++] = n4;
            } else if (bl) {
                if (this.temp[n2] == 69) {
                    ++n2;
                    bl = false;
                } else {
                    nArray[n3++] = 92;
                    nArray[n3++] = 92;
                }
            } else {
                if (this.temp[n2] == 81) {
                    ++n2;
                    bl = true;
                    bl2 = true;
                    continue;
                }
                nArray[n3++] = n4;
                if (n2 != n) {
                    nArray[n3++] = this.temp[n2++];
                }
            }
            bl2 = false;
        }
        this.patternLength = n3;
        this.temp = Arrays.copyOf(nArray, n3 + 2);
    }

    private void compile() {
        int n;
        if (this.has(128) && !this.has(16)) {
            this.normalize();
        } else {
            this.normalizedPattern = this.pattern;
        }
        this.patternLength = this.normalizedPattern.length();
        this.temp = new int[this.patternLength + 2];
        this.hasSupplementary = false;
        int n2 = 0;
        for (int i = 0; i < this.patternLength; i += Character.charCount(n)) {
            n = this.normalizedPattern.codePointAt(i);
            if (Pattern.isSupplementary(n)) {
                this.hasSupplementary = true;
            }
            this.temp[n2++] = n;
        }
        this.patternLength = n2;
        if (!this.has(16)) {
            this.RemoveQEQuoting();
        }
        this.buffer = new int[32];
        this.groupNodes = new GroupHead[10];
        this.namedGroups = null;
        if (this.has(16)) {
            this.matchRoot = this.newSlice(this.temp, this.patternLength, this.hasSupplementary);
            this.matchRoot.next = lastAccept;
        } else {
            this.matchRoot = this.expr(lastAccept);
            if (this.patternLength != this.cursor) {
                if (this.peek() == 41) {
                    throw this.error("Unmatched closing ')'");
                }
                throw this.error("Unexpected internal error");
            }
        }
        if (this.matchRoot instanceof Slice) {
            this.root = BnM.optimize(this.matchRoot);
            if (this.root == this.matchRoot) {
                this.root = this.hasSupplementary ? new StartS(this.matchRoot) : new Start(this.matchRoot);
            }
        } else {
            this.root = this.matchRoot instanceof Begin || this.matchRoot instanceof First ? this.matchRoot : (this.hasSupplementary ? new StartS(this.matchRoot) : new Start(this.matchRoot));
        }
        this.temp = null;
        this.buffer = null;
        this.groupNodes = null;
        this.patternLength = 0;
        this.compiled = true;
    }

    Map<String, Integer> namedGroups() {
        if (this.namedGroups == null) {
            this.namedGroups = new HashMap<String, Integer>(2);
        }
        return this.namedGroups;
    }

    private static void printObjectTree(Node node) {
        while (node != null) {
            if (node instanceof Prolog) {
                System.out.println(node);
                Pattern.printObjectTree(((Prolog)node).loop);
                System.out.println("**** end contents prolog loop");
            } else if (node instanceof Loop) {
                System.out.println(node);
                Pattern.printObjectTree(((Loop)node).body);
                System.out.println("**** end contents Loop body");
            } else if (node instanceof Curly) {
                System.out.println(node);
                Pattern.printObjectTree(((Curly)node).atom);
                System.out.println("**** end contents Curly body");
            } else if (node instanceof GroupCurly) {
                System.out.println(node);
                Pattern.printObjectTree(((GroupCurly)node).atom);
                System.out.println("**** end contents GroupCurly body");
            } else {
                if (node instanceof GroupTail) {
                    System.out.println(node);
                    System.out.println("Tail next is " + node.next);
                    return;
                }
                System.out.println(node);
            }
            node = node.next;
            if (node != null) {
                System.out.println("->next:");
            }
            if (node != accept) continue;
            System.out.println("Accept Node");
            node = null;
        }
    }

    private boolean has(int n) {
        return (this.flags & n) != 0;
    }

    private void accept(int n, String string) {
        int n2 = this.temp[this.cursor++];
        if (this.has(4)) {
            n2 = this.parsePastWhitespace(n2);
        }
        if (n != n2) {
            throw this.error(string);
        }
    }

    private void mark(int n) {
        this.temp[this.patternLength] = n;
    }

    private int peek() {
        int n = this.temp[this.cursor];
        if (this.has(4)) {
            n = this.peekPastWhitespace(n);
        }
        return n;
    }

    private int read() {
        int n = this.temp[this.cursor++];
        if (this.has(4)) {
            n = this.parsePastWhitespace(n);
        }
        return n;
    }

    private int readEscaped() {
        int n = this.temp[this.cursor++];
        return n;
    }

    private int next() {
        int n = this.temp[++this.cursor];
        if (this.has(4)) {
            n = this.peekPastWhitespace(n);
        }
        return n;
    }

    private int nextEscaped() {
        int n = this.temp[++this.cursor];
        return n;
    }

    private int peekPastWhitespace(int n) {
        while (ASCII.isSpace(n) || n == 35) {
            while (ASCII.isSpace(n)) {
                n = this.temp[++this.cursor];
            }
            if (n != 35) continue;
            n = this.peekPastLine();
        }
        return n;
    }

    private int parsePastWhitespace(int n) {
        while (ASCII.isSpace(n) || n == 35) {
            while (ASCII.isSpace(n)) {
                n = this.temp[this.cursor++];
            }
            if (n != 35) continue;
            n = this.parsePastLine();
        }
        return n;
    }

    private int parsePastLine() {
        int n = this.temp[this.cursor++];
        while (n != 0 && !this.isLineSeparator(n)) {
            n = this.temp[this.cursor++];
        }
        return n;
    }

    private int peekPastLine() {
        int n = this.temp[++this.cursor];
        while (n != 0 && !this.isLineSeparator(n)) {
            n = this.temp[++this.cursor];
        }
        return n;
    }

    private boolean isLineSeparator(int n) {
        if (this.has(1)) {
            return n == 10;
        }
        return n == 10 || n == 13 || (n | 1) == 8233 || n == 133;
    }

    private int skip() {
        int n = this.cursor;
        int n2 = this.temp[n + 1];
        this.cursor = n + 2;
        return n2;
    }

    private void unread() {
        --this.cursor;
    }

    private PatternSyntaxException error(String string) {
        return new PatternSyntaxException(string, this.normalizedPattern, this.cursor - 1);
    }

    private boolean findSupplementary(int n, int n2) {
        for (int i = n; i < n2; ++i) {
            if (!Pattern.isSupplementary(this.temp[i])) continue;
            return true;
        }
        return false;
    }

    private static final boolean isSupplementary(int n) {
        return n >= 65536 || Character.isSurrogate((char)n);
    }

    private Node expr(Node node) {
        Node node2 = null;
        Node node3 = null;
        Branch branch = null;
        BranchConn branchConn = null;
        while (true) {
            Node node4 = this.sequence(node);
            Node node5 = this.root;
            if (node2 == null) {
                node2 = node4;
                node3 = node5;
            } else {
                if (branchConn == null) {
                    branchConn = new BranchConn();
                    branchConn.next = node;
                }
                if (node4 == node) {
                    node4 = null;
                } else {
                    node5.next = branchConn;
                }
                if (node2 == branch) {
                    branch.add(node4);
                } else {
                    if (node2 == node) {
                        node2 = null;
                    } else {
                        node3.next = branchConn;
                    }
                    branch = new Branch(node2, node4, branchConn);
                    node2 = branch;
                }
            }
            if (this.peek() != 124) {
                return node2;
            }
            this.next();
        }
    }

    private Node sequence(Node node) {
        Node node2 = null;
        Node node3 = null;
        Node node4 = null;
        block12: while (true) {
            int n = this.peek();
            switch (n) {
                case 40: {
                    node4 = this.group0();
                    if (node4 == null) continue block12;
                    if (node2 == null) {
                        node2 = node4;
                    } else {
                        node3.next = node4;
                    }
                    node3 = this.root;
                    continue block12;
                }
                case 91: {
                    node4 = this.clazz(true);
                    break;
                }
                case 92: {
                    n = this.nextEscaped();
                    if (n == 112 || n == 80) {
                        boolean bl = true;
                        boolean bl2 = n == 80;
                        n = this.next();
                        if (n != 123) {
                            this.unread();
                        } else {
                            bl = false;
                        }
                        node4 = this.family(bl, bl2);
                        break;
                    }
                    this.unread();
                    node4 = this.atom();
                    break;
                }
                case 94: {
                    this.next();
                    if (this.has(8)) {
                        if (this.has(1)) {
                            node4 = new UnixCaret();
                            break;
                        }
                        node4 = new Caret();
                        break;
                    }
                    node4 = new Begin();
                    break;
                }
                case 36: {
                    this.next();
                    if (this.has(1)) {
                        node4 = new UnixDollar(this.has(8));
                        break;
                    }
                    node4 = new Dollar(this.has(8));
                    break;
                }
                case 46: {
                    this.next();
                    if (this.has(32)) {
                        node4 = new All();
                        break;
                    }
                    if (this.has(1)) {
                        node4 = new UnixDot();
                        break;
                    }
                    node4 = new Dot();
                    break;
                }
                case 41: 
                case 124: {
                    break block12;
                }
                case 93: 
                case 125: {
                    node4 = this.atom();
                    break;
                }
                case 42: 
                case 43: 
                case 63: {
                    this.next();
                    throw this.error("Dangling meta character '" + (char)n + "'");
                }
                case 0: {
                    if (this.cursor >= this.patternLength) break block12;
                }
                default: {
                    node4 = this.atom();
                }
            }
            node4 = this.closure(node4);
            if (node2 == null) {
                node2 = node3 = node4;
                continue;
            }
            node3.next = node4;
            node3 = node4;
        }
        if (node2 == null) {
            return node;
        }
        node3.next = node;
        this.root = node3;
        return node2;
    }

    private Node atom() {
        int n = 0;
        int n2 = -1;
        boolean bl = false;
        int n3 = this.peek();
        block6: while (true) {
            switch (n3) {
                case 42: 
                case 43: 
                case 63: 
                case 123: {
                    if (n <= true) break block6;
                    this.cursor = n2;
                    --n;
                    break block6;
                }
                case 36: 
                case 40: 
                case 41: 
                case 46: 
                case 91: 
                case 94: 
                case 124: {
                    break block6;
                }
                case 92: {
                    n3 = this.nextEscaped();
                    if (n3 == 112 || n3 == 80) {
                        if (n > 0) {
                            this.unread();
                            break block6;
                        }
                        boolean bl2 = n3 == 80;
                        boolean bl3 = true;
                        n3 = this.next();
                        if (n3 != 123) {
                            this.unread();
                        } else {
                            bl3 = false;
                        }
                        return this.family(bl3, bl2);
                    }
                    this.unread();
                    n2 = this.cursor;
                    n3 = this.escape(false, n == 0, false);
                    if (n3 >= 0) {
                        this.append(n3, n);
                        ++n;
                        if (Pattern.isSupplementary(n3)) {
                            bl = true;
                        }
                        n3 = this.peek();
                        continue block6;
                    }
                    if (n == 0) {
                        return this.root;
                    }
                    this.cursor = n2;
                    break block6;
                }
                case 0: {
                    if (this.cursor >= this.patternLength) break block6;
                }
                default: {
                    n2 = this.cursor;
                    this.append(n3, n);
                    ++n;
                    if (Pattern.isSupplementary(n3)) {
                        bl = true;
                    }
                    n3 = this.next();
                    continue block6;
                }
            }
            break;
        }
        if (n == 1) {
            return this.newSingle(this.buffer[0]);
        }
        return this.newSlice(this.buffer, n, bl);
    }

    private void append(int n, int n2) {
        if (n2 >= this.buffer.length) {
            int[] nArray = new int[n2 + n2];
            System.arraycopy(this.buffer, 0, nArray, 0, n2);
            this.buffer = nArray;
        }
        this.buffer[n2] = n;
    }

    private Node ref(int n) {
        boolean bl = false;
        block3: while (!bl) {
            int n2 = this.peek();
            switch (n2) {
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    int n3 = n * 10 + (n2 - 48);
                    if (this.capturingGroupCount - 1 < n3) {
                        bl = true;
                        continue block3;
                    }
                    n = n3;
                    this.read();
                    continue block3;
                }
            }
            bl = true;
        }
        if (this.has(2)) {
            return new CIBackRef(n, this.has(64));
        }
        return new BackRef(n);
    }

    private int escape(boolean bl, boolean bl2, boolean bl3) {
        int n = this.skip();
        switch (n) {
            case 48: {
                return this.o();
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                if (bl) break;
                if (bl2) {
                    this.root = this.ref(n - 48);
                }
                return -1;
            }
            case 65: {
                if (bl) break;
                if (bl2) {
                    this.root = new Begin();
                }
                return -1;
            }
            case 66: {
                if (bl) break;
                if (bl2) {
                    this.root = new Bound(Bound.NONE, this.has(256));
                }
                return -1;
            }
            case 67: {
                break;
            }
            case 68: {
                if (bl2) {
                    this.root = this.has(256) ? new Utype(UnicodeProp.DIGIT).complement() : new Ctype(1024).complement();
                }
                return -1;
            }
            case 69: 
            case 70: {
                break;
            }
            case 71: {
                if (bl) break;
                if (bl2) {
                    this.root = new LastMatch();
                }
                return -1;
            }
            case 72: {
                if (bl2) {
                    this.root = new HorizWS().complement();
                }
                return -1;
            }
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: {
                break;
            }
            case 82: {
                if (bl) break;
                if (bl2) {
                    this.root = new LineEnding();
                }
                return -1;
            }
            case 83: {
                if (bl2) {
                    this.root = this.has(256) ? new Utype(UnicodeProp.WHITE_SPACE).complement() : new Ctype(2048).complement();
                }
                return -1;
            }
            case 84: 
            case 85: {
                break;
            }
            case 86: {
                if (bl2) {
                    this.root = new VertWS().complement();
                }
                return -1;
            }
            case 87: {
                if (bl2) {
                    this.root = this.has(256) ? new Utype(UnicodeProp.WORD).complement() : new Ctype(67328).complement();
                }
                return -1;
            }
            case 88: 
            case 89: {
                break;
            }
            case 90: {
                if (bl) break;
                if (bl2) {
                    this.root = this.has(1) ? new UnixDollar(false) : new Dollar(false);
                }
                return -1;
            }
            case 97: {
                return 7;
            }
            case 98: {
                if (bl) break;
                if (bl2) {
                    this.root = new Bound(Bound.BOTH, this.has(256));
                }
                return -1;
            }
            case 99: {
                return this.c();
            }
            case 100: {
                if (bl2) {
                    this.root = this.has(256) ? new Utype(UnicodeProp.DIGIT) : new Ctype(1024);
                }
                return -1;
            }
            case 101: {
                return 27;
            }
            case 102: {
                return 12;
            }
            case 103: {
                break;
            }
            case 104: {
                if (bl2) {
                    this.root = new HorizWS();
                }
                return -1;
            }
            case 105: 
            case 106: {
                break;
            }
            case 107: {
                if (bl) break;
                if (this.read() != 60) {
                    throw this.error("\\k is not followed by '<' for named capturing group");
                }
                String string = this.groupname(this.read());
                if (!this.namedGroups().containsKey(string)) {
                    throw this.error("(named capturing group <" + string + "> does not exit");
                }
                if (bl2) {
                    this.root = this.has(2) ? new CIBackRef(this.namedGroups().get(string), this.has(64)) : new BackRef(this.namedGroups().get(string));
                }
                return -1;
            }
            case 108: 
            case 109: {
                break;
            }
            case 110: {
                return 10;
            }
            case 111: 
            case 112: 
            case 113: {
                break;
            }
            case 114: {
                return 13;
            }
            case 115: {
                if (bl2) {
                    this.root = this.has(256) ? new Utype(UnicodeProp.WHITE_SPACE) : new Ctype(2048);
                }
                return -1;
            }
            case 116: {
                return 9;
            }
            case 117: {
                return this.u();
            }
            case 118: {
                if (bl3) {
                    return 11;
                }
                if (bl2) {
                    this.root = new VertWS();
                }
                return -1;
            }
            case 119: {
                if (bl2) {
                    this.root = this.has(256) ? new Utype(UnicodeProp.WORD) : new Ctype(67328);
                }
                return -1;
            }
            case 120: {
                return this.x();
            }
            case 121: {
                break;
            }
            case 122: {
                if (bl) break;
                if (bl2) {
                    this.root = new End();
                }
                return -1;
            }
            default: {
                return n;
            }
        }
        throw this.error("Illegal/unsupported escape sequence");
    }

    private CharProperty clazz(boolean bl) {
        CharProperty charProperty = null;
        CharProperty charProperty2 = null;
        BitClass bitClass = new BitClass();
        boolean bl2 = true;
        boolean bl3 = true;
        int n = this.next();
        block7: while (true) {
            switch (n) {
                case 94: {
                    if (!bl3 || this.temp[this.cursor - 1] != 91) break;
                    n = this.next();
                    bl2 = !bl2;
                    continue block7;
                }
                case 91: {
                    bl3 = false;
                    charProperty2 = this.clazz(true);
                    charProperty = charProperty == null ? charProperty2 : Pattern.union(charProperty, charProperty2);
                    n = this.peek();
                    continue block7;
                }
                case 38: {
                    bl3 = false;
                    n = this.next();
                    if (n == 38) {
                        n = this.next();
                        CharProperty charProperty3 = null;
                        while (n != 93 && n != 38) {
                            if (n == 91) {
                                charProperty3 = charProperty3 == null ? this.clazz(true) : Pattern.union(charProperty3, this.clazz(true));
                            } else {
                                this.unread();
                                charProperty3 = this.clazz(false);
                            }
                            n = this.peek();
                        }
                        if (charProperty3 != null) {
                            charProperty2 = charProperty3;
                        }
                        if (charProperty == null) {
                            if (charProperty3 == null) {
                                throw this.error("Bad class syntax");
                            }
                            charProperty = charProperty3;
                            continue block7;
                        }
                        charProperty = Pattern.intersection(charProperty, charProperty2);
                        continue block7;
                    }
                    this.unread();
                    break;
                }
                case 0: {
                    bl3 = false;
                    if (this.cursor < this.patternLength) break;
                    throw this.error("Unclosed character class");
                }
                case 93: {
                    bl3 = false;
                    if (charProperty == null) break;
                    if (bl) {
                        this.next();
                    }
                    return charProperty;
                }
                default: {
                    bl3 = false;
                }
            }
            charProperty2 = this.range(bitClass);
            if (bl2) {
                if (charProperty == null) {
                    charProperty = charProperty2;
                } else if (charProperty != charProperty2) {
                    charProperty = Pattern.union(charProperty, charProperty2);
                }
            } else if (charProperty == null) {
                charProperty = charProperty2.complement();
            } else if (charProperty != charProperty2) {
                charProperty = Pattern.setDifference(charProperty, charProperty2);
            }
            n = this.peek();
        }
    }

    private CharProperty bitsOrSingle(BitClass bitClass, int n) {
        if (n < 256 && (!this.has(2) || !this.has(64) || n != 255 && n != 181 && n != 73 && n != 105 && n != 83 && n != 115 && n != 75 && n != 107 && n != 197 && n != 229)) {
            return bitClass.add(n, this.flags());
        }
        return this.newSingle(n);
    }

    private CharProperty range(BitClass bitClass) {
        boolean bl;
        int n = this.peek();
        if (n == 92) {
            n = this.nextEscaped();
            if (n == 112 || n == 80) {
                boolean bl2 = n == 80;
                boolean bl3 = true;
                n = this.next();
                if (n != 123) {
                    this.unread();
                } else {
                    bl3 = false;
                }
                return this.family(bl3, bl2);
            }
            bl = this.temp[this.cursor + 1] == 45;
            this.unread();
            n = this.escape(true, true, bl);
            if (n == -1) {
                return (CharProperty)this.root;
            }
        } else {
            this.next();
        }
        if (n >= 0) {
            if (this.peek() == 45) {
                bl = this.temp[this.cursor + 1];
                if (bl) {
                    return this.bitsOrSingle(bitClass, n);
                }
                if (!bl) {
                    this.next();
                    int n2 = this.peek();
                    if (n2 == 92) {
                        n2 = this.escape(true, false, true);
                    } else {
                        this.next();
                    }
                    if (n2 < n) {
                        throw this.error("Illegal character range");
                    }
                    if (this.has(2)) {
                        return this.caseInsensitiveRangeFor(n, n2);
                    }
                    return Pattern.rangeFor(n, n2);
                }
            }
            return this.bitsOrSingle(bitClass, n);
        }
        throw this.error("Unexpected character '" + (char)n + "'");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private CharProperty family(boolean bl, boolean bl2) {
        String string;
        int n;
        this.next();
        CharProperty charProperty = null;
        if (bl) {
            n = this.temp[this.cursor];
            string = !Character.isSupplementaryCodePoint(n) ? String.valueOf((char)n) : new String(this.temp, this.cursor, 1);
            this.read();
        } else {
            n = this.cursor;
            this.mark(125);
            while (this.read() != 125) {
            }
            this.mark(0);
            int n2 = this.cursor;
            if (n2 > this.patternLength) {
                throw this.error("Unclosed character family");
            }
            if (n + 1 >= n2) {
                throw this.error("Empty character family");
            }
            string = new String(this.temp, n, n2 - n - 1);
        }
        n = string.indexOf(61);
        if (n != -1) {
            String string2 = string.substring(n + 1);
            if ("sc".equals(string = string.substring(0, n).toLowerCase(Locale.ENGLISH)) || "script".equals(string)) {
                charProperty = this.unicodeScriptPropertyFor(string2);
            } else if ("blk".equals(string) || "block".equals(string)) {
                charProperty = this.unicodeBlockPropertyFor(string2);
            } else {
                if (!"gc".equals(string)) {
                    if (!"general_category".equals(string)) throw this.error("Unknown Unicode property {name=<" + string + ">, value=<" + string2 + ">}");
                }
                charProperty = this.charPropertyNodeFor(string2);
            }
        } else if (string.startsWith("In")) {
            charProperty = this.unicodeBlockPropertyFor(string.substring(2));
        } else if (string.startsWith("Is")) {
            UnicodeProp unicodeProp = UnicodeProp.forName(string = string.substring(2));
            if (unicodeProp != null) {
                charProperty = new Utype(unicodeProp);
            }
            if (charProperty == null) {
                charProperty = CharPropertyNames.charPropertyFor(string);
            }
            if (charProperty == null) {
                charProperty = this.unicodeScriptPropertyFor(string);
            }
        } else {
            UnicodeProp unicodeProp;
            if (this.has(256) && (unicodeProp = UnicodeProp.forPOSIXName(string)) != null) {
                charProperty = new Utype(unicodeProp);
            }
            if (charProperty == null) {
                charProperty = this.charPropertyNodeFor(string);
            }
        }
        if (!bl2) return charProperty;
        if (!(charProperty instanceof Category)) {
            if (!(charProperty instanceof Block)) return charProperty.complement();
        }
        this.hasSupplementary = true;
        return charProperty.complement();
    }

    private CharProperty unicodeScriptPropertyFor(String string) {
        Character.UnicodeScript unicodeScript;
        try {
            unicodeScript = Character.UnicodeScript.forName(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw this.error("Unknown character script name {" + string + "}");
        }
        return new Script(unicodeScript);
    }

    private CharProperty unicodeBlockPropertyFor(String string) {
        Character.UnicodeBlock unicodeBlock;
        try {
            unicodeBlock = Character.UnicodeBlock.forName(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw this.error("Unknown character block name {" + string + "}");
        }
        return new Block(unicodeBlock);
    }

    private CharProperty charPropertyNodeFor(String string) {
        CharProperty charProperty = CharPropertyNames.charPropertyFor(string);
        if (charProperty == null) {
            throw this.error("Unknown character property name {" + string + "}");
        }
        return charProperty;
    }

    private String groupname(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Character.toChars(n));
        while (ASCII.isLower(n = this.read()) || ASCII.isUpper(n) || ASCII.isDigit(n)) {
            stringBuilder.append(Character.toChars(n));
        }
        if (stringBuilder.length() == 0) {
            throw this.error("named capturing group has 0 length name");
        }
        if (n != 62) {
            throw this.error("named capturing group is missing trailing '>'");
        }
        return stringBuilder.toString();
    }

    private Node group0() {
        Object object;
        Object object2;
        boolean bl = false;
        Node node = null;
        Node node2 = null;
        int n = this.flags;
        this.root = null;
        int n2 = this.next();
        if (n2 == 63) {
            n2 = this.skip();
            switch (n2) {
                case 58: {
                    node = this.createGroup(true);
                    node2 = this.root;
                    node.next = this.expr(node2);
                    break;
                }
                case 33: 
                case 61: {
                    node = this.createGroup(true);
                    node2 = this.root;
                    node.next = this.expr(node2);
                    if (n2 == 61) {
                        node = node2 = new Pos(node);
                        break;
                    }
                    node = node2 = new Neg(node);
                    break;
                }
                case 62: {
                    node = this.createGroup(true);
                    node2 = this.root;
                    node.next = this.expr(node2);
                    node = node2 = new Ques(node, 3);
                    break;
                }
                case 60: {
                    n2 = this.read();
                    if (ASCII.isLower(n2) || ASCII.isUpper(n2)) {
                        object2 = this.groupname(n2);
                        if (this.namedGroups().containsKey(object2)) {
                            throw this.error("Named capturing group <" + (String)object2 + "> is already defined");
                        }
                        bl = true;
                        node = this.createGroup(false);
                        node2 = this.root;
                        this.namedGroups().put((String)object2, this.capturingGroupCount - 1);
                        node.next = this.expr(node2);
                        break;
                    }
                    int n3 = this.cursor;
                    node = this.createGroup(true);
                    node2 = this.root;
                    node.next = this.expr(node2);
                    node2.next = lookbehindEnd;
                    object = new TreeInfo();
                    node.study((TreeInfo)object);
                    if (!((TreeInfo)object).maxValid) {
                        throw this.error("Look-behind group does not have an obvious maximum length");
                    }
                    boolean bl2 = this.findSupplementary(n3, this.patternLength);
                    if (n2 == 61) {
                        node2 = bl2 ? new BehindS(node, ((TreeInfo)object).maxLength, ((TreeInfo)object).minLength) : new Behind(node, ((TreeInfo)object).maxLength, ((TreeInfo)object).minLength);
                        node = node2;
                        break;
                    }
                    if (n2 == 33) {
                        node2 = bl2 ? new NotBehindS(node, ((TreeInfo)object).maxLength, ((TreeInfo)object).minLength) : new NotBehind(node, ((TreeInfo)object).maxLength, ((TreeInfo)object).minLength);
                        node = node2;
                        break;
                    }
                    throw this.error("Unknown look-behind group");
                }
                case 36: 
                case 64: {
                    throw this.error("Unknown group type");
                }
                default: {
                    this.unread();
                    this.addFlag();
                    n2 = this.read();
                    if (n2 == 41) {
                        return null;
                    }
                    if (n2 != 58) {
                        throw this.error("Unknown inline modifier");
                    }
                    node = this.createGroup(true);
                    node2 = this.root;
                    node.next = this.expr(node2);
                    break;
                }
            }
        } else {
            bl = true;
            node = this.createGroup(false);
            node2 = this.root;
            node.next = this.expr(node2);
        }
        this.accept(41, "Unclosed group");
        this.flags = n;
        object2 = this.closure(node);
        if (object2 == node) {
            this.root = node2;
            return object2;
        }
        if (node == node2) {
            this.root = object2;
            return object2;
        }
        if (object2 instanceof Ques) {
            object = (Ques)object2;
            if (((Ques)object).type == 2) {
                this.root = object2;
                return object2;
            }
            node2 = node2.next = new BranchConn();
            node = ((Ques)object).type == 0 ? new Branch(node, null, node2) : new Branch(null, node, node2);
            this.root = node2;
            return node;
        }
        if (object2 instanceof Curly) {
            object = (Curly)object2;
            if (((Curly)object).type == 2) {
                this.root = object2;
                return object2;
            }
            TreeInfo treeInfo = new TreeInfo();
            if (node.study(treeInfo)) {
                GroupTail groupTail = (GroupTail)node2;
                node = this.root = new GroupCurly(node.next, ((Curly)object).cmin, ((Curly)object).cmax, ((Curly)object).type, ((GroupTail)node2).localIndex, ((GroupTail)node2).groupIndex, bl);
                return node;
            }
            int n4 = ((GroupHead)node).localIndex;
            Loop loop = ((Curly)object).type == 0 ? new Loop(this.localCount, n4) : new LazyLoop(this.localCount, n4);
            Prolog prolog = new Prolog(loop);
            ++this.localCount;
            loop.cmin = ((Curly)object).cmin;
            loop.cmax = ((Curly)object).cmax;
            loop.body = node;
            node2.next = loop;
            this.root = loop;
            return prolog;
        }
        throw this.error("Internal logic error");
    }

    private Node createGroup(boolean bl) {
        int n = this.localCount++;
        int n2 = 0;
        if (!bl) {
            n2 = this.capturingGroupCount++;
        }
        GroupHead groupHead = new GroupHead(n);
        this.root = new GroupTail(n, n2);
        if (!bl && n2 < 10) {
            this.groupNodes[n2] = groupHead;
        }
        return groupHead;
    }

    private void addFlag() {
        int n = this.peek();
        while (true) {
            switch (n) {
                case 105: {
                    this.flags |= 2;
                    break;
                }
                case 109: {
                    this.flags |= 8;
                    break;
                }
                case 115: {
                    this.flags |= 0x20;
                    break;
                }
                case 100: {
                    this.flags |= 1;
                    break;
                }
                case 117: {
                    this.flags |= 0x40;
                    break;
                }
                case 99: {
                    this.flags |= 0x80;
                    break;
                }
                case 120: {
                    this.flags |= 4;
                    break;
                }
                case 85: {
                    this.flags |= 0x140;
                    break;
                }
                case 45: {
                    n = this.next();
                    this.subFlag();
                }
                default: {
                    return;
                }
            }
            n = this.next();
        }
    }

    private void subFlag() {
        int n = this.peek();
        while (true) {
            switch (n) {
                case 105: {
                    this.flags &= 0xFFFFFFFD;
                    break;
                }
                case 109: {
                    this.flags &= 0xFFFFFFF7;
                    break;
                }
                case 115: {
                    this.flags &= 0xFFFFFFDF;
                    break;
                }
                case 100: {
                    this.flags &= 0xFFFFFFFE;
                    break;
                }
                case 117: {
                    this.flags &= 0xFFFFFFBF;
                    break;
                }
                case 99: {
                    this.flags &= 0xFFFFFF7F;
                    break;
                }
                case 120: {
                    this.flags &= 0xFFFFFFFB;
                    break;
                }
                case 85: {
                    this.flags &= 0xFFFFFEBF;
                }
                default: {
                    return;
                }
            }
            n = this.next();
        }
    }

    private Node closure(Node node) {
        int n = this.peek();
        switch (n) {
            case 63: {
                n = this.next();
                if (n == 63) {
                    this.next();
                    return new Ques(node, 1);
                }
                if (n == 43) {
                    this.next();
                    return new Ques(node, 2);
                }
                return new Ques(node, 0);
            }
            case 42: {
                n = this.next();
                if (n == 63) {
                    this.next();
                    return new Curly(node, 0, Integer.MAX_VALUE, 1);
                }
                if (n == 43) {
                    this.next();
                    return new Curly(node, 0, Integer.MAX_VALUE, 2);
                }
                return new Curly(node, 0, Integer.MAX_VALUE, 0);
            }
            case 43: {
                n = this.next();
                if (n == 63) {
                    this.next();
                    return new Curly(node, 1, Integer.MAX_VALUE, 1);
                }
                if (n == 43) {
                    this.next();
                    return new Curly(node, 1, Integer.MAX_VALUE, 2);
                }
                return new Curly(node, 1, Integer.MAX_VALUE, 0);
            }
            case 123: {
                n = this.temp[this.cursor + 1];
                if (ASCII.isDigit(n)) {
                    Curly curly;
                    this.skip();
                    int n2 = 0;
                    do {
                        n2 = n2 * 10 + (n - 48);
                    } while (ASCII.isDigit(n = this.read()));
                    int n3 = n2;
                    if (n == 44) {
                        n = this.read();
                        n3 = Integer.MAX_VALUE;
                        if (n != 125) {
                            n3 = 0;
                            while (ASCII.isDigit(n)) {
                                n3 = n3 * 10 + (n - 48);
                                n = this.read();
                            }
                        }
                    }
                    if (n != 125) {
                        throw this.error("Unclosed counted closure");
                    }
                    if ((n2 | n3 | n3 - n2) < 0) {
                        throw this.error("Illegal repetition range");
                    }
                    n = this.peek();
                    if (n == 63) {
                        this.next();
                        curly = new Curly(node, n2, n3, 1);
                    } else if (n == 43) {
                        this.next();
                        curly = new Curly(node, n2, n3, 2);
                    } else {
                        curly = new Curly(node, n2, n3, 0);
                    }
                    return curly;
                }
                throw this.error("Illegal repetition");
            }
        }
        return node;
    }

    private int c() {
        if (this.cursor < this.patternLength) {
            return this.read() ^ 0x40;
        }
        throw this.error("Illegal control escape sequence");
    }

    private int o() {
        int n = this.read();
        if ((n - 48 | 55 - n) >= 0) {
            int n2 = this.read();
            if ((n2 - 48 | 55 - n2) >= 0) {
                int n3 = this.read();
                if ((n3 - 48 | 55 - n3) >= 0 && (n - 48 | 51 - n) >= 0) {
                    return (n - 48) * 64 + (n2 - 48) * 8 + (n3 - 48);
                }
                this.unread();
                return (n - 48) * 8 + (n2 - 48);
            }
            this.unread();
            return n - 48;
        }
        throw this.error("Illegal octal escape sequence");
    }

    private int x() {
        int n = this.read();
        if (ASCII.isHexDigit(n)) {
            int n2 = this.read();
            if (ASCII.isHexDigit(n2)) {
                return ASCII.toDigit(n) * 16 + ASCII.toDigit(n2);
            }
        } else if (n == 123 && ASCII.isHexDigit(this.peek())) {
            int n3 = 0;
            while (ASCII.isHexDigit(n = this.read())) {
                if ((n3 = (n3 << 4) + ASCII.toDigit(n)) <= 0x10FFFF) continue;
                throw this.error("Hexadecimal codepoint is too big");
            }
            if (n != 125) {
                throw this.error("Unclosed hexadecimal escape sequence");
            }
            return n3;
        }
        throw this.error("Illegal hexadecimal escape sequence");
    }

    private int cursor() {
        return this.cursor;
    }

    private void setcursor(int n) {
        this.cursor = n;
    }

    private int uxxxx() {
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            int n2 = this.read();
            if (!ASCII.isHexDigit(n2)) {
                throw this.error("Illegal Unicode escape sequence");
            }
            n = n * 16 + ASCII.toDigit(n2);
        }
        return n;
    }

    private int u() {
        int n = this.uxxxx();
        if (Character.isHighSurrogate((char)n)) {
            int n2;
            int n3 = this.cursor();
            if (this.read() == 92 && this.read() == 117 && Character.isLowSurrogate((char)(n2 = this.uxxxx()))) {
                return Character.toCodePoint((char)n, (char)n2);
            }
            this.setcursor(n3);
        }
        return n;
    }

    private static final int countChars(CharSequence charSequence, int n, int n2) {
        if (n2 == 1 && !Character.isHighSurrogate(charSequence.charAt(n))) {
            assert (n >= 0 && n < charSequence.length());
            return 1;
        }
        int n3 = charSequence.length();
        int n4 = n;
        if (n2 >= 0) {
            assert (n >= 0 && n < n3);
            for (int i = 0; n4 < n3 && i < n2; ++i) {
                if (!Character.isHighSurrogate(charSequence.charAt(n4++)) || n4 >= n3 || !Character.isLowSurrogate(charSequence.charAt(n4))) continue;
                ++n4;
            }
            return n4 - n;
        }
        assert (n >= 0 && n <= n3);
        if (n == 0) {
            return 0;
        }
        int n5 = -n2;
        for (int i = 0; n4 > 0 && i < n5; ++i) {
            if (!Character.isLowSurrogate(charSequence.charAt(--n4)) || n4 <= 0 || !Character.isHighSurrogate(charSequence.charAt(n4 - 1))) continue;
            --n4;
        }
        return n - n4;
    }

    private static final int countCodePoints(CharSequence charSequence) {
        int n = charSequence.length();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            ++n2;
            if (!Character.isHighSurrogate(charSequence.charAt(n3++)) || n3 >= n || !Character.isLowSurrogate(charSequence.charAt(n3))) continue;
            ++n3;
        }
        return n2;
    }

    private CharProperty newSingle(int n) {
        if (this.has(2)) {
            int n2;
            int n3;
            if (this.has(64)) {
                int n4;
                int n5 = Character.toUpperCase(n);
                if (n5 != (n4 = Character.toLowerCase(n5))) {
                    return new SingleU(n4);
                }
            } else if (ASCII.isAscii(n) && (n3 = ASCII.toLower(n)) != (n2 = ASCII.toUpper(n))) {
                return new SingleI(n3, n2);
            }
        }
        if (Pattern.isSupplementary(n)) {
            return new SingleS(n);
        }
        return new Single(n);
    }

    private Node newSlice(int[] nArray, int n, boolean bl) {
        int[] nArray2 = new int[n];
        if (this.has(2)) {
            if (this.has(64)) {
                for (int i = 0; i < n; ++i) {
                    nArray2[i] = Character.toLowerCase(Character.toUpperCase(nArray[i]));
                }
                return bl ? new SliceUS(nArray2) : new SliceU(nArray2);
            }
            for (int i = 0; i < n; ++i) {
                nArray2[i] = ASCII.toLower(nArray[i]);
            }
            return bl ? new SliceIS(nArray2) : new SliceI(nArray2);
        }
        for (int i = 0; i < n; ++i) {
            nArray2[i] = nArray[i];
        }
        return bl ? new SliceS(nArray2) : new Slice(nArray2);
    }

    private static boolean inRange(int n, int n2, int n3) {
        return n <= n2 && n2 <= n3;
    }

    private static CharProperty rangeFor(final int n, final int n2) {
        return new CharProperty(){

            @Override
            boolean isSatisfiedBy(int n3) {
                return Pattern.inRange(n, n3, n2);
            }
        };
    }

    private CharProperty caseInsensitiveRangeFor(final int n, final int n2) {
        if (this.has(64)) {
            return new CharProperty(){

                @Override
                boolean isSatisfiedBy(int n3) {
                    if (Pattern.inRange(n, n3, n2)) {
                        return true;
                    }
                    int n22 = Character.toUpperCase(n3);
                    return Pattern.inRange(n, n22, n2) || Pattern.inRange(n, Character.toLowerCase(n22), n2);
                }
            };
        }
        return new CharProperty(){

            @Override
            boolean isSatisfiedBy(int n3) {
                return Pattern.inRange(n, n3, n2) || ASCII.isAscii(n3) && (Pattern.inRange(n, ASCII.toUpper(n3), n2) || Pattern.inRange(n, ASCII.toLower(n3), n2));
            }
        };
    }

    private static CharProperty union(final CharProperty charProperty, final CharProperty charProperty2) {
        return new CharProperty(){

            @Override
            boolean isSatisfiedBy(int n) {
                return charProperty.isSatisfiedBy(n) || charProperty2.isSatisfiedBy(n);
            }
        };
    }

    private static CharProperty intersection(final CharProperty charProperty, final CharProperty charProperty2) {
        return new CharProperty(){

            @Override
            boolean isSatisfiedBy(int n) {
                return charProperty.isSatisfiedBy(n) && charProperty2.isSatisfiedBy(n);
            }
        };
    }

    private static CharProperty setDifference(final CharProperty charProperty, final CharProperty charProperty2) {
        return new CharProperty(){

            @Override
            boolean isSatisfiedBy(int n) {
                return !charProperty2.isSatisfiedBy(n) && charProperty.isSatisfiedBy(n);
            }
        };
    }

    private static boolean hasBaseCharacter(Matcher matcher, int n, CharSequence charSequence) {
        int n2 = !matcher.transparentBounds ? matcher.from : 0;
        for (int i = n; i >= n2; --i) {
            int n3 = Character.codePointAt(charSequence, i);
            if (Character.isLetterOrDigit(n3)) {
                return true;
            }
            if (Character.getType(n3) == 6) continue;
            return false;
        }
        return false;
    }

    public Predicate<String> asPredicate() {
        return string -> this.matcher((CharSequence)string).find();
    }

    public Stream<String> splitAsStream(final CharSequence charSequence) {
        class MatcherIterator
        implements Iterator<String> {
            private final Matcher matcher;
            private int current;
            private String nextElement;
            private int emptyElementCount;

            MatcherIterator() {
                this.matcher = Pattern.this.matcher(charSequence);
            }

            @Override
            public String next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                if (this.emptyElementCount == 0) {
                    String string = this.nextElement;
                    this.nextElement = null;
                    return string;
                }
                --this.emptyElementCount;
                return "";
            }

            @Override
            public boolean hasNext() {
                if (this.nextElement != null || this.emptyElementCount > 0) {
                    return true;
                }
                if (this.current == charSequence.length()) {
                    return false;
                }
                while (this.matcher.find()) {
                    this.nextElement = charSequence.subSequence(this.current, this.matcher.start()).toString();
                    this.current = this.matcher.end();
                    if (!this.nextElement.isEmpty()) {
                        return true;
                    }
                    if (this.current <= 0) continue;
                    ++this.emptyElementCount;
                }
                this.nextElement = charSequence.subSequence(this.current, charSequence.length()).toString();
                this.current = charSequence.length();
                if (!this.nextElement.isEmpty()) {
                    return true;
                }
                this.emptyElementCount = 0;
                this.nextElement = null;
                return false;
            }
        }
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(new MatcherIterator(), 272), false);
    }

    private static class CharPropertyNames {
        private static final HashMap<String, CharPropertyFactory> map = new HashMap();

        private CharPropertyNames() {
        }

        static CharProperty charPropertyFor(String string) {
            CharPropertyFactory charPropertyFactory = map.get(string);
            return charPropertyFactory == null ? null : charPropertyFactory.make();
        }

        private static void defCategory(String string, final int n) {
            map.put(string, new CharPropertyFactory(){

                @Override
                CharProperty make() {
                    return new Category(n);
                }
            });
        }

        private static void defRange(String string, final int n, final int n2) {
            map.put(string, new CharPropertyFactory(){

                @Override
                CharProperty make() {
                    return Pattern.rangeFor(n, n2);
                }
            });
        }

        private static void defCtype(String string, final int n) {
            map.put(string, new CharPropertyFactory(){

                @Override
                CharProperty make() {
                    return new Ctype(n);
                }
            });
        }

        private static void defClone(String string, final CloneableProperty cloneableProperty) {
            map.put(string, new CharPropertyFactory(){

                @Override
                CharProperty make() {
                    return cloneableProperty.clone();
                }
            });
        }

        static {
            CharPropertyNames.defCategory("Cn", 1);
            CharPropertyNames.defCategory("Lu", 2);
            CharPropertyNames.defCategory("Ll", 4);
            CharPropertyNames.defCategory("Lt", 8);
            CharPropertyNames.defCategory("Lm", 16);
            CharPropertyNames.defCategory("Lo", 32);
            CharPropertyNames.defCategory("Mn", 64);
            CharPropertyNames.defCategory("Me", 128);
            CharPropertyNames.defCategory("Mc", 256);
            CharPropertyNames.defCategory("Nd", 512);
            CharPropertyNames.defCategory("Nl", 1024);
            CharPropertyNames.defCategory("No", 2048);
            CharPropertyNames.defCategory("Zs", 4096);
            CharPropertyNames.defCategory("Zl", 8192);
            CharPropertyNames.defCategory("Zp", 16384);
            CharPropertyNames.defCategory("Cc", 32768);
            CharPropertyNames.defCategory("Cf", 65536);
            CharPropertyNames.defCategory("Co", 262144);
            CharPropertyNames.defCategory("Cs", 524288);
            CharPropertyNames.defCategory("Pd", 0x100000);
            CharPropertyNames.defCategory("Ps", 0x200000);
            CharPropertyNames.defCategory("Pe", 0x400000);
            CharPropertyNames.defCategory("Pc", 0x800000);
            CharPropertyNames.defCategory("Po", 0x1000000);
            CharPropertyNames.defCategory("Sm", 0x2000000);
            CharPropertyNames.defCategory("Sc", 0x4000000);
            CharPropertyNames.defCategory("Sk", 0x8000000);
            CharPropertyNames.defCategory("So", 0x10000000);
            CharPropertyNames.defCategory("Pi", 0x20000000);
            CharPropertyNames.defCategory("Pf", 0x40000000);
            CharPropertyNames.defCategory("L", 62);
            CharPropertyNames.defCategory("M", 448);
            CharPropertyNames.defCategory("N", 3584);
            CharPropertyNames.defCategory("Z", 28672);
            CharPropertyNames.defCategory("C", 884736);
            CharPropertyNames.defCategory("P", 1643118592);
            CharPropertyNames.defCategory("S", 0x1E000000);
            CharPropertyNames.defCategory("LC", 14);
            CharPropertyNames.defCategory("LD", 574);
            CharPropertyNames.defRange("L1", 0, 255);
            map.put("all", new CharPropertyFactory(){

                @Override
                CharProperty make() {
                    return new All();
                }
            });
            CharPropertyNames.defRange("ASCII", 0, 127);
            CharPropertyNames.defCtype("Alnum", 1792);
            CharPropertyNames.defCtype("Alpha", 768);
            CharPropertyNames.defCtype("Blank", 16384);
            CharPropertyNames.defCtype("Cntrl", 8192);
            CharPropertyNames.defRange("Digit", 48, 57);
            CharPropertyNames.defCtype("Graph", 5888);
            CharPropertyNames.defRange("Lower", 97, 122);
            CharPropertyNames.defRange("Print", 32, 126);
            CharPropertyNames.defCtype("Punct", 4096);
            CharPropertyNames.defCtype("Space", 2048);
            CharPropertyNames.defRange("Upper", 65, 90);
            CharPropertyNames.defCtype("XDigit", 32768);
            CharPropertyNames.defClone("javaLowerCase", new CloneableProperty(){

                @Override
                boolean isSatisfiedBy(int n) {
                    return Character.isLowerCase(n);
                }
            });
            CharPropertyNames.defClone("javaUpperCase", new CloneableProperty(){

                @Override
                boolean isSatisfiedBy(int n) {
                    return Character.isUpperCase(n);
                }
            });
            CharPropertyNames.defClone("javaAlphabetic", new CloneableProperty(){

                @Override
                boolean isSatisfiedBy(int n) {
                    return Character.isAlphabetic(n);
                }
            });
            CharPropertyNames.defClone("javaIdeographic", new CloneableProperty(){

                @Override
                boolean isSatisfiedBy(int n) {
                    return Character.isIdeographic(n);
                }
            });
            CharPropertyNames.defClone("javaTitleCase", new CloneableProperty(){

                @Override
                boolean isSatisfiedBy(int n) {
                    return Character.isTitleCase(n);
                }
            });
            CharPropertyNames.defClone("javaDigit", new CloneableProperty(){

                @Override
                boolean isSatisfiedBy(int n) {
                    return Character.isDigit(n);
                }
            });
            CharPropertyNames.defClone("javaDefined", new CloneableProperty(){

                @Override
                boolean isSatisfiedBy(int n) {
                    return Character.isDefined(n);
                }
            });
            CharPropertyNames.defClone("javaLetter", new CloneableProperty(){

                @Override
                boolean isSatisfiedBy(int n) {
                    return Character.isLetter(n);
                }
            });
            CharPropertyNames.defClone("javaLetterOrDigit", new CloneableProperty(){

                @Override
                boolean isSatisfiedBy(int n) {
                    return Character.isLetterOrDigit(n);
                }
            });
            CharPropertyNames.defClone("javaJavaIdentifierStart", new CloneableProperty(){

                @Override
                boolean isSatisfiedBy(int n) {
                    return Character.isJavaIdentifierStart(n);
                }
            });
            CharPropertyNames.defClone("javaJavaIdentifierPart", new CloneableProperty(){

                @Override
                boolean isSatisfiedBy(int n) {
                    return Character.isJavaIdentifierPart(n);
                }
            });
            CharPropertyNames.defClone("javaUnicodeIdentifierStart", new CloneableProperty(){

                @Override
                boolean isSatisfiedBy(int n) {
                    return Character.isUnicodeIdentifierStart(n);
                }
            });
            CharPropertyNames.defClone("javaUnicodeIdentifierPart", new CloneableProperty(){

                @Override
                boolean isSatisfiedBy(int n) {
                    return Character.isUnicodeIdentifierPart(n);
                }
            });
            CharPropertyNames.defClone("javaIdentifierIgnorable", new CloneableProperty(){

                @Override
                boolean isSatisfiedBy(int n) {
                    return Character.isIdentifierIgnorable(n);
                }
            });
            CharPropertyNames.defClone("javaSpaceChar", new CloneableProperty(){

                @Override
                boolean isSatisfiedBy(int n) {
                    return Character.isSpaceChar(n);
                }
            });
            CharPropertyNames.defClone("javaWhitespace", new CloneableProperty(){

                @Override
                boolean isSatisfiedBy(int n) {
                    return Character.isWhitespace(n);
                }
            });
            CharPropertyNames.defClone("javaISOControl", new CloneableProperty(){

                @Override
                boolean isSatisfiedBy(int n) {
                    return Character.isISOControl(n);
                }
            });
            CharPropertyNames.defClone("javaMirrored", new CloneableProperty(){

                @Override
                boolean isSatisfiedBy(int n) {
                    return Character.isMirrored(n);
                }
            });
        }

        private static abstract class CloneableProperty
        extends CharProperty
        implements Cloneable {
            private CloneableProperty() {
            }

            public CloneableProperty clone() {
                try {
                    return (CloneableProperty)super.clone();
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    throw new AssertionError((Object)cloneNotSupportedException);
                }
            }
        }

        private static abstract class CharPropertyFactory {
            private CharPropertyFactory() {
            }

            abstract CharProperty make();
        }
    }

    static final class BnMS
    extends BnM {
        int lengthInChars;

        BnMS(int[] nArray, int[] nArray2, int[] nArray3, Node node) {
            super(nArray, nArray2, nArray3, node);
            for (int i = 0; i < this.buffer.length; ++i) {
                this.lengthInChars += Character.charCount(this.buffer[i]);
            }
        }

        @Override
        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            int[] nArray = this.buffer;
            int n2 = nArray.length;
            int n3 = matcher.to - this.lengthInChars;
            block0: while (n <= n3) {
                int n4 = Pattern.countChars(charSequence, n, n2);
                int n5 = n2 - 1;
                while (n4 > 0) {
                    int n6 = Character.codePointBefore(charSequence, n + n4);
                    if (n6 != nArray[n5]) {
                        int n7 = Math.max(n5 + 1 - this.lastOcc[n6 & 0x7F], this.optoSft[n5]);
                        n += Pattern.countChars(charSequence, n, n7);
                        continue block0;
                    }
                    n4 -= Character.charCount(n6);
                    --n5;
                }
                matcher.first = n;
                n4 = this.next.match(matcher, n + this.lengthInChars, charSequence) ? 1 : 0;
                if (n4 != 0) {
                    matcher.groups[0] = matcher.first = n;
                    matcher.groups[1] = matcher.last;
                    return true;
                }
                n += Pattern.countChars(charSequence, n, 1);
            }
            matcher.hitEnd = true;
            return false;
        }
    }

    static class BnM
    extends Node {
        int[] buffer;
        int[] lastOcc;
        int[] optoSft;

        static Node optimize(Node node) {
            int n;
            if (!(node instanceof Slice)) {
                return node;
            }
            int[] nArray = ((Slice)node).buffer;
            int n2 = nArray.length;
            if (n2 < 4) {
                return node;
            }
            int[] nArray2 = new int[128];
            int[] nArray3 = new int[n2];
            for (n = 0; n < n2; ++n) {
                nArray2[nArray[n] & 0x7F] = n + 1;
            }
            block1: for (n = n2; n > 0; --n) {
                int n3;
                for (n3 = n2 - 1; n3 >= n; --n3) {
                    if (nArray[n3] != nArray[n3 - n]) continue block1;
                    nArray3[n3 - 1] = n;
                }
                while (n3 > 0) {
                    nArray3[--n3] = n;
                }
            }
            nArray3[n2 - 1] = 1;
            if (node instanceof SliceS) {
                return new BnMS(nArray, nArray2, nArray3, node.next);
            }
            return new BnM(nArray, nArray2, nArray3, node.next);
        }

        BnM(int[] nArray, int[] nArray2, int[] nArray3, Node node) {
            this.buffer = nArray;
            this.lastOcc = nArray2;
            this.optoSft = nArray3;
            this.next = node;
        }

        @Override
        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            int[] nArray = this.buffer;
            int n2 = nArray.length;
            int n3 = matcher.to - n2;
            block0: while (n <= n3) {
                int n4;
                for (n4 = n2 - 1; n4 >= 0; --n4) {
                    char c = charSequence.charAt(n + n4);
                    if (c == nArray[n4]) continue;
                    n += Math.max(n4 + 1 - this.lastOcc[c & 0x7F], this.optoSft[n4]);
                    continue block0;
                }
                matcher.first = n;
                n4 = this.next.match(matcher, n + n2, charSequence) ? 1 : 0;
                if (n4 != 0) {
                    matcher.groups[0] = matcher.first = n;
                    matcher.groups[1] = matcher.last;
                    return true;
                }
                ++n;
            }
            matcher.hitEnd = true;
            return false;
        }

        @Override
        boolean study(TreeInfo treeInfo) {
            treeInfo.minLength += this.buffer.length;
            treeInfo.maxValid = false;
            return this.next.study(treeInfo);
        }
    }

    static final class Bound
    extends Node {
        static int LEFT = 1;
        static int RIGHT = 2;
        static int BOTH = 3;
        static int NONE = 4;
        int type;
        boolean useUWORD;

        Bound(int n, boolean bl) {
            this.type = n;
            this.useUWORD = bl;
        }

        boolean isWord(int n) {
            return this.useUWORD ? UnicodeProp.WORD.is(n) : n == 95 || Character.isLetterOrDigit(n);
        }

        int check(Matcher matcher, int n, CharSequence charSequence) {
            int n2;
            boolean bl = false;
            int n3 = matcher.from;
            int n4 = matcher.to;
            if (matcher.transparentBounds) {
                n3 = 0;
                n4 = matcher.getTextLength();
            }
            if (n > n3) {
                n2 = Character.codePointBefore(charSequence, n);
                bl = this.isWord(n2) || Character.getType(n2) == 6 && Pattern.hasBaseCharacter(matcher, n - 1, charSequence);
            }
            boolean bl2 = false;
            if (n < n4) {
                n2 = Character.codePointAt(charSequence, n);
                bl2 = this.isWord(n2) || Character.getType(n2) == 6 && Pattern.hasBaseCharacter(matcher, n, charSequence);
            } else {
                matcher.hitEnd = true;
                matcher.requireEnd = true;
            }
            return bl ^ bl2 ? (bl2 ? LEFT : RIGHT) : NONE;
        }

        @Override
        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            return (this.check(matcher, n, charSequence) & this.type) > 0 && this.next.match(matcher, n, charSequence);
        }
    }

    static final class NotBehindS
    extends NotBehind {
        NotBehindS(Node node, int n, int n2) {
            super(node, n, n2);
        }

        @Override
        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            int n2 = Pattern.countChars(charSequence, n, -this.rmax);
            int n3 = Pattern.countChars(charSequence, n, -this.rmin);
            int n4 = matcher.from;
            int n5 = matcher.lookbehindTo;
            boolean bl = false;
            int n6 = !matcher.transparentBounds ? matcher.from : 0;
            int n7 = Math.max(n - n2, n6);
            matcher.lookbehindTo = n;
            if (matcher.transparentBounds) {
                matcher.from = 0;
            }
            for (int i = n - n3; !bl && i >= n7; i -= i > n7 ? Pattern.countChars(charSequence, i, -1) : 1) {
                bl = this.cond.match(matcher, i, charSequence);
            }
            matcher.from = n4;
            matcher.lookbehindTo = n5;
            return !bl && this.next.match(matcher, n, charSequence);
        }
    }

    static class NotBehind
    extends Node {
        Node cond;
        int rmax;
        int rmin;

        NotBehind(Node node, int n, int n2) {
            this.cond = node;
            this.rmax = n;
            this.rmin = n2;
        }

        @Override
        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            int n2 = matcher.lookbehindTo;
            int n3 = matcher.from;
            boolean bl = false;
            int n4 = !matcher.transparentBounds ? matcher.from : 0;
            int n5 = Math.max(n - this.rmax, n4);
            matcher.lookbehindTo = n;
            if (matcher.transparentBounds) {
                matcher.from = 0;
            }
            for (int i = n - this.rmin; !bl && i >= n5; --i) {
                bl = this.cond.match(matcher, i, charSequence);
            }
            matcher.from = n3;
            matcher.lookbehindTo = n2;
            return !bl && this.next.match(matcher, n, charSequence);
        }
    }

    static final class BehindS
    extends Behind {
        BehindS(Node node, int n, int n2) {
            super(node, n, n2);
        }

        @Override
        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            int n2 = Pattern.countChars(charSequence, n, -this.rmax);
            int n3 = Pattern.countChars(charSequence, n, -this.rmin);
            int n4 = matcher.from;
            int n5 = !matcher.transparentBounds ? matcher.from : 0;
            boolean bl = false;
            int n6 = Math.max(n - n2, n5);
            int n7 = matcher.lookbehindTo;
            matcher.lookbehindTo = n;
            if (matcher.transparentBounds) {
                matcher.from = 0;
            }
            for (int i = n - n3; !bl && i >= n6; i -= i > n6 ? Pattern.countChars(charSequence, i, -1) : 1) {
                bl = this.cond.match(matcher, i, charSequence);
            }
            matcher.from = n4;
            matcher.lookbehindTo = n7;
            return bl && this.next.match(matcher, n, charSequence);
        }
    }

    static class Behind
    extends Node {
        Node cond;
        int rmax;
        int rmin;

        Behind(Node node, int n, int n2) {
            this.cond = node;
            this.rmax = n;
            this.rmin = n2;
        }

        @Override
        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            int n2 = matcher.from;
            boolean bl = false;
            int n3 = !matcher.transparentBounds ? matcher.from : 0;
            int n4 = Math.max(n - this.rmax, n3);
            int n5 = matcher.lookbehindTo;
            matcher.lookbehindTo = n;
            if (matcher.transparentBounds) {
                matcher.from = 0;
            }
            for (int i = n - this.rmin; !bl && i >= n4; --i) {
                bl = this.cond.match(matcher, i, charSequence);
            }
            matcher.from = n2;
            matcher.lookbehindTo = n5;
            return bl && this.next.match(matcher, n, charSequence);
        }
    }

    static final class Neg
    extends Node {
        Node cond;

        Neg(Node node) {
            this.cond = node;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            int n2 = matcher.to;
            boolean bl = false;
            if (matcher.transparentBounds) {
                matcher.to = matcher.getTextLength();
            }
            try {
                if (n < matcher.to) {
                    bl = !this.cond.match(matcher, n, charSequence);
                } else {
                    matcher.requireEnd = true;
                    bl = !this.cond.match(matcher, n, charSequence);
                }
            }
            finally {
                matcher.to = n2;
            }
            return bl && this.next.match(matcher, n, charSequence);
        }
    }

    static final class Pos
    extends Node {
        Node cond;

        Pos(Node node) {
            this.cond = node;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            int n2 = matcher.to;
            boolean bl = false;
            if (matcher.transparentBounds) {
                matcher.to = matcher.getTextLength();
            }
            try {
                bl = this.cond.match(matcher, n, charSequence);
            }
            finally {
                matcher.to = n2;
            }
            return bl && this.next.match(matcher, n, charSequence);
        }
    }

    static final class Conditional
    extends Node {
        Node cond;
        Node yes;
        Node not;

        Conditional(Node node, Node node2, Node node3) {
            this.cond = node;
            this.yes = node2;
            this.not = node3;
        }

        @Override
        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            if (this.cond.match(matcher, n, charSequence)) {
                return this.yes.match(matcher, n, charSequence);
            }
            return this.not.match(matcher, n, charSequence);
        }

        @Override
        boolean study(TreeInfo treeInfo) {
            int n = treeInfo.minLength;
            int n2 = treeInfo.maxLength;
            boolean bl = treeInfo.maxValid;
            treeInfo.reset();
            this.yes.study(treeInfo);
            int n3 = treeInfo.minLength;
            int n4 = treeInfo.maxLength;
            boolean bl2 = treeInfo.maxValid;
            treeInfo.reset();
            this.not.study(treeInfo);
            treeInfo.minLength = n + Math.min(n3, treeInfo.minLength);
            treeInfo.maxLength = n2 + Math.max(n4, treeInfo.maxLength);
            treeInfo.maxValid = bl & bl2 & treeInfo.maxValid;
            treeInfo.deterministic = false;
            return this.next.study(treeInfo);
        }
    }

    static final class First
    extends Node {
        Node atom;

        First(Node node) {
            this.atom = BnM.optimize(node);
        }

        @Override
        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            if (this.atom instanceof BnM) {
                return this.atom.match(matcher, n, charSequence) && this.next.match(matcher, matcher.last, charSequence);
            }
            while (true) {
                if (n > matcher.to) {
                    matcher.hitEnd = true;
                    return false;
                }
                if (this.atom.match(matcher, n, charSequence)) {
                    return this.next.match(matcher, matcher.last, charSequence);
                }
                n += Pattern.countChars(charSequence, n, 1);
                ++matcher.first;
            }
        }

        @Override
        boolean study(TreeInfo treeInfo) {
            this.atom.study(treeInfo);
            treeInfo.maxValid = false;
            treeInfo.deterministic = false;
            return this.next.study(treeInfo);
        }
    }

    static class CIBackRef
    extends Node {
        int groupIndex;
        boolean doUnicodeCase;

        CIBackRef(int n, boolean bl) {
            this.groupIndex = n + n;
            this.doUnicodeCase = bl;
        }

        @Override
        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            int n2 = matcher.groups[this.groupIndex];
            int n3 = matcher.groups[this.groupIndex + 1];
            int n4 = n3 - n2;
            if (n2 < 0) {
                return false;
            }
            if (n + n4 > matcher.to) {
                matcher.hitEnd = true;
                return false;
            }
            int n5 = n;
            for (int i = 0; i < n4; ++i) {
                int n6;
                int n7;
                int n8;
                int n9 = Character.codePointAt(charSequence, n5);
                if (n9 != (n8 = Character.codePointAt(charSequence, n2)) && (this.doUnicodeCase ? (n7 = Character.toUpperCase(n9)) != (n6 = Character.toUpperCase(n8)) && Character.toLowerCase(n7) != Character.toLowerCase(n6) : ASCII.toLower(n9) != ASCII.toLower(n8))) {
                    return false;
                }
                n5 += Character.charCount(n9);
                n2 += Character.charCount(n8);
            }
            return this.next.match(matcher, n + n4, charSequence);
        }

        @Override
        boolean study(TreeInfo treeInfo) {
            treeInfo.maxValid = false;
            return this.next.study(treeInfo);
        }
    }

    static class BackRef
    extends Node {
        int groupIndex;

        BackRef(int n) {
            this.groupIndex = n + n;
        }

        @Override
        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            int n2 = matcher.groups[this.groupIndex];
            int n3 = matcher.groups[this.groupIndex + 1];
            int n4 = n3 - n2;
            if (n2 < 0) {
                return false;
            }
            if (n + n4 > matcher.to) {
                matcher.hitEnd = true;
                return false;
            }
            for (int i = 0; i < n4; ++i) {
                if (charSequence.charAt(n + i) == charSequence.charAt(n2 + i)) continue;
                return false;
            }
            return this.next.match(matcher, n + n4, charSequence);
        }

        @Override
        boolean study(TreeInfo treeInfo) {
            treeInfo.maxValid = false;
            return this.next.study(treeInfo);
        }
    }

    static final class LazyLoop
    extends Loop {
        LazyLoop(int n, int n2) {
            super(n, n2);
        }

        @Override
        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            if (n > matcher.locals[this.beginIndex]) {
                int n2 = matcher.locals[this.countIndex];
                if (n2 < this.cmin) {
                    matcher.locals[this.countIndex] = n2 + 1;
                    boolean bl = this.body.match(matcher, n, charSequence);
                    if (!bl) {
                        matcher.locals[this.countIndex] = n2;
                    }
                    return bl;
                }
                if (this.next.match(matcher, n, charSequence)) {
                    return true;
                }
                if (n2 < this.cmax) {
                    matcher.locals[this.countIndex] = n2 + 1;
                    boolean bl = this.body.match(matcher, n, charSequence);
                    if (!bl) {
                        matcher.locals[this.countIndex] = n2;
                    }
                    return bl;
                }
                return false;
            }
            return this.next.match(matcher, n, charSequence);
        }

        @Override
        boolean matchInit(Matcher matcher, int n, CharSequence charSequence) {
            int n2 = matcher.locals[this.countIndex];
            boolean bl = false;
            if (0 < this.cmin) {
                matcher.locals[this.countIndex] = 1;
                bl = this.body.match(matcher, n, charSequence);
            } else if (this.next.match(matcher, n, charSequence)) {
                bl = true;
            } else if (0 < this.cmax) {
                matcher.locals[this.countIndex] = 1;
                bl = this.body.match(matcher, n, charSequence);
            }
            matcher.locals[this.countIndex] = n2;
            return bl;
        }

        @Override
        boolean study(TreeInfo treeInfo) {
            treeInfo.maxValid = false;
            treeInfo.deterministic = false;
            return false;
        }
    }

    static class Loop
    extends Node {
        Node body;
        int countIndex;
        int beginIndex;
        int cmin;
        int cmax;

        Loop(int n, int n2) {
            this.countIndex = n;
            this.beginIndex = n2;
        }

        @Override
        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            if (n > matcher.locals[this.beginIndex]) {
                int n2 = matcher.locals[this.countIndex];
                if (n2 < this.cmin) {
                    matcher.locals[this.countIndex] = n2 + 1;
                    boolean bl = this.body.match(matcher, n, charSequence);
                    if (!bl) {
                        matcher.locals[this.countIndex] = n2;
                    }
                    return bl;
                }
                if (n2 < this.cmax) {
                    matcher.locals[this.countIndex] = n2 + 1;
                    boolean bl = this.body.match(matcher, n, charSequence);
                    if (!bl) {
                        matcher.locals[this.countIndex] = n2;
                    } else {
                        return true;
                    }
                }
            }
            return this.next.match(matcher, n, charSequence);
        }

        boolean matchInit(Matcher matcher, int n, CharSequence charSequence) {
            int n2 = matcher.locals[this.countIndex];
            boolean bl = false;
            if (0 < this.cmin) {
                matcher.locals[this.countIndex] = 1;
                bl = this.body.match(matcher, n, charSequence);
            } else if (0 < this.cmax) {
                matcher.locals[this.countIndex] = 1;
                bl = this.body.match(matcher, n, charSequence);
                if (!bl) {
                    bl = this.next.match(matcher, n, charSequence);
                }
            } else {
                bl = this.next.match(matcher, n, charSequence);
            }
            matcher.locals[this.countIndex] = n2;
            return bl;
        }

        @Override
        boolean study(TreeInfo treeInfo) {
            treeInfo.maxValid = false;
            treeInfo.deterministic = false;
            return false;
        }
    }

    static final class Prolog
    extends Node {
        Loop loop;

        Prolog(Loop loop) {
            this.loop = loop;
        }

        @Override
        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            return this.loop.matchInit(matcher, n, charSequence);
        }

        @Override
        boolean study(TreeInfo treeInfo) {
            return this.loop.study(treeInfo);
        }
    }

    static final class GroupTail
    extends Node {
        int localIndex;
        int groupIndex;

        GroupTail(int n, int n2) {
            this.localIndex = n;
            this.groupIndex = n2 + n2;
        }

        @Override
        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            int n2 = matcher.locals[this.localIndex];
            if (n2 >= 0) {
                int n3 = matcher.groups[this.groupIndex];
                int n4 = matcher.groups[this.groupIndex + 1];
                matcher.groups[this.groupIndex] = n2;
                matcher.groups[this.groupIndex + 1] = n;
                if (this.next.match(matcher, n, charSequence)) {
                    return true;
                }
                matcher.groups[this.groupIndex] = n3;
                matcher.groups[this.groupIndex + 1] = n4;
                return false;
            }
            matcher.last = n;
            return true;
        }
    }

    static final class GroupRef
    extends Node {
        GroupHead head;

        GroupRef(GroupHead groupHead) {
            this.head = groupHead;
        }

        @Override
        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            return this.head.matchRef(matcher, n, charSequence) && this.next.match(matcher, matcher.last, charSequence);
        }

        @Override
        boolean study(TreeInfo treeInfo) {
            treeInfo.maxValid = false;
            treeInfo.deterministic = false;
            return this.next.study(treeInfo);
        }
    }

    static final class GroupHead
    extends Node {
        int localIndex;

        GroupHead(int n) {
            this.localIndex = n;
        }

        @Override
        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            int n2 = matcher.locals[this.localIndex];
            matcher.locals[this.localIndex] = n;
            boolean bl = this.next.match(matcher, n, charSequence);
            matcher.locals[this.localIndex] = n2;
            return bl;
        }

        boolean matchRef(Matcher matcher, int n, CharSequence charSequence) {
            int n2 = matcher.locals[this.localIndex];
            matcher.locals[this.localIndex] = ~n;
            boolean bl = this.next.match(matcher, n, charSequence);
            matcher.locals[this.localIndex] = n2;
            return bl;
        }
    }

    static final class Branch
    extends Node {
        Node[] atoms = new Node[2];
        int size = 2;
        Node conn;

        Branch(Node node, Node node2, Node node3) {
            this.conn = node3;
            this.atoms[0] = node;
            this.atoms[1] = node2;
        }

        void add(Node node) {
            if (this.size >= this.atoms.length) {
                Node[] nodeArray = new Node[this.atoms.length * 2];
                System.arraycopy(this.atoms, 0, nodeArray, 0, this.atoms.length);
                this.atoms = nodeArray;
            }
            this.atoms[this.size++] = node;
        }

        @Override
        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            for (int i = 0; i < this.size; ++i) {
                if (!(this.atoms[i] == null ? this.conn.next.match(matcher, n, charSequence) : this.atoms[i].match(matcher, n, charSequence))) continue;
                return true;
            }
            return false;
        }

        @Override
        boolean study(TreeInfo treeInfo) {
            int n = treeInfo.minLength;
            int n2 = treeInfo.maxLength;
            boolean bl = treeInfo.maxValid;
            int n3 = Integer.MAX_VALUE;
            int n4 = -1;
            for (int i = 0; i < this.size; ++i) {
                treeInfo.reset();
                if (this.atoms[i] != null) {
                    this.atoms[i].study(treeInfo);
                }
                n3 = Math.min(n3, treeInfo.minLength);
                n4 = Math.max(n4, treeInfo.maxLength);
                bl &= treeInfo.maxValid;
            }
            treeInfo.reset();
            this.conn.next.study(treeInfo);
            treeInfo.minLength += (n += n3);
            treeInfo.maxLength += (n2 += n4);
            treeInfo.maxValid &= bl;
            treeInfo.deterministic = false;
            return false;
        }
    }

    static final class BranchConn
    extends Node {
        BranchConn() {
        }

        @Override
        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            return this.next.match(matcher, n, charSequence);
        }

        @Override
        boolean study(TreeInfo treeInfo) {
            return treeInfo.deterministic;
        }
    }

    static final class GroupCurly
    extends Node {
        Node atom;
        int type;
        int cmin;
        int cmax;
        int localIndex;
        int groupIndex;
        boolean capture;

        GroupCurly(Node node, int n, int n2, int n3, int n4, int n5, boolean bl) {
            this.atom = node;
            this.type = n3;
            this.cmin = n;
            this.cmax = n2;
            this.localIndex = n4;
            this.groupIndex = n5;
            this.capture = bl;
        }

        @Override
        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            int[] nArray = matcher.groups;
            int[] nArray2 = matcher.locals;
            int n2 = nArray2[this.localIndex];
            int n3 = 0;
            int n4 = 0;
            if (this.capture) {
                n3 = nArray[this.groupIndex];
                n4 = nArray[this.groupIndex + 1];
            }
            nArray2[this.localIndex] = -1;
            boolean bl = true;
            for (int i = 0; i < this.cmin; ++i) {
                if (this.atom.match(matcher, n, charSequence)) {
                    if (this.capture) {
                        nArray[this.groupIndex] = n;
                        nArray[this.groupIndex + 1] = matcher.last;
                    }
                } else {
                    bl = false;
                    break;
                }
                n = matcher.last;
            }
            if (bl) {
                bl = this.type == 0 ? this.match0(matcher, n, this.cmin, charSequence) : (this.type == 1 ? this.match1(matcher, n, this.cmin, charSequence) : this.match2(matcher, n, this.cmin, charSequence));
            }
            if (!bl) {
                nArray2[this.localIndex] = n2;
                if (this.capture) {
                    nArray[this.groupIndex] = n3;
                    nArray[this.groupIndex + 1] = n4;
                }
            }
            return bl;
        }

        boolean match0(Matcher matcher, int n, int n2, CharSequence charSequence) {
            int n3 = n2;
            int[] nArray = matcher.groups;
            int n4 = 0;
            int n5 = 0;
            if (this.capture) {
                n4 = nArray[this.groupIndex];
                n5 = nArray[this.groupIndex + 1];
            }
            if (n2 < this.cmax && this.atom.match(matcher, n, charSequence)) {
                int n6 = matcher.last - n;
                if (n6 <= 0) {
                    if (this.capture) {
                        nArray[this.groupIndex] = n;
                        nArray[this.groupIndex + 1] = n + n6;
                    }
                    n += n6;
                } else {
                    block13: {
                        do {
                            if (this.capture) {
                                nArray[this.groupIndex] = n;
                                nArray[this.groupIndex + 1] = n + n6;
                            }
                            if (++n2 >= this.cmax || !this.atom.match(matcher, n += n6, charSequence)) break block13;
                        } while (n + n6 == matcher.last);
                        if (this.match0(matcher, n, n2, charSequence)) {
                            return true;
                        }
                    }
                    while (n2 > n3) {
                        if (this.next.match(matcher, n, charSequence)) {
                            if (this.capture) {
                                nArray[this.groupIndex + 1] = n;
                                nArray[this.groupIndex] = n - n6;
                            }
                            return true;
                        }
                        n -= n6;
                        if (this.capture) {
                            nArray[this.groupIndex + 1] = n;
                            nArray[this.groupIndex] = n - n6;
                        }
                        --n2;
                    }
                }
            }
            if (this.capture) {
                nArray[this.groupIndex] = n4;
                nArray[this.groupIndex + 1] = n5;
            }
            return this.next.match(matcher, n, charSequence);
        }

        boolean match1(Matcher matcher, int n, int n2, CharSequence charSequence) {
            while (!this.next.match(matcher, n, charSequence)) {
                if (n2 >= this.cmax) {
                    return false;
                }
                if (!this.atom.match(matcher, n, charSequence)) {
                    return false;
                }
                if (n == matcher.last) {
                    return false;
                }
                if (this.capture) {
                    matcher.groups[this.groupIndex] = n;
                    matcher.groups[this.groupIndex + 1] = matcher.last;
                }
                n = matcher.last;
                ++n2;
            }
            return true;
        }

        boolean match2(Matcher matcher, int n, int n2, CharSequence charSequence) {
            while (n2 < this.cmax && this.atom.match(matcher, n, charSequence)) {
                if (this.capture) {
                    matcher.groups[this.groupIndex] = n;
                    matcher.groups[this.groupIndex + 1] = matcher.last;
                }
                if (n == matcher.last) break;
                n = matcher.last;
                ++n2;
            }
            return this.next.match(matcher, n, charSequence);
        }

        @Override
        boolean study(TreeInfo treeInfo) {
            int n = treeInfo.minLength;
            int n2 = treeInfo.maxLength;
            boolean bl = treeInfo.maxValid;
            boolean bl2 = treeInfo.deterministic;
            treeInfo.reset();
            this.atom.study(treeInfo);
            int n3 = treeInfo.minLength * this.cmin + n;
            if (n3 < n) {
                n3 = 0xFFFFFFF;
            }
            treeInfo.minLength = n3;
            if (bl & treeInfo.maxValid) {
                treeInfo.maxLength = n3 = treeInfo.maxLength * this.cmax + n2;
                if (n3 < n2) {
                    treeInfo.maxValid = false;
                }
            } else {
                treeInfo.maxValid = false;
            }
            treeInfo.deterministic = treeInfo.deterministic && this.cmin == this.cmax ? bl2 : false;
            return this.next.study(treeInfo);
        }
    }

    static final class Curly
    extends Node {
        Node atom;
        int type;
        int cmin;
        int cmax;

        Curly(Node node, int n, int n2, int n3) {
            this.atom = node;
            this.type = n3;
            this.cmin = n;
            this.cmax = n2;
        }

        @Override
        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            int n2;
            for (n2 = 0; n2 < this.cmin; ++n2) {
                if (!this.atom.match(matcher, n, charSequence)) {
                    return false;
                }
                n = matcher.last;
            }
            if (this.type == 0) {
                return this.match0(matcher, n, n2, charSequence);
            }
            if (this.type == 1) {
                return this.match1(matcher, n, n2, charSequence);
            }
            return this.match2(matcher, n, n2, charSequence);
        }

        boolean match0(Matcher matcher, int n, int n2, CharSequence charSequence) {
            int n3;
            if (n2 >= this.cmax) {
                return this.next.match(matcher, n, charSequence);
            }
            int n4 = n2++;
            if (this.atom.match(matcher, n, charSequence) && (n3 = matcher.last - n) != 0) {
                n = matcher.last;
                while (n2 < this.cmax && this.atom.match(matcher, n, charSequence)) {
                    if (n + n3 != matcher.last) {
                        if (!this.match0(matcher, matcher.last, n2 + 1, charSequence)) break;
                        return true;
                    }
                    n += n3;
                    ++n2;
                }
                while (n2 >= n4) {
                    if (this.next.match(matcher, n, charSequence)) {
                        return true;
                    }
                    n -= n3;
                    --n2;
                }
                return false;
            }
            return this.next.match(matcher, n, charSequence);
        }

        boolean match1(Matcher matcher, int n, int n2, CharSequence charSequence) {
            while (!this.next.match(matcher, n, charSequence)) {
                if (n2 >= this.cmax) {
                    return false;
                }
                if (!this.atom.match(matcher, n, charSequence)) {
                    return false;
                }
                if (n == matcher.last) {
                    return false;
                }
                n = matcher.last;
                ++n2;
            }
            return true;
        }

        boolean match2(Matcher matcher, int n, int n2, CharSequence charSequence) {
            while (n2 < this.cmax && this.atom.match(matcher, n, charSequence) && n != matcher.last) {
                n = matcher.last;
                ++n2;
            }
            return this.next.match(matcher, n, charSequence);
        }

        @Override
        boolean study(TreeInfo treeInfo) {
            int n = treeInfo.minLength;
            int n2 = treeInfo.maxLength;
            boolean bl = treeInfo.maxValid;
            boolean bl2 = treeInfo.deterministic;
            treeInfo.reset();
            this.atom.study(treeInfo);
            int n3 = treeInfo.minLength * this.cmin + n;
            if (n3 < n) {
                n3 = 0xFFFFFFF;
            }
            treeInfo.minLength = n3;
            if (bl & treeInfo.maxValid) {
                treeInfo.maxLength = n3 = treeInfo.maxLength * this.cmax + n2;
                if (n3 < n2) {
                    treeInfo.maxValid = false;
                }
            } else {
                treeInfo.maxValid = false;
            }
            treeInfo.deterministic = treeInfo.deterministic && this.cmin == this.cmax ? bl2 : false;
            return this.next.study(treeInfo);
        }
    }

    static final class Ques
    extends Node {
        Node atom;
        int type;

        Ques(Node node, int n) {
            this.atom = node;
            this.type = n;
        }

        @Override
        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            switch (this.type) {
                case 0: {
                    return this.atom.match(matcher, n, charSequence) && this.next.match(matcher, matcher.last, charSequence) || this.next.match(matcher, n, charSequence);
                }
                case 1: {
                    return this.next.match(matcher, n, charSequence) || this.atom.match(matcher, n, charSequence) && this.next.match(matcher, matcher.last, charSequence);
                }
                case 2: {
                    if (this.atom.match(matcher, n, charSequence)) {
                        n = matcher.last;
                    }
                    return this.next.match(matcher, n, charSequence);
                }
            }
            return this.atom.match(matcher, n, charSequence) && this.next.match(matcher, matcher.last, charSequence);
        }

        @Override
        boolean study(TreeInfo treeInfo) {
            if (this.type != 3) {
                int n = treeInfo.minLength;
                this.atom.study(treeInfo);
                treeInfo.minLength = n;
                treeInfo.deterministic = false;
                return this.next.study(treeInfo);
            }
            this.atom.study(treeInfo);
            return this.next.study(treeInfo);
        }
    }

    static final class UnixDot
    extends CharProperty {
        UnixDot() {
        }

        @Override
        boolean isSatisfiedBy(int n) {
            return n != 10;
        }
    }

    static final class Dot
    extends CharProperty {
        Dot() {
        }

        @Override
        boolean isSatisfiedBy(int n) {
            return n != 10 && n != 13 && (n | 1) != 8233 && n != 133;
        }
    }

    static final class All
    extends CharProperty {
        All() {
        }

        @Override
        boolean isSatisfiedBy(int n) {
            return true;
        }
    }

    static final class SliceUS
    extends SliceIS {
        SliceUS(int[] nArray) {
            super(nArray);
        }

        @Override
        int toLower(int n) {
            return Character.toLowerCase(Character.toUpperCase(n));
        }
    }

    static class SliceIS
    extends SliceNode {
        SliceIS(int[] nArray) {
            super(nArray);
        }

        int toLower(int n) {
            return ASCII.toLower(n);
        }

        @Override
        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            int[] nArray = this.buffer;
            int n2 = n;
            for (int i = 0; i < nArray.length; ++i) {
                if (n2 >= matcher.to) {
                    matcher.hitEnd = true;
                    return false;
                }
                int n3 = Character.codePointAt(charSequence, n2);
                if (nArray[i] != n3 && nArray[i] != this.toLower(n3)) {
                    return false;
                }
                if ((n2 += Character.charCount(n3)) <= matcher.to) continue;
                matcher.hitEnd = true;
                return false;
            }
            return this.next.match(matcher, n2, charSequence);
        }
    }

    static final class SliceS
    extends SliceNode {
        SliceS(int[] nArray) {
            super(nArray);
        }

        @Override
        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            int[] nArray = this.buffer;
            int n2 = n;
            for (int i = 0; i < nArray.length; ++i) {
                if (n2 >= matcher.to) {
                    matcher.hitEnd = true;
                    return false;
                }
                int n3 = Character.codePointAt(charSequence, n2);
                if (nArray[i] != n3) {
                    return false;
                }
                if ((n2 += Character.charCount(n3)) <= matcher.to) continue;
                matcher.hitEnd = true;
                return false;
            }
            return this.next.match(matcher, n2, charSequence);
        }
    }

    static final class SliceU
    extends SliceNode {
        SliceU(int[] nArray) {
            super(nArray);
        }

        @Override
        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            int[] nArray = this.buffer;
            int n2 = nArray.length;
            for (int i = 0; i < n2; ++i) {
                if (n + i >= matcher.to) {
                    matcher.hitEnd = true;
                    return false;
                }
                char c = charSequence.charAt(n + i);
                if (nArray[i] == c || nArray[i] == Character.toLowerCase(Character.toUpperCase((int)c))) continue;
                return false;
            }
            return this.next.match(matcher, n + n2, charSequence);
        }
    }

    static class SliceI
    extends SliceNode {
        SliceI(int[] nArray) {
            super(nArray);
        }

        @Override
        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            int[] nArray = this.buffer;
            int n2 = nArray.length;
            for (int i = 0; i < n2; ++i) {
                if (n + i >= matcher.to) {
                    matcher.hitEnd = true;
                    return false;
                }
                char c = charSequence.charAt(n + i);
                if (nArray[i] == c || nArray[i] == ASCII.toLower(c)) continue;
                return false;
            }
            return this.next.match(matcher, n + n2, charSequence);
        }
    }

    static final class Slice
    extends SliceNode {
        Slice(int[] nArray) {
            super(nArray);
        }

        @Override
        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            int[] nArray = this.buffer;
            int n2 = nArray.length;
            for (int i = 0; i < n2; ++i) {
                if (n + i >= matcher.to) {
                    matcher.hitEnd = true;
                    return false;
                }
                if (nArray[i] == charSequence.charAt(n + i)) continue;
                return false;
            }
            return this.next.match(matcher, n + n2, charSequence);
        }
    }

    static class SliceNode
    extends Node {
        int[] buffer;

        SliceNode(int[] nArray) {
            this.buffer = nArray;
        }

        @Override
        boolean study(TreeInfo treeInfo) {
            treeInfo.minLength += this.buffer.length;
            treeInfo.maxLength += this.buffer.length;
            return this.next.study(treeInfo);
        }
    }

    static final class HorizWS
    extends BmpCharProperty {
        HorizWS() {
        }

        @Override
        boolean isSatisfiedBy(int n) {
            return n == 9 || n == 32 || n == 160 || n == 5760 || n == 6158 || n >= 8192 && n <= 8202 || n == 8239 || n == 8287 || n == 12288;
        }
    }

    static final class VertWS
    extends BmpCharProperty {
        VertWS() {
        }

        @Override
        boolean isSatisfiedBy(int n) {
            return n >= 10 && n <= 13 || n == 133 || n == 8232 || n == 8233;
        }
    }

    static final class Ctype
    extends BmpCharProperty {
        final int ctype;

        Ctype(int n) {
            this.ctype = n;
        }

        @Override
        boolean isSatisfiedBy(int n) {
            return n < 128 && ASCII.isType(n, this.ctype);
        }
    }

    static final class Utype
    extends CharProperty {
        final UnicodeProp uprop;

        Utype(UnicodeProp unicodeProp) {
            this.uprop = unicodeProp;
        }

        @Override
        boolean isSatisfiedBy(int n) {
            return this.uprop.is(n);
        }
    }

    static final class Category
    extends CharProperty {
        final int typeMask;

        Category(int n) {
            this.typeMask = n;
        }

        @Override
        boolean isSatisfiedBy(int n) {
            return (this.typeMask & 1 << Character.getType(n)) != 0;
        }
    }

    static final class Script
    extends CharProperty {
        final Character.UnicodeScript script;

        Script(Character.UnicodeScript unicodeScript) {
            this.script = unicodeScript;
        }

        @Override
        boolean isSatisfiedBy(int n) {
            return this.script == Character.UnicodeScript.of(n);
        }
    }

    static final class Block
    extends CharProperty {
        final Character.UnicodeBlock block;

        Block(Character.UnicodeBlock unicodeBlock) {
            this.block = unicodeBlock;
        }

        @Override
        boolean isSatisfiedBy(int n) {
            return this.block == Character.UnicodeBlock.of(n);
        }
    }

    static final class SingleU
    extends CharProperty {
        final int lower;

        SingleU(int n) {
            this.lower = n;
        }

        @Override
        boolean isSatisfiedBy(int n) {
            return this.lower == n || this.lower == Character.toLowerCase(Character.toUpperCase(n));
        }
    }

    static final class SingleI
    extends BmpCharProperty {
        final int lower;
        final int upper;

        SingleI(int n, int n2) {
            this.lower = n;
            this.upper = n2;
        }

        @Override
        boolean isSatisfiedBy(int n) {
            return n == this.lower || n == this.upper;
        }
    }

    static final class Single
    extends BmpCharProperty {
        final int c;

        Single(int n) {
            this.c = n;
        }

        @Override
        boolean isSatisfiedBy(int n) {
            return n == this.c;
        }
    }

    static final class SingleS
    extends CharProperty {
        final int c;

        SingleS(int n) {
            this.c = n;
        }

        @Override
        boolean isSatisfiedBy(int n) {
            return n == this.c;
        }
    }

    private static abstract class BmpCharProperty
    extends CharProperty {
        private BmpCharProperty() {
        }

        @Override
        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            if (n < matcher.to) {
                return this.isSatisfiedBy(charSequence.charAt(n)) && this.next.match(matcher, n + 1, charSequence);
            }
            matcher.hitEnd = true;
            return false;
        }
    }

    private static abstract class CharProperty
    extends Node {
        private CharProperty() {
        }

        abstract boolean isSatisfiedBy(int var1);

        CharProperty complement() {
            return new CharProperty(){

                @Override
                boolean isSatisfiedBy(int n) {
                    return !this.isSatisfiedBy(n);
                }
            };
        }

        @Override
        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            if (n < matcher.to) {
                int n2 = Character.codePointAt(charSequence, n);
                return this.isSatisfiedBy(n2) && this.next.match(matcher, n + Character.charCount(n2), charSequence);
            }
            matcher.hitEnd = true;
            return false;
        }

        @Override
        boolean study(TreeInfo treeInfo) {
            ++treeInfo.minLength;
            ++treeInfo.maxLength;
            return this.next.study(treeInfo);
        }
    }

    static final class LineEnding
    extends Node {
        LineEnding() {
        }

        @Override
        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            if (n < matcher.to) {
                char c = charSequence.charAt(n);
                if (c == '\n' || c == '\u000b' || c == '\f' || c == '\u0085' || c == '\u2028' || c == '\u2029') {
                    return this.next.match(matcher, n + 1, charSequence);
                }
                if (c == '\r') {
                    if (++n < matcher.to && charSequence.charAt(n) == '\n') {
                        ++n;
                    }
                    return this.next.match(matcher, n, charSequence);
                }
            } else {
                matcher.hitEnd = true;
            }
            return false;
        }

        @Override
        boolean study(TreeInfo treeInfo) {
            ++treeInfo.minLength;
            treeInfo.maxLength += 2;
            return this.next.study(treeInfo);
        }
    }

    static final class UnixDollar
    extends Node {
        boolean multiline;

        UnixDollar(boolean bl) {
            this.multiline = bl;
        }

        @Override
        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            int n2;
            int n3 = n2 = matcher.anchoringBounds ? matcher.to : matcher.getTextLength();
            if (n < n2) {
                char c = charSequence.charAt(n);
                if (c == '\n') {
                    if (!this.multiline && n != n2 - 1) {
                        return false;
                    }
                    if (this.multiline) {
                        return this.next.match(matcher, n, charSequence);
                    }
                } else {
                    return false;
                }
            }
            matcher.hitEnd = true;
            matcher.requireEnd = true;
            return this.next.match(matcher, n, charSequence);
        }

        @Override
        boolean study(TreeInfo treeInfo) {
            this.next.study(treeInfo);
            return treeInfo.deterministic;
        }
    }

    static final class Dollar
    extends Node {
        boolean multiline;

        Dollar(boolean bl) {
            this.multiline = bl;
        }

        @Override
        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            char c;
            int n2;
            int n3 = n2 = matcher.anchoringBounds ? matcher.to : matcher.getTextLength();
            if (!this.multiline) {
                if (n < n2 - 2) {
                    return false;
                }
                if (n == n2 - 2) {
                    c = charSequence.charAt(n);
                    if (c != '\r') {
                        return false;
                    }
                    c = charSequence.charAt(n + 1);
                    if (c != '\n') {
                        return false;
                    }
                }
            }
            if (n < n2) {
                c = charSequence.charAt(n);
                if (c == '\n') {
                    if (n > 0 && charSequence.charAt(n - 1) == '\r') {
                        return false;
                    }
                    if (this.multiline) {
                        return this.next.match(matcher, n, charSequence);
                    }
                } else if (c == '\r' || c == '\u0085' || (c | '\u0001') == 8233) {
                    if (this.multiline) {
                        return this.next.match(matcher, n, charSequence);
                    }
                } else {
                    return false;
                }
            }
            matcher.hitEnd = true;
            matcher.requireEnd = true;
            return this.next.match(matcher, n, charSequence);
        }

        @Override
        boolean study(TreeInfo treeInfo) {
            this.next.study(treeInfo);
            return treeInfo.deterministic;
        }
    }

    static final class LastMatch
    extends Node {
        LastMatch() {
        }

        @Override
        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            if (n != matcher.oldLast) {
                return false;
            }
            return this.next.match(matcher, n, charSequence);
        }
    }

    static final class UnixCaret
    extends Node {
        UnixCaret() {
        }

        @Override
        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            char c;
            int n2 = matcher.from;
            int n3 = matcher.to;
            if (!matcher.anchoringBounds) {
                n2 = 0;
                n3 = matcher.getTextLength();
            }
            if (n == n3) {
                matcher.hitEnd = true;
                return false;
            }
            if (n > n2 && (c = charSequence.charAt(n - 1)) != '\n') {
                return false;
            }
            return this.next.match(matcher, n, charSequence);
        }
    }

    static final class Caret
    extends Node {
        Caret() {
        }

        @Override
        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            int n2 = matcher.from;
            int n3 = matcher.to;
            if (!matcher.anchoringBounds) {
                n2 = 0;
                n3 = matcher.getTextLength();
            }
            if (n == n3) {
                matcher.hitEnd = true;
                return false;
            }
            if (n > n2) {
                char c = charSequence.charAt(n - 1);
                if (c != '\n' && c != '\r' && (c | '\u0001') != 8233 && c != '\u0085') {
                    return false;
                }
                if (c == '\r' && charSequence.charAt(n) == '\n') {
                    return false;
                }
            }
            return this.next.match(matcher, n, charSequence);
        }
    }

    static final class End
    extends Node {
        End() {
        }

        @Override
        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            int n2;
            int n3 = n2 = matcher.anchoringBounds ? matcher.to : matcher.getTextLength();
            if (n == n2) {
                matcher.hitEnd = true;
                return this.next.match(matcher, n, charSequence);
            }
            return false;
        }
    }

    static final class Begin
    extends Node {
        Begin() {
        }

        @Override
        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            int n2;
            int n3 = n2 = matcher.anchoringBounds ? matcher.from : 0;
            if (n == n2 && this.next.match(matcher, n, charSequence)) {
                matcher.first = n;
                matcher.groups[0] = n;
                matcher.groups[1] = matcher.last;
                return true;
            }
            return false;
        }
    }

    static final class StartS
    extends Start {
        StartS(Node node) {
            super(node);
        }

        @Override
        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            if (n > matcher.to - this.minLength) {
                matcher.hitEnd = true;
                return false;
            }
            int n2 = matcher.to - this.minLength;
            while (n <= n2) {
                if (this.next.match(matcher, n, charSequence)) {
                    matcher.groups[0] = matcher.first = n;
                    matcher.groups[1] = matcher.last;
                    return true;
                }
                if (n == n2) break;
                if (!Character.isHighSurrogate(charSequence.charAt(n++)) || n >= charSequence.length() || !Character.isLowSurrogate(charSequence.charAt(n))) continue;
                ++n;
            }
            matcher.hitEnd = true;
            return false;
        }
    }

    static class Start
    extends Node {
        int minLength;

        Start(Node node) {
            this.next = node;
            TreeInfo treeInfo = new TreeInfo();
            this.next.study(treeInfo);
            this.minLength = treeInfo.minLength;
        }

        @Override
        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            if (n > matcher.to - this.minLength) {
                matcher.hitEnd = true;
                return false;
            }
            int n2 = matcher.to - this.minLength;
            while (n <= n2) {
                if (this.next.match(matcher, n, charSequence)) {
                    matcher.groups[0] = matcher.first = n;
                    matcher.groups[1] = matcher.last;
                    return true;
                }
                ++n;
            }
            matcher.hitEnd = true;
            return false;
        }

        @Override
        boolean study(TreeInfo treeInfo) {
            this.next.study(treeInfo);
            treeInfo.maxValid = false;
            treeInfo.deterministic = false;
            return false;
        }
    }

    static class LastNode
    extends Node {
        LastNode() {
        }

        @Override
        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            if (matcher.acceptMode == 1 && n != matcher.to) {
                return false;
            }
            matcher.last = n;
            matcher.groups[0] = matcher.first;
            matcher.groups[1] = matcher.last;
            return true;
        }
    }

    static class Node {
        Node next = accept;

        Node() {
        }

        boolean match(Matcher matcher, int n, CharSequence charSequence) {
            matcher.last = n;
            matcher.groups[0] = matcher.first;
            matcher.groups[1] = matcher.last;
            return true;
        }

        boolean study(TreeInfo treeInfo) {
            if (this.next != null) {
                return this.next.study(treeInfo);
            }
            return treeInfo.deterministic;
        }
    }

    private static final class BitClass
    extends BmpCharProperty {
        final boolean[] bits;

        BitClass() {
            this.bits = new boolean[256];
        }

        private BitClass(boolean[] blArray) {
            this.bits = blArray;
        }

        BitClass add(int n, int n2) {
            assert (n >= 0 && n <= 255);
            if ((n2 & 2) != 0) {
                if (ASCII.isAscii(n)) {
                    this.bits[ASCII.toUpper((int)n)] = true;
                    this.bits[ASCII.toLower((int)n)] = true;
                } else if ((n2 & 0x40) != 0) {
                    this.bits[Character.toLowerCase((int)n)] = true;
                    this.bits[Character.toUpperCase((int)n)] = true;
                }
            }
            this.bits[n] = true;
            return this;
        }

        @Override
        boolean isSatisfiedBy(int n) {
            return n < 256 && this.bits[n];
        }
    }

    static final class TreeInfo {
        int minLength;
        int maxLength;
        boolean maxValid;
        boolean deterministic;

        TreeInfo() {
            this.reset();
        }

        void reset() {
            this.minLength = 0;
            this.maxLength = 0;
            this.maxValid = true;
            this.deterministic = true;
        }
    }
}

