/*
 * Decompiled with CFR 0.152.
 */
package sun.lwawt;

import java.awt.AWTEvent;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.JobAttributes;
import java.awt.Label;
import java.awt.List;
import java.awt.PageAttributes;
import java.awt.Panel;
import java.awt.PrintJob;
import java.awt.ScrollPane;
import java.awt.Scrollbar;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.image.ColorModel;
import java.awt.peer.ButtonPeer;
import java.awt.peer.CanvasPeer;
import java.awt.peer.CheckboxPeer;
import java.awt.peer.ChoicePeer;
import java.awt.peer.ComponentPeer;
import java.awt.peer.DialogPeer;
import java.awt.peer.FileDialogPeer;
import java.awt.peer.FramePeer;
import java.awt.peer.KeyboardFocusManagerPeer;
import java.awt.peer.LabelPeer;
import java.awt.peer.ListPeer;
import java.awt.peer.MouseInfoPeer;
import java.awt.peer.PanelPeer;
import java.awt.peer.ScrollPanePeer;
import java.awt.peer.ScrollbarPeer;
import java.awt.peer.TextAreaPeer;
import java.awt.peer.TextFieldPeer;
import java.awt.peer.WindowPeer;
import java.security.AccessController;
import java.util.Properties;
import sun.awt.AWTAccessor;
import sun.awt.AWTAutoShutdown;
import sun.awt.AppContext;
import sun.awt.LightweightFrame;
import sun.awt.SunToolkit;
import sun.lwawt.LWButtonPeer;
import sun.lwawt.LWCanvasPeer;
import sun.lwawt.LWCheckboxPeer;
import sun.lwawt.LWChoicePeer;
import sun.lwawt.LWCursorManager;
import sun.lwawt.LWKeyboardFocusManagerPeer;
import sun.lwawt.LWLabelPeer;
import sun.lwawt.LWLightweightFramePeer;
import sun.lwawt.LWListPeer;
import sun.lwawt.LWMouseInfoPeer;
import sun.lwawt.LWPanelPeer;
import sun.lwawt.LWScrollBarPeer;
import sun.lwawt.LWScrollPanePeer;
import sun.lwawt.LWTextAreaPeer;
import sun.lwawt.LWTextFieldPeer;
import sun.lwawt.LWWindowPeer;
import sun.lwawt.PlatformComponent;
import sun.lwawt.PlatformWindow;
import sun.lwawt.SecurityWarningWindow;
import sun.misc.ThreadGroupUtils;
import sun.print.PrintJob2D;
import sun.security.util.SecurityConstants;

public abstract class LWToolkit
extends SunToolkit
implements Runnable {
    private static final int STATE_NONE = 0;
    private static final int STATE_INIT = 1;
    private static final int STATE_MESSAGELOOP = 2;
    private static final int STATE_SHUTDOWN = 3;
    private static final int STATE_CLEANUP = 4;
    private static final int STATE_DONE = 5;
    private int runState = 0;
    private Clipboard clipboard;
    private MouseInfoPeer mouseInfoPeer;
    private volatile boolean dynamicLayoutSetting = true;

    protected LWToolkit() {
    }

    protected final void init() {
        AWTAutoShutdown.notifyToolkitThreadBusy();
        ThreadGroup threadGroup = AccessController.doPrivileged(ThreadGroupUtils::getRootThreadGroup);
        Runtime.getRuntime().addShutdownHook(new Thread(threadGroup, () -> {
            this.shutdown();
            this.waitForRunState(4);
        }));
        Thread thread = new Thread(threadGroup, this, "AWT-LW");
        thread.setDaemon(true);
        thread.setPriority(6);
        thread.start();
        this.waitForRunState(2);
    }

    protected abstract void platformInit();

    public final void shutdown() {
        this.setRunState(3);
        this.platformShutdown();
    }

    protected abstract void platformShutdown();

    protected abstract void platformCleanup();

    private synchronized int getRunState() {
        return this.runState;
    }

    private synchronized void setRunState(int n) {
        this.runState = n;
        this.notifyAll();
    }

    public final boolean isTerminating() {
        return this.getRunState() >= 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForRunState(int n) {
        while (this.getRunState() < n) {
            try {
                LWToolkit lWToolkit = this;
                synchronized (lWToolkit) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                break;
            }
        }
    }

    @Override
    public final void run() {
        this.setRunState(1);
        this.platformInit();
        AWTAutoShutdown.notifyToolkitThreadFree();
        this.setRunState(2);
        while (this.getRunState() < 3) {
            try {
                this.platformRunMessage();
                if (!Thread.currentThread().isInterrupted() || !AppContext.getAppContext().isDisposed()) continue;
                break;
            }
            catch (ThreadDeath threadDeath) {
                break;
            }
            catch (Throwable throwable) {
                System.err.println("Exception on the toolkit thread");
                throwable.printStackTrace(System.err);
            }
        }
        this.setRunState(4);
        AWTAutoShutdown.notifyToolkitThreadFree();
        this.platformCleanup();
        this.setRunState(5);
    }

    protected abstract void platformRunMessage();

    public static LWToolkit getLWToolkit() {
        return (LWToolkit)Toolkit.getDefaultToolkit();
    }

    protected LWWindowPeer createDelegatedPeer(Window window, PlatformComponent platformComponent, PlatformWindow platformWindow, LWWindowPeer.PeerType peerType) {
        LWWindowPeer lWWindowPeer = new LWWindowPeer(window, platformComponent, platformWindow, peerType);
        LWToolkit.targetCreatedPeer(window, lWWindowPeer);
        lWWindowPeer.initialize();
        return lWWindowPeer;
    }

    @Override
    public final FramePeer createLightweightFrame(LightweightFrame lightweightFrame) {
        PlatformComponent platformComponent = this.createLwPlatformComponent();
        PlatformWindow platformWindow = this.createPlatformWindow(LWWindowPeer.PeerType.LW_FRAME);
        LWLightweightFramePeer lWLightweightFramePeer = new LWLightweightFramePeer(lightweightFrame, platformComponent, platformWindow);
        LWToolkit.targetCreatedPeer(lightweightFrame, lWLightweightFramePeer);
        lWLightweightFramePeer.initialize();
        return lWLightweightFramePeer;
    }

    @Override
    public final WindowPeer createWindow(Window window) {
        PlatformComponent platformComponent = this.createPlatformComponent();
        PlatformWindow platformWindow = this.createPlatformWindow(LWWindowPeer.PeerType.SIMPLEWINDOW);
        return this.createDelegatedPeer(window, platformComponent, platformWindow, LWWindowPeer.PeerType.SIMPLEWINDOW);
    }

    @Override
    public final FramePeer createFrame(Frame frame) {
        PlatformComponent platformComponent = this.createPlatformComponent();
        PlatformWindow platformWindow = this.createPlatformWindow(LWWindowPeer.PeerType.FRAME);
        return this.createDelegatedPeer(frame, platformComponent, platformWindow, LWWindowPeer.PeerType.FRAME);
    }

    @Override
    public DialogPeer createDialog(Dialog dialog) {
        PlatformComponent platformComponent = this.createPlatformComponent();
        PlatformWindow platformWindow = this.createPlatformWindow(LWWindowPeer.PeerType.DIALOG);
        return this.createDelegatedPeer(dialog, platformComponent, platformWindow, LWWindowPeer.PeerType.DIALOG);
    }

    @Override
    public final FileDialogPeer createFileDialog(FileDialog fileDialog) {
        FileDialogPeer fileDialogPeer = this.createFileDialogPeer(fileDialog);
        LWToolkit.targetCreatedPeer(fileDialog, fileDialogPeer);
        return fileDialogPeer;
    }

    @Override
    public final ButtonPeer createButton(Button button) {
        PlatformComponent platformComponent = this.createPlatformComponent();
        LWButtonPeer lWButtonPeer = new LWButtonPeer(button, platformComponent);
        LWToolkit.targetCreatedPeer(button, lWButtonPeer);
        lWButtonPeer.initialize();
        return lWButtonPeer;
    }

    @Override
    public final CheckboxPeer createCheckbox(Checkbox checkbox) {
        PlatformComponent platformComponent = this.createPlatformComponent();
        LWCheckboxPeer lWCheckboxPeer = new LWCheckboxPeer(checkbox, platformComponent);
        LWToolkit.targetCreatedPeer(checkbox, lWCheckboxPeer);
        lWCheckboxPeer.initialize();
        return lWCheckboxPeer;
    }

    @Override
    public final ChoicePeer createChoice(Choice choice) {
        PlatformComponent platformComponent = this.createPlatformComponent();
        LWChoicePeer lWChoicePeer = new LWChoicePeer(choice, platformComponent);
        LWToolkit.targetCreatedPeer(choice, lWChoicePeer);
        lWChoicePeer.initialize();
        return lWChoicePeer;
    }

    @Override
    public final LabelPeer createLabel(Label label) {
        PlatformComponent platformComponent = this.createPlatformComponent();
        LWLabelPeer lWLabelPeer = new LWLabelPeer(label, platformComponent);
        LWToolkit.targetCreatedPeer(label, lWLabelPeer);
        lWLabelPeer.initialize();
        return lWLabelPeer;
    }

    @Override
    public final CanvasPeer createCanvas(Canvas canvas) {
        PlatformComponent platformComponent = this.createPlatformComponent();
        LWCanvasPeer lWCanvasPeer = new LWCanvasPeer(canvas, platformComponent);
        LWToolkit.targetCreatedPeer(canvas, lWCanvasPeer);
        lWCanvasPeer.initialize();
        return lWCanvasPeer;
    }

    @Override
    public final ListPeer createList(List list) {
        PlatformComponent platformComponent = this.createPlatformComponent();
        LWListPeer lWListPeer = new LWListPeer(list, platformComponent);
        LWToolkit.targetCreatedPeer(list, lWListPeer);
        lWListPeer.initialize();
        return lWListPeer;
    }

    @Override
    public final PanelPeer createPanel(Panel panel) {
        PlatformComponent platformComponent = this.createPlatformComponent();
        LWPanelPeer lWPanelPeer = new LWPanelPeer(panel, platformComponent);
        LWToolkit.targetCreatedPeer(panel, lWPanelPeer);
        lWPanelPeer.initialize();
        return lWPanelPeer;
    }

    @Override
    public final ScrollPanePeer createScrollPane(ScrollPane scrollPane) {
        PlatformComponent platformComponent = this.createPlatformComponent();
        LWScrollPanePeer lWScrollPanePeer = new LWScrollPanePeer(scrollPane, platformComponent);
        LWToolkit.targetCreatedPeer(scrollPane, lWScrollPanePeer);
        lWScrollPanePeer.initialize();
        return lWScrollPanePeer;
    }

    @Override
    public final ScrollbarPeer createScrollbar(Scrollbar scrollbar) {
        PlatformComponent platformComponent = this.createPlatformComponent();
        LWScrollBarPeer lWScrollBarPeer = new LWScrollBarPeer(scrollbar, platformComponent);
        LWToolkit.targetCreatedPeer(scrollbar, lWScrollBarPeer);
        lWScrollBarPeer.initialize();
        return lWScrollBarPeer;
    }

    @Override
    public final TextAreaPeer createTextArea(TextArea textArea) {
        PlatformComponent platformComponent = this.createPlatformComponent();
        LWTextAreaPeer lWTextAreaPeer = new LWTextAreaPeer(textArea, platformComponent);
        LWToolkit.targetCreatedPeer(textArea, lWTextAreaPeer);
        lWTextAreaPeer.initialize();
        return lWTextAreaPeer;
    }

    @Override
    public final TextFieldPeer createTextField(TextField textField) {
        PlatformComponent platformComponent = this.createPlatformComponent();
        LWTextFieldPeer lWTextFieldPeer = new LWTextFieldPeer(textField, platformComponent);
        LWToolkit.targetCreatedPeer(textField, lWTextFieldPeer);
        lWTextFieldPeer.initialize();
        return lWTextFieldPeer;
    }

    @Override
    public final ColorModel getColorModel() throws HeadlessException {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getColorModel();
    }

    @Override
    public final boolean isDesktopSupported() {
        return true;
    }

    @Override
    public final KeyboardFocusManagerPeer getKeyboardFocusManagerPeer() {
        return LWKeyboardFocusManagerPeer.getInstance();
    }

    @Override
    public final synchronized MouseInfoPeer getMouseInfoPeer() {
        if (this.mouseInfoPeer == null) {
            this.mouseInfoPeer = this.createMouseInfoPeerImpl();
        }
        return this.mouseInfoPeer;
    }

    protected final MouseInfoPeer createMouseInfoPeerImpl() {
        return new LWMouseInfoPeer();
    }

    @Override
    public final PrintJob getPrintJob(Frame frame, String string, Properties properties) {
        return this.getPrintJob(frame, string, null, null);
    }

    @Override
    public final PrintJob getPrintJob(Frame frame, String string, JobAttributes jobAttributes, PageAttributes pageAttributes) {
        if (GraphicsEnvironment.isHeadless()) {
            throw new IllegalArgumentException();
        }
        PrintJob2D printJob2D = new PrintJob2D(frame, string, jobAttributes, pageAttributes);
        if (!printJob2D.printDialog()) {
            printJob2D = null;
        }
        return printJob2D;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Clipboard getSystemClipboard() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(SecurityConstants.AWT.ACCESS_CLIPBOARD_PERMISSION);
        }
        LWToolkit lWToolkit = this;
        synchronized (lWToolkit) {
            if (this.clipboard == null) {
                this.clipboard = this.createPlatformClipboard();
            }
        }
        return this.clipboard;
    }

    protected abstract SecurityWarningWindow createSecurityWarning(Window var1, LWWindowPeer var2);

    public abstract Clipboard createPlatformClipboard();

    protected abstract PlatformWindow createPlatformWindow(LWWindowPeer.PeerType var1);

    protected abstract PlatformComponent createPlatformComponent();

    protected abstract PlatformComponent createLwPlatformComponent();

    protected abstract FileDialogPeer createFileDialogPeer(FileDialog var1);

    public static final Object targetToPeer(Object object) {
        return SunToolkit.targetToPeer(object);
    }

    public static final void targetDisposedPeer(Object object, Object object2) {
        SunToolkit.targetDisposedPeer(object, object2);
    }

    public abstract LWCursorManager getCursorManager();

    public static void postEvent(AWTEvent aWTEvent) {
        LWToolkit.postEvent(LWToolkit.targetToAppContext(aWTEvent.getSource()), aWTEvent);
    }

    @Override
    public final void grab(Window window) {
        ComponentPeer componentPeer = AWTAccessor.getComponentAccessor().getPeer(window);
        if (componentPeer != null) {
            ((LWWindowPeer)componentPeer).grab();
        }
    }

    @Override
    public final void ungrab(Window window) {
        ComponentPeer componentPeer = AWTAccessor.getComponentAccessor().getPeer(window);
        if (componentPeer != null) {
            ((LWWindowPeer)componentPeer).ungrab(false);
        }
    }

    @Override
    protected final Object lazilyLoadDesktopProperty(String string) {
        if (string.equals("awt.dynamicLayoutSupported")) {
            return this.isDynamicLayoutSupported();
        }
        return super.lazilyLoadDesktopProperty(string);
    }

    @Override
    public final void setDynamicLayout(boolean bl) {
        this.dynamicLayoutSetting = bl;
    }

    @Override
    protected final boolean isDynamicLayoutSet() {
        return this.dynamicLayoutSetting;
    }

    @Override
    public final boolean isDynamicLayoutActive() {
        return this.isDynamicLayoutSupported();
    }

    protected final boolean isDynamicLayoutSupported() {
        return true;
    }
}

