/*
 * Decompiled with CFR 0.152.
 */
package aigis.gl;

import aigis.Logger;
import aigis.Scene;
import aigis.gl.Textures;
import aigis.model.CameraInfo;
import aigis.model.General3D;
import aigis.model.Grids;
import aigis.model.LatLon;
import aigis.model.Light;
import aigis.model.Model;
import aigis.model.ModelSelection;
import aigis.model.Models;
import aigis.model.SpectrumMap;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.glu.GLU;
import com.jogamp.opengl.util.awt.TextRenderer;
import java.awt.Font;
import java.awt.geom.Point2D;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import javax.vecmath.Matrix4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class Renderer {
    public RenderSetting setting = new RenderSetting();
    private CameraInfo camera = new CameraInfo();
    private double[] modelview = new double[16];
    private double[] projection = new double[16];
    private int[] viewport = new int[4];
    private Light light = new Light();
    private ModelSelection currentSelection = new ModelSelection(ModelSelection.Resolution.Low, 0);
    private ModelSelection prevSelection = null;
    private Model currentModel;
    private String currentSpectrum = "#None";
    private String prevSpectrum = null;
    private ArrayList<Integer> polygonIDs = new ArrayList();
    private HashMap<Integer, float[]> prevRGBAs = new HashMap();
    private Scene scene;
    private Font font = new Font("Monospaced", 1, 32);
    private TextRenderer tr = new TextRenderer(this.font, true, true);
    private GLU glu = new GLU();

    public Renderer(Scene scene) {
        this.scene = scene;
    }

    public void resetSetting(boolean bl) {
        if (bl) {
            this.camera.reset();
            this.polygonIDs.clear();
        }
        this.setting = new RenderSetting();
        this.currentSpectrum = "#None";
        this.changeModel(new ModelSelection(ModelSelection.Resolution.Low, 0));
        this.changeColorbar(this.setting.colorbarIndex);
        this.changeShading(this.setting.isShading);
    }

    public int getPolygonID() {
        return this.polygonIDs.isEmpty() ? -1 : this.polygonIDs.get(this.polygonIDs.size() - 1);
    }

    public LatLon selectPolygon(int n, boolean bl) {
        if (n >= 0) {
            Object object;
            if (bl) {
                object = "";
                for (int n2 : this.polygonIDs) {
                    object = (String)object + n2 + ",";
                }
                object = (String)object + n;
                Logger.Info("Selected:" + (String)object);
            } else {
                this.polygonIDs.clear();
                this.prevRGBAs.clear();
            }
            this.polygonIDs.add(n);
            object = new float[4];
            for (int i = 0; i < 3; ++i) {
                object[i] = this.currentModel.rgba[n][i];
            }
            this.prevRGBAs.put(n, (float[])object);
            return this.currentModel.getLatLon()[n];
        }
        this.polygonIDs.clear();
        this.prevRGBAs.clear();
        return null;
    }

    public void changeModel(ModelSelection modelSelection, String string) {
        this.polygonIDs.clear();
        this.currentSelection = modelSelection;
        this.currentModel = this.scene.getModel(modelSelection);
        this.currentSpectrum = string;
        if (this.currentModel != null) {
            this.currentModel.changeSpectrumMap(this.currentSpectrum, this.setting.colorbarIndex);
        }
    }

    public void changeModel(ModelSelection modelSelection) {
        this.changeModel(modelSelection, "#None");
    }

    public void changeResolution(ModelSelection.Resolution resolution) {
        if (resolution == null) {
            this.changeModel(this.prevSelection, this.prevSpectrum);
            this.prevSelection = null;
        } else {
            this.prevSelection = this.currentSelection;
            this.prevSpectrum = this.currentSpectrum;
            this.changeModel(new ModelSelection(resolution, this.currentSelection.index));
        }
    }

    public Model getCurrentModel() {
        return this.currentModel;
    }

    public boolean isHighResolution() {
        return this.currentSelection.resolution == ModelSelection.Resolution.High;
    }

    public ModelSelection getCuttentSelection() {
        return this.prevSelection == null ? this.currentSelection : this.prevSelection;
    }

    public void changeSpectrum(String string) {
        if (this.currentModel != null) {
            this.currentSpectrum = string;
            this.currentModel.changeSpectrumMap(string, this.setting.colorbarIndex);
        }
    }

    public SpectrumMap getCurrentSpectrum() {
        return this.currentModel.getSpectrum(this.currentSpectrum);
    }

    public String getCurrentSpectrumKey() {
        return this.currentSpectrum;
    }

    public void changeColorbar(int n) {
        this.setting.colorbarIndex = n;
        this.changeSpectrum(this.currentSpectrum);
    }

    public void changeShading(boolean bl) {
        this.setting.isShading = bl;
        this.light.changeDiffuse(!bl);
    }

    public Integer getPointPolygonID(Point2D.Double double_, float[] fArray) {
        if (fArray[0] > 1.0f) {
            this.viewport[0] = (int)((float)this.viewport[0] / fArray[0]);
            this.viewport[2] = (int)((float)this.viewport[2] / fArray[0]);
        }
        if (fArray[1] > 1.0f) {
            this.viewport[1] = (int)((float)this.viewport[1] / fArray[1]);
            this.viewport[3] = (int)((float)this.viewport[3] / fArray[1]);
        }
        if (this.currentModel == null) {
            return -1;
        }
        return this.currentModel.getID(double_, this.modelview, this.projection, this.viewport);
    }

    public void syncCamera(Renderer renderer) {
        this.camera = renderer.camera.clone();
    }

    public void scale(float f) {
        double d = (double)this.camera.getDistance() - this.scene.getModelSize() / 2.0 * 0.7;
        double d2 = 3.2 - this.camera.fov * 2.0;
        if (d2 < 0.0) {
            d2 = 0.0;
        }
        if (d < 0.0) {
            d = 0.0;
        }
        if (d < d2) {
            d = d2 - d + 1.0;
            d *= d;
        } else {
            d = d2 / d;
        }
        Vector3d vector3d = new Vector3d(this.camera.direction);
        vector3d.scale((double)(-f / 10.0f) / d);
        this.camera.position.add((Tuple3d)vector3d);
    }

    public void setCameraDistance(float f) {
        Vector3d vector3d = new Vector3d((Tuple3d)this.camera.position);
        this.camera.direction.normalize();
        double d = this.camera.direction.dot(vector3d) * 2.0;
        double d2 = (-d - Math.sqrt(Math.pow(d, 2.0) - 4.0 * (vector3d.lengthSquared() - Math.pow(f, 2.0)))) / 2.0;
        if (Double.isNaN(d2)) {
            return;
        }
        Vector3d vector3d2 = new Vector3d(this.camera.direction);
        vector3d2.scale(d2);
        this.camera.position.add((Tuple3d)vector3d2);
    }

    public CameraInfo getCameraInfo() {
        return this.camera;
    }

    public void setCameraInfo(CameraInfo cameraInfo) {
        this.camera = cameraInfo;
    }

    public void move(float f, float f2) {
        this.camera.move(f / 100.0f, f2 / 100.0f);
    }

    public void rotateObject(float f, float f2, float f3, boolean bl) {
        double d = (double)this.camera.getDistance() - this.scene.getModelSize() / 2.0 * 0.7;
        double d2 = 3.2 - this.camera.fov * 2.0;
        if (d2 < 0.0) {
            d2 = 0.0;
        }
        if (d < 0.0) {
            d = 0.0;
        }
        if (d < d2) {
            d = d2 - d + 1.0;
            d = d * d * d;
            f = (float)((double)f / d);
            f2 = (float)((double)f2 / d);
            f3 = (float)((double)f3 / d);
        }
        this.camera.rotate(f, f2, f3, bl, this.setting.fixedLightPos);
    }

    public void moveCamera(float f, float f2, float f3) {
        this.camera.moveLatLng(f, f2, f3);
    }

    public void moveLight(float f, float f2) {
        this.camera.moveLightLatLng(f, f2);
    }

    public void rotateLight(float f, float f2) {
        this.camera.rotateLight(f, f2, 0.0f);
    }

    public LatLon getLightLatLon() {
        return this.camera.getLightLatLng();
    }

    public void setFov(float f) {
        this.camera.fov = Math.toRadians(f);
    }

    public void render(GL2 gL2, Textures textures, int n) throws Exception {
        Models models = this.scene.getRegisteredModels();
        if (!models.isCompiled()) {
            return;
        }
        if (this.currentModel == null) {
            return;
        }
        textures.bind(gL2, this.currentModel, n);
        int n2 = gL2.glGetError();
        if (n2 != 0) {
            throw new Exception("gl error: " + n2);
        }
        this.renderMain(gL2);
        textures.unbind(gL2);
        n2 = gL2.glGetError();
        if (n2 != 0) {
            throw new Exception("gl error: " + n2);
        }
        this.renderOthers(gL2);
    }

    private void renderMain(GL2 gL2) throws Exception {
        Models models = this.scene.getRegisteredModels();
        if (!models.isCompiled()) {
            return;
        }
        if (this.currentModel == null) {
            return;
        }
        this.changeSpectrum(this.currentSpectrum);
        for (int n : this.polygonIDs) {
            float[] fArray = this.prevRGBAs.get(n);
            for (int i = 0; i < 3; ++i) {
                this.currentModel.rgba[n][i] = 1.0f - fArray[i];
            }
        }
        if (this.setting.isShading) {
            gL2.glEnable(2896);
            gL2.glEnable(16384);
        } else {
            gL2.glDisable(2896);
            gL2.glDisable(16384);
        }
        gL2.glEnable(2903);
        gL2.glColor3f(1.0f, 1.0f, 1.0f);
        gL2.glEnable(2929);
        gL2.glEnable(2884);
        gL2.glGetIntegerv(2978, this.viewport, 0);
        gL2.glMatrixMode(5889);
        gL2.glLoadIdentity();
        float f = (float)((double)this.viewport[2] / (double)this.viewport[3]);
        float f2 = this.camera.getDistance();
        if (this.setting.isPerspective) {
            this.glu.gluPerspective(Math.toDegrees(this.camera.fov), (double)f, (double)(f2 / 100.0f), (double)f2 * 1.5);
        } else {
            double d = (double)f2 * Math.tan(this.camera.fov / 2.0);
            double d2 = d * (double)f;
            gL2.glOrtho(-d2, d2, -d, d, (double)0.3f, (double)f2 * 1.5);
        }
        gL2.glMatrixMode(5888);
        double[] dArray = this.camera.lookatArray();
        gL2.glLoadMatrixd(dArray, 0);
        float[] fArray = new float[3];
        this.camera.light.get(fArray);
        gL2.glLightfv(16384, 4611, fArray, 0);
        gL2.glLightfv(16384, 4610, this.light.getSpecular(), 0);
        gL2.glLightfv(16384, 4609, this.light.getDiffuse(), 0);
        gL2.glLightfv(16384, 4608, this.light.getAmbient(), 0);
        if (this.setting.displayLightDirection) {
            gL2.glLineWidth(3.0f);
            gL2.glColor3f(255.0f, 100.0f, 0.0f);
            gL2.glBegin(1);
            gL2.glVertex3f(0.0f, 0.0f, 0.0f);
            gL2.glVertex3f(fArray[0], fArray[1], fArray[2]);
            gL2.glEnd();
        }
        gL2.glGetDoublev(2982, this.modelview, 0);
        gL2.glGetDoublev(2983, this.projection, 0);
        gL2.glEnable(32823);
        if (this.setting.isPerspective) {
            gL2.glPolygonOffset(1.0f, 1.0f);
        } else {
            gL2.glPolygonOffset(0.8f, 0.8f);
        }
        this.renderModel(gL2, models);
        gL2.glDisable(32823);
        int n = gL2.glGetError();
        if (n != 0) {
            throw new Exception("gl error: " + n);
        }
    }

    private void renderOthers(GL2 gL2) throws Exception {
        int n;
        Models models = this.scene.getRegisteredModels();
        if (!models.isCompiled()) {
            return;
        }
        if (this.currentModel == null) {
            return;
        }
        if (this.setting.displayLatLonGrid) {
            this.renderGrid(gL2, this.currentModel);
        }
        if (this.setting.displayAdditional3D) {
            this.renderAdditional3D(gL2);
        }
        if (this.setting.displayAxis) {
            this.renderAxis(gL2);
        }
        if (this.setting.displayColorBar) {
            gL2.glMatrixMode(5889);
            gL2.glLoadIdentity();
            float f = (float)((double)this.viewport[2] / (double)this.viewport[3]);
            this.glu.gluPerspective(7.6f, f, 0.3f, 300.0f);
            gL2.glMatrixMode(5888);
            gL2.glLoadIdentity();
            this.scene.colorbar.draw(gL2, this.viewport[2], this.viewport[3], this.scene, this);
        }
        if ((n = gL2.glGetError()) != 0) {
            throw new Exception("gl error: " + n);
        }
        for (int n2 : this.polygonIDs) {
            float[] fArray = this.prevRGBAs.get(n2);
            for (int i = 0; i < 3; ++i) {
                this.currentModel.rgba[n2][i] = fArray[i];
            }
        }
    }

    private void renderModel(GL2 gL2, Models models) {
        if (!models.isCompiled()) {
            return;
        }
        gL2.glBindBuffer(34962, this.currentModel.getVboId(2));
        ByteBuffer byteBuffer = gL2.glMapBuffer(34962, 35002);
        if (this.currentModel.rewriteColor(byteBuffer)) {
            gL2.glUnmapBuffer(34962);
        }
        gL2.glMaterialfv(1028, 4610, this.currentModel.getSpecular(), 0);
        gL2.glMaterialfv(1028, 4609, this.currentModel.getDiffuse(), 0);
        gL2.glMaterialfv(1028, 4608, this.currentModel.getAmbient(), 0);
        gL2.glMaterialf(1028, 5633, this.currentModel.getShiness());
        gL2.glEnableClientState(32884);
        gL2.glEnableClientState(32885);
        gL2.glEnableClientState(32886);
        gL2.glBindBuffer(34962, this.currentModel.getVboId(0));
        gL2.glVertexPointer(3, 5126, 0, 0L);
        gL2.glBindBuffer(34962, this.currentModel.getVboId(1));
        gL2.glNormalPointer(5126, 0, 0L);
        gL2.glBindBuffer(34962, this.currentModel.getVboId(2));
        gL2.glColorPointer(4, 5126, 0, 0L);
        int n = 3 * this.currentModel.getNFace();
        gL2.glDrawArrays(4, 0, n);
        gL2.glDisableClientState(32884);
        gL2.glDisableClientState(32885);
        gL2.glDisableClientState(32886);
    }

    private void renderGrid(GL2 gL2, Model model) {
        Grids.Grid[] gridArray;
        gL2.glEnableClientState(32884);
        gL2.glEnableClientState(32886);
        int n = 3 * model.getNFace();
        gL2.glDisable(2896);
        gL2.glDisable(2903);
        gL2.glDisable(16384);
        gL2.glEnable(3042);
        gL2.glBlendFunc(770, 771);
        gL2.glLineWidth(0.5f);
        Grids grids = model.getGrids();
        int n2 = 0;
        for (Grids.Grid grid : gridArray = new Grids.Grid[]{grids.r, grids.w}) {
            for (int i = 0; i < grid.zeroIndex.size(); ++i) {
                int n3 = grid.zeroIndex.get(i);
                int n4 = n3 - n2 - 1;
                if (n4 > 0) {
                    gL2.glDrawArrays(3, n + n2 + 1, n4);
                }
                n2 = n3;
            }
            n2 = 0;
            n += grid.size;
        }
        gL2.glDisable(2848);
        gL2.glDisable(3042);
        gL2.glEnable(2896);
        gL2.glEnable(2903);
        gL2.glEnable(16384);
        gL2.glDisableClientState(32884);
        gL2.glDisableClientState(32886);
    }

    private void renderAdditional3D(GL2 gL2) {
        gL2.glDisable(2896);
        gL2.glDisable(2903);
        gL2.glDisable(16384);
        gL2.glEnable(3042);
        gL2.glBlendFunc(770, 771);
        for (General3D general3D : this.scene.generals) {
            if (!general3D.active) continue;
            gL2.glLineWidth(general3D.lineSize);
            for (float[][] fArray : general3D.lines) {
                gL2.glBegin(3);
                float[] fArray2 = general3D.lineColor;
                gL2.glColor4d((double)fArray2[0], (double)fArray2[1], (double)fArray2[2], (double)fArray2[3]);
                for (int i = 0; i < fArray.length; ++i) {
                    float[] fArray3 = fArray[i];
                    if ((double)fArray3[0] == 0.0 && (double)fArray3[1] == 0.0 && (double)fArray3[2] == 0.0) continue;
                    gL2.glVertex3f(fArray3[0], fArray3[1], fArray3[2]);
                }
                gL2.glEnd();
            }
        }
        gL2.glDisable(2848);
        gL2.glDisable(3042);
        gL2.glEnable(2896);
        gL2.glEnable(2903);
        gL2.glEnable(16384);
    }

    public void renderAxis(GL2 gL2) {
        gL2.glDisable(2929);
        gL2.glLineWidth(3.0f);
        gL2.glMatrixMode(5889);
        gL2.glLoadIdentity();
        gL2.glMatrixMode(5888);
        gL2.glLoadIdentity();
        gL2.glTranslatef(0.85f, 0.85f, 0.0f);
        float f = (float)((double)this.viewport[3] / (double)this.viewport[2]);
        gL2.glScaled((double)f, 1.0, 1.0);
        Matrix4d matrix4d = this.camera.lookat();
        matrix4d.setTranslation(new Vector3d());
        gL2.glMultMatrixd(this.camera.matrixToArray(matrix4d), 0);
        gL2.glBegin(1);
        gL2.glColor3f(1.0f, 0.0f, 0.0f);
        gL2.glVertex3f(0.0f, 0.0f, 0.0f);
        gL2.glVertex3f(0.1f, 0.0f, 0.0f);
        gL2.glColor3f(0.0f, 1.0f, 0.0f);
        gL2.glVertex3f(0.0f, 0.0f, 0.0f);
        gL2.glVertex3f(0.0f, 0.1f, 0.0f);
        gL2.glColor3f(0.0f, 0.0f, 1.0f);
        gL2.glVertex3f(0.0f, 0.0f, 0.0f);
        gL2.glVertex3f(0.0f, 0.0f, 0.1f);
        gL2.glEnd();
        matrix4d.invert();
        double[] dArray = this.camera.matrixToArray(matrix4d);
        String[] stringArray = new String[]{"X", "Z", "Y"};
        float[] fArray = new float[]{0.08f, 0.01f, 0.01f, 0.08f, 0.01f};
        for (int i = 0; i < 3; ++i) {
            gL2.glPushMatrix();
            this.tr.begin3DRendering();
            this.tr.setColor(1.0f, 1.0f, 0.0f, 1.0f);
            gL2.glTranslatef(fArray[i], fArray[i + 1], fArray[i + 2]);
            gL2.glMultMatrixd(dArray, 0);
            this.tr.draw3D(stringArray[i], 0.0f, 0.0f, 0.0f, 0.0015f);
            this.tr.end3DRendering();
            gL2.glPopMatrix();
        }
    }

    public class RenderSetting {
        public boolean displayLightDirection = false;
        public boolean displayColorBar = true;
        public boolean displayLatLonGrid = false;
        public boolean displayAdditional3D = true;
        public boolean displayAxis = true;
        public boolean isShading = true;
        public boolean isTexRender = true;
        public boolean fixedLightPos = false;
        public boolean isPerspective = true;
        public int colorbarIndex = 0;
    }
}

