/*
 * Decompiled with CFR 0.152.
 */
package aigis.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.text.DecimalFormat;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class RescaleRangeDialog
extends JDialog {
    private final JPanel contentPanel = new JPanel();
    private JTextField textMinimum;
    private JTextField textMaximum;
    private EventListener eventListener;

    public static void main(String[] stringArray) {
        try {
            RescaleRangeDialog rescaleRangeDialog = new RescaleRangeDialog(null);
            rescaleRangeDialog.setDefaultCloseOperation(2);
            rescaleRangeDialog.setVisible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public RescaleRangeDialog(Frame frame) {
        super(frame);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                if (RescaleRangeDialog.this.eventListener != null) {
                    RescaleRangeDialog.this.eventListener.close();
                }
            }
        });
        this.setTitle("Rescale Range");
        this.setResizable(false);
        this.setBounds(100, 100, 370, 200);
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{40, 62, 0, 40};
        gridBagLayout.rowHeights = new int[]{35, 26, 26, 0};
        gridBagLayout.columnWeights = new double[]{0.0, 0.0, 1.0, 0.0};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, 0.0, Double.MIN_VALUE};
        this.contentPanel.setLayout(gridBagLayout);
        Serializable serializable = new JLabel("Minimum");
        Serializable serializable2 = new GridBagConstraints();
        ((GridBagConstraints)serializable2).fill = 2;
        ((GridBagConstraints)serializable2).insets = new Insets(0, 0, 5, 5);
        ((GridBagConstraints)serializable2).gridx = 1;
        ((GridBagConstraints)serializable2).gridy = 1;
        this.contentPanel.add((Component)serializable, serializable2);
        this.textMinimum = new JTextField();
        this.textMinimum.setText("0");
        this.textMinimum.setHorizontalAlignment(11);
        serializable = new GridBagConstraints();
        ((GridBagConstraints)serializable).anchor = 11;
        ((GridBagConstraints)serializable).fill = 2;
        ((GridBagConstraints)serializable).insets = new Insets(0, 0, 5, 5);
        ((GridBagConstraints)serializable).gridx = 2;
        ((GridBagConstraints)serializable).gridy = 1;
        this.contentPanel.add((Component)this.textMinimum, serializable);
        this.textMinimum.setColumns(10);
        serializable = new JLabel("Maximum");
        serializable2 = new GridBagConstraints();
        ((GridBagConstraints)serializable2).anchor = 17;
        ((GridBagConstraints)serializable2).insets = new Insets(0, 0, 0, 5);
        ((GridBagConstraints)serializable2).gridx = 1;
        ((GridBagConstraints)serializable2).gridy = 2;
        this.contentPanel.add((Component)serializable, serializable2);
        this.textMaximum = new JTextField();
        this.textMaximum.setText("0");
        this.textMaximum.setHorizontalAlignment(11);
        serializable = new GridBagConstraints();
        ((GridBagConstraints)serializable).anchor = 11;
        ((GridBagConstraints)serializable).fill = 2;
        ((GridBagConstraints)serializable).insets = new Insets(0, 0, 0, 5);
        ((GridBagConstraints)serializable).gridx = 2;
        ((GridBagConstraints)serializable).gridy = 2;
        this.contentPanel.add((Component)this.textMaximum, serializable);
        this.textMaximum.setColumns(10);
        serializable = new JPanel();
        serializable2 = new FlowLayout(2);
        ((FlowLayout)serializable2).setHgap(0);
        ((Container)serializable).setLayout((LayoutManager)((Object)serializable2));
        this.getContentPane().add((Component)serializable, "South");
        JButton jButton = new JButton("Apply");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RescaleRangeDialog.this.applay();
            }
        });
        ((Container)serializable).add(jButton);
        jButton = new JButton("Reset");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (RescaleRangeDialog.this.eventListener != null) {
                    RescaleRangeDialog.this.eventListener.reset();
                }
            }
        });
        ((Container)serializable).add(jButton);
        jButton = new JButton("OK");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RescaleRangeDialog.this.applay();
                RescaleRangeDialog.this.close();
            }
        });
        jButton.setActionCommand("OK");
        ((Container)serializable).add(jButton);
        this.getRootPane().setDefaultButton(jButton);
        jButton = new JButton("Cancel");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RescaleRangeDialog.this.close();
            }
        });
        jButton.setActionCommand("Cancel");
        ((Container)serializable).add(jButton);
    }

    public void setValues(double d, double d2) {
        DecimalFormat decimalFormat = new DecimalFormat("####.##########");
        this.textMaximum.setText(decimalFormat.format(d));
        this.textMinimum.setText(decimalFormat.format(d2));
    }

    public void setEventListener(EventListener eventListener) {
        this.eventListener = eventListener;
    }

    private void applay() {
        try {
            double d = Double.parseDouble(this.textMinimum.getText());
            double d2 = Double.parseDouble(this.textMaximum.getText());
            if (this.eventListener != null) {
                this.eventListener.applay(d2, d);
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, "Invalid data. Please input numerical value!!", "Error", 0);
        }
    }

    private void close() {
        this.setVisible(false);
        if (this.eventListener != null) {
            this.eventListener.close();
        }
    }

    public static interface EventListener {
        public void applay(double var1, double var3);

        public void close();

        public void reset();
    }
}

