/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits.compression.algorithm.rice;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.logging.Logger;
import nom.tam.fits.compression.algorithm.api.ICompressor;
import nom.tam.fits.compression.algorithm.quant.QuantizeProcessor;
import nom.tam.fits.compression.algorithm.rice.BitBuffer;
import nom.tam.fits.compression.algorithm.rice.RiceCompressOption;
import nom.tam.fits.compression.algorithm.rice.RiceQuantizeCompressOption;
import nom.tam.util.type.PrimitiveTypes;

public abstract class RiceCompressor<T extends Buffer>
implements ICompressor<T> {
    private static final Logger LOG = Logger.getLogger(RiceCompressor.class.getName());
    private static final int BITS_OF_1_BYTE = 8;
    private static final int BITS_PER_BYTE = 8;
    private static final int BYTE_MASK = 255;
    private static final int FS_BITS_FOR_BYTE = 3;
    private static final int FS_BITS_FOR_INT = 5;
    private static final int FS_BITS_FOR_SHORT = 4;
    private static final int FS_MAX_FOR_BYTE = 6;
    private static final int FS_MAX_FOR_INT = 25;
    private static final int FS_MAX_FOR_SHORT = 14;
    private static final int[] NONZERO_COUNT = new int[]{0, 1, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8};
    private final int bBits;
    private final int bitsPerPixel;
    private final int blockSize;
    private final int fsBits;
    private final int fsMax;

    private RiceCompressor(RiceCompressOption option) {
        this.blockSize = option.getBlockSize();
        if (option.getBytePix() == PrimitiveTypes.BYTE.size()) {
            this.fsBits = 3;
            this.fsMax = 6;
            this.bitsPerPixel = 8;
        } else if (option.getBytePix() == PrimitiveTypes.SHORT.size()) {
            this.fsBits = 4;
            this.fsMax = 14;
            this.bitsPerPixel = 16;
        } else if (option.getBytePix() == PrimitiveTypes.INT.size()) {
            this.fsBits = 5;
            this.fsMax = 25;
            this.bitsPerPixel = 32;
        } else {
            throw new UnsupportedOperationException("Rice only supports 1/2/4 type per pixel");
        }
        this.bBits = 1 << this.fsBits;
    }

    protected void compress(int dataLength, int firstPixel, BitBuffer buffer) {
        int lastpix = firstPixel;
        buffer.putInt(lastpix, this.bitsPerPixel);
        int thisblock = this.blockSize;
        for (int i = 0; i < dataLength; i += this.blockSize) {
            if (dataLength - i < this.blockSize) {
                thisblock = dataLength - i;
            }
            long[] diff = new long[this.blockSize];
            double pixelsum = 0.0;
            for (int j = 0; j < thisblock; ++j) {
                int nextpix = this.nextPixel();
                long pdiff = nextpix - lastpix;
                diff[j] = Math.abs(pdiff < 0L ? pdiff << 1 ^ 0xFFFFFFFFFFFFFFFFL : pdiff << 1);
                pixelsum += (double)diff[j];
                lastpix = nextpix;
            }
            double dpsum = (pixelsum - (double)thisblock / 2.0 - 1.0) / (double)thisblock;
            if (dpsum < 0.0) {
                dpsum = 0.0;
            }
            long psum = (long)dpsum >> 1;
            int fs = 0;
            while (psum > 0L) {
                psum >>= 1;
                ++fs;
            }
            if (fs >= this.fsMax) {
                buffer.putInt(this.fsMax + 1, this.fsBits);
                for (int j = 0; j < thisblock; ++j) {
                    buffer.putLong(diff[j], this.bBits);
                }
                continue;
            }
            if (fs == 0 && pixelsum == 0.0) {
                buffer.putInt(0, this.fsBits);
                continue;
            }
            buffer.putInt(fs + 1, this.fsBits);
            int fsmask = (1 << fs) - 1;
            int bitsToGo = buffer.missingBitsInCurrentByte();
            int bitBuffer = buffer.bitbuffer() >> bitsToGo;
            buffer.movePosition(bitsToGo - 8);
            for (int j = 0; j < thisblock; ++j) {
                int v = (int)diff[j];
                int top = v >> fs;
                if (bitsToGo >= top + 1) {
                    bitBuffer <<= top + 1;
                    bitBuffer |= 1;
                    bitsToGo -= top + 1;
                } else {
                    buffer.putByte((byte)((bitBuffer <<= bitsToGo) & 0xFF));
                    top -= bitsToGo;
                    while (top >= 8) {
                        buffer.putByte((byte)0);
                        top -= 8;
                    }
                    bitBuffer = 1;
                    bitsToGo = 7 - top;
                }
                if (fs <= 0) continue;
                bitBuffer <<= fs;
                bitBuffer |= v & fsmask;
                bitsToGo -= fs;
                while (bitsToGo <= 0) {
                    buffer.putByte((byte)(bitBuffer >> -bitsToGo & 0xFF));
                    bitsToGo += 8;
                }
            }
            buffer.putByte((byte)(bitBuffer & 0xFF), 8 - bitsToGo);
        }
        buffer.close();
    }

    protected void decompressBuffer(ByteBuffer readBuffer, int nx) {
        int lastpix = 0;
        if (this.bitsPerPixel == PrimitiveTypes.BYTE.bitPix()) {
            lastpix = readBuffer.get();
        } else if (this.bitsPerPixel == PrimitiveTypes.SHORT.bitPix()) {
            lastpix = readBuffer.getShort();
        } else if (this.bitsPerPixel == PrimitiveTypes.INT.bitPix()) {
            lastpix = readBuffer.getInt();
        }
        int b = readBuffer.get() & 0xFF;
        int nbits = 8;
        int i = 0;
        while (i < nx) {
            int diff;
            nbits -= this.fsBits;
            while (nbits < 0) {
                b = b << 8 | readBuffer.get() & 0xFF;
                nbits += 8;
            }
            int fs = (b >> nbits) - 1;
            b &= (1 << nbits) - 1;
            int imax = i + this.blockSize;
            if (imax > nx) {
                imax = nx;
            }
            if (fs < 0) {
                while (i < imax) {
                    this.nextPixel(lastpix);
                    ++i;
                }
                continue;
            }
            if (fs == this.fsMax) {
                while (i < imax) {
                    int k = this.bBits - nbits;
                    diff = b << k;
                    k -= 8;
                    while (k >= 0) {
                        b = readBuffer.get() & 0xFF;
                        diff |= b << k;
                        k -= 8;
                    }
                    if (nbits > 0) {
                        b = readBuffer.get() & 0xFF;
                        diff |= b >> -k;
                        b &= (1 << nbits) - 1;
                    } else {
                        b = 0;
                    }
                    diff = (diff & 1) == 0 ? (diff >>= 1) : ~(diff >> 1);
                    lastpix = diff + lastpix;
                    this.nextPixel(lastpix);
                    ++i;
                }
                continue;
            }
            while (i < imax) {
                while (b == 0) {
                    nbits += 8;
                    b = readBuffer.get() & 0xFF;
                }
                int nzero = nbits - NONZERO_COUNT[b & 0xFF];
                b ^= 1 << (nbits -= nzero + 1);
                nbits -= fs;
                while (nbits < 0) {
                    b = b << 8 | readBuffer.get() & 0xFF;
                    nbits += 8;
                }
                diff = nzero << fs | b >> nbits;
                b &= (1 << nbits) - 1;
                diff = (diff & 1) == 0 ? (diff >>= 1) : ~(diff >> 1);
                lastpix = diff + lastpix;
                this.nextPixel(lastpix);
                ++i;
            }
        }
        if (readBuffer.limit() > readBuffer.position()) {
            LOG.warning("decompressing left over some extra bytes got: " + readBuffer.limit() + " but needed only " + readBuffer.position());
        }
    }

    protected abstract int nextPixel();

    protected abstract void nextPixel(int var1);

    public static class ShortRiceCompressor
    extends RiceCompressor<ShortBuffer> {
        private ShortBuffer pixelBuffer;

        public ShortRiceCompressor(RiceCompressOption option) {
            super(option.setDefaultBytePix(PrimitiveTypes.SHORT.size()));
        }

        @Override
        public boolean compress(ShortBuffer buffer, ByteBuffer writeBuffer) {
            this.pixelBuffer = buffer;
            super.compress(buffer.limit(), this.pixelBuffer.get(this.pixelBuffer.position()), new BitBuffer(writeBuffer));
            return true;
        }

        @Override
        public void decompress(ByteBuffer readBuffer, ShortBuffer buffer) {
            this.pixelBuffer = buffer;
            super.decompressBuffer(readBuffer, buffer.limit());
        }

        @Override
        protected int nextPixel() {
            return this.pixelBuffer.get();
        }

        @Override
        protected void nextPixel(int pixel) {
            this.pixelBuffer.put((short)pixel);
        }
    }

    public static class IntRiceCompressor
    extends RiceCompressor<IntBuffer> {
        private IntBuffer pixelBuffer;

        public IntRiceCompressor(RiceCompressOption option) {
            super(option.setDefaultBytePix(PrimitiveTypes.INT.size()));
        }

        @Override
        public boolean compress(IntBuffer buffer, ByteBuffer writeBuffer) {
            this.pixelBuffer = buffer;
            super.compress(buffer.limit(), this.pixelBuffer.get(this.pixelBuffer.position()), new BitBuffer(writeBuffer));
            return true;
        }

        @Override
        public void decompress(ByteBuffer readBuffer, IntBuffer buffer) {
            this.pixelBuffer = buffer;
            super.decompressBuffer(readBuffer, buffer.limit());
        }

        @Override
        protected int nextPixel() {
            return this.pixelBuffer.get();
        }

        @Override
        protected void nextPixel(int pixel) {
            this.pixelBuffer.put(pixel);
        }
    }

    public static class FloatRiceCompressor
    extends QuantizeProcessor.FloatQuantCompressor {
        public FloatRiceCompressor(RiceQuantizeCompressOption options) {
            super(options, new IntRiceCompressor(options.getRiceCompressOption()));
        }
    }

    public static class DoubleRiceCompressor
    extends QuantizeProcessor.DoubleQuantCompressor {
        public DoubleRiceCompressor(RiceQuantizeCompressOption options) {
            super(options, new IntRiceCompressor(options.getRiceCompressOption()));
        }
    }

    public static class ByteRiceCompressor
    extends RiceCompressor<ByteBuffer> {
        private ByteBuffer pixelBuffer;

        public ByteRiceCompressor(RiceCompressOption option) {
            super(option.setDefaultBytePix(PrimitiveTypes.BYTE.size()));
        }

        @Override
        public boolean compress(ByteBuffer buffer, ByteBuffer writeBuffer) {
            this.pixelBuffer = buffer;
            super.compress(buffer.limit(), this.pixelBuffer.get(this.pixelBuffer.position()), new BitBuffer(writeBuffer));
            return true;
        }

        @Override
        public void decompress(ByteBuffer readBuffer, ByteBuffer buffer) {
            this.pixelBuffer = buffer;
            super.decompressBuffer(readBuffer, buffer.limit());
        }

        @Override
        protected int nextPixel() {
            return this.pixelBuffer.get();
        }

        @Override
        protected void nextPixel(int pixel) {
            this.pixelBuffer.put((byte)pixel);
        }
    }
}

