/*
 * Decompiled with CFR 0.152.
 */
package aigis;

import aigis.Logger;
import aigis.ui.MainFrame;
import java.awt.Component;
import java.awt.EventQueue;
import java.io.File;
import java.io.FileOutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.util.Collections;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;

public class App {
    public static boolean isMacExe = false;

    public static void main(final String[] stringArray) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    if (stringArray.length > 0 && stringArray[0].equalsIgnoreCase("mac")) {
                        isMacExe = true;
                    }
                    MainFrame mainFrame = new MainFrame();
                    mainFrame.setSize(1180, 850);
                    mainFrame.setVisible(true);
                    mainFrame.openFirst();
                }
                catch (Exception exception) {
                    Logger.Error(exception);
                    String string = exception.getMessage();
                    JOptionPane.showMessageDialog(null, string == null ? "An unknown error occurred.." : string, "Error", 0);
                }
            }
        });
    }

    public static File getWorkingDir() {
        CodeSource codeSource = App.class.getProtectionDomain().getCodeSource();
        try {
            return new File(codeSource.getLocation().toURI().getPath()).getParentFile();
        }
        catch (URISyntaxException uRISyntaxException) {
            Logger.Error(uRISyntaxException);
            return null;
        }
    }

    private static ResourceBundle getBundle() throws Exception {
        File file = new File(".");
        if (isMacExe) {
            file = App.getWorkingDir();
        }
        URLClassLoader uRLClassLoader = new URLClassLoader(new URL[]{file.toURI().toURL()});
        ResourceBundle resourceBundle = ResourceBundle.getBundle("AiGIS", Locale.getDefault(), uRLClassLoader);
        return resourceBundle;
    }

    public static String getProp(String string) {
        try {
            ResourceBundle resourceBundle = App.getBundle();
            return resourceBundle.getString(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void setProp(String string, String string2) {
        try {
            Object object;
            Properties properties = new Properties();
            try {
                object = App.getBundle();
                for (String string3 : Collections.list(((ResourceBundle)object).getKeys())) {
                    properties.setProperty(string3, ((ResourceBundle)object).getString(string3));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            properties.setProperty(string, string2);
            object = new File("AiGIS.properties");
            if (isMacExe) {
                object = new File(App.getWorkingDir(), "AiGIS.properties");
            }
            properties.store(new FileOutputStream((File)object), "AiGIS");
        }
        catch (Exception exception) {
            Logger.Error(exception);
        }
    }

    public static JFileChooser showOpenDialog(Component component, String string, int n, FileNameExtensionFilter fileNameExtensionFilter, boolean bl) {
        int n2;
        if (string == null) {
            string = System.getProperty("user.home");
        }
        File file = new File(string);
        JFileChooser jFileChooser = new JFileChooser(file);
        jFileChooser.setFileSelectionMode(n);
        if (fileNameExtensionFilter != null) {
            jFileChooser.setFileFilter(fileNameExtensionFilter);
        }
        if ((n2 = bl ? jFileChooser.showOpenDialog(component) : jFileChooser.showSaveDialog(component)) == 0) {
            return jFileChooser;
        }
        return null;
    }
}

