/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits.header;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import nom.tam.fits.header.Checksum;
import nom.tam.fits.header.Compression;
import nom.tam.fits.header.DataDescription;
import nom.tam.fits.header.FitsHeaderImpl;
import nom.tam.fits.header.IFitsHeader;
import nom.tam.fits.header.InstrumentDescription;
import nom.tam.fits.header.NonStandard;
import nom.tam.fits.header.ObservationDescription;
import nom.tam.fits.header.Standard;

public final class GenericKey {
    private static final int NUMBER_BASE = 10;
    private static final Map<String, IFitsHeader> STANDARD_KEYS;

    public static IFitsHeader create(String key) {
        IFitsHeader result = STANDARD_KEYS.get(key);
        if (result == null) {
            result = new FitsHeaderImpl(key, IFitsHeader.SOURCE.UNKNOWN, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.ANY, "");
        }
        return result;
    }

    public static IFitsHeader[] create(String[] keys) {
        IFitsHeader[] result = new IFitsHeader[keys.length];
        for (int index = 0; index < result.length; ++index) {
            result[index] = GenericKey.create(keys[index]);
        }
        return result;
    }

    public static int getN(String card) {
        int n = 0;
        int numberBase = 1;
        for (int index = card.length() - 1; index >= 0 && Character.isDigit(card.charAt(index)); --index) {
            n += (card.charAt(index) - 48) * numberBase;
            numberBase *= 10;
        }
        return n;
    }

    public static IFitsHeader lookup(String key) {
        int keyLength = key.length();
        if (keyLength > 0 && Character.isDigit(key.charAt(keyLength - 1))) {
            StringBuilder builder = new StringBuilder();
            for (int index = 0; index < keyLength; ++index) {
                char character = key.charAt(index);
                if (Character.isDigit(character)) {
                    if (builder.charAt(builder.length() - 1) == 'n') continue;
                    builder.append('n');
                    continue;
                }
                builder.append(character);
            }
            return STANDARD_KEYS.get(builder.toString());
        }
        return STANDARD_KEYS.get(key);
    }

    private GenericKey() {
    }

    static {
        HashMap<String, Enum> headers = new HashMap<String, Enum>();
        for (Standard standard : Standard.values()) {
            headers.put(standard.key(), standard);
        }
        for (Enum enum_ : Checksum.values()) {
            headers.put(enum_.key(), enum_);
        }
        for (Enum enum_ : Compression.values()) {
            headers.put(enum_.key(), enum_);
        }
        for (Enum enum_ : DataDescription.values()) {
            headers.put(enum_.key(), enum_);
        }
        for (Enum enum_ : InstrumentDescription.values()) {
            headers.put(enum_.key(), enum_);
        }
        for (Enum enum_ : NonStandard.values()) {
            headers.put(enum_.key(), enum_);
        }
        for (Enum enum_ : ObservationDescription.values()) {
            headers.put(enum_.key(), enum_);
        }
        STANDARD_KEYS = Collections.unmodifiableMap(headers);
    }
}

