/*
 * Decompiled with CFR 0.152.
 */
package aigis;

import aigis.App;
import aigis.Logger;
import aigis.gl.ColorBar;
import aigis.model.ChartData;
import aigis.model.General3D;
import aigis.model.Model;
import aigis.model.ModelSelection;
import aigis.model.Models;
import aigis.model.SettingModel;
import aigis.model.SpectrumMap;
import aigis.model.loader.ChartLoader;
import aigis.model.loader.GeneralLoader;
import aigis.ui.LoadingDialog;
import com.jogamp.opengl.GL2;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;

public class Scene {
    public ColorBar colorbar = new ColorBar();
    private SettingModel settings = new SettingModel();
    private Models registeredModels = new Models();
    private HashMap<String, ChartData> chartData = new HashMap();
    private double modelSize = 0.0;
    private boolean isDirty = false;
    public ArrayList<General3D> generals = new ArrayList();

    public void load(File file, LoadingDialog loadingDialog, boolean bl) throws Exception {
        try {
            loadingDialog.updateInfo("configfile");
            this.settings.loadData(file);
            this.settings.dump();
            this.registeredModels = new Models();
            int n = 0;
            for (SettingModel.ShapePath shapePath : this.settings.getPathList()) {
                for (ModelSelection.Resolution resolution : shapePath.keySet()) {
                    SettingModel.ShapePathData shapePathData = shapePath.get(resolution);
                    loadingDialog.updateInfo(shapePathData.path);
                    Model model = new Model(file.getAbsolutePath(), shapePathData.path, this.settings.getGridwPath(), this.settings.getGridrPath());
                    this.registeredModels.addModel(new ModelSelection(resolution, n), model);
                    this.modelSize = model.getSize();
                }
                ++n;
            }
            this.loadGeneral3D();
            this.loadMapData(loadingDialog, bl);
        }
        catch (Exception exception) {
            this.registeredModels = new Models();
            this.generals.clear();
            this.settings.clear();
            this.chartData.clear();
            throw exception;
        }
        Model model = this.registeredModels.getModel(new ModelSelection(ModelSelection.Resolution.Low, 0));
        model.addSpectrumMap("#None", new SpectrumMap(model.getNFace(), "#None", this.colorbar));
        model.changeSpectrumMap("#None", 0);
        this.isDirty = true;
    }

    public void loadGeneral3D() throws Exception {
        String string = this.settings.getGridPath();
        if (string != null) {
            File file = new File(this.settings.getBaseDir().getAbsolutePath() + File.separator + string);
            String[] stringArray = file.list();
            ArrayList<General3D> arrayList = new ArrayList<General3D>();
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                if (string2.trim().startsWith(".")) continue;
                General3D general3D = this.findGeneral(string2);
                if (general3D == null) {
                    general3D = new General3D();
                }
                GeneralLoader.load(file.getAbsolutePath(), string2, general3D);
                arrayList.add(general3D);
            }
            this.generals = arrayList;
        } else {
            this.generals.clear();
        }
    }

    public void loadGeneral3D(String string) throws Exception {
        String string2 = this.settings.getGridPath();
        if (string2 == null) {
            return;
        }
        File file = new File(this.settings.getBaseDir().getAbsolutePath() + File.separator + string2);
        General3D general3D = this.findGeneral(string);
        if (general3D == null) {
            general3D = new General3D();
            this.generals.add(general3D);
        }
        GeneralLoader.load(file.getAbsolutePath(), string, general3D);
    }

    private General3D findGeneral(String string) {
        for (General3D general3D : this.generals) {
            if (!general3D.name.equals(string)) continue;
            return general3D;
        }
        return null;
    }

    public void loadLookUpTable() throws Exception {
        String string = App.getProp("LookUpTablePath");
        if (string == null) {
            return;
        }
        File file = new File(string);
        File[] fileArray = file.listFiles();
        this.colorbar.init();
        if (fileArray == null) {
            return;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].getName().startsWith(".")) continue;
            Logger.Debug("lookup:" + fileArray[i].getName());
            this.colorbar.load(fileArray[i].getName(), fileArray[i].getAbsolutePath());
        }
    }

    public void loadMapData(LoadingDialog loadingDialog, boolean bl) throws Exception {
        Object object;
        Object object2;
        File[] fileArray;
        String[] stringArray;
        Object object3;
        String string = this.settings.getBaseDir().getAbsolutePath() + File.separator;
        ArrayList<String> arrayList = new ArrayList<String>();
        this.chartData.clear();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        int n = 0;
        for (SettingModel.ShapePath shapePath : this.settings.getPathList()) {
            for (Object object4 : shapePath.keySet()) {
                int n2;
                object3 = shapePath.get((ModelSelection.Resolution)((Object)object4));
                loadingDialog.updateInfo(((SettingModel.ShapePathData)object3).mapDir);
                stringArray = this.registeredModels.getModel(new ModelSelection((ModelSelection.Resolution)((Object)object4), n));
                stringArray.getAvailableSpectrumMaps().clear();
                stringArray.addSpectrumMap("#None", new SpectrumMap(stringArray.getNFace(), "#None", this.colorbar));
                File file = new File(string + ((SettingModel.ShapePathData)object3).mapDir);
                fileArray = file.listFiles();
                if (fileArray == null) {
                    fileArray = new File[]{};
                }
                if ((object2 = ((SettingModel.ShapePathData)object3).mapData) != null) {
                    object = ((String)object2).split(",", 0);
                    n2 = fileArray.length;
                    fileArray = new File[fileArray.length + ((String[])object).length];
                    if (n2 > 0) {
                        System.arraycopy(file.listFiles(), 0, fileArray, 0, n2);
                    }
                    for (int i = 0; i < ((Object)object).length; ++i) {
                        fileArray[n2 + i] = new File(string + (String)object[i]);
                    }
                }
                Arrays.sort(fileArray, new Comparator<File>(){

                    @Override
                    public int compare(File file, File file2) {
                        return file.getName().compareToIgnoreCase(file2.getName());
                    }
                });
                object = new ArrayList();
                for (n2 = 0; n2 < fileArray.length; ++n2) {
                    if (fileArray[n2].getName().startsWith(".")) continue;
                    SpectrumMap spectrumMap = new SpectrumMap(fileArray[n2].getPath(), this.colorbar);
                    String string2 = n + "-" + spectrumMap.getName() + "-" + (Object)object4;
                    if (arrayList.contains(string2)) {
                        throw new Exception("The map name \"" + spectrumMap.getName() + "\" is duplicated in \"" + fileArray[n2].getName() + "\".");
                    }
                    Logger.Debug("spec:" + string2);
                    arrayList.add(string2);
                    object.add(spectrumMap);
                }
                if (bl) {
                    Collections.sort(object, new Comparator<SpectrumMap>(){

                        @Override
                        public int compare(SpectrumMap spectrumMap, SpectrumMap spectrumMap2) {
                            return spectrumMap.getName().compareToIgnoreCase(spectrumMap2.getName());
                        }
                    });
                }
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    SpectrumMap spectrumMap = (SpectrumMap)iterator.next();
                    stringArray.addSpectrumMap(spectrumMap.getName(), spectrumMap);
                }
            }
            ++n;
        }
        n = 0;
        for (SettingModel.ShapePath shapePath : this.settings.getPathList()) {
            Object object4;
            SettingModel.ShapePathData shapePathData = shapePath.get(ModelSelection.Resolution.Low);
            object4 = this.registeredModels.getModel(new ModelSelection(ModelSelection.Resolution.Low, n));
            object3 = shapePathData.chartData;
            if (object3 != null) {
                stringArray = ((String)object3).split(",", 0);
                for (int i = 0; i < stringArray.length; ++i) {
                    loadingDialog.updateInfo(stringArray[i]);
                    fileArray = ChartLoader.load(string + stringArray[i], loadingDialog);
                    object2 = ModelSelection.Resolution.Low;
                    if (fileArray.nFace != ((Model)object4).nFace) {
                        object2 = ModelSelection.Resolution.High;
                    }
                    if (!arrayList.contains(object = n + "-" + fileArray.mapName + "-" + object2)) {
                        throw new Exception("The map name \"" + fileArray.mapName + "\" is not defined in '" + object2 + "' type of map data. \n[" + stringArray[i] + "].");
                    }
                    if (arrayList2.contains(object)) {
                        throw new Exception("The map name \"" + fileArray.mapName + "\" is duplicated in \"" + stringArray[i] + "\".");
                    }
                    arrayList2.add(object);
                    this.chartData.put((String)object, (ChartData)fileArray);
                }
            }
            ++n;
        }
    }

    public ChartData getChartData(String string, ModelSelection modelSelection) {
        return this.chartData.get(modelSelection.index + "-" + string + "-" + (Object)((Object)modelSelection.resolution));
    }

    public void compile(GL2 gL2) throws Exception {
        if (!this.isDirty) {
            return;
        }
        try {
            this.registeredModels.compile(gL2);
            this.isDirty = false;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            Logger.Error(outOfMemoryError);
            throw new Exception("OutOfMemoryError");
        }
    }

    public Models getRegisteredModels() {
        return this.registeredModels;
    }

    public Model getModel(ModelSelection modelSelection) {
        return this.getRegisteredModels().getModel(modelSelection);
    }

    public boolean isChangeModel() {
        return this.settings.isChangeModel();
    }

    public String getTitle() {
        return this.settings.getBodyName();
    }

    public SettingModel.ShapePathData getShapePath(ModelSelection modelSelection) {
        return this.settings.getPathList().get(modelSelection.index).get(modelSelection.resolution);
    }

    public String getImageMapPath() {
        return this.settings.getImageMapPath();
    }

    public double getModelSize() {
        return this.modelSize;
    }
}

