/*
 * Decompiled with CFR 0.152.
 */
package aigis.ui;

import aigis.App;
import aigis.Logger;
import aigis.Scene;
import aigis.gl.Renderer;
import aigis.gl.Textures;
import aigis.model.CameraInfo;
import aigis.model.ChartData;
import aigis.model.General3D;
import aigis.model.LatLon;
import aigis.model.Model;
import aigis.model.ModelSelection;
import aigis.model.SettingModel;
import aigis.model.SpectrumMap;
import aigis.model.SpectrumMaps;
import aigis.ui.AboutDialog;
import aigis.ui.ButtonCellEditor;
import aigis.ui.CameraInfoDialog;
import aigis.ui.ChartFrame;
import aigis.ui.GLSplitWindow;
import aigis.ui.LoadingDialog;
import aigis.ui.MainFrameDesign;
import aigis.ui.OpenImageDialog;
import aigis.ui.RescaleRangeDialog;
import aigis.ui.SettingDialog;
import aigis.ui.TexPrevDialog;
import com.jogamp.opengl.awt.GLJPanel;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class MainFrame
extends MainFrameDesign {
    private Scene scene = new Scene();
    private GLSplitWindow window;
    private MapTableModel mapModel;
    private TexTableModel texModel;
    private General3DTableModel g3dModel;
    private SettingDialog settingDialog;
    private TreeMap<String, ChartFrame> chartFrames = new TreeMap();
    private final DecimalFormat doubleFormat = new DecimalFormat("#.########");
    private final ButtonGroup buttonGroupModel = new ButtonGroup();
    private final HashMap<ModelSelection, JRadioButton> modelListButtons = new HashMap();

    public MainFrame() {
        Serializable serializable;
        Serializable serializable2;
        this.setTitle("AiGIS");
        URL uRL = App.class.getResource("res/icon.png");
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(uRL));
        this.setDefaultCloseOperation(3);
        this.setMinimumSize(new Dimension(320, 320));
        final JTextField jTextField = this.getTextCameraLat();
        final JTextField jTextField2 = this.getTextCameraLng();
        final JTextField jTextField3 = this.getTextCameraRoll();
        final JTextField jTextField4 = this.getTextCameraDistance();
        final JTextField jTextField5 = this.getTextFov();
        final JTextField jTextField6 = this.getTextLightLat();
        final JTextField jTextField7 = this.getTextLightLng();
        final JTable jTable = this.getMapTable();
        final JMenuItem jMenuItem = this.getMntmOpen();
        final JMenuItem jMenuItem2 = this.getMntmSaveSS();
        final JMenuItem jMenuItem3 = this.getMntmAbout();
        final JMenuItem jMenuItem4 = this.getMntmSettings();
        final JCheckBoxMenuItem jCheckBoxMenuItem = this.getChckbxmntmColorBar();
        final JCheckBoxMenuItem jCheckBoxMenuItem2 = this.getChckbxmntmLatLonGrid();
        final JCheckBoxMenuItem jCheckBoxMenuItem3 = this.getChckbxmntmShading();
        final JCheckBoxMenuItem jCheckBoxMenuItem4 = this.getChckbxmntmFixedLight();
        final JCheckBoxMenuItem jCheckBoxMenuItem5 = this.getChckbxmntmShowAxis();
        final JMenuItem jMenuItem5 = this.getMntmReset();
        final JMenuItem jMenuItem6 = this.getMntmRescaleRange();
        final JCheckBoxMenuItem jCheckBoxMenuItem6 = this.getChckbxmntmPerspective();
        final JCheckBoxMenuItem jCheckBoxMenuItem7 = this.getChckbxmntmOrthographic();
        final JMenuItem jMenuItem7 = this.getMntmSyncAllViews();
        final JCheckBoxMenuItem jCheckBoxMenuItem8 = this.getChckbxmntmSyncViews();
        final JRadioButtonMenuItem jRadioButtonMenuItem = this.getRadioDivision1();
        final JRadioButtonMenuItem jRadioButtonMenuItem2 = this.getRadioDivision2();
        final JRadioButtonMenuItem jRadioButtonMenuItem3 = this.getRadioDivision4();
        final JMenuItem jMenuItem8 = this.getMntmOpenImage();
        JMenuItem jMenuItem9 = this.getMntmReload();
        JCheckBoxMenuItem jCheckBoxMenuItem9 = this.getChckbxmntmByName();
        JCheckBoxMenuItem jCheckBoxMenuItem10 = this.getChckbxmntmByFilename();
        final JCheckBoxMenuItem jCheckBoxMenuItem11 = this.getChckbxmntmShowAdditional3d();
        final JMenuItem jMenuItem10 = this.getMntmReloadAll();
        final GLJPanel gLJPanel = this.getPanelGL();
        this.window = new GLSplitWindow(gLJPanel, this.scene);
        this.window.setEventListener(new GLSplitWindow.EventListener(){
            final /* synthetic */ MainFrame this$0;
            {
                this.this$0 = mainFrame;
            }

            @Override
            public void cameraMoved(CameraInfo cameraInfo) {
                LatLon latLon = cameraInfo.getLatLng();
                jTextField.setText(this.this$0.doubleFormat.format(latLon.latitude));
                jTextField2.setText(this.this$0.doubleFormat.format(latLon.longitude));
                jTextField3.setText(this.this$0.doubleFormat.format(cameraInfo.roll));
                jTextField4.setText(Float.toString(cameraInfo.getDistance()));
                jTextField5.setText(this.this$0.doubleFormat.format(cameraInfo.getFov()));
            }

            @Override
            public void lightMoved(LatLon latLon) {
                jTextField6.setText(this.this$0.doubleFormat.format(latLon.latitude));
                jTextField7.setText(this.this$0.doubleFormat.format(latLon.longitude));
            }

            @Override
            public void polygonSelected(int n, LatLon latLon) {
                this.this$0.updateMapInfo(n, latLon, null);
            }

            @Override
            public void screenChanged(int n) {
                Renderer renderer = this.this$0.window.getActiveRenderer();
                int n2 = renderer.getPolygonID();
                LatLon latLon = renderer.selectPolygon(n2, false);
                String string = renderer.getCurrentSpectrumKey();
                this.this$0.updateMapInfo(n2, latLon, string);
                jCheckBoxMenuItem.setSelected(renderer.setting.displayColorBar);
                jCheckBoxMenuItem2.setSelected(renderer.setting.displayLatLonGrid);
                jCheckBoxMenuItem3.setSelected(renderer.setting.isShading);
                jCheckBoxMenuItem4.setSelected(renderer.setting.fixedLightPos);
                jCheckBoxMenuItem5.setSelected(renderer.setting.displayAxis);
                jCheckBoxMenuItem6.setSelected(renderer.setting.isPerspective);
                jCheckBoxMenuItem7.setSelected(!renderer.setting.isPerspective);
                this.this$0.selectModelList(renderer.getCuttentSelection());
                jCheckBoxMenuItem11.setSelected(renderer.setting.displayAdditional3D);
                JMenu jMenu = this.this$0.getMnLookUp();
                for (int i = 0; i < jMenu.getItemCount(); ++i) {
                    JRadioButtonMenuItem jRadioButtonMenuItem = (JRadioButtonMenuItem)jMenu.getItem(i);
                    jRadioButtonMenuItem.setSelected(i == renderer.setting.colorbarIndex);
                }
            }
        });
        this.getBtnCameraMove().addActionListener(new ActionListener(){
            final /* synthetic */ MainFrame this$0;
            {
                this.this$0 = mainFrame;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Logger.Debug("Move Camera:" + jTextField.getText() + " - " + jTextField2.getText());
                    float f = Float.parseFloat(jTextField.getText());
                    float f2 = Float.parseFloat(jTextField2.getText());
                    float f3 = Float.parseFloat(jTextField3.getText());
                    this.this$0.window.moveCamera(f, f2, f3);
                    if (jCheckBoxMenuItem4.isSelected()) {
                        LatLon latLon = this.this$0.window.getActiveRenderer().getLightLatLon();
                        jTextField6.setText(this.this$0.doubleFormat.format(latLon.latitude));
                        jTextField7.setText(this.this$0.doubleFormat.format(latLon.longitude));
                    }
                    gLJPanel.repaint();
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(this.this$0, "Invalid data. Lat.:[-90,90], Lon.:[0,360]", "Error", 0);
                }
            }
        });
        this.getBtnCameraSet().addActionListener(new ActionListener(){
            final /* synthetic */ MainFrame this$0;
            {
                this.this$0 = mainFrame;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Logger.Debug("Set Camera: dist:" + jTextField4.getText() + " fov:" + jTextField5.getText());
                    float f = Float.parseFloat(jTextField4.getText());
                    float f2 = Float.parseFloat(jTextField5.getText());
                    this.this$0.window.setCameraDistance(f);
                    this.this$0.window.setFov(f2);
                    gLJPanel.repaint();
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(this.this$0, "Invalid data.", "Error", 0);
                }
            }
        });
        this.getBtnLightMove().addActionListener(new ActionListener(){
            final /* synthetic */ MainFrame this$0;
            {
                this.this$0 = mainFrame;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Logger.Debug("Move Light:" + jTextField6.getText() + " - " + jTextField7.getText());
                    float f = Float.parseFloat(jTextField6.getText());
                    float f2 = Float.parseFloat(jTextField7.getText());
                    this.this$0.window.moveLight(f, f2);
                    gLJPanel.repaint();
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(this.this$0, "Invalid data. Lat.:[-90,90], Lon.:[0,360]", "Error", 0);
                }
            }
        });
        this.getBtnCameraInfo().addActionListener(new ActionListener(){
            final /* synthetic */ MainFrame this$0;
            {
                this.this$0 = mainFrame;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Renderer renderer = this.this$0.window.getActiveRenderer();
                CameraInfoDialog cameraInfoDialog = new CameraInfoDialog((Frame)this.this$0, renderer.getCameraInfo());
                cameraInfoDialog.setLocationRelativeTo(this.this$0);
                cameraInfoDialog.setVisible(true);
                if (cameraInfoDialog.canceled) {
                    return;
                }
                CameraInfo cameraInfo = cameraInfoDialog.getCameraInfo();
                renderer.setCameraInfo(cameraInfo);
                LatLon latLon = cameraInfo.getLatLng();
                jTextField.setText(this.this$0.doubleFormat.format(latLon.latitude));
                jTextField2.setText(this.this$0.doubleFormat.format(latLon.longitude));
                jTextField4.setText(Float.toString(cameraInfo.getDistance()));
                jTextField5.setText(this.this$0.doubleFormat.format(cameraInfo.getFov()));
                jTextField3.setText(this.this$0.doubleFormat.format(cameraInfo.roll));
                latLon = cameraInfo.getLightLatLng();
                jTextField6.setText(this.this$0.doubleFormat.format(latLon.latitude));
                jTextField7.setText(this.this$0.doubleFormat.format(latLon.longitude));
                gLJPanel.repaint();
            }
        });
        this.getBtnInfoCopy().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object;
                TableModel tableModel = MainFrame.this.getInfoTable().getModel();
                String string = "PolygonID : " + tableModel.getValueAt(0, 1);
                String string2 = (String)tableModel.getValueAt(1, 1);
                string = string + "\nLatitude : " + (string2.equals("-") ? string2 : string2 + "\u00b0");
                string2 = (String)tableModel.getValueAt(2, 1);
                string = string + "\nLongitude : " + (string2.equals("-") ? string2 : string2 + "\u00b0");
                string = string + "\nDistance : " + tableModel.getValueAt(3, 1);
                string = string + "\nX : " + tableModel.getValueAt(4, 1);
                string = string + "\nY : " + tableModel.getValueAt(5, 1);
                string = string + "\nZ : " + tableModel.getValueAt(6, 1);
                TableModel tableModel2 = MainFrame.this.getMapTable().getModel();
                for (int i = 0; i < tableModel2.getRowCount(); ++i) {
                    object = (String)tableModel2.getValueAt(i, 0);
                    if (((String)object).equals("#None")) continue;
                    string = string + "\n" + (String)object + " : " + tableModel2.getValueAt(i, 1);
                }
                Logger.Debug(string);
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                object = toolkit.getSystemClipboard();
                StringSelection stringSelection = new StringSelection(string);
                ((Clipboard)object).setContents(stringSelection, stringSelection);
            }
        });
        ActionListener actionListener = new ActionListener(){
            final /* synthetic */ MainFrame this$0;
            {
                this.this$0 = mainFrame;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object;
                if (actionEvent.getSource() == jMenuItem) {
                    this.this$0.openFile(false);
                }
                if (actionEvent.getSource() == jMenuItem2) {
                    this.this$0.saveSS();
                }
                if (actionEvent.getSource() == jMenuItem3) {
                    object = new AboutDialog(this.this$0);
                    ((Dialog)object).setVisible(true);
                }
                if (actionEvent.getSource() == jMenuItem4) {
                    if (this.this$0.settingDialog == null) {
                        this.this$0.settingDialog = new SettingDialog(this.this$0);
                    }
                    object = String.valueOf(App.getProp("LookUpTablePath"));
                    this.this$0.settingDialog.setVisible(true);
                    if (!((String)object).equals(App.getProp("LookUpTablePath"))) {
                        this.this$0.loadLookUpTable();
                    }
                }
            }
        };
        jMenuItem.addActionListener(actionListener);
        jMenuItem2.addActionListener(actionListener);
        jMenuItem3.addActionListener(actionListener);
        jMenuItem4.addActionListener(actionListener);
        ActionListener actionListener2 = new ActionListener(){
            final /* synthetic */ MainFrame this$0;
            {
                this.this$0 = mainFrame;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Renderer renderer = this.this$0.window.getActiveRenderer();
                renderer.setting.isPerspective = actionEvent.getSource() == jCheckBoxMenuItem6;
                gLJPanel.repaint();
            }
        };
        jCheckBoxMenuItem6.addActionListener(actionListener2);
        jCheckBoxMenuItem7.addActionListener(actionListener2);
        ActionListener actionListener3 = new ActionListener(){
            final /* synthetic */ MainFrame this$0;
            {
                this.this$0 = mainFrame;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Renderer renderer = this.this$0.window.getActiveRenderer();
                if (actionEvent.getSource() == jCheckBoxMenuItem) {
                    renderer.setting.displayColorBar = jCheckBoxMenuItem.isSelected();
                }
                if (actionEvent.getSource() == jCheckBoxMenuItem2) {
                    renderer.setting.displayLatLonGrid = jCheckBoxMenuItem2.isSelected();
                }
                if (actionEvent.getSource() == jCheckBoxMenuItem5) {
                    renderer.setting.displayAxis = jCheckBoxMenuItem5.isSelected();
                }
                if (actionEvent.getSource() == jCheckBoxMenuItem4) {
                    renderer.setting.fixedLightPos = jCheckBoxMenuItem4.isSelected();
                    this.this$0.getBtnLightMove().doClick();
                }
                if (actionEvent.getSource() == jCheckBoxMenuItem3) {
                    renderer.changeShading(jCheckBoxMenuItem3.isSelected());
                }
                if (actionEvent.getSource() == jMenuItem5) {
                    this.this$0.window.resetRenderer(true, this.this$0.scene.getModelSize());
                }
                if (actionEvent.getSource() == jMenuItem6) {
                    final SpectrumMap spectrumMap = renderer.getCurrentSpectrum();
                    if (spectrumMap == null) {
                        return;
                    }
                    this.this$0.setEnabled(false);
                    final RescaleRangeDialog rescaleRangeDialog = new RescaleRangeDialog(this.this$0);
                    rescaleRangeDialog.setEventListener(new RescaleRangeDialog.EventListener(){
                        final /* synthetic */ 9 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        @Override
                        public void applay(double d, double d2) {
                            spectrumMap.setCustomRange(d, d2);
                            this.this$1.gLJPanel.repaint();
                        }

                        @Override
                        public void close() {
                            this.this$1.this$0.setEnabled(true);
                        }

                        @Override
                        public void reset() {
                            spectrumMap.clearCustomRange();
                            rescaleRangeDialog.setValues(spectrumMap.orgMaxColor, spectrumMap.orgMinColor);
                            this.this$1.gLJPanel.repaint();
                        }
                    });
                    rescaleRangeDialog.setValues(spectrumMap.maxColor, spectrumMap.minColor);
                    rescaleRangeDialog.setLocationRelativeTo(this.this$0);
                    rescaleRangeDialog.setVisible(true);
                }
                gLJPanel.repaint();
            }
        };
        jCheckBoxMenuItem.addActionListener(actionListener3);
        jCheckBoxMenuItem2.addActionListener(actionListener3);
        jCheckBoxMenuItem3.addActionListener(actionListener3);
        jMenuItem5.addActionListener(actionListener3);
        jMenuItem6.addActionListener(actionListener3);
        jCheckBoxMenuItem4.addActionListener(actionListener3);
        jCheckBoxMenuItem5.addActionListener(actionListener3);
        ActionListener actionListener4 = new ActionListener(){
            final /* synthetic */ MainFrame this$0;
            {
                this.this$0 = mainFrame;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource() == jMenuItem7) {
                    this.this$0.window.sync();
                }
                if (actionEvent.getSource() == jCheckBoxMenuItem8) {
                    ((MainFrame)this.this$0).window.isSync = jCheckBoxMenuItem8.isSelected();
                }
            }
        };
        jMenuItem7.addActionListener(actionListener4);
        jCheckBoxMenuItem8.addActionListener(actionListener4);
        ActionListener actionListener5 = new ActionListener(){
            final /* synthetic */ MainFrame this$0;
            {
                this.this$0 = mainFrame;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource() == jMenuItem8 || actionEvent.getSource() == this.this$0.getBtnAddTex()) {
                    if (!((MainFrame)this.this$0).window.textures.canAddTexture()) {
                        String string = "You can not add more textures.";
                        JOptionPane.showMessageDialog(this.this$0, string, "Warning", 2);
                        return;
                    }
                    OpenImageDialog openImageDialog = new OpenImageDialog((Frame)this.this$0, this.this$0.scene.getImageMapPath());
                    openImageDialog.setLocationRelativeTo(this.this$0);
                    openImageDialog.setVisible(true);
                    if (openImageDialog.canceled) {
                        return;
                    }
                    try {
                        ((MainFrame)this.this$0).window.textures.addTexture(openImageDialog.imageFile, openImageDialog.infoFile, openImageDialog.rotateAngle, openImageDialog.flipType);
                        this.this$0.texModel.fireTableDataChanged();
                    }
                    catch (Exception exception) {
                        Logger.Error(exception);
                        String string = "Failed to open files. \n";
                        if (exception.getMessage() != null) {
                            string = string + "[" + exception.getMessage() + "]";
                        }
                        JOptionPane.showMessageDialog(this.this$0, string, "Error", 0);
                    }
                }
                gLJPanel.repaint();
            }
        };
        jMenuItem8.addActionListener(actionListener5);
        ActionListener actionListener6 = new ActionListener(){
            final /* synthetic */ MainFrame this$0;
            {
                this.this$0 = mainFrame;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                this.this$0.reloadMapData();
                gLJPanel.repaint();
            }
        };
        jMenuItem9.addActionListener(actionListener6);
        jCheckBoxMenuItem9.addActionListener(actionListener6);
        jCheckBoxMenuItem10.addActionListener(actionListener6);
        ActionListener actionListener7 = new ActionListener(){
            final /* synthetic */ MainFrame this$0;
            {
                this.this$0 = mainFrame;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource() == jRadioButtonMenuItem) {
                    this.this$0.window.divide(1);
                }
                if (actionEvent.getSource() == jRadioButtonMenuItem2) {
                    this.this$0.window.divide(2);
                }
                if (actionEvent.getSource() == jRadioButtonMenuItem3) {
                    this.this$0.window.divide(4);
                }
            }
        };
        jRadioButtonMenuItem.addActionListener(actionListener7);
        jRadioButtonMenuItem2.addActionListener(actionListener7);
        jRadioButtonMenuItem3.addActionListener(actionListener7);
        ActionListener actionListener8 = new ActionListener(){
            final /* synthetic */ MainFrame this$0;
            {
                this.this$0 = mainFrame;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Renderer renderer = this.this$0.window.getActiveRenderer();
                if (actionEvent.getSource() == jCheckBoxMenuItem11) {
                    renderer.setting.displayAdditional3D = jCheckBoxMenuItem11.isSelected();
                }
                if (actionEvent.getSource() == jMenuItem10) {
                    try {
                        this.this$0.scene.loadGeneral3D();
                        if (this.this$0.getGeneral3DTable().getCellEditor() != null) {
                            this.this$0.getGeneral3DTable().getCellEditor().stopCellEditing();
                        }
                        this.this$0.g3dModel.fireTableDataChanged();
                    }
                    catch (Exception exception) {
                        Logger.Error(exception);
                        String string = "Failed to open files. \n";
                        if (exception.getMessage() != null) {
                            string = string + "[" + exception.getMessage() + "]";
                        }
                        JOptionPane.showMessageDialog(this.this$0, string, "Error", 0);
                    }
                }
                gLJPanel.repaint();
            }
        };
        jCheckBoxMenuItem11.addActionListener(actionListener8);
        jMenuItem10.addActionListener(actionListener8);
        JTable jTable2 = this.getInfoTable();
        Object[][] objectArray = new String[][]{{"PolygonID", "-"}, {"Latitude", "-"}, {"Longitude", "-"}, {"Distance", "-"}, {"X", "-"}, {"Y", "-"}, {"Z", "-"}};
        Object[] objectArray2 = new String[]{"", ""};
        jTable2.setModel(new DefaultTableModel(objectArray, objectArray2));
        this.mapModel = new MapTableModel();
        jTable.setModel(this.mapModel);
        ButtonCellEditor buttonCellEditor = new ButtonCellEditor("Plot", new ButtonCellEditor.CellEventListener(){

            @Override
            public void actionPerformed(JTable jTable, int n, int n2, boolean bl) {
                ChartFrame chartFrame;
                Renderer renderer = MainFrame.this.window.getActiveRenderer();
                int n3 = renderer.getPolygonID();
                if (n3 < 0) {
                    return;
                }
                String string = (String)jTable.getModel().getValueAt(n, 0);
                ModelSelection modelSelection = renderer.getCuttentSelection();
                String string2 = modelSelection.index + "-" + string + "-" + (Object)((Object)modelSelection.resolution);
                ChartData chartData = MainFrame.this.scene.getChartData(string, modelSelection);
                if (MainFrame.this.chartFrames.containsKey(string2)) {
                    chartFrame = (ChartFrame)MainFrame.this.chartFrames.get(string2);
                } else {
                    chartFrame = new ChartFrame();
                    chartFrame.getPanel().setData(chartData);
                    chartFrame.getPanel().setChartInfo(chartData.mapName, chartData.xLabel, chartData.yLabel);
                    MainFrame.this.chartFrames.put(string2, chartFrame);
                }
                chartFrame.getPanel().addPolygonID(n3);
                chartFrame.setVisible(true);
            }
        }, false);
        String[] stringArray = new String[]{"Name", "Value", "Plot"};
        for (int i = 0; i < stringArray.length; ++i) {
            serializable2 = jTable.getColumnModel().getColumn(i);
            ((TableColumn)serializable2).setHeaderValue(stringArray[i]);
            if (i != 2) continue;
            ((TableColumn)serializable2).setMinWidth(40);
            ((TableColumn)serializable2).setMaxWidth(40);
            ((TableColumn)serializable2).setCellEditor(buttonCellEditor);
            ((TableColumn)serializable2).setCellRenderer(buttonCellEditor);
        }
        ListSelectionModel listSelectionModel = jTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){
            final /* synthetic */ MainFrame this$0;
            {
                this.this$0 = mainFrame;
            }

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    int n = jTable.getSelectedRow();
                    String string = (String)jTable.getModel().getValueAt(n, 0);
                    this.this$0.window.getActiveRenderer().changeSpectrum(string);
                    jMenuItem6.setEnabled(n > 0);
                    gLJPanel.repaint();
                }
            }
        });
        serializable2 = this.getTexInfoTable();
        this.texModel = new TexTableModel();
        ((JTable)serializable2).setModel(this.texModel);
        ((JTable)serializable2).setRowHeight(24);
        ((JTable)serializable2).setRowSelectionAllowed(false);
        ((Component)serializable2).addMouseListener(new MouseAdapter(this, (JTable)serializable2){
            final /* synthetic */ JTable val$texInfoTable;
            final /* synthetic */ MainFrame this$0;
            {
                this.val$texInfoTable = jTable;
                this.this$0 = mainFrame;
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    TexPrevDialog texPrevDialog = new TexPrevDialog(this.this$0);
                    Point point = mouseEvent.getPoint();
                    int n = this.val$texInfoTable.rowAtPoint(point);
                    if (n < 0) {
                        return;
                    }
                    int n2 = this.val$texInfoTable.convertRowIndexToModel(n);
                    Textures.Setting setting = ((MainFrame)this.this$0).window.textures.getTexsInfo().get(n2);
                    texPrevDialog.setTextureSetting(setting);
                    texPrevDialog.setVisible(true);
                }
            }
        });
        ButtonCellEditor buttonCellEditor2 = new ButtonCellEditor(null, new ButtonCellEditor.CellEventListener(){
            final /* synthetic */ MainFrame this$0;
            {
                this.this$0 = mainFrame;
            }

            @Override
            public void actionPerformed(JTable jTable, int n, int n2, boolean bl) {
                if (n2 == 5) {
                    ((MainFrame)this.this$0).window.textures.getTexsInfo().get((int)n).showFrustum = bl;
                } else {
                    ((MainFrame)this.this$0).window.textures.activate(n, n2 - 1, bl);
                }
                gLJPanel.repaint();
            }
        }, true);
        ButtonCellEditor buttonCellEditor3 = new ButtonCellEditor("\u2191", new ButtonCellEditor.CellEventListener(){
            final /* synthetic */ JTable val$texInfoTable;
            final /* synthetic */ GLJPanel val$glPanel;
            final /* synthetic */ MainFrame this$0;
            {
                this.val$texInfoTable = jTable;
                this.val$glPanel = gLJPanel;
                this.this$0 = mainFrame;
            }

            @Override
            public void actionPerformed(JTable jTable, int n, int n2, boolean bl) {
                ((MainFrame)this.this$0).window.textures.upOrder(n);
                this.val$texInfoTable.changeSelection(n, 0, true, false);
                this.val$texInfoTable.changeSelection(n - 1, 0, true, false);
                this.val$glPanel.repaint();
            }
        }, false);
        ButtonCellEditor buttonCellEditor4 = new ButtonCellEditor("x", new ButtonCellEditor.CellEventListener(){
            final /* synthetic */ MainFrame this$0;
            {
                this.this$0 = mainFrame;
            }

            @Override
            public void actionPerformed(JTable jTable, int n, int n2, boolean bl) {
                ((MainFrame)this.this$0).window.textures.removeTexture(n);
                gLJPanel.repaint();
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        this$0.texModel.fireTableDataChanged();
                    }
                });
            }
        }, false);
        String[] stringArray2 = new String[]{"Name", "1", "2", "3", "4", "Frus", "", ""};
        for (int i = 0; i < stringArray2.length; ++i) {
            serializable = ((JTable)serializable2).getColumnModel().getColumn(i);
            ((TableColumn)serializable).setHeaderValue(stringArray2[i]);
            if (i == 0) continue;
            ((TableColumn)serializable).setMinWidth(30);
            ((TableColumn)serializable).setMaxWidth(30);
            if (i < 6) {
                ((TableColumn)serializable).setCellEditor(buttonCellEditor2);
                ((TableColumn)serializable).setCellRenderer(buttonCellEditor2);
            }
            if (i == 6) {
                ((TableColumn)serializable).setCellEditor(buttonCellEditor3);
                ((TableColumn)serializable).setCellRenderer(buttonCellEditor3);
            }
            if (i != 7) continue;
            ((TableColumn)serializable).setCellEditor(buttonCellEditor4);
            ((TableColumn)serializable).setCellRenderer(buttonCellEditor4);
        }
        this.getBtnAddTex().addActionListener(actionListener5);
        ButtonCellEditor buttonCellEditor5 = new ButtonCellEditor(null, new ButtonCellEditor.CellEventListener(){
            final /* synthetic */ MainFrame this$0;
            {
                this.this$0 = mainFrame;
            }

            @Override
            public void actionPerformed(JTable jTable, int n, int n2, boolean bl) {
                ((MainFrame)this.this$0).scene.generals.get((int)n).active = bl;
                gLJPanel.repaint();
            }
        }, true);
        serializable = new ButtonCellEditor("Reload", new ButtonCellEditor.CellEventListener(){
            final /* synthetic */ MainFrame this$0;
            {
                this.this$0 = mainFrame;
            }

            @Override
            public void actionPerformed(JTable jTable, int n, int n2, boolean bl) {
                try {
                    String string = ((MainFrame)this.this$0).scene.generals.get((int)n).name;
                    this.this$0.scene.loadGeneral3D(string);
                    if (this.this$0.getGeneral3DTable().getCellEditor() != null) {
                        this.this$0.getGeneral3DTable().getCellEditor().stopCellEditing();
                    }
                    this.this$0.g3dModel.fireTableDataChanged();
                    gLJPanel.repaint();
                }
                catch (Exception exception) {
                    Logger.Error(exception);
                    String string = "Failed to open files. \n";
                    if (exception.getMessage() != null) {
                        string = string + "[" + exception.getMessage() + "]";
                    }
                    JOptionPane.showMessageDialog(this.this$0, string, "Error", 0);
                }
            }
        }, false);
        JTable jTable3 = this.getGeneral3DTable();
        this.g3dModel = new General3DTableModel();
        jTable3.setModel(this.g3dModel);
        jTable3.setRowHeight(24);
        String[] stringArray3 = new String[]{"Show", "FileName", ""};
        for (int i = 0; i < stringArray3.length; ++i) {
            TableColumn tableColumn = jTable3.getColumnModel().getColumn(i);
            tableColumn.setHeaderValue(stringArray3[i]);
            if (i == 0) {
                tableColumn.setMinWidth(40);
                tableColumn.setMaxWidth(40);
                tableColumn.setCellEditor(buttonCellEditor5);
                tableColumn.setCellRenderer(buttonCellEditor5);
                continue;
            }
            if (i == 1) continue;
            tableColumn.setMinWidth(70);
            tableColumn.setMaxWidth(70);
            tableColumn.setCellEditor((TableCellEditor)((Object)serializable));
            tableColumn.setCellRenderer((TableCellRenderer)((Object)serializable));
        }
        this.loadLookUpTable();
    }

    public void openFirst() {
        if (!this.openFile(true)) {
            // empty if block
        }
    }

    private boolean openFile(boolean bl) {
        String string = App.getProp("defaultDataPath");
        File file = null;
        if (string != null) {
            file = new File(string);
        }
        if (file == null || !file.exists() || string.equals("")) {
            File file2 = App.getWorkingDir();
            if (App.isMacExe) {
                file2 = file2.getParentFile().getParentFile().getParentFile();
            }
            return this.openDialog(file2);
        }
        File file3 = new File(string);
        String[] stringArray = file3.list();
        if (Arrays.asList(stringArray).contains("AiGIS_setting.txt")) {
            if (bl) {
                this.loadFile(file3);
                return true;
            }
            String string2 = string.equals("/") ? string : file3.getParent();
            File file4 = new File(string2);
            return this.openDialog(file4);
        }
        return this.openDialog(file3);
    }

    private void saveSS() {
        Comparable<File> comparable;
        String string = null;
        String string2 = App.getProp("savePngPath");
        if (string2 != null && !string2.equals("") && ((File)(comparable = new File(string2))).exists()) {
            string = string2;
        }
        if (string == null || string == "") {
            string = System.getProperty("user.home");
        }
        comparable = new Date();
        String string3 = "yyyy-MM-dd'T'HH'.'mm'.'ss";
        String string4 = new SimpleDateFormat(string3).format((Date)comparable);
        string4 = "AiGIS_" + string4;
        string = string + File.separator + string4 + ".png";
        File file = new File(string);
        try {
            this.window.screenshot(file);
        }
        catch (Exception exception) {
            Logger.Error(exception);
            JOptionPane.showMessageDialog(this, "Failed to take a snapshot. \n[" + exception.getMessage() + "]", "Error", 0);
            return;
        }
        JOptionPane.showMessageDialog(this, "The snapshot was saved successfully.\n'" + string + "'", "Done", 1);
    }

    private boolean openDialog(File file) {
        JFileChooser jFileChooser = App.showOpenDialog(this, file.getAbsolutePath(), 1, null, true);
        if (jFileChooser != null) {
            this.loadFile(jFileChooser.getSelectedFile());
            return true;
        }
        return false;
    }

    private void updateMapInfo(int n, LatLon latLon, String string) {
        JTable jTable = this.getInfoTable();
        if (n >= 0) {
            jTable.getModel().setValueAt(Integer.toString(n + 1), 0, 1);
            jTable.getModel().setValueAt(this.doubleFormat.format(latLon.latitude), 1, 1);
            jTable.getModel().setValueAt(this.doubleFormat.format(latLon.longitude), 2, 1);
            jTable.getModel().setValueAt(Float.toString(latLon.distance), 3, 1);
            jTable.getModel().setValueAt(Float.toString(latLon.xPosition), 4, 1);
            jTable.getModel().setValueAt(Float.toString(latLon.yPosition), 5, 1);
            jTable.getModel().setValueAt(Float.toString(latLon.zPosition), 6, 1);
        } else {
            for (int i = 0; i < 7; ++i) {
                jTable.getModel().setValueAt("-", i, 1);
            }
        }
        JTable jTable2 = this.getMapTable();
        this.mapModel.update();
        if (string != null) {
            for (int i = 0; i < this.mapModel.getRowCount(); ++i) {
                if (!string.equals(this.mapModel.getValueAt(i, 0))) continue;
                jTable2.setRowSelectionInterval(i, i);
            }
        }
        jTable2.revalidate();
        jTable2.repaint();
    }

    private void loadLookUpTable() {
        try {
            this.scene.loadLookUpTable();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        this.window.resetColorbar();
        final JMenu jMenu = this.getMnLookUp();
        ButtonGroup buttonGroup = new ButtonGroup();
        ActionListener actionListener = new ActionListener(){
            final /* synthetic */ MainFrame this$0;
            {
                this.this$0 = mainFrame;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Renderer renderer = this.this$0.window.getActiveRenderer();
                for (int i = 0; i < jMenu.getItemCount(); ++i) {
                    JRadioButtonMenuItem jRadioButtonMenuItem = (JRadioButtonMenuItem)jMenu.getItem(i);
                    if (actionEvent.getSource() != jRadioButtonMenuItem) continue;
                    renderer.changeColorbar(i);
                }
                this.this$0.getPanelGL().repaint();
            }
        };
        jMenu.removeAll();
        for (String string : this.scene.colorbar.getTitles()) {
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(string);
            jRadioButtonMenuItem.addActionListener(actionListener);
            jMenu.add(jRadioButtonMenuItem);
            buttonGroup.add(jRadioButtonMenuItem);
        }
        buttonGroup.getElements().nextElement().setSelected(true);
    }

    private void loadFile(final File file) {
        Logger.Debug(file.getAbsolutePath());
        final LoadingDialog loadingDialog = new LoadingDialog(this);
        this.setEnabled(false);
        EventQueue.invokeLater(new Runnable(){
            final /* synthetic */ MainFrame this$0;
            {
                this.this$0 = mainFrame;
            }

            @Override
            public void run() {
                for (ChartFrame chartFrame : this.this$0.chartFrames.values()) {
                    chartFrame.setVisible(false);
                }
                this.this$0.chartFrames.clear();
                ((MainFrame)this.this$0).window.textures.clearTextures();
                loadingDialog.setLocationRelativeTo(this.this$0);
                loadingDialog.setVisible(true);
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            this$0.setTitle("AiGIS");
                            this$0.clearModelList();
                            this$0.updateMapInfo(-1, null, null);
                            this$0.mapModel.clear();
                            JCheckBoxMenuItem jCheckBoxMenuItem = this$0.getChckbxmntmByName();
                            this$0.scene.load(file, loadingDialog, jCheckBoxMenuItem.isSelected());
                            this$0.window.resetRenderer(true, this$0.scene.getModelSize());
                            this$0.getPanelGL().repaint();
                        }
                        catch (Exception exception) {
                            Logger.Error(exception);
                            EventQueue.invokeLater(new Runnable(){
                                final /* synthetic */ 1 this$2;
                                {
                                    this.this$2 = var1_1;
                                }

                                @Override
                                public void run() {
                                    this$0.setEnabled(true);
                                    this.this$2.loadingDialog.setVisible(false);
                                    JOptionPane.showMessageDialog(this$0, "Can't load the data. \n[" + exception.getMessage() + "]", "Error", 0);
                                }
                            });
                            return;
                        }
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                this$0.g3dModel.fireTableDataChanged();
                                this$0.setEnabled(true);
                                String string = this$0.scene.getTitle();
                                string = string == null ? "" : " -" + string + "-";
                                this$0.setTitle("AiGIS" + string);
                                this$0.buildModelList();
                                loadingDialog.setVisible(false);
                            }
                        });
                    }
                }).start();
            }
        });
    }

    private void reloadMapData() {
        final LoadingDialog loadingDialog = new LoadingDialog(this);
        this.setEnabled(false);
        EventQueue.invokeLater(new Runnable(){
            final /* synthetic */ MainFrame this$0;
            {
                this.this$0 = mainFrame;
            }

            @Override
            public void run() {
                for (ChartFrame chartFrame : this.this$0.chartFrames.values()) {
                    chartFrame.setVisible(false);
                }
                this.this$0.chartFrames.clear();
                loadingDialog.setLocationRelativeTo(this.this$0);
                loadingDialog.setVisible(true);
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            JCheckBoxMenuItem jCheckBoxMenuItem = this$0.getChckbxmntmByName();
                            this$0.scene.loadMapData(loadingDialog, jCheckBoxMenuItem.isSelected());
                            this$0.window.resetRenderer(false, this$0.scene.getModelSize());
                            this$0.getPanelGL().repaint();
                        }
                        catch (Exception exception) {
                            Logger.Error(exception);
                            EventQueue.invokeLater(new Runnable(){
                                final /* synthetic */ 1 this$2;
                                {
                                    this.this$2 = var1_1;
                                }

                                @Override
                                public void run() {
                                    this$0.setEnabled(true);
                                    this.this$2.loadingDialog.setVisible(false);
                                    JOptionPane.showMessageDialog(this$0, "Can't load the data. \n[" + exception.getMessage() + "]", "Error", 0);
                                }
                            });
                            return;
                        }
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                this$0.setEnabled(true);
                                loadingDialog.setVisible(false);
                            }
                        });
                    }
                }).start();
            }
        });
    }

    private void buildRadioButton(final ModelSelection modelSelection, String string) {
        JRadioButton jRadioButton = new JRadioButton(string);
        jRadioButton.setMinimumSize(new Dimension(30, 23));
        jRadioButton.setHorizontalAlignment(2);
        jRadioButton.setSelected(true);
        this.buttonGroupModel.add(jRadioButton);
        this.getPanelToolsModel().add(jRadioButton);
        ActionListener actionListener = new ActionListener(){
            final /* synthetic */ MainFrame this$0;
            {
                this.this$0 = mainFrame;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Renderer renderer = this.this$0.window.getActiveRenderer();
                renderer.changeModel(modelSelection);
                this.this$0.getPanelGL().repaint();
                this.this$0.updateMapInfo(-1, null, renderer.getCurrentSpectrumKey());
            }
        };
        jRadioButton.addActionListener(actionListener);
        this.modelListButtons.put(modelSelection, jRadioButton);
    }

    private void clearModelList() {
        this.getPanelToolsModel().removeAll();
        for (JRadioButton jRadioButton : this.modelListButtons.values()) {
            this.buttonGroupModel.remove(jRadioButton);
        }
        this.modelListButtons.clear();
    }

    private void buildModelList() {
        for (ModelSelection modelSelection : this.scene.getRegisteredModels().getKeys()) {
            SettingModel.ShapePathData shapePathData = this.scene.getShapePath(modelSelection);
            Path path = Paths.get(shapePathData.path, new String[0]).getFileName();
            this.buildRadioButton(modelSelection, path.toString());
        }
        this.getPanelToolsModel().updateUI();
    }

    private void selectModelList(ModelSelection modelSelection) {
        JRadioButton jRadioButton = this.modelListButtons.get(modelSelection);
        if (jRadioButton != null) {
            this.buttonGroupModel.clearSelection();
            jRadioButton.setSelected(true);
        }
    }

    private class MapTableModel
    extends AbstractTableModel {
        private SpectrumMaps maps;
        private ArrayList<Map.Entry<String, SpectrumMap>> spectrums;

        private MapTableModel() {
        }

        public void clear() {
            this.maps = null;
            this.spectrums = null;
        }

        public void update() {
            Renderer renderer = MainFrame.this.window.getActiveRenderer();
            Model model = renderer.getCurrentModel();
            if (model == null) {
                return;
            }
            this.maps = model.getAvailableSpectrumMaps();
            if (this.maps != null) {
                this.spectrums = new ArrayList<Map.Entry<String, SpectrumMap>>(this.maps.getEntrySet());
            }
        }

        @Override
        public int getRowCount() {
            if (this.maps == null) {
                return 0;
            }
            return this.maps.getSize();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            SpectrumMap spectrumMap = this.spectrums.get(n).getValue();
            if (n2 == 0) {
                return spectrumMap.getName();
            }
            if (n2 == 1) {
                Renderer renderer = MainFrame.this.window.getActiveRenderer();
                int n3 = renderer.getPolygonID();
                if (n3 >= 0 && !this.spectrums.get(n).getKey().equals("#None")) {
                    float f = spectrumMap.getSpectrumData(n3);
                    return f == Float.NEGATIVE_INFINITY ? "-" : f + " [" + spectrumMap.getUnitRepresentation() + "]";
                }
                return "-";
            }
            if (n2 == 2) {
                Renderer renderer = MainFrame.this.window.getActiveRenderer();
                ChartData chartData = MainFrame.this.scene.getChartData(spectrumMap.getName(), renderer.getCuttentSelection());
                if (chartData != null) {
                    int n4 = renderer.getPolygonID();
                    if (n4 >= 0 && !this.spectrums.get(n).getKey().equals("#None")) {
                        return "[BUTTON]";
                    }
                    return "[BUTTON-D]";
                }
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 2;
        }
    }

    private class General3DTableModel
    extends AbstractTableModel {
        private General3DTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return ((MainFrame)MainFrame.this).scene.generals == null ? 0 : ((MainFrame)MainFrame.this).scene.generals.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            General3D general3D = ((MainFrame)MainFrame.this).scene.generals.get(n);
            if (n2 == 0) {
                if (general3D.active) {
                    return "[BUTTON-C]";
                }
                return "[BUTTON]";
            }
            if (n2 == 1) {
                return ((MainFrame)MainFrame.this).scene.generals.get((int)n).name;
            }
            return "[BUTTON]";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 != 1;
        }
    }

    private class TexTableModel
    extends AbstractTableModel {
        private TexTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 8;
        }

        @Override
        public int getRowCount() {
            if (((MainFrame)MainFrame.this).window.textures == null) {
                return 0;
            }
            ArrayList<Textures.Setting> arrayList = ((MainFrame)MainFrame.this).window.textures.getTexsInfo();
            return arrayList.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Textures.Setting setting = ((MainFrame)MainFrame.this).window.textures.getTexsInfo().get(n);
            if (n2 == 0) {
                return setting.imageFile.getName();
            }
            if (n2 < 5 && setting.active[n2 - 1]) {
                return "[BUTTON-C]";
            }
            if (n2 == 5 && setting.showFrustum) {
                return "[BUTTON-C]";
            }
            if (n == 0 && n2 == 6) {
                return null;
            }
            return "[BUTTON]";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 > 0;
        }
    }
}

