/*
 * Decompiled with CFR 0.152.
 */
package aigis.model.loader;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.StringTokenizer;

public class FastReader {
    BufferedReader br;
    StringTokenizer st;
    public boolean eof = false;
    public boolean hasComment = false;
    public boolean exComment = false;
    private ArrayList<String> peekList = new ArrayList();
    String filename;
    int lineNum = 0;
    int checkRow = 4;

    public FastReader(String string) throws IOException {
        this.filename = string;
        this.br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string), "UTF-8"));
        this.st = new StringTokenizer("");
    }

    public boolean hasMoreTokens() {
        return this.st.hasMoreTokens();
    }

    public String nextString() throws IOException {
        this.hasComment = false;
        return this.nextStringImpl(false);
    }

    public String peekString() throws IOException {
        return this.nextStringImpl(true);
    }

    private String nextStringImpl(boolean bl) throws IOException {
        String string;
        if (!bl && this.peekList.size() > 0) {
            String string2 = this.peekList.get(0);
            this.peekList.remove(0);
            return string2;
        }
        if (!this.st.hasMoreTokens()) {
            string = this.br.readLine();
            if (string == null) {
                this.eof = true;
                return null;
            }
            if (!bl) {
                ++this.lineNum;
            }
            if (string.trim().length() == 0) {
                return this.nextStringImpl(bl);
            }
            if (string.trim().startsWith("#") || this.exComment && string.trim().startsWith("-")) {
                this.hasComment = true;
                return this.nextStringImpl(bl);
            }
            string = string.split("#")[0];
            this.st = new StringTokenizer(string);
        }
        string = this.st.nextToken();
        if (bl) {
            this.peekList.add(string.toString());
        }
        return string.toString();
    }

    public int nextInt() throws IOException {
        String string = this.nextString();
        if (string == null) {
            return Integer.MIN_VALUE;
        }
        try {
            return Integer.valueOf(string);
        }
        catch (Exception exception) {
            String[] stringArray = this.filename.split("/");
            String string2 = string;
            if (string.length() > 15) {
                string2 = string.substring(0, 15);
                string2 = string2 + "...";
            }
            throw new IOException("Data format error in \"" + stringArray[stringArray.length - 1] + "\" line:" + this.lineNum + " \n[" + string2 + "]", exception);
        }
    }

    public float nextFloat() throws IOException {
        String string = this.nextString();
        if (string == null) {
            return Float.NEGATIVE_INFINITY;
        }
        try {
            return Float.valueOf(string.toLowerCase().replace("d", "e")).floatValue();
        }
        catch (Exception exception) {
            String[] stringArray = this.filename.split("/");
            String string2 = string;
            if (string.length() > 15) {
                string2 = string.substring(0, 15);
                string2 = string2 + "...";
            }
            throw new IOException("Data format error in \"" + stringArray[stringArray.length - 1] + "\" line:" + this.lineNum + " \n[" + string2 + "]", exception);
        }
    }

    public void close() throws IOException {
        this.br.close();
    }

    public float[] scanFloat() throws IOException {
        ArrayList<Float> arrayList = new ArrayList<Float>();
        while (this.hasMoreTokens()) {
            arrayList.add(Float.valueOf(this.nextFloat()));
        }
        float[] fArray = new float[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            fArray[i] = ((Float)arrayList.get(i)).floatValue();
        }
        return fArray;
    }

    public long[] scanDate() throws IOException, ParseException {
        ArrayList<String> arrayList = new ArrayList<String>();
        while (this.hasMoreTokens()) {
            arrayList.add(this.nextString());
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss");
        long[] lArray = new long[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            String string = (String)arrayList.get(i);
            Date date = simpleDateFormat.parse(string);
            lArray[i] = date.getTime() / 1000L;
        }
        return lArray;
    }
}

