/*
 * Decompiled with CFR 0.152.
 */
package aigis.ui;

import aigis.App;
import aigis.model.CameraInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class CameraInfoDialog
extends JDialog {
    private final JPanel contentPanel = new JPanel();
    private JTextField textPositionX;
    private JTextField textPositionY;
    private JTextField textPositionZ;
    private JTextField textDirectionX;
    private JTextField textDirectionY;
    private JTextField textDirectionZ;
    private JTextField textUpX;
    private JTextField textUpY;
    private JTextField textUpZ;
    private JTextField textFrustum1X;
    private JTextField textFrustum1Y;
    private JTextField textFrustum1Z;
    private JTextField textFrustum2X;
    private JTextField textFrustum2Y;
    private JTextField textFrustum2Z;
    private JTextField textFrustum3X;
    private JTextField textFrustum3Y;
    private JTextField textFrustum3Z;
    private JTextField textFrustum4X;
    private JTextField textFrustum4Y;
    private JTextField textFrustum4Z;
    private JButton btnOpen;
    private Component horizontalStrut;
    private JButton btnSave;
    private CameraInfo cameraInfo;
    public boolean canceled = true;

    public CameraInfo getCameraInfo() {
        this.cameraInfo.position.x = this.getDouble(this.textPositionX);
        this.cameraInfo.position.y = this.getDouble(this.textPositionY);
        this.cameraInfo.position.z = this.getDouble(this.textPositionZ);
        this.cameraInfo.direction.x = this.getDouble(this.textDirectionX);
        this.cameraInfo.direction.y = this.getDouble(this.textDirectionY);
        this.cameraInfo.direction.z = this.getDouble(this.textDirectionZ);
        this.cameraInfo.direction.normalize();
        this.cameraInfo.up.x = this.getDouble(this.textUpX);
        this.cameraInfo.up.y = this.getDouble(this.textUpY);
        this.cameraInfo.up.z = this.getDouble(this.textUpZ);
        this.cameraInfo.up.normalize();
        return this.cameraInfo;
    }

    private double getDouble(JTextField jTextField) {
        return Double.parseDouble(jTextField.getText());
    }

    private void setText(JTextField jTextField, double d) {
        jTextField.setText(String.format("%.16e", d));
    }

    private String toupleStr(Tuple3d tuple3d) {
        return String.format("( %.16e, %.16e, %.16e )", tuple3d.x, tuple3d.y, tuple3d.z);
    }

    private void updateUI() {
        this.setText(this.textPositionX, this.cameraInfo.position.x);
        this.setText(this.textPositionY, this.cameraInfo.position.y);
        this.setText(this.textPositionZ, this.cameraInfo.position.z);
        this.setText(this.textDirectionX, this.cameraInfo.direction.x);
        this.setText(this.textDirectionY, this.cameraInfo.direction.y);
        this.setText(this.textDirectionZ, this.cameraInfo.direction.z);
        this.setText(this.textUpX, this.cameraInfo.up.x);
        this.setText(this.textUpY, this.cameraInfo.up.y);
        this.setText(this.textUpZ, this.cameraInfo.up.z);
        Vector3d[] vector3dArray = this.cameraInfo.getFrustum();
        this.setText(this.textFrustum1X, vector3dArray[0].x);
        this.setText(this.textFrustum1Y, vector3dArray[0].y);
        this.setText(this.textFrustum1Z, vector3dArray[0].z);
        this.setText(this.textFrustum2X, vector3dArray[1].x);
        this.setText(this.textFrustum2Y, vector3dArray[1].y);
        this.setText(this.textFrustum2Z, vector3dArray[1].z);
        this.setText(this.textFrustum3X, vector3dArray[2].x);
        this.setText(this.textFrustum3Y, vector3dArray[2].y);
        this.setText(this.textFrustum3Z, vector3dArray[2].z);
        this.setText(this.textFrustum4X, vector3dArray[3].x);
        this.setText(this.textFrustum4Y, vector3dArray[3].y);
        this.setText(this.textFrustum4Z, vector3dArray[3].z);
    }

    public static void main(String[] stringArray) {
        try {
            CameraInfoDialog cameraInfoDialog = new CameraInfoDialog(null, new CameraInfo());
            cameraInfoDialog.setDefaultCloseOperation(2);
            cameraInfoDialog.setVisible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public CameraInfoDialog(Frame frame, CameraInfo cameraInfo) {
        super(frame);
        this.cameraInfo = cameraInfo.clone();
        this.setModal(true);
        this.setTitle("Camera Info");
        this.setBounds(100, 100, 660, 335);
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0, 0, 0, 0, 0};
        gridBagLayout.rowHeights = new int[]{24, 0, 0, 0, 0, 0, 0, 0, 0};
        gridBagLayout.columnWeights = new double[]{0.0, 0.0, 1.0, 1.0, 1.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        this.contentPanel.setLayout(gridBagLayout);
        Serializable serializable = new JLabel("Position");
        Serializable serializable2 = new GridBagConstraints();
        ((GridBagConstraints)serializable2).anchor = 13;
        ((GridBagConstraints)serializable2).insets = new Insets(0, 0, 5, 5);
        ((GridBagConstraints)serializable2).gridx = 1;
        ((GridBagConstraints)serializable2).gridy = 1;
        this.contentPanel.add((Component)serializable, serializable2);
        this.textPositionX = new JTextField();
        serializable = new GridBagConstraints();
        ((GridBagConstraints)serializable).insets = new Insets(0, 0, 5, 5);
        ((GridBagConstraints)serializable).fill = 2;
        ((GridBagConstraints)serializable).gridx = 2;
        ((GridBagConstraints)serializable).gridy = 1;
        this.contentPanel.add((Component)this.textPositionX, serializable);
        this.textPositionX.setColumns(10);
        this.textPositionY = new JTextField();
        serializable = new GridBagConstraints();
        ((GridBagConstraints)serializable).insets = new Insets(0, 0, 5, 5);
        ((GridBagConstraints)serializable).fill = 2;
        ((GridBagConstraints)serializable).gridx = 3;
        ((GridBagConstraints)serializable).gridy = 1;
        this.contentPanel.add((Component)this.textPositionY, serializable);
        this.textPositionY.setColumns(10);
        this.textPositionZ = new JTextField();
        serializable = new GridBagConstraints();
        ((GridBagConstraints)serializable).insets = new Insets(0, 0, 5, 0);
        ((GridBagConstraints)serializable).fill = 2;
        ((GridBagConstraints)serializable).gridx = 4;
        ((GridBagConstraints)serializable).gridy = 1;
        this.contentPanel.add((Component)this.textPositionZ, serializable);
        this.textPositionZ.setColumns(10);
        serializable = new JLabel("Direction");
        serializable2 = new GridBagConstraints();
        ((GridBagConstraints)serializable2).anchor = 13;
        ((GridBagConstraints)serializable2).insets = new Insets(0, 0, 5, 5);
        ((GridBagConstraints)serializable2).gridx = 1;
        ((GridBagConstraints)serializable2).gridy = 2;
        this.contentPanel.add((Component)serializable, serializable2);
        this.textDirectionX = new JTextField();
        serializable = new GridBagConstraints();
        ((GridBagConstraints)serializable).insets = new Insets(0, 0, 5, 5);
        ((GridBagConstraints)serializable).fill = 2;
        ((GridBagConstraints)serializable).gridx = 2;
        ((GridBagConstraints)serializable).gridy = 2;
        this.contentPanel.add((Component)this.textDirectionX, serializable);
        this.textDirectionX.setColumns(10);
        this.textDirectionY = new JTextField();
        serializable = new GridBagConstraints();
        ((GridBagConstraints)serializable).insets = new Insets(0, 0, 5, 5);
        ((GridBagConstraints)serializable).fill = 2;
        ((GridBagConstraints)serializable).gridx = 3;
        ((GridBagConstraints)serializable).gridy = 2;
        this.contentPanel.add((Component)this.textDirectionY, serializable);
        this.textDirectionY.setColumns(10);
        this.textDirectionZ = new JTextField();
        serializable = new GridBagConstraints();
        ((GridBagConstraints)serializable).insets = new Insets(0, 0, 5, 0);
        ((GridBagConstraints)serializable).fill = 2;
        ((GridBagConstraints)serializable).gridx = 4;
        ((GridBagConstraints)serializable).gridy = 2;
        this.contentPanel.add((Component)this.textDirectionZ, serializable);
        this.textDirectionZ.setColumns(10);
        serializable = new JLabel("Up");
        serializable2 = new GridBagConstraints();
        ((GridBagConstraints)serializable2).anchor = 13;
        ((GridBagConstraints)serializable2).insets = new Insets(0, 0, 5, 5);
        ((GridBagConstraints)serializable2).gridx = 1;
        ((GridBagConstraints)serializable2).gridy = 3;
        this.contentPanel.add((Component)serializable, serializable2);
        this.textUpX = new JTextField();
        serializable = new GridBagConstraints();
        ((GridBagConstraints)serializable).insets = new Insets(0, 0, 5, 5);
        ((GridBagConstraints)serializable).fill = 2;
        ((GridBagConstraints)serializable).gridx = 2;
        ((GridBagConstraints)serializable).gridy = 3;
        this.contentPanel.add((Component)this.textUpX, serializable);
        this.textUpX.setColumns(10);
        this.textUpY = new JTextField();
        serializable = new GridBagConstraints();
        ((GridBagConstraints)serializable).insets = new Insets(0, 0, 5, 5);
        ((GridBagConstraints)serializable).fill = 2;
        ((GridBagConstraints)serializable).gridx = 3;
        ((GridBagConstraints)serializable).gridy = 3;
        this.contentPanel.add((Component)this.textUpY, serializable);
        this.textUpY.setColumns(10);
        this.textUpZ = new JTextField();
        serializable = new GridBagConstraints();
        ((GridBagConstraints)serializable).insets = new Insets(0, 0, 5, 0);
        ((GridBagConstraints)serializable).fill = 2;
        ((GridBagConstraints)serializable).gridx = 4;
        ((GridBagConstraints)serializable).gridy = 3;
        this.contentPanel.add((Component)this.textUpZ, serializable);
        this.textUpZ.setColumns(10);
        serializable = new JLabel("Frustum1");
        serializable2 = new GridBagConstraints();
        ((GridBagConstraints)serializable2).anchor = 13;
        ((GridBagConstraints)serializable2).insets = new Insets(0, 0, 5, 5);
        ((GridBagConstraints)serializable2).gridx = 1;
        ((GridBagConstraints)serializable2).gridy = 4;
        this.contentPanel.add((Component)serializable, serializable2);
        this.textFrustum1X = new JTextField();
        serializable = new GridBagConstraints();
        ((GridBagConstraints)serializable).insets = new Insets(0, 0, 5, 5);
        ((GridBagConstraints)serializable).fill = 2;
        ((GridBagConstraints)serializable).gridx = 2;
        ((GridBagConstraints)serializable).gridy = 4;
        this.contentPanel.add((Component)this.textFrustum1X, serializable);
        this.textFrustum1X.setColumns(10);
        this.textFrustum1Y = new JTextField();
        serializable = new GridBagConstraints();
        ((GridBagConstraints)serializable).insets = new Insets(0, 0, 5, 5);
        ((GridBagConstraints)serializable).fill = 2;
        ((GridBagConstraints)serializable).gridx = 3;
        ((GridBagConstraints)serializable).gridy = 4;
        this.contentPanel.add((Component)this.textFrustum1Y, serializable);
        this.textFrustum1Y.setColumns(10);
        this.textFrustum1Z = new JTextField();
        serializable = new GridBagConstraints();
        ((GridBagConstraints)serializable).insets = new Insets(0, 0, 5, 0);
        ((GridBagConstraints)serializable).fill = 2;
        ((GridBagConstraints)serializable).gridx = 4;
        ((GridBagConstraints)serializable).gridy = 4;
        this.contentPanel.add((Component)this.textFrustum1Z, serializable);
        this.textFrustum1Z.setColumns(10);
        serializable = new JLabel("Frustum2");
        serializable2 = new GridBagConstraints();
        ((GridBagConstraints)serializable2).anchor = 13;
        ((GridBagConstraints)serializable2).insets = new Insets(0, 0, 5, 5);
        ((GridBagConstraints)serializable2).gridx = 1;
        ((GridBagConstraints)serializable2).gridy = 5;
        this.contentPanel.add((Component)serializable, serializable2);
        this.textFrustum2X = new JTextField();
        serializable = new GridBagConstraints();
        ((GridBagConstraints)serializable).insets = new Insets(0, 0, 5, 5);
        ((GridBagConstraints)serializable).fill = 2;
        ((GridBagConstraints)serializable).gridx = 2;
        ((GridBagConstraints)serializable).gridy = 5;
        this.contentPanel.add((Component)this.textFrustum2X, serializable);
        this.textFrustum2X.setColumns(10);
        this.textFrustum2Y = new JTextField();
        serializable = new GridBagConstraints();
        ((GridBagConstraints)serializable).insets = new Insets(0, 0, 5, 5);
        ((GridBagConstraints)serializable).fill = 2;
        ((GridBagConstraints)serializable).gridx = 3;
        ((GridBagConstraints)serializable).gridy = 5;
        this.contentPanel.add((Component)this.textFrustum2Y, serializable);
        this.textFrustum2Y.setColumns(10);
        this.textFrustum2Z = new JTextField();
        serializable = new GridBagConstraints();
        ((GridBagConstraints)serializable).insets = new Insets(0, 0, 5, 0);
        ((GridBagConstraints)serializable).fill = 2;
        ((GridBagConstraints)serializable).gridx = 4;
        ((GridBagConstraints)serializable).gridy = 5;
        this.contentPanel.add((Component)this.textFrustum2Z, serializable);
        this.textFrustum2Z.setColumns(10);
        serializable = new JLabel("Frustum3");
        serializable2 = new GridBagConstraints();
        ((GridBagConstraints)serializable2).anchor = 13;
        ((GridBagConstraints)serializable2).insets = new Insets(0, 0, 5, 5);
        ((GridBagConstraints)serializable2).gridx = 1;
        ((GridBagConstraints)serializable2).gridy = 6;
        this.contentPanel.add((Component)serializable, serializable2);
        this.textFrustum3X = new JTextField();
        serializable = new GridBagConstraints();
        ((GridBagConstraints)serializable).insets = new Insets(0, 0, 5, 5);
        ((GridBagConstraints)serializable).fill = 2;
        ((GridBagConstraints)serializable).gridx = 2;
        ((GridBagConstraints)serializable).gridy = 6;
        this.contentPanel.add((Component)this.textFrustum3X, serializable);
        this.textFrustum3X.setColumns(10);
        this.textFrustum3Y = new JTextField();
        serializable = new GridBagConstraints();
        ((GridBagConstraints)serializable).insets = new Insets(0, 0, 5, 5);
        ((GridBagConstraints)serializable).fill = 2;
        ((GridBagConstraints)serializable).gridx = 3;
        ((GridBagConstraints)serializable).gridy = 6;
        this.contentPanel.add((Component)this.textFrustum3Y, serializable);
        this.textFrustum3Y.setColumns(10);
        this.textFrustum3Z = new JTextField();
        serializable = new GridBagConstraints();
        ((GridBagConstraints)serializable).insets = new Insets(0, 0, 5, 0);
        ((GridBagConstraints)serializable).fill = 2;
        ((GridBagConstraints)serializable).gridx = 4;
        ((GridBagConstraints)serializable).gridy = 6;
        this.contentPanel.add((Component)this.textFrustum3Z, serializable);
        this.textFrustum3Z.setColumns(10);
        serializable = new JLabel("Frustum4");
        serializable2 = new GridBagConstraints();
        ((GridBagConstraints)serializable2).anchor = 13;
        ((GridBagConstraints)serializable2).insets = new Insets(0, 0, 0, 5);
        ((GridBagConstraints)serializable2).gridx = 1;
        ((GridBagConstraints)serializable2).gridy = 7;
        this.contentPanel.add((Component)serializable, serializable2);
        this.textFrustum4X = new JTextField();
        serializable = new GridBagConstraints();
        ((GridBagConstraints)serializable).insets = new Insets(0, 0, 0, 5);
        ((GridBagConstraints)serializable).fill = 2;
        ((GridBagConstraints)serializable).gridx = 2;
        ((GridBagConstraints)serializable).gridy = 7;
        this.contentPanel.add((Component)this.textFrustum4X, serializable);
        this.textFrustum4X.setColumns(10);
        this.textFrustum4Y = new JTextField();
        serializable = new GridBagConstraints();
        ((GridBagConstraints)serializable).insets = new Insets(0, 0, 0, 5);
        ((GridBagConstraints)serializable).fill = 2;
        ((GridBagConstraints)serializable).gridx = 3;
        ((GridBagConstraints)serializable).gridy = 7;
        this.contentPanel.add((Component)this.textFrustum4Y, serializable);
        this.textFrustum4Y.setColumns(10);
        this.textFrustum4Z = new JTextField();
        serializable = new GridBagConstraints();
        ((GridBagConstraints)serializable).fill = 2;
        ((GridBagConstraints)serializable).gridx = 4;
        ((GridBagConstraints)serializable).gridy = 7;
        this.contentPanel.add((Component)this.textFrustum4Z, serializable);
        this.textFrustum4Z.setColumns(10);
        serializable = new JPanel();
        ((Container)serializable).setLayout(new FlowLayout(2));
        this.getContentPane().add((Component)serializable, "South");
        this.btnOpen = new JButton("Open...");
        this.btnOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CameraInfoDialog cameraInfoDialog = CameraInfoDialog.this;
                FileNameExtensionFilter fileNameExtensionFilter = new FileNameExtensionFilter("Info file", "info", "txt");
                JFileChooser jFileChooser = App.showOpenDialog(cameraInfoDialog, null, 0, fileNameExtensionFilter, true);
                if (jFileChooser != null) {
                    try {
                        File file = jFileChooser.getSelectedFile();
                        cameraInfoDialog.cameraInfo = CameraInfo.loadFromInfo(file.getAbsolutePath());
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    CameraInfoDialog.this.updateUI();
                }
            }
        });
        ((Container)serializable).add(this.btnOpen);
        this.btnSave = new JButton("Save...");
        this.btnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CameraInfoDialog cameraInfoDialog = CameraInfoDialog.this;
                FileNameExtensionFilter fileNameExtensionFilter = new FileNameExtensionFilter("Info file", "info", "txt");
                JFileChooser jFileChooser = App.showOpenDialog(cameraInfoDialog, null, 0, fileNameExtensionFilter, false);
                if (jFileChooser != null) {
                    try {
                        int n;
                        File file = jFileChooser.getSelectedFile();
                        if (file.exists() && (n = JOptionPane.showConfirmDialog(cameraInfoDialog, "The file exist.\nDo you want to replace it?")) != 0) {
                            return;
                        }
                        if (!file.getName().toLowerCase().endsWith(".info")) {
                            file = new File(file.getParent() + File.separator + file.getName() + ".info");
                        }
                        FileWriter fileWriter = new FileWriter(file);
                        PrintWriter printWriter = new PrintWriter(new BufferedWriter(fileWriter));
                        String string = DateTimeFormatter.ISO_LOCAL_DATE_TIME.format(LocalDateTime.now());
                        CameraInfo cameraInfo = CameraInfoDialog.this.cameraInfo;
                        printWriter.println("START_TIME          = " + string);
                        printWriter.println("STOP_TIME           = " + string);
                        printWriter.println("SPACECRAFT_POSITION = " + CameraInfoDialog.this.toupleStr((Tuple3d)cameraInfo.position));
                        printWriter.println("BORESIGHT_DIRECTION = " + CameraInfoDialog.this.toupleStr((Tuple3d)cameraInfo.direction));
                        printWriter.println("UP_DIRECTION        = " + CameraInfoDialog.this.toupleStr((Tuple3d)cameraInfo.up));
                        Vector3d[] vector3dArray = cameraInfo.getFrustum();
                        printWriter.println("FRUSTUM1            = " + CameraInfoDialog.this.toupleStr((Tuple3d)vector3dArray[0]));
                        printWriter.println("FRUSTUM2            = " + CameraInfoDialog.this.toupleStr((Tuple3d)vector3dArray[1]));
                        printWriter.println("FRUSTUM3            = " + CameraInfoDialog.this.toupleStr((Tuple3d)vector3dArray[2]));
                        printWriter.println("FRUSTUM4            = " + CameraInfoDialog.this.toupleStr((Tuple3d)vector3dArray[3]));
                        printWriter.println("SUN_POSITION_LT     = " + CameraInfoDialog.this.toupleStr((Tuple3d)cameraInfo.position));
                        printWriter.close();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    CameraInfoDialog.this.updateUI();
                }
            }
        });
        ((Container)serializable).add(this.btnSave);
        this.horizontalStrut = Box.createHorizontalStrut(20);
        this.horizontalStrut.setPreferredSize(new Dimension(60, 0));
        ((Container)serializable).add(this.horizontalStrut);
        serializable2 = new JButton("OK");
        ((AbstractButton)serializable2).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CameraInfoDialog.this.canceled = false;
                CameraInfoDialog.this.setVisible(false);
            }
        });
        ((AbstractButton)serializable2).setActionCommand("OK");
        ((Container)serializable).add((Component)serializable2);
        this.getRootPane().setDefaultButton((JButton)serializable2);
        serializable2 = new JButton("Cancel");
        ((AbstractButton)serializable2).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CameraInfoDialog.this.setVisible(false);
            }
        });
        ((AbstractButton)serializable2).setActionCommand("Cancel");
        ((Container)serializable).add((Component)serializable2);
        this.updateUI();
    }
}

