/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.graph.font;

import com.jogamp.common.net.Uri;
import com.jogamp.common.util.IOUtil;
import com.jogamp.common.util.PropertyAccess;
import com.jogamp.common.util.ReflectionUtil;
import com.jogamp.common.util.SecurityUtil;
import com.jogamp.common.util.cache.TempJarCache;
import com.jogamp.graph.font.Font;
import com.jogamp.graph.font.FontSet;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.security.PrivilegedAction;
import jogamp.graph.font.FontConstructor;
import jogamp.graph.font.JavaFontLoader;
import jogamp.graph.font.UbuntuFontLoader;

public class FontFactory {
    private static final String FontConstructorPropKey = "jogamp.graph.font.ctor";
    private static final String DefaultFontConstructor = "jogamp.graph.font.typecast.TypecastFontConstructor";
    public static final int UBUNTU = 0;
    public static final int JAVA = 1;
    private static final FontConstructor fontConstr;

    public static final FontSet getDefault() {
        return FontFactory.get(0);
    }

    public static final FontSet get(int n) {
        switch (n) {
            case 1: {
                return JavaFontLoader.get();
            }
        }
        return UbuntuFontLoader.get();
    }

    public static final Font get(File file) throws IOException {
        return fontConstr.create(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Font get(InputStream inputStream, int n, boolean bl) throws IOException {
        try {
            Font font = fontConstr.create(inputStream, n);
            return font;
        }
        finally {
            if (bl) {
                inputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Font get(final InputStream inputStream, final boolean bl) throws IOException {
        Font font;
        File[] fileArray;
        block7: {
            final IOException[] iOExceptionArray = new IOException[]{null};
            final int[] nArray = new int[]{0};
            fileArray = new File[]{null};
            InputStream inputStream2 = (InputStream)SecurityUtil.doPrivileged((PrivilegedAction)new PrivilegedAction<InputStream>(){

                @Override
                public InputStream run() {
                    BufferedInputStream bufferedInputStream = null;
                    try {
                        fileArray[0] = IOUtil.createTempFile((String)"jogl.font", (String)".ttf", (boolean)false);
                        nArray[0] = IOUtil.copyStream2File((InputStream)inputStream, (File)fileArray[0], (int)-1);
                        if (0 == nArray[0]) {
                            throw new IOException("Font stream has zero bytes");
                        }
                        bufferedInputStream = new BufferedInputStream(new FileInputStream(fileArray[0]), nArray[0]);
                    }
                    catch (IOException iOException) {
                        iOExceptionArray[0] = iOException;
                        if (null != fileArray[0]) {
                            fileArray[0].delete();
                            fileArray[0] = null;
                        }
                        nArray[0] = 0;
                    }
                    finally {
                        if (bl) {
                            IOUtil.close((Closeable)inputStream, (IOException[])iOExceptionArray, (PrintStream)System.err);
                        }
                    }
                    return bufferedInputStream;
                }
            });
            if (null != iOExceptionArray[0]) {
                throw iOExceptionArray[0];
            }
            if (null == inputStream2) {
                throw new IOException("Could not cache font stream");
            }
            try {
                font = fontConstr.create(inputStream2, nArray[0]);
                if (null == inputStream2) break block7;
            }
            catch (Throwable throwable) {
                if (null != inputStream2) {
                    inputStream2.close();
                }
                if (null != fileArray[0]) {
                    SecurityUtil.doPrivileged((PrivilegedAction)new PrivilegedAction<Object>(fileArray){
                        final /* synthetic */ File[] val$tempFile;
                        {
                            this.val$tempFile = fileArray;
                        }

                        @Override
                        public Object run() {
                            this.val$tempFile[0].delete();
                            return null;
                        }
                    });
                }
                throw throwable;
            }
            inputStream2.close();
        }
        if (null != fileArray[0]) {
            SecurityUtil.doPrivileged((PrivilegedAction)new /* invalid duplicate definition of identical inner class */);
        }
        return font;
    }

    public static final Font get(Class<?> clazz, String string, boolean bl) throws IOException {
        InputStream inputStream = null;
        if (bl) {
            try {
                Uri uri = TempJarCache.getResourceUri((String)string);
                inputStream = null != uri ? uri.toURL().openConnection().getInputStream() : null;
            }
            catch (Exception exception) {
                throw new IOException(exception);
            }
        } else {
            inputStream = IOUtil.getResource((String)string, (ClassLoader)clazz.getClassLoader(), clazz).getInputStream();
        }
        if (null != inputStream) {
            return FontFactory.get(inputStream, true);
        }
        return null;
    }

    public static boolean isPrintableChar(char c) {
        if (Character.isWhitespace(c)) {
            return true;
        }
        if ('\u0000' == c || Character.isISOControl(c)) {
            return false;
        }
        Character.UnicodeBlock unicodeBlock = Character.UnicodeBlock.of(c);
        return unicodeBlock != null && unicodeBlock != Character.UnicodeBlock.SPECIALS;
    }

    static {
        String string = PropertyAccess.getProperty((String)FontConstructorPropKey, (boolean)true);
        if (null == string) {
            string = DefaultFontConstructor;
        }
        fontConstr = (FontConstructor)ReflectionUtil.createInstance((String)string, (ClassLoader)FontFactory.class.getClassLoader());
    }
}

