/*
 * Decompiled with CFR 0.152.
 */
package aigis.model;

import aigis.Logger;
import aigis.model.Geometry;
import aigis.model.Grids;
import aigis.model.LatLon;
import aigis.model.SpectrumMap;
import aigis.model.SpectrumMaps;
import aigis.model.loader.GridsLoader;
import aigis.model.loader.ModelLoader;
import aigis.model.loader.ObjLoader;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLBufferStorage;
import com.jogamp.opengl.glu.GLU;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

public class Model {
    public int nVertex;
    public int nFace;
    public int nNormal;
    public float[][] vertices;
    public int[][] faces;
    public float[][] normals;
    public int[] normalIndex;
    public float[][] point;
    public float[][] uv;
    public float[][] rgba;
    private int nMap;
    private Grids grids;
    private int vboIdVertex;
    private int vboIdNormal;
    private int vboIdColor;
    private int[] vboIdUVs;
    private SpectrumMaps spms;
    public LatLon[] info;
    private float[] specular = new float[]{0.5f, 0.5f, 0.5f, 1.0f};
    private float[] diffuse = new float[]{0.5f, 0.5f, 0.5f, 1.0f};
    private float[] ambient = new float[]{0.4f, 0.4f, 0.4f, 1.0f};
    private float shiness = 5.0f;
    private double size = 0.0;

    public Model(String string, String string2, String string3, String string4) throws IOException {
        String string5 = string + File.separator;
        if (string2.endsWith(".obj")) {
            ObjLoader.load(string5 + string2, this);
        } else {
            ModelLoader.load(string5 + string2, this);
        }
        this.grids = GridsLoader.load(string5, string3, string4);
        this.nMap = this.nFace;
        this.rgba = new float[this.nMap][4];
        this.spms = new SpectrumMaps();
    }

    public Integer getID(Point2D.Double double_, double[] dArray, double[] dArray2, int[] nArray) {
        GLU gLU = new GLU();
        int[] nArray2 = new int[64];
        double[] dArray3 = new double[64];
        int n = 0;
        double[] dArray4 = new double[9];
        for (int i = 0; i < this.nFace; ++i) {
            for (int j = 0; j < 3; ++j) {
                gLU.gluProject((double)this.vertices[this.faces[i][j] - 1][0], (double)this.vertices[this.faces[i][j] - 1][1], (double)this.vertices[this.faces[i][j] - 1][2], dArray, 0, dArray2, 0, nArray, 0, dArray4, 3 * j);
            }
            if (!Geometry.triangleInside2(dArray4, double_)) continue;
            nArray2[n] = i;
            dArray3[n] = (dArray4[2] + dArray4[5] + dArray4[8]) / 3.0;
            ++n;
        }
        if (n > 0) {
            double d = 1.0E80;
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                if (!(d > dArray3[i])) continue;
                d = dArray3[i];
                n2 = i;
            }
            return nArray2[n2];
        }
        return -1;
    }

    public void makeUV(ByteBuffer byteBuffer, Vector3d vector3d, FloatBuffer floatBuffer, double[] dArray, double[] dArray2, int[] nArray) {
        GLU gLU = new GLU();
        FloatBuffer floatBuffer2 = byteBuffer.asFloatBuffer();
        double[] dArray3 = new double[9];
        for (int i = 0; i < this.nFace; ++i) {
            int n;
            int n2;
            Vector3f vector3f = new Vector3f(this.vertices[this.faces[i][0] - 1]);
            Vector3f vector3f2 = new Vector3f(this.vertices[this.faces[i][1] - 1]);
            Vector3f vector3f3 = new Vector3f(this.vertices[this.faces[i][2] - 1]);
            Vector3f vector3f4 = new Vector3f();
            vector3f4.sub((Tuple3f)vector3f, (Tuple3f)vector3f2);
            Vector3f vector3f5 = new Vector3f();
            vector3f5.sub((Tuple3f)vector3f2, (Tuple3f)vector3f3);
            Vector3f vector3f6 = new Vector3f();
            vector3f6.cross(vector3f4, vector3f5);
            float f = vector3f6.dot(new Vector3f(vector3d));
            if (f < 0.0f) {
                for (n2 = 0; n2 < 3; ++n2) {
                    int n3 = i * 6 + n2 * 2;
                    floatBuffer2.put(n3, 0.0f);
                    floatBuffer2.put(n3 + 1, 0.0f);
                }
                continue;
            }
            n2 = 0;
            float[] fArray = new float[9];
            for (n = 0; n < 3; ++n) {
                float[] fArray2 = this.vertices[this.faces[i][n] - 1];
                gLU.gluProject((double)fArray2[0], (double)fArray2[1], (double)fArray2[2], dArray, 0, dArray2, 0, nArray, 0, dArray3, 0);
                fArray[n * 2] = (float)dArray3[0];
                fArray[n * 2 + 1] = (float)dArray3[1];
                int n4 = (int)Math.round(dArray3[0]);
                int n5 = (int)Math.round(dArray3[1]);
                int n6 = n4 + n5 * 512;
                if (n4 < 0 || n5 < 0 || n4 >= 512 || n5 >= 512 || Math.abs((double)floatBuffer.get(n6) - dArray3[2]) > 0.01) continue;
                n2 = 1;
            }
            for (n = 0; n < 3; ++n) {
                int n7 = i * 6 + n * 2;
                if (n2 != 0) {
                    floatBuffer2.put(n7, fArray[n * 2] / 512.0f);
                    floatBuffer2.put(n7 + 1, fArray[n * 2 + 1] / 512.0f);
                    continue;
                }
                floatBuffer2.put(n7, 0.0f);
                floatBuffer2.put(n7 + 1, 0.0f);
            }
        }
    }

    private int calcRequiredBufferSize(int n) {
        int n2 = 0;
        if (n == 1 || n == 0) {
            n2 = 9 * this.nFace + 3 * (this.grids.w.size + this.grids.r.size);
        } else if (n == 2) {
            n2 = 12 * this.nFace + 4 * (this.grids.w.size + this.grids.r.size);
        } else if (n == 3) {
            n2 = 6 * this.nFace;
        }
        return n2;
    }

    private void buildBuffer(int n, GLBufferStorage gLBufferStorage) {
        block23: {
            int n2;
            int n3;
            ByteBuffer byteBuffer;
            block22: {
                byteBuffer = gLBufferStorage.getMappedBuffer();
                if (n == 0) {
                    for (n3 = 0; n3 < this.nFace; ++n3) {
                        for (n2 = 0; n2 < 3; ++n2) {
                            byteBuffer.putFloat(this.vertices[this.faces[n3][n2] - 1][0]);
                            byteBuffer.putFloat(this.vertices[this.faces[n3][n2] - 1][1]);
                            byteBuffer.putFloat(this.vertices[this.faces[n3][n2] - 1][2]);
                        }
                    }
                } else if (n == 1) {
                    for (n3 = 0; n3 < 3 * this.nNormal; ++n3) {
                        for (n2 = 0; n2 < 3; ++n2) {
                            byteBuffer.putFloat(this.normals[this.normalIndex[n3]][n2]);
                        }
                    }
                } else if (n == 2) {
                    for (n3 = 0; n3 < this.nMap; ++n3) {
                        for (n2 = 0; n2 < 3; ++n2) {
                            for (int i = 0; i < 4; ++i) {
                                byteBuffer.putFloat(this.rgba[n3][i]);
                            }
                        }
                    }
                } else if (n >= 3) {
                    for (n3 = 0; n3 < this.nFace; ++n3) {
                        for (n2 = 0; n2 < 6; ++n2) {
                            if (n == 3) {
                                byteBuffer.putFloat(this.uv[n3][n2]);
                                continue;
                            }
                            byteBuffer.putFloat(0.0f);
                        }
                    }
                }
                if (n != 0 && n != 1) break block22;
                for (n3 = 0; n3 < this.grids.r.size; ++n3) {
                    byteBuffer.putFloat(this.grids.r.data[n3][0]);
                    byteBuffer.putFloat(this.grids.r.data[n3][1]);
                    byteBuffer.putFloat(this.grids.r.data[n3][2]);
                }
                for (n3 = 0; n3 < this.grids.w.size; ++n3) {
                    byteBuffer.putFloat(this.grids.w.data[n3][0]);
                    byteBuffer.putFloat(this.grids.w.data[n3][1]);
                    byteBuffer.putFloat(this.grids.w.data[n3][2]);
                }
                break block23;
            }
            if (n != 2) break block23;
            for (n3 = 0; n3 < this.grids.r.size; ++n3) {
                byteBuffer.putFloat(1.0f);
                byteBuffer.putFloat(0.0f);
                byteBuffer.putFloat(0.0f);
                byteBuffer.putFloat(1.0f);
            }
            for (n3 = 0; n3 < this.grids.w.size; ++n3) {
                for (n2 = 0; n2 < 4; ++n2) {
                    byteBuffer.putFloat(1.0f);
                }
            }
        }
    }

    public boolean rewriteColor(ByteBuffer byteBuffer) {
        if (byteBuffer != null) {
            FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
            for (int i = 0; i < this.nMap; ++i) {
                floatBuffer.put(this.rgba[i]);
                floatBuffer.put(this.rgba[i]);
                floatBuffer.put(this.rgba[i]);
            }
            byteBuffer.limit(byteBuffer.position());
            byteBuffer.position(0);
            return true;
        }
        return false;
    }

    public void compile(GL2 gL2) {
        this.vboIdVertex = 0;
        this.vboIdNormal = 0;
        this.vboIdColor = 0;
        int[] nArray = new int[1];
        gL2.glGetIntegerv(34018, nArray, 0);
        int n = nArray[0];
        Logger.Debug("MaxTexture: " + n);
        this.vboIdUVs = new int[n];
        int n2 = 3 + n + 1;
        int[] nArray2 = new int[n2];
        gL2.glGenBuffers(n2, nArray2, 0);
        gL2.glBindBuffer(34962, nArray2[0]);
        int n3 = this.calcRequiredBufferSize(0);
        gL2.glBufferData(34962, (long)(n3 * 4), null, 35044);
        GLBufferStorage gLBufferStorage = gL2.mapBuffer(34962, 35001);
        this.buildBuffer(0, gLBufferStorage);
        gL2.glUnmapBuffer(34962);
        gL2.glBindBuffer(34962, nArray2[1]);
        n3 = this.calcRequiredBufferSize(1);
        gL2.glBufferData(34962, (long)(n3 * 4), null, 35044);
        gLBufferStorage = gL2.mapBuffer(34962, 35001);
        this.buildBuffer(1, gLBufferStorage);
        gL2.glUnmapBuffer(34962);
        gL2.glBindBuffer(34962, nArray2[2]);
        n3 = this.calcRequiredBufferSize(2);
        gL2.glBufferData(34962, (long)(n3 * 4), null, 35048);
        gLBufferStorage = gL2.mapBuffer(34962, 35001);
        this.buildBuffer(2, gLBufferStorage);
        gL2.glUnmapBuffer(34962);
        for (int i = 0; i < n; ++i) {
            gL2.glBindBuffer(34962, nArray2[3 + i]);
            n3 = this.calcRequiredBufferSize(3);
            gL2.glBufferData(34962, (long)(n3 * 4), null, 35048);
            gLBufferStorage = gL2.mapBuffer(34962, 35001);
            this.buildBuffer(3 + i, gLBufferStorage);
            gL2.glUnmapBuffer(34962);
            this.vboIdUVs[i] = nArray2[3 + i];
        }
        this.vboIdVertex = nArray2[0];
        this.vboIdNormal = nArray2[1];
        this.vboIdColor = nArray2[2];
    }

    public void changeSpectrumMap(String string, int n) {
        this.spms.convertToRGB(string, this.rgba, n);
    }

    public void addSpectrumMap(String string, SpectrumMap spectrumMap) throws IOException {
        this.spms.addSpectrumMap(string, spectrumMap);
    }

    public void emphasizePolygon(Integer n) {
        int n2 = n;
        this.rgba[n2][0] = 1.0f;
        this.rgba[n2][1] = 0.0f;
        this.rgba[n2][2] = 0.0f;
        this.rgba[n2][3] = 1.0f;
    }

    public double getSize() {
        return this.size;
    }

    public void setSize(double d) {
        System.out.println("size:" + d);
        this.size = d;
    }

    public SpectrumMap getSpectrum(String string) {
        return this.spms.getSpectrum(string);
    }

    public float getSpectrumData(String string, int n) {
        return this.spms.getSpectrumData(string, n);
    }

    public SpectrumMaps getAvailableSpectrumMaps() {
        return this.spms;
    }

    public int getVboId(int n) {
        if (n == 0) {
            return this.vboIdVertex;
        }
        if (n == 1) {
            return this.vboIdNormal;
        }
        if (n == 2) {
            return this.vboIdColor;
        }
        if (n >= 3) {
            return this.vboIdUVs[n - 3];
        }
        return -1;
    }

    public int getNVertex() {
        return this.nVertex;
    }

    public int getNFace() {
        return this.nFace;
    }

    public int getNNormal() {
        return this.nNormal;
    }

    public float getVertex(int n, int n2) {
        return this.vertices[n][n2];
    }

    public int getFace(int n, int n2) {
        return this.faces[n][n2];
    }

    public float getNormal(int n, int n2) {
        return this.normals[n][n2];
    }

    public int getNormalIndex(int n) {
        return this.normalIndex[n];
    }

    public int getTotalMapping() {
        return this.nMap;
    }

    public Grids getGrids() {
        return this.grids;
    }

    public float[][] getPoint() {
        return this.point;
    }

    public LatLon[] getLatLon() {
        return this.info;
    }

    public float[][] getNormal() {
        return this.normals;
    }

    public float[] getSpecular() {
        return this.specular;
    }

    public float[] getDiffuse() {
        return this.diffuse;
    }

    public float[] getAmbient() {
        return this.ambient;
    }

    public float getShiness() {
        return this.shiness;
    }
}

