/*
 * Decompiled with CFR 0.152.
 */
package aigis.model;

import aigis.gl.ColorBar;
import aigis.model.loader.FastReader;
import java.io.IOException;

public class SpectrumMap {
    public double minColor;
    public double maxColor;
    public double orgMinColor;
    public double orgMaxColor;
    private int nData;
    private float[] faceData;
    private String name;
    private String unitRepresentation;
    private double customRangeMin = Double.MAX_VALUE;
    private double customRangeMax = Double.MAX_VALUE;
    private ColorBar colorbar;

    public SpectrumMap(int n, String string, ColorBar colorBar) {
        this.nData = n;
        this.faceData = new float[this.nData];
        for (int i = 0; i < this.nData; ++i) {
            this.faceData[i] = Float.NEGATIVE_INFINITY;
        }
        this.name = string;
        this.colorbar = colorBar;
    }

    public SpectrumMap(String string, ColorBar colorBar) throws IOException {
        FastReader fastReader = new FastReader(string);
        this.name = fastReader.nextString();
        this.unitRepresentation = fastReader.nextString();
        this.nData = fastReader.nextInt();
        this.faceData = new float[this.nData];
        for (int i = 0; i < this.nData; ++i) {
            fastReader.nextInt();
            String string2 = fastReader.nextString();
            this.faceData[i] = string2.equals("-") ? Float.NEGATIVE_INFINITY : Float.valueOf(string2).floatValue();
        }
        fastReader.close();
        this.colorbar = colorBar;
    }

    public String getName() {
        return this.name;
    }

    public String getUnitRepresentation() {
        return this.unitRepresentation;
    }

    public void setCustomRange(double d, double d2) {
        this.customRangeMax = d;
        this.customRangeMin = d2;
    }

    public void clearCustomRange() {
        this.customRangeMin = Double.MAX_VALUE;
        this.customRangeMax = Double.MAX_VALUE;
    }

    public void convertToRGB(float[][] fArray, int n) {
        double d;
        float f = Float.NEGATIVE_INFINITY;
        float f2 = Float.POSITIVE_INFINITY;
        for (int i = 0; i < this.nData; ++i) {
            if (f < this.faceData[i] && this.faceData[i] != Float.NEGATIVE_INFINITY) {
                f = this.faceData[i];
            }
            if (!(f2 > this.faceData[i]) || this.faceData[i] == Float.NEGATIVE_INFINITY) continue;
            f2 = this.faceData[i];
        }
        double d2 = f;
        this.orgMinColor = d = (double)f2;
        this.orgMaxColor = d2;
        if (this.customRangeMin != Double.MAX_VALUE) {
            d = this.customRangeMin;
        }
        if (this.customRangeMax != Double.MAX_VALUE) {
            d2 = this.customRangeMax;
        }
        this.minColor = d;
        this.maxColor = d2;
        for (int i = 0; i < this.nData; ++i) {
            if (fArray.length <= i) {
                return;
            }
            fArray[i] = this.colorbar.convertSpectrum(n, this, this.faceData[i]);
        }
    }

    public float getSpectrumData(int n) {
        return this.faceData[n];
    }
}

