/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits.compression.algorithm.rice;

import java.nio.ByteBuffer;

public class BitBuffer {
    private static final int BITS_OF_4_BYTES = 32;
    private static final int BYTE_MASK = 255;
    private static final long INTEGER_MASK = 0xFFFFFFFFL;
    private static final int BITS_OF_1_BYTE = 8;
    private static final int BITS_OF_2_BYTES = 16;
    private static final int BITS_OF_3_BYTES = 24;
    private static final int BYTE_1_OF_INT = 255;
    private static final int BYTE_2_OF_INT = 65280;
    private static final int BYTE_3_OF_INT = 0xFF0000;
    private static final int BYTE_4_OF_INT = -16777216;
    private final ByteBuffer buffer;
    private long position;

    public BitBuffer(ByteBuffer writeBuffer) {
        this.buffer = writeBuffer;
    }

    public int bitbuffer() {
        return this.buffer.get((int)(this.position / 8L));
    }

    void close() {
        if (this.position % 8L != 0L) {
            this.putByte((byte)0, (int)(8L - this.position % 8L));
        }
        this.buffer.position((int)(this.position / 8L));
    }

    public int missingBitsInCurrentByte() {
        return (int)(8L - this.position % 8L);
    }

    public void movePosition(int i) {
        this.position += (long)i;
    }

    public void putByte(byte byteToAdd) {
        int bytePosition = (int)(this.position / 8L);
        int positionInByte = (int)(this.position % 8L);
        byte old = (byte)(this.buffer.get(bytePosition) & (byte)(~(255 >>> positionInByte)));
        int byteAsInt = byteToAdd & 0xFF;
        this.buffer.put(bytePosition, (byte)(old | (byte)(byteAsInt >>> positionInByte)));
        if (positionInByte > 0) {
            this.buffer.put(bytePosition + 1, (byte)(byteAsInt << 8 - positionInByte));
        }
        this.position += 8L;
    }

    public void putByte(byte byteToAdd, int bits) {
        int bytePosition = (int)(this.position / 8L);
        int positionInByte = (int)(this.position % 8L);
        byte old = this.buffer.get(bytePosition);
        int byteAsInt = 0xFF & (byteToAdd & 255 >>> 8 - bits) << 8 - bits;
        this.buffer.put(bytePosition, (byte)(0xFF & (old & 255 << 8 - positionInByte | byteAsInt >>> positionInByte)));
        if (8 - positionInByte < bits) {
            this.buffer.put(bytePosition + 1, (byte)(0xFF & byteAsInt << 8 - positionInByte));
        }
        this.position += (long)bits;
    }

    public void putInt(int i) {
        this.putByte((byte)((i & 0xFF000000) >>> 24));
        this.putByte((byte)((i & 0xFF0000) >>> 16));
        this.putByte((byte)((i & 0xFF00) >>> 8));
        this.putByte((byte)(i & 0xFF));
    }

    public void putInt(int i, int bits) {
        if (bits == 0) {
            return;
        }
        do {
            if (bits >= 8) {
                this.putByte((byte)((i & 255 << bits - 8) >>> bits - 8 & 0xFF));
                bits -= 8;
                continue;
            }
            this.putByte((byte)(i & 255 >> -(bits - 8)), bits);
            bits = 0;
        } while (bits > 0);
    }

    public void putLong(long l, int bits) {
        if (bits == 0) {
            return;
        }
        do {
            if (bits >= 32) {
                this.putInt((int)((l & 0xFFFFFFFFL << bits - 32) >>> bits - 32));
                bits -= 32;
                continue;
            }
            this.putInt((int)(l & 0xFFFFFFFFL >> -(bits - 32)), bits);
            bits = 0;
        } while (bits > 0);
    }
}

