/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits.header;

import nom.tam.fits.header.FitsHeaderImpl;
import nom.tam.fits.header.IFitsHeader;

public enum Checksum implements IFitsHeader
{
    CHECKSUM(IFitsHeader.HDU.ANY, IFitsHeader.VALUE.STRING, "checksum for the current HDU"),
    CHECKVER(IFitsHeader.HDU.ANY, IFitsHeader.VALUE.STRING, "version of checksum algorithm"),
    DATASUM(IFitsHeader.HDU.ANY, IFitsHeader.VALUE.STRING, "checksum of the data records");

    private final IFitsHeader key;

    private Checksum(IFitsHeader.HDU hdu, IFitsHeader.VALUE valueType, String comment) {
        this.key = new FitsHeaderImpl(this.name(), IFitsHeader.SOURCE.CHECKSUM, hdu, valueType, comment);
    }

    @Override
    public String comment() {
        return this.key.comment();
    }

    @Override
    public IFitsHeader.HDU hdu() {
        return this.key.hdu();
    }

    @Override
    public String key() {
        return this.key.key();
    }

    @Override
    public IFitsHeader n(int ... number) {
        return this.key.n(number);
    }

    @Override
    public IFitsHeader.SOURCE status() {
        return this.key.status();
    }

    @Override
    public IFitsHeader.VALUE valueType() {
        return this.key.valueType();
    }
}

