/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.util;

import java.io.IOException;
import java.lang.reflect.Array;
import nom.tam.util.AsciiFuncs;
import nom.tam.util.BufferPointer;

public abstract class BufferEncoder {
    private final BufferPointer sharedBuffer;

    protected BufferEncoder(BufferPointer sharedBuffer) {
        this.sharedBuffer = sharedBuffer;
    }

    protected abstract void needBuffer(int var1) throws IOException;

    protected void write(boolean[] b, int start, int length) throws IOException {
        for (int i = start; i < start + length; ++i) {
            this.writeBoolean(b[i]);
        }
    }

    protected abstract void write(byte[] var1, int var2, int var3) throws IOException;

    protected void write(char[] c, int start, int length) throws IOException {
        for (int i = start; i < start + length; ++i) {
            this.writeChar(c[i]);
        }
    }

    protected void write(double[] d, int start, int length) throws IOException {
        for (int i = start; i < start + length; ++i) {
            this.writeLong(Double.doubleToLongBits(d[i]));
        }
    }

    protected void write(float[] f, int start, int length) throws IOException {
        for (int i = start; i < start + length; ++i) {
            this.writeInt(Float.floatToIntBits(f[i]));
        }
    }

    protected void write(int[] i, int start, int length) throws IOException {
        for (int ii = start; ii < start + length; ++ii) {
            this.writeInt(i[ii]);
        }
    }

    protected void write(long[] l, int start, int length) throws IOException {
        for (int i = start; i < start + length; ++i) {
            this.writeLong(l[i]);
        }
    }

    protected void write(short[] s, int start, int length) throws IOException {
        for (int i = start; i < start + length; ++i) {
            this.writeShort(s[i]);
        }
    }

    protected void write(String[] s, int start, int length) throws IOException {
        for (int i = start; i < start + length; ++i) {
            this.write(AsciiFuncs.getBytes(s[i]), 0, s[i].length());
        }
    }

    protected void writeArray(Object o) throws IOException {
        if (!o.getClass().isArray()) {
            throw new IOException("Invalid object passed to BufferedDataOutputStream.write" + o.getClass().getName());
        }
        int length = Array.getLength(o);
        if (o.getClass().getComponentType().isArray()) {
            for (int i = 0; i < length; ++i) {
                this.writeArray(Array.get(o, i));
            }
        } else if (o instanceof boolean[]) {
            this.write((boolean[])o, 0, length);
        } else if (o instanceof byte[]) {
            this.write((byte[])o, 0, length);
        } else if (o instanceof char[]) {
            this.write((char[])o, 0, length);
        } else if (o instanceof short[]) {
            this.write((short[])o, 0, length);
        } else if (o instanceof int[]) {
            this.write((int[])o, 0, length);
        } else if (o instanceof long[]) {
            this.write((long[])o, 0, length);
        } else if (o instanceof float[]) {
            this.write((float[])o, 0, length);
        } else if (o instanceof double[]) {
            this.write((double[])o, 0, length);
        } else if (o instanceof String[]) {
            this.write((String[])o, 0, length);
        } else {
            for (int i = 0; i < length; ++i) {
                this.writeArray(Array.get(o, i));
            }
        }
    }

    protected void writeBoolean(boolean b) throws IOException {
        this.needBuffer(1);
        this.sharedBuffer.buffer[this.sharedBuffer.bufferOffset] = b ? (byte)1 : 0;
        ++this.sharedBuffer.bufferOffset;
    }

    protected void writeByte(int b) throws IOException {
        this.needBuffer(1);
        this.sharedBuffer.buffer[this.sharedBuffer.bufferOffset++] = (byte)b;
    }

    protected void writeChar(int c) throws IOException {
        this.needBuffer(2);
        this.sharedBuffer.buffer[this.sharedBuffer.bufferOffset++] = (byte)(c >>> 8);
        this.sharedBuffer.buffer[this.sharedBuffer.bufferOffset++] = (byte)c;
    }

    protected void writeChars(String s) throws IOException {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            this.writeChar(s.charAt(i));
        }
    }

    protected void writeDouble(double d) throws IOException {
        this.writeLong(Double.doubleToLongBits(d));
    }

    protected void writeFloat(float f) throws IOException {
        this.writeInt(Float.floatToIntBits(f));
    }

    protected void writeInt(int i) throws IOException {
        this.needBuffer(4);
        this.sharedBuffer.buffer[this.sharedBuffer.bufferOffset++] = (byte)(i >>> 24);
        this.sharedBuffer.buffer[this.sharedBuffer.bufferOffset++] = (byte)(i >>> 16);
        this.sharedBuffer.buffer[this.sharedBuffer.bufferOffset++] = (byte)(i >>> 8);
        this.sharedBuffer.buffer[this.sharedBuffer.bufferOffset++] = (byte)i;
    }

    protected void writeLong(long l) throws IOException {
        this.needBuffer(8);
        this.sharedBuffer.buffer[this.sharedBuffer.bufferOffset++] = (byte)(l >>> 56);
        this.sharedBuffer.buffer[this.sharedBuffer.bufferOffset++] = (byte)(l >>> 48);
        this.sharedBuffer.buffer[this.sharedBuffer.bufferOffset++] = (byte)(l >>> 40);
        this.sharedBuffer.buffer[this.sharedBuffer.bufferOffset++] = (byte)(l >>> 32);
        this.sharedBuffer.buffer[this.sharedBuffer.bufferOffset++] = (byte)(l >>> 24);
        this.sharedBuffer.buffer[this.sharedBuffer.bufferOffset++] = (byte)(l >>> 16);
        this.sharedBuffer.buffer[this.sharedBuffer.bufferOffset++] = (byte)(l >>> 8);
        this.sharedBuffer.buffer[this.sharedBuffer.bufferOffset++] = (byte)l;
    }

    protected void writeShort(int s) throws IOException {
        this.needBuffer(2);
        this.sharedBuffer.buffer[this.sharedBuffer.bufferOffset++] = (byte)(s >>> 8);
        this.sharedBuffer.buffer[this.sharedBuffer.bufferOffset++] = (byte)s;
    }
}

