/*
 * Decompiled with CFR 0.152.
 */
package sun.lwawt.macosx;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Label;
import java.awt.MediaTracker;
import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.util.Arrays;
import java.util.List;
import sun.awt.image.MultiResolutionCachedImage;
import sun.awt.image.MultiResolutionImage;
import sun.awt.image.SunWritableRaster;
import sun.lwawt.macosx.CFRetainedResource;

public class CImage
extends CFRetainedResource {
    static Creator creator = new Creator();

    private static native long nativeCreateNSImageFromArray(int[] var0, int var1, int var2);

    private static native long nativeCreateNSImageFromBytes(byte[] var0);

    private static native long nativeCreateNSImageFromArrays(int[][] var0, int[] var1, int[] var2);

    private static native long nativeCreateNSImageFromFileContents(String var0);

    private static native long nativeCreateNSImageOfFileFromLaunchServices(String var0);

    private static native long nativeCreateNSImageFromImageName(String var0);

    private static native long nativeCreateNSImageFromIconSelector(int var0);

    private static native byte[] nativeGetPlatformImageBytes(int[] var0, int var1, int var2);

    private static native void nativeCopyNSImageIntoArray(long var0, int[] var2, int var3, int var4, int var5, int var6);

    private static native Dimension2D nativeGetNSImageSize(long var0);

    private static native void nativeSetNSImageSize(long var0, double var2, double var4);

    private static native void nativeResizeNSImageRepresentations(long var0, double var2, double var4);

    private static native Dimension2D[] nativeGetNSImageRepresentationSizes(long var0, double var2, double var4);

    public static Creator getCreator() {
        return creator;
    }

    CImage(long l) {
        super(l, true);
    }

    private Image toImage() {
        if (this.ptr == 0L) {
            return null;
        }
        Dimension2D dimension2D = CImage.nativeGetNSImageSize(this.ptr);
        int n = (int)dimension2D.getWidth();
        int n2 = (int)dimension2D.getHeight();
        Dimension2D[] dimension2DArray = CImage.nativeGetNSImageRepresentationSizes(this.ptr, dimension2D.getWidth(), dimension2D.getHeight());
        return dimension2DArray == null || dimension2DArray.length < 2 ? new MultiResolutionCachedImage(n, n2, (n3, n4) -> this.toImage(n, n2, (int)n3, (int)n4)) : new MultiResolutionCachedImage(n, n2, dimension2DArray, (n3, n4) -> this.toImage(n, n2, (int)n3, (int)n4));
    }

    private BufferedImage toImage(int n, int n2, int n3, int n4) {
        BufferedImage bufferedImage = new BufferedImage(n3, n4, 3);
        DataBufferInt dataBufferInt = (DataBufferInt)bufferedImage.getRaster().getDataBuffer();
        int[] nArray = SunWritableRaster.stealData(dataBufferInt, 0);
        CImage.nativeCopyNSImageIntoArray(this.ptr, nArray, n, n2, n3, n4);
        SunWritableRaster.markDirty(dataBufferInt);
        return bufferedImage;
    }

    CImage resize(double d, double d2) {
        if (this.ptr != 0L) {
            CImage.nativeSetNSImageSize(this.ptr, d, d2);
        }
        return this;
    }

    void resizeRepresentations(double d, double d2) {
        if (this.ptr != 0L) {
            CImage.nativeResizeNSImageRepresentations(this.ptr, d, d2);
        }
    }

    public static class Creator {
        Creator() {
        }

        public Image createImageUsingNativeSize(long l) {
            if (l == 0L) {
                return null;
            }
            Dimension2D dimension2D = CImage.nativeGetNSImageSize(l);
            return this.createImage(l, dimension2D.getWidth(), dimension2D.getHeight());
        }

        Image createImage(long l, double d, double d2) {
            if (l == 0L) {
                throw new Error("Unable to instantiate CImage with null native image reference.");
            }
            return this.createImageWithSize(l, d, d2);
        }

        public Image createImageWithSize(long l, double d, double d2) {
            CImage cImage = new CImage(l);
            cImage.resize(d, d2);
            return cImage.toImage();
        }

        public Image createImageOfFile(String string, int n, int n2) {
            return this.createImage(CImage.nativeCreateNSImageOfFileFromLaunchServices(string), n, n2);
        }

        public Image createImageFromFile(String string, double d, double d2) {
            long l = CImage.nativeCreateNSImageFromFileContents(string);
            CImage.nativeSetNSImageSize(l, d, d2);
            return this.createImage(l, d, d2);
        }

        public Image createSystemImageFromSelector(String string, int n, int n2) {
            return this.createImage(CImage.nativeCreateNSImageFromIconSelector(Creator.getSelectorAsInt(string)), n, n2);
        }

        public Image createImageFromName(String string, int n, int n2) {
            return this.createImage(CImage.nativeCreateNSImageFromImageName(string), n, n2);
        }

        public Image createImageFromName(String string) {
            return this.createImageUsingNativeSize(CImage.nativeCreateNSImageFromImageName(string));
        }

        private static int[] imageToArray(Image image, boolean bl) {
            if (image == null) {
                return null;
            }
            if (bl && !(image instanceof BufferedImage)) {
                MediaTracker mediaTracker = new MediaTracker(new Label());
                mediaTracker.addImage(image, 0);
                try {
                    mediaTracker.waitForID(0);
                }
                catch (InterruptedException interruptedException) {
                    return null;
                }
                if (mediaTracker.isErrorID(0)) {
                    return null;
                }
            }
            int n = image.getWidth(null);
            int n2 = image.getHeight(null);
            if (n < 0 || n2 < 0) {
                return null;
            }
            BufferedImage bufferedImage = new BufferedImage(n, n2, 3);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.setComposite(AlphaComposite.Src);
            graphics2D.drawImage(image, 0, 0, null);
            graphics2D.dispose();
            return ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
        }

        public byte[] getPlatformImageBytes(Image image) {
            int[] nArray = Creator.imageToArray(image, false);
            if (nArray == null) {
                return null;
            }
            return CImage.nativeGetPlatformImageBytes(nArray, image.getWidth(null), image.getHeight(null));
        }

        public Image createImageFromPlatformImageBytes(byte[] byArray) {
            return this.createImageUsingNativeSize(CImage.nativeCreateNSImageFromBytes(byArray));
        }

        public CImage createFromImage(Image image) {
            return this.createFromImage(image, true);
        }

        public CImage createFromImageImmediately(Image image) {
            return this.createFromImage(image, false);
        }

        private CImage createFromImage(Image image, boolean bl) {
            if (image instanceof MultiResolutionImage) {
                List<Image> list = ((MultiResolutionImage)((Object)image)).getResolutionVariants();
                return this.createFromImages(list, bl);
            }
            int[] nArray = Creator.imageToArray(image, bl);
            if (nArray == null) {
                return null;
            }
            return new CImage(CImage.nativeCreateNSImageFromArray(nArray, image.getWidth(null), image.getHeight(null)));
        }

        public CImage createFromImages(List<Image> list) {
            return this.createFromImages(list, true);
        }

        private CImage createFromImages(List<Image> list, boolean bl) {
            if (list == null || list.isEmpty()) {
                return null;
            }
            int n = list.size();
            int[][] nArrayArray = new int[n][];
            int[] nArray = new int[n];
            int[] nArray2 = new int[n];
            n = 0;
            for (Image image : list) {
                nArrayArray[n] = Creator.imageToArray(image, bl);
                if (nArrayArray[n] == null) continue;
                nArray[n] = image.getWidth(null);
                nArray2[n] = image.getHeight(null);
                ++n;
            }
            if (n == 0) {
                return null;
            }
            return new CImage(CImage.nativeCreateNSImageFromArrays((int[][])Arrays.copyOf(nArrayArray, n), Arrays.copyOf(nArray, n), Arrays.copyOf(nArray2, n)));
        }

        static int getSelectorAsInt(String string) {
            byte[] byArray = string.getBytes();
            int n = Math.min(byArray.length, 4);
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    n2 <<= 8;
                }
                n2 |= byArray[i] & 0xFF;
            }
            return n2;
        }
    }
}

