/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits.compress;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;
import nom.tam.util.LoggerHelper;

public class CloseIS
extends FilterInputStream {
    private static final Logger LOG = LoggerHelper.getLogger(CloseIS.class);
    private static final int COPY_BUFFER_SIZE = 65536;
    private InputStream output;
    private OutputStream input;
    private String errorText;
    private IOException exception;
    private final Thread stdError;
    private final Thread copier;
    private final Process proc;

    public CloseIS(Process proc, final InputStream compressed) {
        super(new BufferedInputStream(proc.getInputStream(), 0x100000));
        if (compressed == null) {
            throw new NullPointerException();
        }
        this.proc = proc;
        final InputStream error = proc.getErrorStream();
        this.output = proc.getInputStream();
        this.input = proc.getOutputStream();
        this.stdError = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    int len;
                    ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                    byte[] buffer = new byte[65536];
                    while ((len = error.read(buffer, 0, buffer.length)) >= 0) {
                        bytes.write(buffer, 0, len);
                    }
                    error.close();
                    CloseIS.this.errorText = new String(bytes.toByteArray(), Charset.defaultCharset());
                }
                catch (IOException e) {
                    CloseIS.this.exception = e;
                }
            }
        });
        this.copier = new Thread(new Runnable(){

            @Override
            public void run() {
                block5: {
                    try {
                        int len;
                        byte[] buffer = new byte[65536];
                        while ((len = compressed.read(buffer, 0, buffer.length)) >= 0) {
                            CloseIS.this.input.write(buffer, 0, len);
                        }
                        CloseIS.this.input.close();
                    }
                    catch (IOException e) {
                        CloseIS.this.exception = e;
                    }
                    try {
                        compressed.close();
                    }
                    catch (IOException e) {
                        if (CloseIS.this.exception != null) break block5;
                        CloseIS.this.exception = e;
                    }
                }
            }
        });
        this.start();
    }

    private void start() {
        this.stdError.start();
        this.copier.start();
    }

    @Override
    public int read() throws IOException {
        int result = 0;
        try {
            int n = result = super.read();
            return n;
        }
        catch (IOException e) {
            result = -1;
            throw e;
        }
        finally {
            this.handledOccuredException(result);
        }
    }

    private void handledOccuredException(int result) throws IOException {
        int exitValue = 0;
        if (result < 0) {
            try {
                this.stdError.join();
                this.copier.join();
                exitValue = this.proc.exitValue();
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "could not join the stream processes", e);
            }
        }
        if (this.exception != null || exitValue != 0) {
            if (this.errorText != null && !this.errorText.trim().isEmpty()) {
                throw new IOException(this.errorText, this.exception);
            }
            if (this.exception == null) {
                throw new IOException("exit value was " + exitValue);
            }
            throw this.exception;
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int result = 0;
        try {
            int n = result = super.read(b, off, len);
            return n;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            this.handledOccuredException(result);
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.input.close();
        this.output.close();
    }
}

