/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.invoke.BoundMethodHandle;
import java.lang.invoke.DirectMethodHandle;
import java.lang.invoke.LambdaForm;
import java.lang.invoke.MemberName;
import java.lang.invoke.MethodHandleImpl;
import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodType;
import java.lang.invoke.WrongMethodTypeException;
import java.util.Arrays;
import java.util.List;

public abstract class MethodHandle {
    private final MethodType type;
    final LambdaForm form;
    MethodHandle asTypeCache;
    byte customizationCount;
    private static final long FORM_OFFSET;

    public MethodType type() {
        return this.type;
    }

    MethodHandle(MethodType methodType, LambdaForm lambdaForm) {
        methodType.getClass();
        lambdaForm.getClass();
        this.type = methodType;
        this.form = lambdaForm.uncustomize();
        this.form.prepare();
    }

    @PolymorphicSignature
    public final native Object invokeExact(Object ... var1) throws Throwable;

    @PolymorphicSignature
    public final native Object invoke(Object ... var1) throws Throwable;

    @PolymorphicSignature
    final native Object invokeBasic(Object ... var1) throws Throwable;

    @PolymorphicSignature
    static native Object linkToVirtual(Object ... var0) throws Throwable;

    @PolymorphicSignature
    static native Object linkToStatic(Object ... var0) throws Throwable;

    @PolymorphicSignature
    static native Object linkToSpecial(Object ... var0) throws Throwable;

    @PolymorphicSignature
    static native Object linkToInterface(Object ... var0) throws Throwable;

    public Object invokeWithArguments(Object ... objectArray) throws Throwable {
        MethodType methodType = MethodType.genericMethodType(objectArray == null ? 0 : objectArray.length);
        return methodType.invokers().spreadInvoker(0).invokeExact(this.asType(methodType), objectArray);
    }

    public Object invokeWithArguments(List<?> list) throws Throwable {
        return this.invokeWithArguments(list.toArray());
    }

    public MethodHandle asType(MethodType methodType) {
        if (methodType == this.type) {
            return this;
        }
        MethodHandle methodHandle = this.asTypeCached(methodType);
        if (methodHandle != null) {
            return methodHandle;
        }
        return this.asTypeUncached(methodType);
    }

    private MethodHandle asTypeCached(MethodType methodType) {
        MethodHandle methodHandle = this.asTypeCache;
        if (methodHandle != null && methodType == methodHandle.type) {
            return methodHandle;
        }
        return null;
    }

    MethodHandle asTypeUncached(MethodType methodType) {
        if (!this.type.isConvertibleTo(methodType)) {
            throw new WrongMethodTypeException("cannot convert " + this + " to " + methodType);
        }
        this.asTypeCache = MethodHandleImpl.makePairwiseConvert(this, methodType, true);
        return this.asTypeCache;
    }

    public MethodHandle asSpreader(Class<?> clazz, int n) {
        MethodType methodType = this.asSpreaderChecks(clazz, n);
        int n2 = this.type().parameterCount();
        int n3 = n2 - n;
        MethodHandle methodHandle = this.asType(methodType);
        BoundMethodHandle boundMethodHandle = methodHandle.rebind();
        LambdaForm lambdaForm = boundMethodHandle.editor().spreadArgumentsForm(1 + n3, clazz, n);
        MethodType methodType2 = methodType.replaceParameterTypes(n3, n2, clazz);
        return boundMethodHandle.copyWith(methodType2, lambdaForm);
    }

    private MethodType asSpreaderChecks(Class<?> clazz, int n) {
        this.spreadArrayChecks(clazz, n);
        int n2 = this.type().parameterCount();
        if (n2 < n || n < 0) {
            throw MethodHandleStatics.newIllegalArgumentException("bad spread array length");
        }
        Class<?> clazz2 = clazz.getComponentType();
        MethodType methodType = this.type();
        boolean bl = true;
        boolean bl2 = false;
        for (int i = n2 - n; i < n2; ++i) {
            Class<?> clazz3 = methodType.parameterType(i);
            if (clazz3 == clazz2) continue;
            bl = false;
            if (MethodType.canConvert(clazz2, clazz3)) continue;
            bl2 = true;
            break;
        }
        if (bl) {
            return methodType;
        }
        MethodType methodType2 = methodType.asSpreaderType(clazz, n);
        if (!bl2) {
            return methodType2;
        }
        this.asType(methodType2);
        throw MethodHandleStatics.newInternalError("should not return", null);
    }

    private void spreadArrayChecks(Class<?> clazz, int n) {
        Class<?> clazz2 = clazz.getComponentType();
        if (clazz2 == null) {
            throw MethodHandleStatics.newIllegalArgumentException("not an array type", clazz);
        }
        if ((n & 0x7F) != n) {
            if ((n & 0xFF) != n) {
                throw MethodHandleStatics.newIllegalArgumentException("array length is not legal", n);
            }
            assert (n >= 128);
            if (clazz2 == Long.TYPE || clazz2 == Double.TYPE) {
                throw MethodHandleStatics.newIllegalArgumentException("array length is not legal for long[] or double[]", n);
            }
        }
    }

    public MethodHandle asCollector(Class<?> clazz, int n) {
        this.asCollectorChecks(clazz, n);
        int n2 = this.type().parameterCount() - 1;
        BoundMethodHandle boundMethodHandle = this.rebind();
        MethodType methodType = this.type().asCollectorType(clazz, n);
        MethodHandle methodHandle = MethodHandleImpl.varargsArray(clazz, n);
        LambdaForm lambdaForm = boundMethodHandle.editor().collectArgumentArrayForm(1 + n2, methodHandle);
        if (lambdaForm != null) {
            return boundMethodHandle.copyWith(methodType, lambdaForm);
        }
        lambdaForm = boundMethodHandle.editor().collectArgumentsForm(1 + n2, methodHandle.type().basicType());
        return boundMethodHandle.copyWithExtendL(methodType, lambdaForm, methodHandle);
    }

    boolean asCollectorChecks(Class<?> clazz, int n) {
        this.spreadArrayChecks(clazz, n);
        int n2 = this.type().parameterCount();
        if (n2 != 0) {
            Class<?> clazz2 = this.type().parameterType(n2 - 1);
            if (clazz2 == clazz) {
                return true;
            }
            if (clazz2.isAssignableFrom(clazz)) {
                return false;
            }
        }
        throw MethodHandleStatics.newIllegalArgumentException("array type not assignable to trailing argument", this, clazz);
    }

    public MethodHandle asVarargsCollector(Class<?> clazz) {
        clazz.getClass();
        boolean bl = this.asCollectorChecks(clazz, 0);
        if (this.isVarargsCollector() && bl) {
            return this;
        }
        return MethodHandleImpl.makeVarargsCollector(this, clazz);
    }

    public boolean isVarargsCollector() {
        return false;
    }

    public MethodHandle asFixedArity() {
        assert (!this.isVarargsCollector());
        return this;
    }

    public MethodHandle bindTo(Object object) {
        object = this.type.leadingReferenceParameter().cast(object);
        return this.bindArgumentL(0, object);
    }

    public String toString() {
        if (MethodHandleStatics.DEBUG_METHOD_HANDLE_NAMES) {
            return "MethodHandle" + this.debugString();
        }
        return this.standardString();
    }

    String standardString() {
        return "MethodHandle" + this.type;
    }

    String debugString() {
        return this.type + " : " + this.internalForm() + this.internalProperties();
    }

    BoundMethodHandle bindArgumentL(int n, Object object) {
        return this.rebind().bindArgumentL(n, object);
    }

    MethodHandle setVarargs(MemberName memberName) throws IllegalAccessException {
        if (!memberName.isVarargs()) {
            return this;
        }
        Class<?> clazz = this.type().lastParameterType();
        if (clazz.isArray()) {
            return MethodHandleImpl.makeVarargsCollector(this, clazz);
        }
        throw memberName.makeAccessException("cannot make variable arity", null);
    }

    MethodHandle viewAsType(MethodType methodType, boolean bl) {
        assert (this.viewAsTypeChecks(methodType, bl));
        BoundMethodHandle boundMethodHandle = this.rebind();
        assert (!(boundMethodHandle instanceof DirectMethodHandle));
        return boundMethodHandle.copyWith(methodType, boundMethodHandle.form);
    }

    boolean viewAsTypeChecks(MethodType methodType, boolean bl) {
        if (bl ? !$assertionsDisabled && !this.type().isViewableAs(methodType, true) : !$assertionsDisabled && !this.type().basicType().isViewableAs(methodType.basicType(), true)) {
            throw new AssertionError(Arrays.asList(this, methodType));
        }
        return true;
    }

    LambdaForm internalForm() {
        return this.form;
    }

    MemberName internalMemberName() {
        return null;
    }

    Class<?> internalCallerClass() {
        return null;
    }

    MethodHandleImpl.Intrinsic intrinsicName() {
        return MethodHandleImpl.Intrinsic.NONE;
    }

    MethodHandle withInternalMemberName(MemberName memberName, boolean bl) {
        if (memberName != null) {
            return MethodHandleImpl.makeWrappedMember(this, memberName, bl);
        }
        if (this.internalMemberName() == null) {
            return this;
        }
        BoundMethodHandle boundMethodHandle = this.rebind();
        assert (boundMethodHandle.internalMemberName() == null);
        return boundMethodHandle;
    }

    boolean isInvokeSpecial() {
        return false;
    }

    Object internalValues() {
        return null;
    }

    Object internalProperties() {
        return "";
    }

    abstract MethodHandle copyWith(MethodType var1, LambdaForm var2);

    abstract BoundMethodHandle rebind();

    void updateForm(LambdaForm lambdaForm) {
        assert (lambdaForm.customized == null || lambdaForm.customized == this);
        if (this.form == lambdaForm) {
            return;
        }
        lambdaForm.prepare();
        MethodHandleStatics.UNSAFE.putObject((Object)this, FORM_OFFSET, (Object)lambdaForm);
        MethodHandleStatics.UNSAFE.fullFence();
    }

    void customize() {
        if (this.form.customized == null) {
            LambdaForm lambdaForm = this.form.customize(this);
            this.updateForm(lambdaForm);
        } else assert (this.form.customized == this);
    }

    static {
        MethodHandleImpl.initStatics();
        try {
            FORM_OFFSET = MethodHandleStatics.UNSAFE.objectFieldOffset(MethodHandle.class.getDeclaredField("form"));
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw MethodHandleStatics.newInternalError(reflectiveOperationException);
        }
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface PolymorphicSignature {
    }
}

