/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import java.io.PrintStream;
import java.util.logging.Logger;
import nom.tam.fits.BasicHDU;
import nom.tam.fits.Data;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import nom.tam.fits.RandomGroupsData;
import nom.tam.fits.header.Standard;
import nom.tam.util.ArrayFuncs;

public class RandomGroupsHDU
extends BasicHDU<RandomGroupsData> {
    private static final Logger LOG = Logger.getLogger(RandomGroupsHDU.class.getName());

    public static RandomGroupsData encapsulate(Object o) throws FitsException {
        if (o instanceof Object[][]) {
            return new RandomGroupsData((Object[][])o);
        }
        throw new FitsException("Attempt to encapsulate invalid data in Random Group");
    }

    static Object[] generateSampleRow(Header h) throws FitsException {
        Class<Number> baseClass;
        int ndim = h.getIntValue(Standard.NAXIS, 0) - 1;
        int[] dims = new int[ndim];
        int bitpix = h.getIntValue(Standard.BITPIX, 0);
        switch (bitpix) {
            case 8: {
                baseClass = Byte.TYPE;
                break;
            }
            case 16: {
                baseClass = Short.TYPE;
                break;
            }
            case 32: {
                baseClass = Integer.TYPE;
                break;
            }
            case 64: {
                baseClass = Long.TYPE;
                break;
            }
            case -32: {
                baseClass = Float.TYPE;
                break;
            }
            case -64: {
                baseClass = Double.TYPE;
                break;
            }
            default: {
                throw new FitsException("Invalid BITPIX:" + bitpix);
            }
        }
        for (int i = 0; i < ndim; ++i) {
            long cdim = h.getIntValue(Standard.NAXISn.n(i + 2), 0);
            if (cdim < 0L) {
                throw new FitsException("Invalid array dimension:" + cdim);
            }
            dims[ndim - i - 1] = (int)cdim;
        }
        Object[] sample = new Object[]{ArrayFuncs.newInstance(baseClass, h.getIntValue(Standard.PCOUNT)), ArrayFuncs.newInstance(baseClass, dims)};
        return sample;
    }

    public static boolean isData(Object potentialData) {
        String cn;
        Object[][] o;
        return potentialData instanceof Object[][] && (o = (Object[][])potentialData).length > 0 && o[0].length == 2 && ArrayFuncs.getBaseClass(o[0][0]) == ArrayFuncs.getBaseClass(o[0][1]) && ((cn = o[0][0].getClass().getName()).length() == 2 && cn.charAt(1) != 'Z' || cn.charAt(1) != 'C');
    }

    public static boolean isHeader(Header hdr) {
        if (hdr.getBooleanValue(Standard.SIMPLE)) {
            return hdr.getBooleanValue(Standard.GROUPS);
        }
        String xtension = hdr.getStringValue(Standard.XTENSION);
        String string = xtension = xtension == null ? "" : xtension.trim();
        if ("IMAGE".equals(xtension)) {
            return hdr.getBooleanValue(Standard.GROUPS);
        }
        return false;
    }

    public static RandomGroupsData manufactureData(Header header) throws FitsException {
        int gcount = header.getIntValue(Standard.GCOUNT, -1);
        int pcount = header.getIntValue(Standard.PCOUNT, -1);
        if (!header.getBooleanValue(Standard.GROUPS) || header.getIntValue(Standard.NAXISn.n(1), -1) != 0 || gcount < 0 || pcount < 0 || header.getIntValue(Standard.NAXIS) < 2) {
            throw new FitsException("Invalid Random Groups Parameters");
        }
        Object dataArray = gcount > 0 ? new Object[gcount][2] : new Object[][]{};
        Object[] sampleRow = RandomGroupsHDU.generateSampleRow(header);
        for (int i = 0; i < gcount; ++i) {
            dataArray[i][0] = ((Object[])ArrayFuncs.deepClone(sampleRow))[0];
            dataArray[i][1] = ((Object[])ArrayFuncs.deepClone(sampleRow))[1];
        }
        return new RandomGroupsData((Object[][])dataArray);
    }

    static Header manufactureHeader(Data d) throws FitsException {
        if (d == null) {
            throw new FitsException("Attempt to create null Random Groups data");
        }
        Header h = new Header();
        d.fillHeader(h);
        return h;
    }

    public RandomGroupsHDU(Header header, RandomGroupsData data) {
        super(header, data);
    }

    @Override
    protected boolean canBePrimary() {
        return true;
    }

    @Override
    public void info(PrintStream stream) {
        stream.println("Random Groups HDU");
        if (this.myHeader != null) {
            stream.println("   HeaderInformation:");
            stream.println("     Ngroups:" + this.myHeader.getIntValue(Standard.GCOUNT));
            stream.println("     Npar:   " + this.myHeader.getIntValue(Standard.PCOUNT));
            stream.println("     BITPIX: " + this.myHeader.getIntValue(Standard.BITPIX));
            stream.println("     NAXIS:  " + this.myHeader.getIntValue(Standard.NAXIS));
            for (int i = 0; i < this.myHeader.getIntValue(Standard.NAXIS); ++i) {
                stream.println("      NAXIS" + (i + 1) + "= " + this.myHeader.getIntValue(Standard.NAXISn.n(i + 1)));
            }
        } else {
            stream.println("    No Header Information");
        }
        Object[][] data = null;
        if (this.myData != null) {
            data = (Object[][])((RandomGroupsData)this.myData).getData();
        }
        if (data == null || data.length < 1 || data[0].length != 2) {
            stream.println("    Invalid/unreadable data");
        } else {
            stream.println("    Number of groups:" + data.length);
            stream.println("    Parameters: " + ArrayFuncs.arrayDescription(data[0][0]));
            stream.println("    Data:" + ArrayFuncs.arrayDescription(data[0][1]));
        }
    }

    public boolean isHeader() {
        return RandomGroupsHDU.isHeader(this.myHeader);
    }

    @Override
    protected void setPrimaryHDU(boolean status) throws FitsException {
        super.setPrimaryHDU(status);
        if (status) {
            this.myHeader.setSimple(true);
        } else {
            this.myHeader.setXtension("IMAGE");
        }
    }
}

