/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.util;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import nom.tam.util.ArrayDataInput;
import nom.tam.util.ArrayDataOutput;
import nom.tam.util.ArrayFuncs;
import nom.tam.util.DataTable;
import nom.tam.util.TableException;
import nom.tam.util.type.PrimitiveType;
import nom.tam.util.type.PrimitiveTypeHandler;
import nom.tam.util.type.PrimitiveTypes;

public class ColumnTable<T>
implements DataTable {
    private static final int MAX_COLUMN_INDEXES = 256;
    private static final int MAX_TYPE_VALUE = 256;
    private static final Map<PrimitiveType<?>, PointerAccess<?>> POINTER_ACCESSORS;
    private static final PointerAccess<?>[] POINTER_ACCESSORS_BY_TYPE;
    private Object[] arrays;
    private int[] sizes;
    private int nrow;
    private char[] types;
    private Class<?>[] bases;
    private byte[][] bytePointers;
    private short[][] shortPointers;
    private int[][] intPointers;
    private long[][] longPointers;
    private float[][] floatPointers;
    private double[][] doublePointers;
    private char[][] charPointers;
    private boolean[][] booleanPointers;
    private T extraState;

    public ColumnTable(Object[] arrays, int[] sizes) throws TableException {
        this.setup(arrays, sizes);
    }

    public void addColumn(Object newColumn, int size) throws TableException {
        String classname = newColumn.getClass().getName();
        this.nrow = this.checkColumnConsistency(newColumn, classname, this.nrow, size);
        int ncol = this.arrays.length;
        Object[] newArrays = new Object[ncol + 1];
        int[] newSizes = new int[ncol + 1];
        Class[] newBases = new Class[ncol + 1];
        char[] newTypes = new char[ncol + 1];
        System.arraycopy(this.arrays, 0, newArrays, 0, ncol);
        System.arraycopy(this.sizes, 0, newSizes, 0, ncol);
        System.arraycopy(this.bases, 0, newBases, 0, ncol);
        System.arraycopy(this.types, 0, newTypes, 0, ncol);
        this.arrays = newArrays;
        this.sizes = newSizes;
        this.bases = newBases;
        this.types = newTypes;
        this.arrays[ncol] = newColumn;
        this.sizes[ncol] = size;
        this.bases[ncol] = ArrayFuncs.getBaseClass(newColumn);
        this.types[ncol] = classname.charAt(1);
        this.addPointer(newColumn);
    }

    protected void addPointer(Object data) throws TableException {
        PointerAccess<Object> accessor = this.selectPointerAccessor(data);
        if (accessor == null) {
            throw new TableException("Invalid type for added column:" + data.getClass().getComponentType());
        }
        accessor.set(this, this.extendArray(accessor.get(this), data));
    }

    private PointerAccess<Object> selectPointerAccessor(Object data) {
        return POINTER_ACCESSORS.get(PrimitiveTypeHandler.valueOf(data.getClass().getComponentType()));
    }

    private <ArrayType> ArrayType extendArray(ArrayType originalArray, Object data) {
        int length = Array.getLength(originalArray);
        Object xb = Array.newInstance(originalArray.getClass().getComponentType(), length + 1);
        System.arraycopy(originalArray, 0, xb, 0, length);
        Array.set(xb, length, data);
        return (ArrayType)xb;
    }

    public void addRow(Object[] row) throws TableException {
        if (this.arrays.length == 0) {
            for (Object element : row) {
                this.addColumn(element, Array.getLength(element));
            }
        } else {
            if (row.length != this.arrays.length) {
                throw new TableException("Row length mismatch");
            }
            for (int i = 0; i < row.length; ++i) {
                if (row[i].getClass() != this.arrays[i].getClass() || Array.getLength(row[i]) != this.sizes[i]) {
                    throw new TableException("Row column mismatch at column:" + i);
                }
                Object xarray = ArrayFuncs.newInstance(this.bases[i], (this.nrow + 1) * this.sizes[i]);
                System.arraycopy(this.arrays[i], 0, xarray, 0, this.nrow * this.sizes[i]);
                System.arraycopy(row[i], 0, xarray, this.nrow * this.sizes[i], this.sizes[i]);
                this.arrays[i] = xarray;
            }
            this.initializePointers();
            ++this.nrow;
        }
    }

    protected void checkArrayConsistency(Object[] newArrays, int[] newSizes) throws TableException {
        if (newArrays.length != newSizes.length) {
            throw new TableException("readArraysAsColumns: Incompatible arrays and sizes.");
        }
        int ratio = 0;
        int newRowSize = 0;
        this.types = new char[newArrays.length];
        this.bases = new Class[newArrays.length];
        for (int i = 0; i < newArrays.length; ++i) {
            String classname = newArrays[i].getClass().getName();
            ratio = this.checkColumnConsistency(newArrays[i], classname, ratio, newSizes[i]);
            newRowSize += newSizes[i] * ArrayFuncs.getBaseLength(newArrays[i]);
            this.types[i] = classname.charAt(1);
            this.bases[i] = ArrayFuncs.getBaseClass(newArrays[i]);
        }
        this.nrow = ratio;
        this.arrays = newArrays;
        this.sizes = newSizes;
    }

    private int checkColumnConsistency(Object data, String classname, int ratio, int size) throws TableException {
        if (classname.charAt(0) != '[' || classname.length() != 2) {
            throw new TableException("Non-primitive array for column");
        }
        int thisSize = Array.getLength(data);
        if (thisSize == 0 && size != 0 && ratio != 0 || thisSize != 0 && size == 0) {
            throw new TableException("Size mismatch in column: " + thisSize + " != " + size);
        }
        if (size != 0 && thisSize % size != 0) {
            throw new TableException("Row size does not divide array for column");
        }
        int thisRatio = 0;
        if (size > 0) {
            thisRatio = thisSize / size;
            if (ratio != 0 && thisRatio != ratio) {
                throw new TableException("Different number of rows in different columns");
            }
        }
        if (thisRatio > 0) {
            return thisRatio;
        }
        return ratio;
    }

    public ColumnTable<T> copy() throws TableException {
        return new ColumnTable<T>((Object[])ArrayFuncs.deepClone(this.arrays), (int[])this.sizes.clone());
    }

    public void deleteColumns(int start, int len) throws TableException {
        int ncol = this.arrays.length;
        if (start < 0 || len < 0 || start + len > ncol) {
            throw new TableException("Invalid request to delete columns start: " + start + " length:" + len + " for table with " + ncol + " columns.");
        }
        if (len == 0) {
            return;
        }
        int ocol = ncol;
        Object[] newArrays = new Object[ncol -= len];
        int[] newSizes = new int[ncol];
        Class[] newBases = new Class[ncol];
        char[] newTypes = new char[ncol];
        System.arraycopy(this.arrays, 0, newArrays, 0, start);
        System.arraycopy(this.sizes, 0, newSizes, 0, start);
        System.arraycopy(this.bases, 0, newBases, 0, start);
        System.arraycopy(this.types, 0, newTypes, 0, start);
        int rem = ocol - (start + len);
        System.arraycopy(this.arrays, start + len, newArrays, start, rem);
        System.arraycopy(this.sizes, start + len, newSizes, start, rem);
        System.arraycopy(this.bases, start + len, newBases, start, rem);
        System.arraycopy(this.types, start + len, newTypes, start, rem);
        this.arrays = newArrays;
        this.sizes = newSizes;
        this.bases = newBases;
        this.types = newTypes;
        this.initializePointers();
    }

    public void deleteRow(int row) throws TableException {
        this.deleteRows(row, 1);
    }

    public void deleteRows(int row, int length) throws TableException {
        if (row < 0 || length < 0 || row + length > this.nrow) {
            throw new TableException("Invalid request to delete rows start: " + row + " length:" + length + " for table with " + this.nrow + " rows.");
        }
        if (length == 0) {
            return;
        }
        for (int col = 0; col < this.arrays.length; ++col) {
            int sz = this.sizes[col];
            int newSize = sz * (this.nrow - length);
            Object newArr = ArrayFuncs.newInstance(this.bases[col], newSize);
            System.arraycopy(this.arrays[col], 0, newArr, 0, row * sz);
            System.arraycopy(this.arrays[col], (row + length) * sz, newArr, row * sz, (this.nrow - row - length) * sz);
            this.arrays[col] = newArr;
        }
        this.nrow -= length;
        this.initializePointers();
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="intended exposure of mutable data")
    public Class<?>[] getBases() {
        return this.bases;
    }

    @Override
    public Object getColumn(int col) {
        return this.arrays[col];
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="intended exposure of mutable data")
    public Object[] getColumns() {
        return this.arrays;
    }

    @Override
    public Object getElement(int row, int col) {
        Object x = ArrayFuncs.newInstance(this.bases[col], this.sizes[col]);
        System.arraycopy(this.arrays[col], this.sizes[col] * row, x, 0, this.sizes[col]);
        return x;
    }

    public T getExtraState() {
        return this.extraState;
    }

    @Override
    public int getNCols() {
        return this.arrays.length;
    }

    @Override
    public int getNRows() {
        return this.nrow;
    }

    @Override
    public Object getRow(int row) {
        Object[] x = new Object[this.arrays.length];
        for (int col = 0; col < this.arrays.length; ++col) {
            x[col] = this.getElement(row, col);
        }
        return x;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="intended exposure of mutable data")
    public int[] getSizes() {
        return this.sizes;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="intended exposure of mutable data")
    public char[] getTypes() {
        return this.types;
    }

    protected void initializePointers() {
        int col;
        int[] columnIndex = new int[256];
        for (col = 0; col < this.arrays.length; ++col) {
            char c = this.types[col];
            columnIndex[c] = columnIndex[c] + 1;
        }
        this.bytePointers = new byte[columnIndex[PrimitiveTypes.BYTE.type()]][];
        this.shortPointers = new short[columnIndex[PrimitiveTypes.SHORT.type()]][];
        this.intPointers = new int[columnIndex[PrimitiveTypes.INT.type()]][];
        this.longPointers = new long[columnIndex[PrimitiveTypes.LONG.type()]][];
        this.floatPointers = new float[columnIndex[PrimitiveTypes.FLOAT.type()]][];
        this.doublePointers = new double[columnIndex[PrimitiveTypes.DOUBLE.type()]][];
        this.charPointers = new char[columnIndex[PrimitiveTypes.CHAR.type()]][];
        this.booleanPointers = new boolean[columnIndex[PrimitiveTypes.BOOLEAN.type()]][];
        Arrays.fill(columnIndex, 0);
        for (col = 0; col < this.arrays.length; ++col) {
            char colType = this.types[col];
            PointerAccess<?> accessor = POINTER_ACCESSORS_BY_TYPE[colType];
            Array.set(accessor.get(this), columnIndex[colType], this.arrays[col]);
            char c = colType;
            columnIndex[c] = columnIndex[c] + 1;
        }
    }

    public void read(ArrayDataInput is) throws IOException {
        int[] columnIndex = new int[256];
        for (int row = 0; row < this.nrow; ++row) {
            Arrays.fill(columnIndex, 0);
            for (int col = 0; col < this.arrays.length; ++col) {
                int arrOffset = this.sizes[col] * row;
                int size = this.sizes[col];
                char colType = this.types[col];
                PointerAccess<?> accessor = POINTER_ACCESSORS_BY_TYPE[colType];
                accessor.read(this, is, columnIndex[colType], arrOffset, size);
                char c = colType;
                columnIndex[c] = columnIndex[c] + 1;
            }
        }
    }

    @Override
    public void setColumn(int col, Object newColumn) throws TableException {
        boolean reset = newColumn.getClass() != this.arrays[col].getClass() || Array.getLength(newColumn) != Array.getLength(this.arrays[col]);
        this.arrays[col] = newColumn;
        if (reset) {
            this.setup(this.arrays, this.sizes);
        } else {
            this.initializePointers();
        }
    }

    @Override
    public void setElement(int row, int col, Object x) throws TableException {
        String classname = x.getClass().getName();
        if (!classname.equals("[" + this.types[col])) {
            throw new TableException("setElement: Incompatible element type");
        }
        if (Array.getLength(x) != this.sizes[col]) {
            throw new TableException("setElement: Incompatible element size");
        }
        System.arraycopy(x, 0, this.arrays[col], this.sizes[col] * row, this.sizes[col]);
    }

    public void setExtraState(T opaque) {
        this.extraState = opaque;
    }

    @Override
    public void setRow(int row, Object x) throws TableException {
        if (!(x instanceof Object[])) {
            throw new TableException("setRow: Incompatible row");
        }
        for (int col = 0; col < this.arrays.length; ++col) {
            this.setElement(row, col, ((Object[])x)[col]);
        }
    }

    private void setup(Object[] newArrays, int[] newSizes) throws TableException {
        this.checkArrayConsistency(newArrays, newSizes);
        this.initializePointers();
    }

    public void write(ArrayDataOutput os) throws IOException {
        int[] columnIndex = new int[256];
        for (int row = 0; row < this.nrow; ++row) {
            Arrays.fill(columnIndex, 0);
            for (int col = 0; col < this.arrays.length; ++col) {
                int arrOffset = this.sizes[col] * row;
                int size = this.sizes[col];
                char colType = this.types[col];
                POINTER_ACCESSORS_BY_TYPE[colType].write(this, os, columnIndex[colType], arrOffset, size);
                char c = colType;
                columnIndex[c] = columnIndex[c] + 1;
            }
        }
    }

    public void write(ArrayDataOutput os, int rowStart, int rowEnd, int columnNr) throws IOException {
        int[] columnIndex = new int[256];
        for (int row = 0; row < this.nrow; ++row) {
            if (row < rowStart || row >= rowEnd) continue;
            Arrays.fill(columnIndex, 0);
            for (int col = 0; col < this.arrays.length; ++col) {
                int arrOffset = this.sizes[col] * row;
                int size = this.sizes[col];
                char colType = this.types[col];
                if (columnNr == col) {
                    POINTER_ACCESSORS_BY_TYPE[colType].write(this, os, columnIndex[colType], arrOffset, size);
                }
                char c = colType;
                columnIndex[c] = columnIndex[c] + 1;
            }
        }
    }

    public void read(ArrayDataInput is, int rowStart, int rowEnd, int columnNr) throws IOException {
        int[] columnIndex = new int[256];
        for (int row = 0; row < this.nrow; ++row) {
            if (row < rowStart || row >= rowEnd) continue;
            Arrays.fill(columnIndex, 0);
            for (int col = 0; col < this.arrays.length; ++col) {
                int arrOffset = this.sizes[col] * row;
                int size = this.sizes[col];
                char colType = this.types[col];
                if (col == columnNr) {
                    POINTER_ACCESSORS_BY_TYPE[colType].read(this, is, columnIndex[colType], arrOffset, size);
                }
                char c = colType;
                columnIndex[c] = columnIndex[c] + 1;
            }
        }
    }

    static /* synthetic */ byte[][] access$002(ColumnTable x0, byte[][] x1) {
        x0.bytePointers = x1;
        return x1;
    }

    static /* synthetic */ boolean[][] access$102(ColumnTable x0, boolean[][] x1) {
        x0.booleanPointers = x1;
        return x1;
    }

    static /* synthetic */ short[][] access$202(ColumnTable x0, short[][] x1) {
        x0.shortPointers = x1;
        return x1;
    }

    static /* synthetic */ char[][] access$302(ColumnTable x0, char[][] x1) {
        x0.charPointers = x1;
        return x1;
    }

    static /* synthetic */ int[][] access$402(ColumnTable x0, int[][] x1) {
        x0.intPointers = x1;
        return x1;
    }

    static /* synthetic */ long[][] access$502(ColumnTable x0, long[][] x1) {
        x0.longPointers = x1;
        return x1;
    }

    static /* synthetic */ float[][] access$602(ColumnTable x0, float[][] x1) {
        x0.floatPointers = x1;
        return x1;
    }

    static /* synthetic */ double[][] access$702(ColumnTable x0, double[][] x1) {
        x0.doublePointers = x1;
        return x1;
    }

    static {
        POINTER_ACCESSORS_BY_TYPE = new PointerAccess[256];
        ColumnTable.POINTER_ACCESSORS_BY_TYPE[PrimitiveTypes.BYTE.type()] = new PointerAccess<byte[][]>(){

            @Override
            public byte[][] get(ColumnTable<?> table) {
                return ((ColumnTable)table).bytePointers;
            }

            @Override
            public void set(ColumnTable<?> table, byte[][] array) {
                ColumnTable.access$002(table, array);
            }

            @Override
            public void write(ColumnTable<?> table, ArrayDataOutput os, int index, int arrOffset, int size) throws IOException {
                os.write(((ColumnTable)table).bytePointers[index], arrOffset, size);
            }

            @Override
            @SuppressFBWarnings(value={"RR_NOT_CHECKED"}, justification="this read will never return less than the requested length")
            public void read(ColumnTable<?> table, ArrayDataInput is, int index, int arrOffset, int size) throws IOException {
                is.read(((ColumnTable)table).bytePointers[index], arrOffset, size);
            }
        };
        ColumnTable.POINTER_ACCESSORS_BY_TYPE[PrimitiveTypes.BOOLEAN.type()] = new PointerAccess<boolean[][]>(){

            @Override
            public boolean[][] get(ColumnTable<?> table) {
                return ((ColumnTable)table).booleanPointers;
            }

            @Override
            public void set(ColumnTable<?> table, boolean[][] array) {
                ColumnTable.access$102(table, array);
            }

            @Override
            public void write(ColumnTable<?> table, ArrayDataOutput os, int index, int arrOffset, int size) throws IOException {
                os.write(((ColumnTable)table).booleanPointers[index], arrOffset, size);
            }

            @Override
            public void read(ColumnTable<?> table, ArrayDataInput is, int index, int arrOffset, int size) throws IOException {
                is.read(((ColumnTable)table).booleanPointers[index], arrOffset, size);
            }
        };
        ColumnTable.POINTER_ACCESSORS_BY_TYPE[PrimitiveTypes.SHORT.type()] = new PointerAccess<short[][]>(){

            @Override
            public short[][] get(ColumnTable<?> table) {
                return ((ColumnTable)table).shortPointers;
            }

            @Override
            public void set(ColumnTable<?> table, short[][] array) {
                ColumnTable.access$202(table, array);
            }

            @Override
            public void write(ColumnTable<?> table, ArrayDataOutput os, int index, int arrOffset, int size) throws IOException {
                os.write(((ColumnTable)table).shortPointers[index], arrOffset, size);
            }

            @Override
            public void read(ColumnTable<?> table, ArrayDataInput is, int index, int arrOffset, int size) throws IOException {
                is.read(((ColumnTable)table).shortPointers[index], arrOffset, size);
            }
        };
        ColumnTable.POINTER_ACCESSORS_BY_TYPE[PrimitiveTypes.CHAR.type()] = new PointerAccess<char[][]>(){

            @Override
            public char[][] get(ColumnTable<?> table) {
                return ((ColumnTable)table).charPointers;
            }

            @Override
            public void set(ColumnTable<?> table, char[][] array) {
                ColumnTable.access$302(table, array);
            }

            @Override
            public void write(ColumnTable<?> table, ArrayDataOutput os, int index, int arrOffset, int size) throws IOException {
                os.write(((ColumnTable)table).charPointers[index], arrOffset, size);
            }

            @Override
            @SuppressFBWarnings(value={"RR_NOT_CHECKED"}, justification="this read will never return less than the requested length")
            public void read(ColumnTable<?> table, ArrayDataInput is, int index, int arrOffset, int size) throws IOException {
                is.read(((ColumnTable)table).charPointers[index], arrOffset, size);
            }
        };
        ColumnTable.POINTER_ACCESSORS_BY_TYPE[PrimitiveTypes.INT.type()] = new PointerAccess<int[][]>(){

            @Override
            public int[][] get(ColumnTable<?> table) {
                return ((ColumnTable)table).intPointers;
            }

            @Override
            public void set(ColumnTable<?> table, int[][] array) {
                ColumnTable.access$402(table, array);
            }

            @Override
            public void write(ColumnTable<?> table, ArrayDataOutput os, int index, int arrOffset, int size) throws IOException {
                os.write(((ColumnTable)table).intPointers[index], arrOffset, size);
            }

            @Override
            public void read(ColumnTable<?> table, ArrayDataInput is, int index, int arrOffset, int size) throws IOException {
                is.read(((ColumnTable)table).intPointers[index], arrOffset, size);
            }
        };
        ColumnTable.POINTER_ACCESSORS_BY_TYPE[PrimitiveTypes.LONG.type()] = new PointerAccess<long[][]>(){

            @Override
            public long[][] get(ColumnTable<?> table) {
                return ((ColumnTable)table).longPointers;
            }

            @Override
            public void set(ColumnTable<?> table, long[][] array) {
                ColumnTable.access$502(table, array);
            }

            @Override
            public void write(ColumnTable<?> table, ArrayDataOutput os, int index, int arrOffset, int size) throws IOException {
                os.write(((ColumnTable)table).longPointers[index], arrOffset, size);
            }

            @Override
            public void read(ColumnTable<?> table, ArrayDataInput is, int index, int arrOffset, int size) throws IOException {
                is.read(((ColumnTable)table).longPointers[index], arrOffset, size);
            }
        };
        ColumnTable.POINTER_ACCESSORS_BY_TYPE[PrimitiveTypes.FLOAT.type()] = new PointerAccess<float[][]>(){

            @Override
            public float[][] get(ColumnTable<?> table) {
                return ((ColumnTable)table).floatPointers;
            }

            @Override
            public void set(ColumnTable<?> table, float[][] array) {
                ColumnTable.access$602(table, array);
            }

            @Override
            public void write(ColumnTable<?> table, ArrayDataOutput os, int index, int arrOffset, int size) throws IOException {
                os.write(((ColumnTable)table).floatPointers[index], arrOffset, size);
            }

            @Override
            public void read(ColumnTable<?> table, ArrayDataInput is, int index, int arrOffset, int size) throws IOException {
                is.read(((ColumnTable)table).floatPointers[index], arrOffset, size);
            }
        };
        ColumnTable.POINTER_ACCESSORS_BY_TYPE[PrimitiveTypes.DOUBLE.type()] = new PointerAccess<double[][]>(){

            @Override
            public double[][] get(ColumnTable<?> table) {
                return ((ColumnTable)table).doublePointers;
            }

            @Override
            public void set(ColumnTable<?> table, double[][] array) {
                ColumnTable.access$702(table, array);
            }

            @Override
            public void write(ColumnTable<?> table, ArrayDataOutput os, int index, int arrOffset, int size) throws IOException {
                os.write(((ColumnTable)table).doublePointers[index], arrOffset, size);
            }

            @Override
            public void read(ColumnTable<?> table, ArrayDataInput is, int index, int arrOffset, int size) throws IOException {
                is.read(((ColumnTable)table).doublePointers[index], arrOffset, size);
            }
        };
        HashMap pointerAccess = new HashMap();
        pointerAccess.put(PrimitiveTypes.BYTE, POINTER_ACCESSORS_BY_TYPE[PrimitiveTypes.BYTE.type()]);
        pointerAccess.put(PrimitiveTypes.BOOLEAN, POINTER_ACCESSORS_BY_TYPE[PrimitiveTypes.BOOLEAN.type()]);
        pointerAccess.put(PrimitiveTypes.CHAR, POINTER_ACCESSORS_BY_TYPE[PrimitiveTypes.CHAR.type()]);
        pointerAccess.put(PrimitiveTypes.SHORT, POINTER_ACCESSORS_BY_TYPE[PrimitiveTypes.SHORT.type()]);
        pointerAccess.put(PrimitiveTypes.INT, POINTER_ACCESSORS_BY_TYPE[PrimitiveTypes.INT.type()]);
        pointerAccess.put(PrimitiveTypes.LONG, POINTER_ACCESSORS_BY_TYPE[PrimitiveTypes.LONG.type()]);
        pointerAccess.put(PrimitiveTypes.FLOAT, POINTER_ACCESSORS_BY_TYPE[PrimitiveTypes.FLOAT.type()]);
        pointerAccess.put(PrimitiveTypes.DOUBLE, POINTER_ACCESSORS_BY_TYPE[PrimitiveTypes.DOUBLE.type()]);
        POINTER_ACCESSORS = Collections.unmodifiableMap(pointerAccess);
    }

    private static interface PointerAccess<X> {
        public void set(ColumnTable<?> var1, X var2);

        public X get(ColumnTable<?> var1);

        public void write(ColumnTable<?> var1, ArrayDataOutput var2, int var3, int var4, int var5) throws IOException;

        public void read(ColumnTable<?> var1, ArrayDataInput var2, int var3, int var4, int var5) throws IOException;
    }
}

