/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.image.tile.operation.buffer;

import java.nio.Buffer;
import nom.tam.image.tile.operation.buffer.TileBuffer;
import nom.tam.util.type.PrimitiveType;
import nom.tam.util.type.PrimitiveTypeHandler;

class TileBufferColumnBased
extends TileBuffer {
    private Buffer gapLessBuffer;
    private final int imageWidth;

    TileBufferColumnBased(PrimitiveType<Buffer> baseType, int dataOffset, int imageWidth, int width, int height) {
        super(baseType, dataOffset, width, height);
        this.imageWidth = imageWidth;
    }

    @Override
    public void finish() {
        this.desolveGapLessBuffer();
    }

    @Override
    public Buffer getBuffer() {
        if (this.gapLessBuffer == null) {
            this.createGapLessBuffer();
        }
        return this.gapLessBuffer;
    }

    private void createGapLessBuffer() {
        int gap = this.imageWidth - this.getWidth();
        int pixelSizeInData = this.getPixelSizeInData();
        Buffer imagebuffer = this.getImageBuffer();
        imagebuffer.position(0);
        imagebuffer.limit(0);
        PrimitiveType<Buffer> type = this.primitiveType();
        this.gapLessBuffer = type.newBuffer(this.getPixelSize());
        while (imagebuffer.limit() < pixelSizeInData) {
            imagebuffer.limit(imagebuffer.position() + this.getWidth());
            type.appendBuffer(this.gapLessBuffer, imagebuffer);
            imagebuffer.limit(Math.min(pixelSizeInData, imagebuffer.position() + gap));
            imagebuffer.position(imagebuffer.limit());
        }
        this.gapLessBuffer.rewind();
    }

    private void desolveGapLessBuffer() {
        int gap = this.imageWidth - this.getWidth();
        int pixelSize = this.getPixelSize();
        Buffer imagebuffer = this.getImageBuffer();
        imagebuffer.limit(this.getPixelSizeInData());
        imagebuffer.rewind();
        this.gapLessBuffer.rewind();
        this.gapLessBuffer.limit(0);
        PrimitiveType<Buffer> type = this.primitiveType();
        while (this.gapLessBuffer.limit() < pixelSize) {
            this.gapLessBuffer.limit(this.gapLessBuffer.position() + this.getWidth());
            type.appendBuffer(imagebuffer, this.gapLessBuffer);
            imagebuffer.position(Math.min(imagebuffer.position() + gap, imagebuffer.limit()));
        }
        this.gapLessBuffer = null;
    }

    private int getPixelSizeInData() {
        return (this.getHeight() - 1) * this.imageWidth + this.getWidth();
    }

    private PrimitiveType<Buffer> primitiveType() {
        return PrimitiveTypeHandler.valueOf(this.getImageBuffer().getClass());
    }
}

