/*
 * Decompiled with CFR 0.152.
 */
package aigis.model;

import aigis.Logger;
import aigis.model.LatLon;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Point4f;
import javax.vecmath.Tuple4f;

public class Rotate
implements Cloneable {
    private Matrix4f matrix = new Matrix4f();

    public Rotate() {
        this.matrix.setIdentity();
    }

    public Rotate clone() {
        Rotate rotate = null;
        try {
            rotate = (Rotate)super.clone();
            rotate.matrix = new Matrix4f(this.matrix);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            Logger.Error(cloneNotSupportedException);
        }
        return rotate;
    }

    public float[] getMatrix() {
        float[] fArray = new float[16];
        for (int i = 0; i < 16; ++i) {
            fArray[i] = this.matrix.getElement(i / 4, i % 4);
        }
        return fArray;
    }

    public float[] getInvertMatrix() {
        Matrix4f matrix4f = new Matrix4f(this.matrix);
        matrix4f.invert();
        float[] fArray = new float[16];
        for (int i = 0; i < 16; ++i) {
            fArray[i] = matrix4f.getElement(i / 4, i % 4);
        }
        return fArray;
    }

    public void rotate(float f, float f2, float f3, boolean bl) {
        Matrix4f matrix4f = new Matrix4f();
        float f4 = (float)Math.sqrt(f * f + f2 * f2 + f3 * f3);
        matrix4f.set(new AxisAngle4f(f, f2, f3, f4 / 100.0f));
        if (bl) {
            matrix4f.mul(this.matrix);
            this.matrix = matrix4f;
        } else {
            this.matrix.mul(matrix4f);
        }
    }

    public void rotate(float f, float f2, Rotate rotate) {
        Matrix4f matrix4f = new Matrix4f(rotate.matrix);
        Point3f point3f = new Point3f();
        matrix4f.transform(new Point3f(-f, -f2, 0.0f), point3f);
        float f3 = (float)Math.sqrt(f * f + f2 * f2);
        matrix4f.set(new AxisAngle4f(point3f.x, point3f.y, point3f.z, f3 / 100.0f));
        this.matrix.mul(matrix4f);
    }

    public void moveXZ(float f, float f2, Rotate rotate) {
        this.matrix.rotX((float)Math.toRadians(f - 90.0f));
        Matrix4f matrix4f = new Matrix4f();
        matrix4f.rotZ((float)Math.toRadians(-f2 - 90.0f));
        this.matrix.mul(matrix4f);
        if (rotate != null) {
            this.matrix.mul(rotate.matrix);
        }
    }

    public void moveZX(float f, float f2) {
        this.matrix.rotZ((float)Math.toRadians(f2 + 90.0f));
        Matrix4f matrix4f = new Matrix4f();
        matrix4f.rotX((float)Math.toRadians(-f + 90.0f));
        this.matrix.mul(matrix4f);
    }

    public LatLon getLatLon(boolean bl, Rotate rotate) {
        Point4f point4f = new Point4f();
        Matrix4f matrix4f = new Matrix4f(this.matrix);
        if (rotate != null) {
            Matrix4f matrix4f2 = new Matrix4f(rotate.matrix);
            matrix4f2.invert();
            matrix4f.mul(matrix4f2);
        }
        if (bl) {
            matrix4f.invert();
        }
        matrix4f.transform((Tuple4f)new Point4f(0.0f, 0.0f, 1.0f, 1.0f), (Tuple4f)point4f);
        float f = (float)Math.atan2(point4f.z, Math.sqrt(point4f.x * point4f.x + point4f.y * point4f.y)) * 180.0f / (float)Math.PI;
        float f2 = (float)Math.atan2(point4f.y, point4f.x) * 180.0f / (float)Math.PI;
        if (f2 < 0.0f) {
            f2 = 360.0f + f2;
        }
        if ((double)f > -1.0E-5 && (double)f < 1.0E-5) {
            f = 0.0f;
        }
        if ((double)f2 > -1.0E-5 && (double)f2 < 1.0E-5) {
            f2 = 0.0f;
        }
        return new LatLon(f, f2);
    }
}

