/*
 * Decompiled with CFR 0.152.
 */
package aigis.model;

import aigis.Logger;
import aigis.model.ModelSelection;
import aigis.model.loader.PropLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;

public class SettingModel {
    private File baseDir = null;
    private String bodyName = null;
    private ArrayList<ShapePath> paths;
    private String gridrPath = null;
    private String gridwPath = null;
    private String gridPath = null;
    private String imageMapPath = null;
    private boolean isChangeModel = false;

    public void loadData(File file) throws Exception {
        Object object;
        PropLoader propLoader = new PropLoader();
        propLoader.load(new InputStreamReader((InputStream)new FileInputStream(new File(file, "AiGIS_setting.txt")), "UTF-8"));
        this.paths = new ArrayList();
        int n = 0;
        while (this.addPath(propLoader, (ShapePath)(object = new ShapePath()), ModelSelection.Resolution.Low, n)) {
            this.addPath(propLoader, (ShapePath)object, ModelSelection.Resolution.High, n);
            this.paths.add((ShapePath)object);
            ++n;
        }
        if (this.paths.isEmpty()) {
            throw new Exception("Property key 'SHAPE' is required");
        }
        this.bodyName = propLoader.getProperty("BODYNAME");
        this.gridrPath = propLoader.getProperty("GRIDR");
        this.gridwPath = propLoader.getProperty("GRIDW");
        this.gridPath = propLoader.getProperty("GRID");
        object = propLoader.getProperty("CHANGEMODEL");
        this.isChangeModel = object == null ? false : ((String)object).toLowerCase().equals("true");
        String string = propLoader.getProperty("IMAGEMAPDIR");
        this.imageMapPath = string != null ? new File(file, string).getAbsolutePath() : file.getAbsolutePath();
        this.baseDir = file;
    }

    private boolean addPath(PropLoader propLoader, ShapePath shapePath, ModelSelection.Resolution resolution, int n) {
        ShapePathData shapePathData = new ShapePathData();
        String string = "";
        if (resolution == ModelSelection.Resolution.High) {
            string = "HIGH";
        }
        if (n > 0) {
            string = string + n;
        }
        shapePathData.path = propLoader.getProperty("SHAPE" + string);
        shapePathData.mapDir = propLoader.getProperty("MAPDATADIR" + string);
        shapePathData.mapData = propLoader.getProperty("MAPDATA" + string);
        string = n > 0 ? String.valueOf(n) : "";
        shapePathData.chartData = propLoader.getProperty("CHARTDATA" + string);
        if (shapePathData.mapDir == null) {
            shapePathData.mapDir = resolution == ModelSelection.Resolution.High ? "MapDataHigh" + string : "MapData" + string;
        }
        if (shapePathData.path != null) {
            shapePath.put(resolution, shapePathData);
            return true;
        }
        return false;
    }

    public void clear() {
        this.bodyName = null;
        this.paths = null;
        this.gridrPath = null;
        this.gridwPath = null;
        this.gridPath = null;
        this.isChangeModel = false;
        this.imageMapPath = null;
        this.baseDir = null;
    }

    public void dump() {
        Logger.Info("--AiGIS_setting.txt--\nbodyName = " + this.bodyName + "\ngridrPath = " + this.gridrPath + "\ngridwPath = " + this.gridwPath + "\ngridPath = " + this.gridPath + "\nisChangeModel = " + this.isChangeModel);
        int n = 0;
        String string = "";
        for (ShapePath shapePath : this.paths) {
            for (ModelSelection.Resolution resolution : shapePath.keySet()) {
                if (n > 0) {
                    string = "" + n;
                }
                ShapePathData shapePathData = shapePath.get(resolution);
                Logger.Info("shapePath" + string + " = " + shapePathData.path + "\nmapDir" + string + " = " + shapePathData.mapDir + "\nmapData" + string + " = " + shapePathData.mapData + "\nchartData" + string + " = " + shapePathData.chartData);
            }
            ++n;
        }
        Logger.Info("");
    }

    public ArrayList<ShapePath> getPathList() {
        return this.paths;
    }

    public String getGridrPath() {
        return this.gridrPath;
    }

    public String getGridwPath() {
        return this.gridwPath;
    }

    public String getGridPath() {
        return this.gridPath;
    }

    public boolean isChangeModel() {
        return this.isChangeModel;
    }

    public String getBodyName() {
        return this.bodyName;
    }

    public String getImageMapPath() {
        return this.imageMapPath;
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    public class ShapePath {
        private HashMap<ModelSelection.Resolution, ShapePathData> paths = new HashMap();

        public void put(ModelSelection.Resolution resolution, ShapePathData shapePathData) {
            this.paths.put(resolution, shapePathData);
        }

        public ShapePathData get(ModelSelection.Resolution resolution) {
            return this.paths.get((Object)resolution);
        }

        public Set<ModelSelection.Resolution> keySet() {
            return this.paths.keySet();
        }
    }

    public class ShapePathData {
        public String path;
        public String mapDir;
        public String mapData;
        public String chartData;
    }
}

