/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.image.tile.operation.buffer;

import java.nio.Buffer;
import nom.tam.util.type.PrimitiveType;

public abstract class TileBuffer {
    private Buffer imageBuffer;
    private final int height;
    private final int offset;
    private final PrimitiveType<Buffer> baseType;
    private final int width;

    protected TileBuffer(PrimitiveType<Buffer> baseType, int dataOffset, int width, int height) {
        this.baseType = baseType;
        this.offset = dataOffset;
        this.width = width;
        this.height = height;
    }

    public void finish() {
    }

    public PrimitiveType<Buffer> getBaseType() {
        return this.baseType;
    }

    public abstract Buffer getBuffer();

    public int getHeight() {
        return this.height;
    }

    public int getPixelSize() {
        return this.width * this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public TileBuffer setData(Buffer value) {
        value.position(this.offset);
        this.imageBuffer = this.baseType.sliceBuffer(value);
        return this;
    }

    protected Buffer getImageBuffer() {
        return this.imageBuffer;
    }
}

