/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits.compression.algorithm.quant;

import nom.tam.fits.compression.algorithm.api.ICompressOption;
import nom.tam.fits.compression.provider.param.api.ICompressParameters;

public class QuantizeOption
implements ICompressOption {
    private static final int NULL_VALUE = -2147483647;
    protected ICompressParameters parameters;
    private double bScale = Double.NaN;
    private double bZero = Double.NaN;
    private boolean centerOnZero;
    private boolean checkNull;
    private boolean checkZero;
    private boolean dither;
    private boolean dither2;
    private int intMaxValue;
    private int intMinValue;
    private double maxValue;
    private double minValue;
    private double nullValue = Double.NaN;
    private Integer nullValueIndicator;
    private double qlevel = Double.NaN;
    private long seed = 1L;
    private int tileHeight;
    private int tileWidth;
    private QuantizeOption original;

    @Override
    public QuantizeOption copy() {
        try {
            return ((QuantizeOption)this.clone()).setOriginal(this);
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("option could not be cloned", e);
        }
    }

    public Integer getBNull() {
        return this.nullValueIndicator;
    }

    public double getBScale() {
        return this.bScale;
    }

    public double getBZero() {
        return this.bZero;
    }

    @Override
    public ICompressParameters getCompressionParameters() {
        return this.parameters;
    }

    public <T> T getCompressOption(Class<T> clazz) {
        return this.unwrap(clazz);
    }

    public int getIntMaxValue() {
        return this.intMaxValue;
    }

    public int getIntMinValue() {
        return this.intMinValue;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public double getMinValue() {
        return this.minValue;
    }

    public double getNullValue() {
        return this.nullValue;
    }

    public Integer getNullValueIndicator() {
        return this.nullValueIndicator;
    }

    public QuantizeOption getOriginal() {
        return this.original;
    }

    public double getQLevel() {
        return this.qlevel;
    }

    public long getSeed() {
        return this.seed;
    }

    public int getTileHeight() {
        return this.tileHeight;
    }

    public int getTileWidth() {
        return this.tileWidth;
    }

    public boolean isCenterOnZero() {
        return this.centerOnZero;
    }

    public boolean isCheckNull() {
        return this.checkNull;
    }

    public boolean isCheckZero() {
        return this.checkZero;
    }

    public boolean isDither() {
        return this.dither;
    }

    public boolean isDither2() {
        return this.dither2;
    }

    @Override
    public boolean isLossyCompression() {
        return true;
    }

    public ICompressOption setBNull(Integer blank) {
        if (blank != null) {
            this.checkNull = true;
            this.nullValueIndicator = blank;
        }
        return this;
    }

    public QuantizeOption setBScale(double value) {
        this.bScale = value;
        return this;
    }

    public QuantizeOption setBZero(double value) {
        this.bZero = value;
        return this;
    }

    public QuantizeOption setCenterOnZero(boolean value) {
        this.centerOnZero = value;
        return this;
    }

    public QuantizeOption setCheckNull(boolean value) {
        this.checkNull = value;
        if (this.nullValueIndicator == null) {
            this.nullValueIndicator = -2147483647;
        }
        return this;
    }

    public QuantizeOption setCheckZero(boolean value) {
        this.checkZero = value;
        return this;
    }

    public QuantizeOption setDither(boolean value) {
        this.dither = value;
        return this;
    }

    public QuantizeOption setDither2(boolean value) {
        this.dither2 = value;
        return this;
    }

    public QuantizeOption setIntMaxValue(int value) {
        this.intMaxValue = value;
        return this;
    }

    public QuantizeOption setIntMinValue(int value) {
        this.intMinValue = value;
        return this;
    }

    public QuantizeOption setMaxValue(double value) {
        this.maxValue = value;
        return this;
    }

    public QuantizeOption setMinValue(double value) {
        this.minValue = value;
        return this;
    }

    public QuantizeOption setNullValue(double value) {
        this.nullValue = value;
        return this;
    }

    @Override
    public void setParameters(ICompressParameters parameters) {
        this.parameters = parameters;
    }

    public QuantizeOption setQlevel(double value) {
        this.qlevel = value;
        return this;
    }

    public QuantizeOption setSeed(long value) {
        this.seed = value;
        return this;
    }

    @Override
    public QuantizeOption setTileHeight(int value) {
        this.tileHeight = value;
        return this;
    }

    @Override
    public QuantizeOption setTileWidth(int value) {
        this.tileWidth = value;
        return this;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) {
        if (clazz.isAssignableFrom(this.getClass())) {
            return clazz.cast(this);
        }
        return null;
    }

    private QuantizeOption setOriginal(QuantizeOption quantizeOption) {
        this.original = quantizeOption;
        this.parameters = this.parameters.copy(this);
        return this;
    }
}

