/*
 * Decompiled with CFR 0.152.
 */
package aigis.model;

import aigis.Logger;
import aigis.model.loader.PropLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;

public class SettingModel {
    private File baseDir = null;
    private String bodyName = null;
    private String shapePath = null;
    private String shapeHighPath = null;
    private String gridrPath = null;
    private String gridwPath = null;
    private String gridPath = null;
    private String mapDir = null;
    private String mapHighDir = null;
    private String mapData = null;
    private String mapHighData = null;
    private String chartData = null;
    private String imageMapPath = null;
    private boolean isChangeModel = false;

    public void loadData(File file) throws Exception {
        PropLoader propLoader = new PropLoader();
        propLoader.load(new InputStreamReader((InputStream)new FileInputStream(new File(file, "AiGIS_setting.txt")), "UTF-8"));
        this.shapePath = propLoader.getProperty("SHAPE");
        if (this.shapePath == null) {
            throw new Exception("Property key 'SHAPE' is required");
        }
        this.bodyName = propLoader.getProperty("BODYNAME");
        this.shapeHighPath = propLoader.getProperty("SHAPEHIGH");
        this.gridrPath = propLoader.getProperty("GRIDR");
        this.gridwPath = propLoader.getProperty("GRIDW");
        this.gridPath = propLoader.getProperty("GRID");
        this.mapDir = propLoader.getProperty("MAPDATADIR");
        this.mapHighDir = propLoader.getProperty("MAPDATAHIGHDIR");
        this.mapData = propLoader.getProperty("MAPDATA");
        this.mapHighData = propLoader.getProperty("MAPDATAHIGH");
        this.chartData = propLoader.getProperty("CHARTDATA");
        String string = propLoader.getProperty("CHANGEMODEL");
        this.isChangeModel = string == null ? false : string.toLowerCase().equals("true");
        String string2 = propLoader.getProperty("IMAGEMAPDIR");
        this.imageMapPath = string2 != null ? new File(file, string2).getAbsolutePath() : file.getAbsolutePath();
        this.baseDir = file;
    }

    public void clear() {
        this.bodyName = null;
        this.shapePath = null;
        this.shapeHighPath = null;
        this.gridrPath = null;
        this.gridwPath = null;
        this.gridPath = null;
        this.mapDir = null;
        this.mapHighDir = null;
        this.mapData = null;
        this.mapHighData = null;
        this.chartData = null;
        this.isChangeModel = false;
        this.imageMapPath = null;
        this.baseDir = null;
    }

    public void dump() {
        Logger.Info("--AiGIS_setting.txt--\nbodyName = " + this.bodyName + "\nshapePath = " + this.shapePath + "\nshapeHighPath = " + this.shapeHighPath + "\ngridrPath = " + this.gridrPath + "\ngridwPath = " + this.gridwPath + "\ngridPath = " + this.gridPath + "\nmapDir = " + this.mapDir + "\nmapHighDir = " + this.mapHighDir + "\nmapData = " + this.mapData + "\nmapHighData = " + this.mapHighData + "\nchartData = " + this.chartData + "\nisChangeModel = " + this.isChangeModel + "\n");
    }

    public String getShapePath() {
        return this.shapePath;
    }

    public String getShapeHighPath() {
        return this.shapeHighPath;
    }

    public String getGridrPath() {
        return this.gridrPath;
    }

    public String getGridwPath() {
        return this.gridwPath;
    }

    public String getGridPath() {
        return this.gridPath;
    }

    public String getMapDir() {
        return this.mapDir;
    }

    public String getMapHighDir() {
        return this.mapHighDir;
    }

    public String getMapData() {
        return this.mapData;
    }

    public String getMapHighData() {
        return this.mapHighData;
    }

    public String getChartData() {
        return this.chartData;
    }

    public boolean isChangeModel() {
        return this.isChangeModel;
    }

    public String getBodyName() {
        return this.bodyName;
    }

    public String getImageMapPath() {
        return this.imageMapPath;
    }

    public File getBaseDir() {
        return this.baseDir;
    }
}

