/*
 * Decompiled with CFR 0.152.
 */
package aigis.model;

import aigis.model.SpectrumMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class SpectrumMaps {
    private LinkedHashMap<String, SpectrumMap> spectrumMaps = new LinkedHashMap();

    SpectrumMaps() {
    }

    public int getSize() {
        return this.spectrumMaps.size();
    }

    public void clear() {
        this.spectrumMaps.clear();
    }

    public void addSpectrumMap(String string, SpectrumMap spectrumMap) {
        this.spectrumMaps.put(string, spectrumMap);
    }

    public void convertToRGB(String string, float[][] fArray, int n) {
        if (!this.spectrumMaps.containsKey(string)) {
            return;
        }
        this.spectrumMaps.get(string).convertToRGB(fArray, n);
    }

    public SpectrumMap getSpectrum(String string) {
        return this.spectrumMaps.get(string);
    }

    public float getSpectrumData(String string, int n) {
        if (this.spectrumMaps.containsKey(string)) {
            return this.spectrumMaps.get(string).getSpectrumData(n);
        }
        return -1.0f;
    }

    public ArrayList<String> getSpectrumList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Map.Entry<String, SpectrumMap> entry : this.spectrumMaps.entrySet()) {
            arrayList.add(entry.getValue().getName());
        }
        return arrayList;
    }

    public Set<Map.Entry<String, SpectrumMap>> getEntrySet() {
        return this.spectrumMaps.entrySet();
    }
}

