/*
 * Decompiled with CFR 0.152.
 */
package aigis.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class ButtonCellEditor
extends AbstractCellEditor
implements TableCellRenderer,
TableCellEditor {
    public static final String NORMAL = "[BUTTON]";
    public static final String DISABLED = "[BUTTON-D]";
    public static final String CHECKED = "[BUTTON-C]";
    private final DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
    private JButton renderButton = null;
    private JCheckBox renderCheck = null;
    private CellEventListener eventListener;

    public ButtonCellEditor(String string, CellEventListener cellEventListener, boolean bl) {
        if (bl) {
            this.renderCheck = new JCheckBox(string);
        } else {
            this.renderButton = new JButton(string);
            this.renderButton.setDefaultCapable(false);
            this.renderButton.setMargin(new Insets(0, 0, 0, 0));
        }
        this.eventListener = cellEventListener;
    }

    @Override
    public Object getCellEditorValue() {
        return NORMAL;
    }

    @Override
    public Component getTableCellEditorComponent(final JTable jTable, Object object, boolean bl, final int n, final int n2) {
        if (NORMAL.equals(object) || DISABLED.equals(object) || CHECKED.equals(object)) {
            if (this.renderButton == null) {
                final JCheckBox jCheckBox = new JCheckBox(this.renderCheck.getText());
                jCheckBox.setPreferredSize(new Dimension(10, 10));
                jCheckBox.setSelected(CHECKED.equals(object));
                jCheckBox.addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent changeEvent) {
                        ButtonCellEditor.this.eventListener.actionPerformed(jTable, n, n2, jCheckBox.isSelected());
                    }
                });
                return jCheckBox;
            }
            JButton jButton = new JButton(this.renderButton.getText());
            jButton.setDefaultCapable(false);
            jButton.setMargin(new Insets(0, 0, 0, 0));
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ButtonCellEditor.this.fireEditingStopped();
                    ButtonCellEditor.this.eventListener.actionPerformed(jTable, n, n2, false);
                }
            });
            return jButton;
        }
        return null;
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (NORMAL.equals(object) || DISABLED.equals(object) || CHECKED.equals(object)) {
            if (this.renderButton == null) {
                if (bl) {
                    this.renderCheck.setBackground(jTable.getSelectionBackground());
                } else {
                    this.renderCheck.setBackground(jTable.getBackground());
                }
                this.renderCheck.setEnabled(!DISABLED.equals(object));
                this.renderCheck.setSelected(CHECKED.equals(object));
                return this.renderCheck;
            }
            this.renderButton.setEnabled(!DISABLED.equals(object));
            return this.renderButton;
        }
        return this.renderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
    }

    static interface CellEventListener {
        public void actionPerformed(JTable var1, int var2, int var3, boolean var4);
    }
}

