/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.util.array;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class MultiArrayCopyFactory {
    private static final Map<Class<?>, Map<Class<?>, MultiArrayCopyFactory>> FACTORIES;
    private static final MultiArrayCopyFactory GENERIC;

    public static MultiArrayCopyFactory select(Class<?> primitiveType, Class<?> primitiveType2) {
        MultiArrayCopyFactory to;
        Map<Class<?>, MultiArrayCopyFactory> from = FACTORIES.get(primitiveType);
        if (from != null && (to = from.get(primitiveType2)) != null) {
            return to;
        }
        return GENERIC;
    }

    public void arraycopy(Object src, int srcPos, Object dest, int destPos, int length) {
        System.arraycopy(src, srcPos, dest, destPos, length);
    }

    static {
        GENERIC = new Generic();
        HashMap factories = new HashMap();
        HashMap<Class<Comparable<Byte>>, MultiArrayCopyFactory> byteMap = new HashMap<Class<Comparable<Byte>>, MultiArrayCopyFactory>();
        byteMap.put(Byte.TYPE, new MultiArrayCopyFactory());
        byteMap.put(Character.TYPE, new ByteToChar());
        byteMap.put(Short.TYPE, new ByteToShort());
        byteMap.put(Integer.TYPE, new ByteToInt());
        byteMap.put(Long.TYPE, new ByteToLong());
        byteMap.put(Float.TYPE, new ByteToFloat());
        byteMap.put(Double.TYPE, new ByteToDouble());
        factories.put(Byte.TYPE, Collections.unmodifiableMap(byteMap));
        HashMap<Class<Comparable<Byte>>, MultiArrayCopyFactory> charMap = new HashMap<Class<Comparable<Byte>>, MultiArrayCopyFactory>();
        charMap.put(Byte.TYPE, new CharToByte());
        charMap.put(Character.TYPE, new MultiArrayCopyFactory());
        charMap.put(Short.TYPE, new CharToShort());
        charMap.put(Integer.TYPE, new CharToInt());
        charMap.put(Long.TYPE, new CharToLong());
        charMap.put(Float.TYPE, new CharToFloat());
        charMap.put(Double.TYPE, new CharToDouble());
        factories.put(Character.TYPE, Collections.unmodifiableMap(charMap));
        HashMap<Class<Comparable<Byte>>, MultiArrayCopyFactory> shortMap = new HashMap<Class<Comparable<Byte>>, MultiArrayCopyFactory>();
        shortMap.put(Byte.TYPE, new ShortToByte());
        shortMap.put(Character.TYPE, new ShortToChar());
        shortMap.put(Short.TYPE, new MultiArrayCopyFactory());
        shortMap.put(Integer.TYPE, new ShortToInt());
        shortMap.put(Long.TYPE, new ShortToLong());
        shortMap.put(Float.TYPE, new ShortToFloat());
        shortMap.put(Double.TYPE, new ShortToDouble());
        factories.put(Short.TYPE, Collections.unmodifiableMap(shortMap));
        HashMap<Class<Comparable<Byte>>, MultiArrayCopyFactory> intMap = new HashMap<Class<Comparable<Byte>>, MultiArrayCopyFactory>();
        intMap.put(Byte.TYPE, new IntToByte());
        intMap.put(Character.TYPE, new IntToChar());
        intMap.put(Short.TYPE, new IntToShort());
        intMap.put(Integer.TYPE, new MultiArrayCopyFactory());
        intMap.put(Long.TYPE, new IntToLong());
        intMap.put(Float.TYPE, new IntToFloat());
        intMap.put(Double.TYPE, new IntToDouble());
        factories.put(Integer.TYPE, Collections.unmodifiableMap(intMap));
        HashMap<Class<Comparable<Byte>>, MultiArrayCopyFactory> longMap = new HashMap<Class<Comparable<Byte>>, MultiArrayCopyFactory>();
        longMap.put(Byte.TYPE, new LongToByte());
        longMap.put(Character.TYPE, new LongToChar());
        longMap.put(Short.TYPE, new LongToShort());
        longMap.put(Integer.TYPE, new LongToInt());
        longMap.put(Long.TYPE, new MultiArrayCopyFactory());
        longMap.put(Float.TYPE, new LongToFloat());
        longMap.put(Double.TYPE, new LongToDouble());
        factories.put(Long.TYPE, Collections.unmodifiableMap(longMap));
        HashMap<Class<Comparable<Byte>>, MultiArrayCopyFactory> floatMap = new HashMap<Class<Comparable<Byte>>, MultiArrayCopyFactory>();
        floatMap.put(Byte.TYPE, new FloatToByte());
        floatMap.put(Character.TYPE, new FloatToChar());
        floatMap.put(Short.TYPE, new FloatToShort());
        floatMap.put(Integer.TYPE, new FloatToInt());
        floatMap.put(Long.TYPE, new FloatToLong());
        floatMap.put(Float.TYPE, new MultiArrayCopyFactory());
        floatMap.put(Double.TYPE, new FloatToDouble());
        factories.put(Float.TYPE, Collections.unmodifiableMap(floatMap));
        HashMap<Class<Comparable<Byte>>, MultiArrayCopyFactory> doubleMap = new HashMap<Class<Comparable<Byte>>, MultiArrayCopyFactory>();
        doubleMap.put(Byte.TYPE, new DoubleToByte());
        doubleMap.put(Character.TYPE, new DoubleToChar());
        doubleMap.put(Short.TYPE, new DoubleToShort());
        doubleMap.put(Integer.TYPE, new DoubleToInt());
        doubleMap.put(Long.TYPE, new DoubleToLong());
        doubleMap.put(Float.TYPE, new DoubleToFloat());
        doubleMap.put(Double.TYPE, new MultiArrayCopyFactory());
        factories.put(Double.TYPE, Collections.unmodifiableMap(doubleMap));
        FACTORIES = Collections.unmodifiableMap(factories);
    }

    private static class ShortToLong
    extends MultiArrayCopyFactory {
        private ShortToLong() {
        }

        @Override
        public void arraycopy(Object srcO, int srcPos, Object destO, int destPos, int length) {
            short[] src = (short[])srcO;
            long[] dest = (long[])destO;
            for (int index = 0; index < length; ++index) {
                dest[index + destPos] = src[index + srcPos];
            }
        }
    }

    private static class ShortToInt
    extends MultiArrayCopyFactory {
        private ShortToInt() {
        }

        @Override
        public void arraycopy(Object srcO, int srcPos, Object destO, int destPos, int length) {
            short[] src = (short[])srcO;
            int[] dest = (int[])destO;
            for (int index = 0; index < length; ++index) {
                dest[index + destPos] = src[index + srcPos];
            }
        }
    }

    private static class ShortToFloat
    extends MultiArrayCopyFactory {
        private ShortToFloat() {
        }

        @Override
        public void arraycopy(Object srcO, int srcPos, Object destO, int destPos, int length) {
            short[] src = (short[])srcO;
            float[] dest = (float[])destO;
            for (int index = 0; index < length; ++index) {
                dest[index + destPos] = src[index + srcPos];
            }
        }
    }

    private static class ShortToDouble
    extends MultiArrayCopyFactory {
        private ShortToDouble() {
        }

        @Override
        public void arraycopy(Object srcO, int srcPos, Object destO, int destPos, int length) {
            short[] src = (short[])srcO;
            double[] dest = (double[])destO;
            for (int index = 0; index < length; ++index) {
                dest[index + destPos] = src[index + srcPos];
            }
        }
    }

    private static class ShortToChar
    extends MultiArrayCopyFactory {
        private ShortToChar() {
        }

        @Override
        public void arraycopy(Object srcO, int srcPos, Object destO, int destPos, int length) {
            short[] src = (short[])srcO;
            char[] dest = (char[])destO;
            for (int index = 0; index < length; ++index) {
                dest[index + destPos] = (char)src[index + srcPos];
            }
        }
    }

    private static class ShortToByte
    extends MultiArrayCopyFactory {
        private ShortToByte() {
        }

        @Override
        public void arraycopy(Object srcO, int srcPos, Object destO, int destPos, int length) {
            short[] src = (short[])srcO;
            byte[] dest = (byte[])destO;
            for (int index = 0; index < length; ++index) {
                dest[index + destPos] = (byte)src[index + srcPos];
            }
        }
    }

    private static class LongToShort
    extends MultiArrayCopyFactory {
        private LongToShort() {
        }

        @Override
        public void arraycopy(Object srcO, int srcPos, Object destO, int destPos, int length) {
            long[] src = (long[])srcO;
            short[] dest = (short[])destO;
            for (int index = 0; index < length; ++index) {
                dest[index + destPos] = (short)src[index + srcPos];
            }
        }
    }

    private static class LongToInt
    extends MultiArrayCopyFactory {
        private LongToInt() {
        }

        @Override
        public void arraycopy(Object srcO, int srcPos, Object destO, int destPos, int length) {
            long[] src = (long[])srcO;
            int[] dest = (int[])destO;
            for (int index = 0; index < length; ++index) {
                dest[index + destPos] = (int)src[index + srcPos];
            }
        }
    }

    private static class LongToFloat
    extends MultiArrayCopyFactory {
        private LongToFloat() {
        }

        @Override
        public void arraycopy(Object srcO, int srcPos, Object destO, int destPos, int length) {
            long[] src = (long[])srcO;
            float[] dest = (float[])destO;
            for (int index = 0; index < length; ++index) {
                dest[index + destPos] = src[index + srcPos];
            }
        }
    }

    private static class LongToDouble
    extends MultiArrayCopyFactory {
        private LongToDouble() {
        }

        @Override
        public void arraycopy(Object srcO, int srcPos, Object destO, int destPos, int length) {
            long[] src = (long[])srcO;
            double[] dest = (double[])destO;
            for (int index = 0; index < length; ++index) {
                dest[index + destPos] = src[index + srcPos];
            }
        }
    }

    private static class LongToChar
    extends MultiArrayCopyFactory {
        private LongToChar() {
        }

        @Override
        public void arraycopy(Object srcO, int srcPos, Object destO, int destPos, int length) {
            long[] src = (long[])srcO;
            char[] dest = (char[])destO;
            for (int index = 0; index < length; ++index) {
                dest[index + destPos] = (char)src[index + srcPos];
            }
        }
    }

    private static class LongToByte
    extends MultiArrayCopyFactory {
        private LongToByte() {
        }

        @Override
        public void arraycopy(Object srcO, int srcPos, Object destO, int destPos, int length) {
            long[] src = (long[])srcO;
            byte[] dest = (byte[])destO;
            for (int index = 0; index < length; ++index) {
                dest[index + destPos] = (byte)src[index + srcPos];
            }
        }
    }

    private static class IntToShort
    extends MultiArrayCopyFactory {
        private IntToShort() {
        }

        @Override
        public void arraycopy(Object srcO, int srcPos, Object destO, int destPos, int length) {
            int[] src = (int[])srcO;
            short[] dest = (short[])destO;
            for (int index = 0; index < length; ++index) {
                dest[index + destPos] = (short)src[index + srcPos];
            }
        }
    }

    private static class IntToLong
    extends MultiArrayCopyFactory {
        private IntToLong() {
        }

        @Override
        public void arraycopy(Object srcO, int srcPos, Object destO, int destPos, int length) {
            int[] src = (int[])srcO;
            long[] dest = (long[])destO;
            for (int index = 0; index < length; ++index) {
                dest[index + destPos] = src[index + srcPos];
            }
        }
    }

    private static class IntToFloat
    extends MultiArrayCopyFactory {
        private IntToFloat() {
        }

        @Override
        public void arraycopy(Object srcO, int srcPos, Object destO, int destPos, int length) {
            int[] src = (int[])srcO;
            float[] dest = (float[])destO;
            for (int index = 0; index < length; ++index) {
                dest[index + destPos] = src[index + srcPos];
            }
        }
    }

    private static class IntToDouble
    extends MultiArrayCopyFactory {
        private IntToDouble() {
        }

        @Override
        public void arraycopy(Object srcO, int srcPos, Object destO, int destPos, int length) {
            int[] src = (int[])srcO;
            double[] dest = (double[])destO;
            for (int index = 0; index < length; ++index) {
                dest[index + destPos] = src[index + srcPos];
            }
        }
    }

    private static class IntToChar
    extends MultiArrayCopyFactory {
        private IntToChar() {
        }

        @Override
        public void arraycopy(Object srcO, int srcPos, Object destO, int destPos, int length) {
            int[] src = (int[])srcO;
            char[] dest = (char[])destO;
            for (int index = 0; index < length; ++index) {
                dest[index + destPos] = (char)src[index + srcPos];
            }
        }
    }

    private static class IntToByte
    extends MultiArrayCopyFactory {
        private IntToByte() {
        }

        @Override
        public void arraycopy(Object srcO, int srcPos, Object destO, int destPos, int length) {
            int[] src = (int[])srcO;
            byte[] dest = (byte[])destO;
            for (int index = 0; index < length; ++index) {
                dest[index + destPos] = (byte)src[index + srcPos];
            }
        }
    }

    private static class Generic
    extends MultiArrayCopyFactory {
        private Generic() {
        }

        @Override
        public void arraycopy(Object srcO, int srcPos, Object destO, int destPos, int length) {
            System.arraycopy(srcO, srcPos, destO, destPos, length);
        }
    }

    private static class FloatToShort
    extends MultiArrayCopyFactory {
        private FloatToShort() {
        }

        @Override
        public void arraycopy(Object srcO, int srcPos, Object destO, int destPos, int length) {
            float[] src = (float[])srcO;
            short[] dest = (short[])destO;
            for (int index = 0; index < length; ++index) {
                dest[index + destPos] = (short)src[index + srcPos];
            }
        }
    }

    private static class FloatToLong
    extends MultiArrayCopyFactory {
        private FloatToLong() {
        }

        @Override
        public void arraycopy(Object srcO, int srcPos, Object destO, int destPos, int length) {
            float[] src = (float[])srcO;
            long[] dest = (long[])destO;
            for (int index = 0; index < length; ++index) {
                dest[index + destPos] = (long)src[index + srcPos];
            }
        }
    }

    private static class FloatToInt
    extends MultiArrayCopyFactory {
        private FloatToInt() {
        }

        @Override
        public void arraycopy(Object srcO, int srcPos, Object destO, int destPos, int length) {
            float[] src = (float[])srcO;
            int[] dest = (int[])destO;
            for (int index = 0; index < length; ++index) {
                dest[index + destPos] = (int)src[index + srcPos];
            }
        }
    }

    private static class FloatToDouble
    extends MultiArrayCopyFactory {
        private FloatToDouble() {
        }

        @Override
        public void arraycopy(Object srcO, int srcPos, Object destO, int destPos, int length) {
            float[] src = (float[])srcO;
            double[] dest = (double[])destO;
            for (int index = 0; index < length; ++index) {
                dest[index + destPos] = src[index + srcPos];
            }
        }
    }

    private static class FloatToChar
    extends MultiArrayCopyFactory {
        private FloatToChar() {
        }

        @Override
        public void arraycopy(Object srcO, int srcPos, Object destO, int destPos, int length) {
            float[] src = (float[])srcO;
            char[] dest = (char[])destO;
            for (int index = 0; index < length; ++index) {
                dest[index + destPos] = (char)src[index + srcPos];
            }
        }
    }

    private static class FloatToByte
    extends MultiArrayCopyFactory {
        private FloatToByte() {
        }

        @Override
        public void arraycopy(Object srcO, int srcPos, Object destO, int destPos, int length) {
            float[] src = (float[])srcO;
            byte[] dest = (byte[])destO;
            for (int index = 0; index < length; ++index) {
                dest[index + destPos] = (byte)src[index + srcPos];
            }
        }
    }

    private static class DoubleToShort
    extends MultiArrayCopyFactory {
        private DoubleToShort() {
        }

        @Override
        public void arraycopy(Object srcO, int srcPos, Object destO, int destPos, int length) {
            double[] src = (double[])srcO;
            short[] dest = (short[])destO;
            for (int index = 0; index < length; ++index) {
                dest[index + destPos] = (short)src[index + srcPos];
            }
        }
    }

    private static class DoubleToLong
    extends MultiArrayCopyFactory {
        private DoubleToLong() {
        }

        @Override
        public void arraycopy(Object srcO, int srcPos, Object destO, int destPos, int length) {
            double[] src = (double[])srcO;
            long[] dest = (long[])destO;
            for (int index = 0; index < length; ++index) {
                dest[index + destPos] = (long)src[index + srcPos];
            }
        }
    }

    private static class DoubleToInt
    extends MultiArrayCopyFactory {
        private DoubleToInt() {
        }

        @Override
        public void arraycopy(Object srcO, int srcPos, Object destO, int destPos, int length) {
            double[] src = (double[])srcO;
            int[] dest = (int[])destO;
            for (int index = 0; index < length; ++index) {
                dest[index + destPos] = (int)src[index + srcPos];
            }
        }
    }

    private static class DoubleToFloat
    extends MultiArrayCopyFactory {
        private DoubleToFloat() {
        }

        @Override
        public void arraycopy(Object srcO, int srcPos, Object destO, int destPos, int length) {
            double[] src = (double[])srcO;
            float[] dest = (float[])destO;
            for (int index = 0; index < length; ++index) {
                dest[index + destPos] = (float)src[index + srcPos];
            }
        }
    }

    private static class DoubleToChar
    extends MultiArrayCopyFactory {
        private DoubleToChar() {
        }

        @Override
        public void arraycopy(Object srcO, int srcPos, Object destO, int destPos, int length) {
            double[] src = (double[])srcO;
            char[] dest = (char[])destO;
            for (int index = 0; index < length; ++index) {
                dest[index + destPos] = (char)src[index + srcPos];
            }
        }
    }

    private static class DoubleToByte
    extends MultiArrayCopyFactory {
        private DoubleToByte() {
        }

        @Override
        public void arraycopy(Object srcO, int srcPos, Object destO, int destPos, int length) {
            double[] src = (double[])srcO;
            byte[] dest = (byte[])destO;
            for (int index = 0; index < length; ++index) {
                dest[index + destPos] = (byte)src[index + srcPos];
            }
        }
    }

    private static class CharToShort
    extends MultiArrayCopyFactory {
        private CharToShort() {
        }

        @Override
        public void arraycopy(Object srcO, int srcPos, Object destO, int destPos, int length) {
            char[] src = (char[])srcO;
            short[] dest = (short[])destO;
            for (int index = 0; index < length; ++index) {
                dest[index + destPos] = (short)src[index + srcPos];
            }
        }
    }

    private static class CharToLong
    extends MultiArrayCopyFactory {
        private CharToLong() {
        }

        @Override
        public void arraycopy(Object srcO, int srcPos, Object destO, int destPos, int length) {
            char[] src = (char[])srcO;
            long[] dest = (long[])destO;
            for (int index = 0; index < length; ++index) {
                dest[index + destPos] = src[index + srcPos];
            }
        }
    }

    private static class CharToInt
    extends MultiArrayCopyFactory {
        private CharToInt() {
        }

        @Override
        public void arraycopy(Object srcO, int srcPos, Object destO, int destPos, int length) {
            char[] src = (char[])srcO;
            int[] dest = (int[])destO;
            for (int index = 0; index < length; ++index) {
                dest[index + destPos] = src[index + srcPos];
            }
        }
    }

    private static class CharToFloat
    extends MultiArrayCopyFactory {
        private CharToFloat() {
        }

        @Override
        public void arraycopy(Object srcO, int srcPos, Object destO, int destPos, int length) {
            char[] src = (char[])srcO;
            float[] dest = (float[])destO;
            for (int index = 0; index < length; ++index) {
                dest[index + destPos] = src[index + srcPos];
            }
        }
    }

    private static class CharToDouble
    extends MultiArrayCopyFactory {
        private CharToDouble() {
        }

        @Override
        public void arraycopy(Object srcO, int srcPos, Object destO, int destPos, int length) {
            char[] src = (char[])srcO;
            double[] dest = (double[])destO;
            for (int index = 0; index < length; ++index) {
                dest[index + destPos] = src[index + srcPos];
            }
        }
    }

    private static class CharToByte
    extends MultiArrayCopyFactory {
        private CharToByte() {
        }

        @Override
        public void arraycopy(Object srcO, int srcPos, Object destO, int destPos, int length) {
            char[] src = (char[])srcO;
            byte[] dest = (byte[])destO;
            for (int index = 0; index < length; ++index) {
                dest[index + destPos] = (byte)src[index + srcPos];
            }
        }
    }

    private static class ByteToShort
    extends MultiArrayCopyFactory {
        private ByteToShort() {
        }

        @Override
        public void arraycopy(Object srcO, int srcPos, Object destO, int destPos, int length) {
            byte[] src = (byte[])srcO;
            short[] dest = (short[])destO;
            for (int index = 0; index < length; ++index) {
                dest[index + destPos] = src[index + srcPos];
            }
        }
    }

    private static class ByteToLong
    extends MultiArrayCopyFactory {
        private ByteToLong() {
        }

        @Override
        public void arraycopy(Object srcO, int srcPos, Object destO, int destPos, int length) {
            byte[] src = (byte[])srcO;
            long[] dest = (long[])destO;
            for (int index = 0; index < length; ++index) {
                dest[index + destPos] = src[index + srcPos];
            }
        }
    }

    private static class ByteToInt
    extends MultiArrayCopyFactory {
        private ByteToInt() {
        }

        @Override
        public void arraycopy(Object srcO, int srcPos, Object destO, int destPos, int length) {
            byte[] src = (byte[])srcO;
            int[] dest = (int[])destO;
            for (int index = 0; index < length; ++index) {
                dest[index + destPos] = src[index + srcPos];
            }
        }
    }

    private static class ByteToFloat
    extends MultiArrayCopyFactory {
        private ByteToFloat() {
        }

        @Override
        public void arraycopy(Object srcO, int srcPos, Object destO, int destPos, int length) {
            byte[] src = (byte[])srcO;
            float[] dest = (float[])destO;
            for (int index = 0; index < length; ++index) {
                dest[index + destPos] = src[index + srcPos];
            }
        }
    }

    private static class ByteToDouble
    extends MultiArrayCopyFactory {
        private ByteToDouble() {
        }

        @Override
        public void arraycopy(Object srcO, int srcPos, Object destO, int destPos, int length) {
            byte[] src = (byte[])srcO;
            double[] dest = (double[])destO;
            for (int index = 0; index < length; ++index) {
                dest[index + destPos] = src[index + srcPos];
            }
        }
    }

    private static class ByteToChar
    extends MultiArrayCopyFactory {
        private ByteToChar() {
        }

        @Override
        public void arraycopy(Object srcO, int srcPos, Object destO, int destPos, int length) {
            byte[] src = (byte[])srcO;
            char[] dest = (char[])destO;
            for (int index = 0; index < length; ++index) {
                dest[index + destPos] = (char)src[index + srcPos];
            }
        }
    }
}

