/*
 * Decompiled with CFR 0.152.
 */
package sun.lwawt.macosx;

import java.awt.AWTEvent;
import java.awt.Button;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.PopupMenu;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.peer.TrayIconPeer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import sun.awt.AWTAccessor;
import sun.awt.SunToolkit;
import sun.lwawt.macosx.CFRetainedResource;
import sun.lwawt.macosx.CImage;
import sun.lwawt.macosx.CPopupMenu;
import sun.lwawt.macosx.LWCToolkit;
import sun.lwawt.macosx.NSEvent;

public class CTrayIcon
extends CFRetainedResource
implements TrayIconPeer {
    private TrayIcon target;
    private PopupMenu popup;
    private JDialog messageDialog = null;
    private DialogEventHandler handler = null;
    private final Frame dummyFrame;
    private static int mouseClickButtons = 0;

    CTrayIcon(TrayIcon trayIcon) {
        super(0L, true);
        this.target = trayIcon;
        this.popup = trayIcon.getPopupMenu();
        this.dummyFrame = new Frame();
        this.setPtr(this.createModel());
        this.checkAndCreatePopupPeer();
        this.updateImage();
    }

    private CPopupMenu checkAndCreatePopupPeer() {
        CPopupMenu cPopupMenu = null;
        if (this.popup != null) {
            try {
                cPopupMenu = (CPopupMenu)this.popup.getPeer();
                if (cPopupMenu == null) {
                    this.popup.addNotify();
                    cPopupMenu = (CPopupMenu)this.popup.getPeer();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return cPopupMenu;
    }

    private long createModel() {
        return this.nativeCreate();
    }

    private long getModel() {
        return this.ptr;
    }

    private native long nativeCreate();

    public long getPopupMenuModel() {
        if (this.popup == null) {
            PopupMenu popupMenu = this.target.getPopupMenu();
            if (popupMenu != null) {
                this.popup = popupMenu;
            } else {
                return 0L;
            }
        }
        return this.checkAndCreatePopupPeer().ptr;
    }

    @Override
    public void displayMessage(final String string, final String string2, final String string3) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.displayMessageOnEDT(string, string2, string3);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        CTrayIcon.this.displayMessageOnEDT(string, string2, string3);
                    }
                });
            }
            catch (Exception exception) {
                throw new AssertionError((Object)exception);
            }
        }
    }

    @Override
    public void dispose() {
        if (this.messageDialog != null) {
            this.disposeMessageDialog();
        }
        this.dummyFrame.dispose();
        if (this.popup != null) {
            this.popup.removeNotify();
        }
        LWCToolkit.targetDisposedPeer(this.target, this);
        this.target = null;
        super.dispose();
    }

    @Override
    public void setToolTip(String string) {
        this.nativeSetToolTip(this.getModel(), string);
    }

    private native void nativeSetToolTip(long var1, String var3);

    @Override
    public void showPopupMenu(int n, int n2) {
    }

    @Override
    public void updateImage() {
        Image image = this.target.getImage();
        if (image == null) {
            return;
        }
        MediaTracker mediaTracker = new MediaTracker(new Button(""));
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (image.getWidth(null) <= 0 || image.getHeight(null) <= 0) {
            return;
        }
        CImage cImage = CImage.getCreator().createFromImage(image);
        this.setNativeImage(this.getModel(), cImage.ptr, this.target.isImageAutoSize());
    }

    private native void setNativeImage(long var1, long var3, boolean var5);

    private void postEvent(final AWTEvent aWTEvent) {
        SunToolkit.executeOnEventHandlerThread(this.target, new Runnable(){

            @Override
            public void run() {
                SunToolkit.postEvent(SunToolkit.targetToAppContext(CTrayIcon.this.target), aWTEvent);
            }
        });
    }

    private void handleMouseEvent(NSEvent nSEvent) {
        Object object;
        int n = nSEvent.getButtonNumber();
        SunToolkit sunToolkit = (SunToolkit)Toolkit.getDefaultToolkit();
        if (n > 2 && !sunToolkit.areExtraMouseButtonsEnabled() || n > sunToolkit.getNumberOfButtons() - 1) {
            return;
        }
        int n2 = NSEvent.nsToJavaEventType(nSEvent.getType());
        int n3 = 0;
        int n4 = 0;
        if (n2 != 503) {
            n3 = NSEvent.nsToJavaButton(n);
            n4 = nSEvent.getClickCount();
        }
        int n5 = NSEvent.nsToJavaMouseModifiers(n, nSEvent.getModifierFlags());
        boolean bl = NSEvent.isPopupTrigger(n5);
        int n6 = n3 > 0 ? MouseEvent.getMaskForButton(n3) : 0;
        long l = System.currentTimeMillis();
        if (n2 == 501) {
            mouseClickButtons |= n6;
        } else if (n2 == 506) {
            mouseClickButtons = 0;
        }
        int n7 = nSEvent.getAbsX();
        int n8 = nSEvent.getAbsY();
        MouseEvent mouseEvent = new MouseEvent(this.dummyFrame, n2, l, n5, n7, n8, n7, n8, n4, bl, n3);
        mouseEvent.setSource(this.target);
        this.postEvent(mouseEvent);
        if (n2 == 501 && bl) {
            object = this.target.getActionCommand();
            ActionEvent actionEvent = new ActionEvent(this.target, 1001, (String)object);
            this.postEvent(actionEvent);
        }
        if (n2 == 502) {
            if ((mouseClickButtons & n6) != 0) {
                object = new MouseEvent(this.dummyFrame, 500, l, n5, n7, n8, n7, n8, n4, bl, n3);
                ((AWTEvent)object).setSource(this.target);
                this.postEvent((AWTEvent)object);
            }
            mouseClickButtons &= ~n6;
        }
    }

    private native Point2D nativeGetIconLocation(long var1);

    public void displayMessageOnEDT(String string, String string2, String string3) {
        Icon icon;
        if (this.messageDialog != null) {
            this.disposeMessageDialog();
        }
        if ((icon = CTrayIcon.getIconForMessageType(string3)) != null) {
            icon = new ImageIcon(CTrayIcon.scaleIcon(icon, 0.75));
        }
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = dimension.width / 8;
        this.messageDialog = this.createMessageDialog(string, string2, n, icon);
        this.showMessageDialog();
    }

    private JDialog createMessageDialog(String string, String string2, int n, Icon icon) {
        JComponent jComponent;
        this.handler = new DialogEventHandler();
        JTextArea jTextArea = null;
        if (string != null) {
            jTextArea = CTrayIcon.createTextArea(string, n, false, true);
        }
        JTextArea jTextArea2 = null;
        if (string2 != null) {
            jTextArea2 = CTrayIcon.createTextArea(string2, n, true, false);
        }
        Object[] objectArray = null;
        if (jTextArea != null) {
            objectArray = jTextArea2 != null ? new Object[]{jTextArea, new JLabel(), jTextArea2} : new Object[]{jTextArea};
        } else if (jTextArea2 != null) {
            objectArray = new Object[]{jTextArea2};
        }
        JOptionPane jOptionPane = new JOptionPane(objectArray);
        jOptionPane.setIcon(icon);
        jOptionPane.addPropertyChangeListener(this.handler);
        try {
            jComponent = (JPanel)jOptionPane.getComponent(1);
            JButton jButton = (JButton)jComponent.getComponent(0);
            jButton.putClientProperty("JComponent.sizeVariant", "small");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        JDialog jDialog = new JDialog((Dialog)null);
        jComponent = jDialog.getRootPane();
        jComponent.putClientProperty("Window.style", "small");
        jComponent.putClientProperty("Window.zoomable", "false");
        jDialog.setDefaultCloseOperation(0);
        jDialog.setModal(false);
        jDialog.setModalExclusionType(Dialog.ModalExclusionType.TOOLKIT_EXCLUDE);
        jDialog.setAlwaysOnTop(true);
        jDialog.setAutoRequestFocus(false);
        jDialog.setResizable(false);
        jDialog.setContentPane(jOptionPane);
        jDialog.addWindowListener(this.handler);
        AWTAccessor.getWindowAccessor().setTrayIconWindow(jDialog, true);
        jDialog.pack();
        return jDialog;
    }

    private void showMessageDialog() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Point2D point2D = this.nativeGetIconLocation(this.getModel());
        int n = (int)point2D.getY();
        int n2 = (int)point2D.getX();
        if (n2 + this.messageDialog.getWidth() > dimension.width) {
            n2 = dimension.width - this.messageDialog.getWidth();
        }
        this.messageDialog.setLocation(n2, n);
        this.messageDialog.setVisible(true);
    }

    private void disposeMessageDialog() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.disposeMessageDialogOnEDT();
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        CTrayIcon.this.disposeMessageDialogOnEDT();
                    }
                });
            }
            catch (Exception exception) {
                throw new AssertionError((Object)exception);
            }
        }
    }

    private void disposeMessageDialogOnEDT() {
        if (this.messageDialog != null) {
            this.messageDialog.removeWindowListener(this.handler);
            this.messageDialog.removePropertyChangeListener(this.handler);
            this.messageDialog.dispose();
            this.messageDialog = null;
            this.handler = null;
        }
    }

    private static BufferedImage scaleIcon(Icon icon, double d) {
        if (icon == null) {
            return null;
        }
        int n = icon.getIconWidth();
        int n2 = icon.getIconHeight();
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
        GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, n2, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        icon.paintIcon(null, graphics2D, 0, 0);
        graphics2D.dispose();
        int n3 = (int)((double)n * d);
        int n4 = (int)((double)n2 * d);
        BufferedImage bufferedImage2 = graphicsConfiguration.createCompatibleImage(n3, n4, 3);
        graphics2D = bufferedImage2.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics2D.drawImage(bufferedImage, 0, 0, n3, n4, null);
        graphics2D.dispose();
        return bufferedImage2;
    }

    private static Icon getIconForMessageType(String string) {
        if (string.equals("ERROR")) {
            return UIManager.getIcon("OptionPane.errorIcon");
        }
        if (string.equals("WARNING")) {
            return UIManager.getIcon("OptionPane.warningIcon");
        }
        return UIManager.getIcon("OptionPane.informationIcon");
    }

    private static JTextArea createTextArea(String string, int n, boolean bl, boolean bl2) {
        JTextArea jTextArea = new JTextArea(string);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setEditable(false);
        jTextArea.setFocusable(false);
        jTextArea.setBorder(null);
        jTextArea.setBackground(new JLabel().getBackground());
        if (bl) {
            jTextArea.putClientProperty("JComponent.sizeVariant", "small");
        }
        if (bl2) {
            Font font = jTextArea.getFont();
            Font font2 = new Font(font.getName(), 1, font.getSize());
            jTextArea.setFont(font2);
        }
        jTextArea.setSize(n, 1);
        return jTextArea;
    }

    private final class DialogEventHandler
    extends WindowAdapter
    implements PropertyChangeListener {
        private DialogEventHandler() {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            CTrayIcon.this.disposeMessageDialog();
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (CTrayIcon.this.messageDialog == null) {
                return;
            }
            String string = propertyChangeEvent.getPropertyName();
            Container container = CTrayIcon.this.messageDialog.getContentPane();
            if (CTrayIcon.this.messageDialog.isVisible() && propertyChangeEvent.getSource() == container && string.equals("value")) {
                CTrayIcon.this.disposeMessageDialog();
            }
        }
    }
}

