/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.image.compression.bintable;

import java.nio.Buffer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import nom.tam.fits.Header;
import nom.tam.fits.HeaderCardException;
import nom.tam.fits.compression.algorithm.api.ICompressorControl;
import nom.tam.fits.compression.provider.CompressorProvider;
import nom.tam.fits.header.Compression;
import nom.tam.image.compression.bintable.BinaryTableTileDescription;
import nom.tam.util.ColumnTable;
import nom.tam.util.type.PrimitiveType;
import nom.tam.util.type.PrimitiveTypeHandler;

public abstract class BinaryTableTile
implements Runnable {
    protected final ColumnTable<?> data;
    protected final int rowStart;
    protected final int rowEnd;
    protected final int column;
    protected String compressionAlgorithm;
    protected final PrimitiveType<Buffer> type;
    protected final int length;
    protected final int tileIndex;
    private Future<?> future;

    public BinaryTableTile(ColumnTable<?> data, BinaryTableTileDescription description) {
        this.data = data;
        this.rowStart = description.getRowStart();
        this.rowEnd = description.getRowEnd();
        this.column = description.getColumn();
        this.tileIndex = description.getTileIndex();
        this.compressionAlgorithm = description.getCompressionAlgorithm();
        this.type = PrimitiveTypeHandler.valueOf(data.getTypes()[this.column]);
        this.length = (this.rowEnd - this.rowStart) * data.getSizes()[this.column];
    }

    public void execute(ExecutorService threadPool) {
        this.future = threadPool.submit(this);
    }

    public void fillHeader(Header header) throws HeaderCardException {
        header.card(Compression.ZCTYPn.n(this.column)).value(this.compressionAlgorithm);
    }

    public int getTileIndex() {
        return this.tileIndex;
    }

    public void waitForResult() {
        try {
            this.future.get();
        }
        catch (Exception e) {
            throw new IllegalStateException("could not process tile", e);
        }
    }

    protected ICompressorControl getCompressorControl() {
        return CompressorProvider.findCompressorControl(null, this.compressionAlgorithm, this.type.primitiveClass());
    }

    protected int getUncompressedSizeInBytes() {
        return this.length * this.type.size();
    }
}

